# Copyright (C) 2025 Advanced Micro Devices, Inc. All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

from kernels.configs import config_lds
from types import SimpleNamespace as NS

# Note: Default half_lds is True and default direct_to_from_reg is True as well.
# TODO- Currently, if half_lds is True, then direct_to_from_reg must be True
#       but if half_lds is False, direct_to_from_reg can be either (still can be True).

# yapf: disable
sbrr_kernels = [
    NS(length=   1, workgroup_size= 64, threads_per_transform=  1, factors=(1,), runtime_compile=True),
    NS(length=   2, workgroup_size= 64, threads_per_transform=  1, factors=(2,), runtime_compile=True),
    NS(length=   3, workgroup_size= 64, threads_per_transform=  1, factors=(3,), runtime_compile=True),
    NS(length=   4, workgroup_size=128, threads_per_transform=  1, factors=(4,), runtime_compile=True),
    NS(length=   5, workgroup_size=128, threads_per_transform=  1, factors=(5,), runtime_compile=True),
    NS(length=   6, workgroup_size=128, threads_per_transform=  1, factors=(6,), runtime_compile=True),
    NS(length=   7, workgroup_size= 64, threads_per_transform=  1, factors=(7,), runtime_compile=True),
    NS(length=   8, workgroup_size= 64, threads_per_transform=  4, factors=(4, 2), runtime_compile=True),
    NS(length=   9, workgroup_size= 64, threads_per_transform=  3, factors=(3, 3), runtime_compile=True),
    NS(length=  10, workgroup_size= 64, threads_per_transform=  1, factors=(10,), runtime_compile=True),
    NS(length=  11, workgroup_size=128, threads_per_transform=  1, factors=(11,), runtime_compile=True),
    NS(length=  12, workgroup_size=128, threads_per_transform=  6, factors=(6, 2), runtime_compile=True),
    NS(length=  13, workgroup_size= 64, threads_per_transform=  1, factors=(13,), runtime_compile=True),
    NS(length=  14, workgroup_size=128, threads_per_transform=  7, factors=(7, 2), runtime_compile=True),
    NS(length=  15, workgroup_size=128, threads_per_transform=  5, factors=(3, 5), runtime_compile=True),
    NS(length=  16, workgroup_size= 64, threads_per_transform=  4, factors=(4, 4), runtime_compile=True),
    NS(length=  17, workgroup_size=256, threads_per_transform=  1, factors=(17,), runtime_compile=True),
    NS(length=  18, workgroup_size= 64, threads_per_transform=  6, factors=(3, 6), runtime_compile=True),
    NS(length=  20, workgroup_size=256, threads_per_transform= 10, factors=(5, 4), runtime_compile=True),
    NS(length=  21, workgroup_size=128, threads_per_transform=  7, factors=(3, 7), runtime_compile=True),
    NS(length=  22, workgroup_size= 64, threads_per_transform=  2, factors=(11, 2), runtime_compile=True),
    NS(length=  24, workgroup_size=256, threads_per_transform=  8, factors=(8, 3), runtime_compile=True),
    NS(length=  25, workgroup_size=256, threads_per_transform=  5, factors=(5, 5), runtime_compile=True),
    NS(length=  26, workgroup_size= 64, threads_per_transform=  2, factors=(13, 2), runtime_compile=True),
    NS(length=  27, workgroup_size=256, threads_per_transform=  9, factors=(3, 3, 3), runtime_compile=True),
    NS(length=  28, workgroup_size= 64, threads_per_transform=  4, factors=(7, 4), runtime_compile=True),
    NS(length=  30, workgroup_size=128, threads_per_transform= 10, factors=(10, 3), runtime_compile=True),
    NS(length=  32, workgroup_size=128, threads_per_transform= 16, factors=(8, 4)),
    NS(length=  33, workgroup_size=256, threads_per_transform= 11, factors=(11, 3), runtime_compile=True),
    NS(length=  34, workgroup_size=256, threads_per_transform= 17, factors=(17, 2), runtime_compile=True),
    NS(length=  35, workgroup_size=256, threads_per_transform=  7, factors=(5, 7), half_lds=False, runtime_compile=True),
    NS(length=  36, workgroup_size= 64, threads_per_transform=  6, factors=(6, 6)),
    NS(length=  39, workgroup_size=256, threads_per_transform= 13, factors=(13, 3), runtime_compile=True),
    NS(length=  40, workgroup_size=128, threads_per_transform= 10, factors=(10, 4)),
    NS(length=  42, workgroup_size=256, threads_per_transform=  7, factors=(7, 6)),
    NS(length=  44, workgroup_size= 64, threads_per_transform=  4, factors=(11, 4)),
    NS(length=  45, workgroup_size=128, threads_per_transform= 15, factors=(5, 3, 3)),
    NS(length=  48, workgroup_size= 64, threads_per_transform= 16, factors=(4, 3, 4)),
    NS(length=  49, workgroup_size= 64, threads_per_transform=  7, factors=(7, 7)),
    NS(length=  50, workgroup_size=256, threads_per_transform= 10, factors=(10, 5)),
    NS(length=  51, workgroup_size=256, threads_per_transform= 17, factors=(17, 3), runtime_compile=True),
    NS(length=  52, workgroup_size= 64, threads_per_transform=  4, factors=(13, 4)),
    NS(length=  54, workgroup_size=256, threads_per_transform= 18, factors=(6, 3, 3)),
    NS(length=  55, workgroup_size=256, threads_per_transform= 11, factors=(5, 11), half_lds=False, runtime_compile=True),
    NS(length=  56, workgroup_size=128, threads_per_transform=  8, factors=(7, 8)),
    NS(length=  60, workgroup_size= 64, threads_per_transform= 10, factors=(6, 10)),
    NS(length=  63, workgroup_size=256, threads_per_transform= 21, factors=(3, 3, 7), half_lds=False, runtime_compile=True),
    NS(length=  64, workgroup_size= 64, threads_per_transform= 16, factors=(4, 4, 4), half_lds=False, direct_to_from_reg=True),
    NS(length=  65, workgroup_size=256, threads_per_transform= 13, factors=(13, 5), runtime_compile=True),
    NS(length=  66, workgroup_size=256, threads_per_transform= 11, factors=(6, 11), half_lds=False, runtime_compile=True),
    NS(length=  68, workgroup_size=256, threads_per_transform= 17, factors=(17, 4), runtime_compile=True),
    NS(length=  70, workgroup_size=256, threads_per_transform= 14, factors=(2, 5, 7), runtime_compile=True),
    NS(length=  72, workgroup_size= 64, threads_per_transform=  9, factors=(8, 3, 3)),
    NS(length=  75, workgroup_size=256, threads_per_transform= 25, factors=(5, 5, 3)),
    NS(length=  77, workgroup_size=256, threads_per_transform= 11, factors=(7, 11), runtime_compile=True),
    NS(length=  78, workgroup_size=256, threads_per_transform= 13, factors=(6, 13), half_lds=False, runtime_compile=True),
    NS(length=  80, workgroup_size= 64, threads_per_transform= 10, factors=(5, 2, 8)),
    NS(length=  81, workgroup_size=128, threads_per_transform= 27, factors=(3, 3, 3, 3)),
    NS(length=  84, workgroup_size=128, threads_per_transform= 12, factors=(7, 2, 6)),
    NS(length=  85, workgroup_size=256, threads_per_transform= 17, factors=(17, 5), runtime_compile=True),
    NS(length=  88, workgroup_size=128, threads_per_transform= 11, factors=(11, 8)),
    NS(length=  90, workgroup_size= 64, threads_per_transform=  9, factors=(3, 3, 10)),
    NS(length=  91, workgroup_size=256, threads_per_transform= 13, factors=(7, 13), half_lds=False, runtime_compile=True),
    NS(length=  96, workgroup_size=128, threads_per_transform= 16, factors=(6, 16), half_lds=False, direct_to_from_reg=False),
    NS(length=  98, workgroup_size= 256, threads_per_transform= 14, factors=(2, 7, 7), half_lds=False, runtime_compile=True),
    NS(length=  99, workgroup_size= 256, threads_per_transform= 11, factors=(3, 3, 11), half_lds=False, runtime_compile=True),
    NS(length= 100, workgroup_size= 64, threads_per_transform= 10, factors=(10, 10)),
    NS(length= 102, workgroup_size=128, threads_per_transform= 17, factors=(17, 6), runtime_compile=True),
    NS(length= 104, workgroup_size= 64, threads_per_transform=  8, factors=(13, 8)),
    NS(length= 105, workgroup_size=256, threads_per_transform= 21, factors=(7, 3, 5), half_lds=False, runtime_compile=True),
    NS(length= 108, workgroup_size=256, threads_per_transform= 36, factors=(6, 6, 3)),
    NS(length= 110, workgroup_size=256, threads_per_transform= 11, factors=(2, 5, 11), half_lds=False, runtime_compile=True),
    NS(length= 112, workgroup_size=256, threads_per_transform= 16, factors=(16, 7), half_lds=False, direct_to_from_reg=False),
    NS(length= 117, workgroup_size= 64, threads_per_transform= 13, factors=(13, 9), runtime_compile=True),
    NS(length= 119, workgroup_size=256, threads_per_transform= 17, factors=(17, 7), runtime_compile=True),
    NS(length= 120, workgroup_size= 64, threads_per_transform= 12, factors=(6, 10, 2), runtime_compile=True),
    NS(length= 121, workgroup_size=128, threads_per_transform= 11, factors=(11, 11), runtime_compile=True),
    NS(length= 125, workgroup_size=256, threads_per_transform= 25, factors=(5, 5, 5), half_lds=False, direct_to_from_reg=False),
    NS(length= 126, workgroup_size= 256, threads_per_transform= 42, factors=(6, 7, 3), half_lds=False, runtime_compile=True),
    NS(length= 128, workgroup_size=256, threads_per_transform= 16, factors=(16, 8)),
    NS(length= 130, workgroup_size= 64, threads_per_transform= 13, factors=(13, 10), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 132, workgroup_size=128, threads_per_transform= 22, factors=(11, 6, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 135, workgroup_size=128, threads_per_transform=  9, factors=(5, 3, 3, 3), runtime_compile=True),
    NS(length= 136, workgroup_size=128, threads_per_transform=17, factors=(17, 8), runtime_compile=True),
    NS(length= 140, workgroup_size= 64, threads_per_transform= 28, factors=(7, 5, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 143, workgroup_size=256, threads_per_transform= 13, factors=(13, 11), half_lds=False, runtime_compile=True),
    NS(length= 144, workgroup_size=128, threads_per_transform= 12, factors=(6, 6, 4)),
    NS(length= 147, workgroup_size= 64, threads_per_transform= 21, factors=(7, 7, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 150, workgroup_size= 64, threads_per_transform=  5, factors=(10, 5, 3), runtime_compile=True),
    NS(length= 153, workgroup_size=128, threads_per_transform= 17, factors=(17, 9), runtime_compile=True),
    NS(length= 154, workgroup_size=128, threads_per_transform= 22, factors=(11, 7, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 156, workgroup_size= 128, threads_per_transform=13, factors=(3, 4, 13), half_lds=False, runtime_compile=True),
    NS(length= 160, workgroup_size=256, threads_per_transform= 16, factors=(16, 10)),
    NS(length= 162, workgroup_size=256, threads_per_transform= 27, factors=(6, 3, 3, 3), runtime_compile=True),
    NS(length= 165, workgroup_size= 64, threads_per_transform= 11, factors=(11, 5, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 168, workgroup_size=256, threads_per_transform= 56, factors=(8, 7, 3), half_lds=False, direct_to_from_reg=False),
    NS(length= 169, workgroup_size=256, threads_per_transform= 13, factors=(13, 13), runtime_compile=True),
    NS(length= 170, workgroup_size=128, threads_per_transform= 17, factors=(17, 10), runtime_compile=True),
    NS(length= 175, workgroup_size=256, threads_per_transform= 35, factors=(5, 5, 7), half_lds=False, runtime_compile=True),
    NS(length= 176, workgroup_size= 64, threads_per_transform= 16, factors=(11, 16), runtime_compile=True),
    NS(length= 180, workgroup_size=256, threads_per_transform= 60, factors=(10, 6, 3), half_lds=False, direct_to_from_reg=False),
    NS(length= 182, workgroup_size= 64, threads_per_transform= 13, factors=(13, 2, 7), half_lds=False, runtime_compile=True),
    NS(length= 187, workgroup_size=128, threads_per_transform= 17, factors=(17, 11), runtime_compile=True),
    NS(length= 189, workgroup_size= 64, threads_per_transform= 21, factors=(7, 3, 3, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 192, workgroup_size=128, threads_per_transform= 16, factors=(6, 4, 4, 2)),
    NS(length= 195, workgroup_size= 64, threads_per_transform= 13, factors=(13, 5, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 196, workgroup_size= 64, threads_per_transform= 28, factors=(4, 7, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 198, workgroup_size=128, threads_per_transform= 22, factors=(11, 2, 9), half_lds=False, runtime_compile=True),
    NS(length= 200, workgroup_size= 64, threads_per_transform= 20, factors=(10, 10, 2)),
    NS(length= 204, workgroup_size=128, threads_per_transform= 17, factors=(17, 4, 3), runtime_compile=True),
    NS(length= 208, workgroup_size= 64, threads_per_transform= 16, factors=(13, 16)),
    NS(length= 210, workgroup_size= 64, threads_per_transform= 30, factors=(10, 7, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 216, workgroup_size=256, threads_per_transform= 36, factors=(6, 6, 6)),
    NS(length= 220, workgroup_size=128, threads_per_transform= 22, factors=(10, 2, 11), half_lds=False, runtime_compile=True),
    NS(length= 221, workgroup_size=128, threads_per_transform= 17, factors=(17, 13), runtime_compile=True),
    NS(length= 224, workgroup_size= 64, threads_per_transform= 16, factors=(7, 2, 2, 2, 2, 2)),
    NS(length= 225, workgroup_size=256, threads_per_transform= 75, factors=(5, 5, 3, 3), runtime_compile=True),
    NS(length= 231, workgroup_size=256, threads_per_transform= 33, factors=(11, 7, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 234, workgroup_size= 64, threads_per_transform= 26, factors=(13, 9, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 238, workgroup_size= 64, threads_per_transform= 17, factors=(17, 7, 2), runtime_compile=True),
    NS(length= 240, workgroup_size=128, threads_per_transform= 48, factors=(8, 5, 6)),
    NS(length= 242, workgroup_size=128, threads_per_transform= 22, factors=(11, 2, 11), half_lds=False, runtime_compile=True),
    NS(length= 243, workgroup_size=256, threads_per_transform= 81, factors=(3, 3, 3, 3, 3)),
    NS(length= 245, workgroup_size=256, threads_per_transform= 35, factors=(7, 5, 7), half_lds=False, runtime_compile=True),
    NS(length= 250, workgroup_size=128, threads_per_transform= 25, factors=(10, 5, 5), runtime_compile=True),
    NS(length= 252, workgroup_size= 64, threads_per_transform= 63, factors=(7, 3, 3, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 255, workgroup_size= 64, threads_per_transform= 17, factors=(17, 5, 3), runtime_compile=True),
    NS(length= 256, workgroup_size= 64, threads_per_transform= 64, factors=(4, 4, 4, 4)),
    NS(length= 260, workgroup_size= 64, threads_per_transform= 26, factors=(13, 10, 2), half_lds=False, runtime_compile=True),
    NS(length= 264, workgroup_size=256, threads_per_transform= 33, factors=(8, 3, 11), half_lds=False, runtime_compile=True),
    NS(length= 270, workgroup_size=128, threads_per_transform= 27, factors=(10, 3, 3, 3)),
    NS(length= 272, workgroup_size=128, threads_per_transform= 17, factors=(16, 17), runtime_compile=True),
    NS(length= 273, workgroup_size= 64, threads_per_transform= 13, factors=(13, 3, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 275, workgroup_size= 64, threads_per_transform= 55, factors=(11, 5, 5), half_lds=False, runtime_compile=True),
    NS(length= 280, workgroup_size= 64, threads_per_transform= 56, factors=(8, 7, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 286, workgroup_size= 64, threads_per_transform= 26, factors=(13, 11, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 288, workgroup_size=128, threads_per_transform= 24, factors=(6, 6, 4, 2), runtime_compile=True),
    NS(length= 289, workgroup_size=128, threads_per_transform= 17, factors=(17, 17), runtime_compile=True),
    NS(length= 294, workgroup_size=128, threads_per_transform= 42, factors=(6, 7, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 297, workgroup_size=256, threads_per_transform= 33, factors=(9, 3, 11), runtime_compile=True),
    NS(length= 300, workgroup_size= 64, threads_per_transform= 30, factors=(10, 10, 3), runtime_compile=True),
    NS(length= 306, workgroup_size=256, threads_per_transform= 34, factors=(17, 2, 9), runtime_compile=True),
    NS(length= 308, workgroup_size= 64, threads_per_transform= 44, factors=(11, 7, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 312, workgroup_size= 64, threads_per_transform= 26, factors=(13, 4, 3, 2), half_lds=False, runtime_compile=True),
    NS(length= 315, workgroup_size= 64, threads_per_transform= 63, factors=(7, 3, 3, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 320, workgroup_size= 64, threads_per_transform= 16, factors=(10, 4, 4, 2), runtime_compile=True),
    NS(length= 324, workgroup_size= 64, threads_per_transform= 54, factors=(3, 6, 6, 3), runtime_compile=True),
    NS(length= 325, workgroup_size= 64, threads_per_transform= 13, factors=(13, 5, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 330, workgroup_size=128, threads_per_transform= 33, factors=(11, 10, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 336, workgroup_size=128, threads_per_transform= 56, factors=(8, 7, 6)),
    NS(length= 338, workgroup_size= 64, threads_per_transform= 26, factors=(13, 2, 13), runtime_compile=True),
    NS(length= 340, workgroup_size=128, threads_per_transform= 34, factors=(17, 2, 10), runtime_compile=True),
    NS(length= 343, workgroup_size=256, threads_per_transform= 49, factors=(7, 7, 7), runtime_compile=True),
    NS(length= 350, workgroup_size= 64, threads_per_transform= 50, factors=(5, 7, 10), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 351, workgroup_size=128, threads_per_transform= 39, factors=(13, 3, 9), half_lds=False, runtime_compile=True),
    NS(length= 352, workgroup_size= 64, threads_per_transform= 32, factors=(11, 2, 16), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 357, workgroup_size=256, threads_per_transform= 17, factors=(17, 3, 7), runtime_compile=True),
    NS(length= 360, workgroup_size=256, threads_per_transform= 60, factors=(10, 6, 6), runtime_compile=True),
    NS(length= 363, workgroup_size=128, threads_per_transform= 33, factors=(11, 3, 11), runtime_compile=True),
    NS(length= 364, workgroup_size= 64, threads_per_transform= 52, factors=(13, 7, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 374, workgroup_size=256, threads_per_transform= 34, factors=(17, 2, 11), runtime_compile=True),
    NS(length= 375, workgroup_size=128, threads_per_transform= 25, factors=(5, 5, 5, 3), runtime_compile=True),
    NS(length= 378, workgroup_size=128, threads_per_transform=126, factors=(6, 3, 3, 7), half_lds=False, runtime_compile=True),
    NS(length= 384, workgroup_size=128, threads_per_transform= 32, factors=(6, 4, 4, 4), runtime_compile=True),
    NS(length= 385, workgroup_size= 64, threads_per_transform= 55, factors=(11, 7, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 390, workgroup_size=128, threads_per_transform= 39, factors=(13, 3, 10), half_lds=False, runtime_compile=True),
    NS(length= 392, workgroup_size= 64, threads_per_transform= 56, factors=(8, 7, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 396, workgroup_size= 64, threads_per_transform= 44, factors=(11, 9, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 400, workgroup_size=128, threads_per_transform= 40, factors=(4, 10, 10), runtime_compile=True),
    NS(length= 405, workgroup_size=128, threads_per_transform= 27, factors=(5, 3, 3, 3, 3), runtime_compile=True),
    NS(length= 408, workgroup_size= 64, threads_per_transform= 17, factors=(17, 3, 8), runtime_compile=True),
    NS(length= 416, workgroup_size= 64, threads_per_transform= 32, factors=(13, 2, 16), half_lds=False, runtime_compile=True),
    NS(length= 420, workgroup_size= 64, threads_per_transform= 60, factors=(10, 7, 6), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 425, workgroup_size= 64, threads_per_transform= 17, factors=(17, 5, 5), runtime_compile=True),
    NS(length= 429, workgroup_size=128, threads_per_transform= 39, factors=(13, 3, 11), half_lds=False, runtime_compile=True),
    NS(length= 432, workgroup_size= 64, threads_per_transform= 27, factors=(3, 16, 3, 3), runtime_compile=True),
    NS(length= 440, workgroup_size= 64, threads_per_transform= 55, factors=(11, 8, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 441, workgroup_size= 64, threads_per_transform= 63, factors=(9, 7, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 442, workgroup_size=256, threads_per_transform= 34, factors=(17, 2, 13), runtime_compile=True),
    NS(length= 448, workgroup_size=128, threads_per_transform= 64, factors=(8, 7, 8), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 450, workgroup_size=128, threads_per_transform= 30, factors=(10, 5, 3, 3), runtime_compile=True),
    NS(length= 455, workgroup_size=256, threads_per_transform= 65, factors=(13, 5, 7), half_lds=False, runtime_compile=True),
    NS(length= 459, workgroup_size=256, threads_per_transform= 51, factors=(17, 3, 9), runtime_compile=True),
    NS(length= 462, workgroup_size=256, threads_per_transform= 77, factors=(11, 6, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 468, workgroup_size= 64, threads_per_transform= 52, factors=(13, 9, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 476, workgroup_size=128, threads_per_transform= 34, factors=(17, 2, 7, 2), runtime_compile=True),
    NS(length= 480, workgroup_size= 64, threads_per_transform= 16, factors=(10, 8, 6), runtime_compile=True),
    NS(length= 484, workgroup_size= 64, threads_per_transform= 44, factors=(4, 11, 11), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 486, workgroup_size=256, threads_per_transform=162, factors=(6, 3, 3, 3, 3), runtime_compile=True),
    NS(length= 490, workgroup_size=256, threads_per_transform= 70, factors=(10, 7, 7), half_lds=False, runtime_compile=True),
    NS(length= 495, workgroup_size= 64, threads_per_transform= 55, factors=(11, 9, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 500, workgroup_size=128, threads_per_transform=100, factors=(10, 5, 10), runtime_compile=True),
    NS(length= 504, workgroup_size= 64, threads_per_transform= 63, factors=(7, 9, 4, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 507, workgroup_size=128, threads_per_transform= 39, factors=(13, 3, 13), runtime_compile=True),
    NS(length= 510, workgroup_size=256, threads_per_transform= 34, factors=(17, 2, 3, 5), runtime_compile=True),
    NS(length= 512, workgroup_size= 64, threads_per_transform= 64, factors=(8, 8, 8)),
    NS(length= 520, workgroup_size= 64, threads_per_transform= 52, factors=(13, 10, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 525, workgroup_size= 128, threads_per_transform=105, factors=(7, 3, 5, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 528, workgroup_size= 64, threads_per_transform= 48, factors=(4, 4, 3, 11), runtime_compile=True),
    NS(length= 539, workgroup_size=256, threads_per_transform= 77, factors=(11, 7, 7), runtime_compile=True),
    NS(length= 540, workgroup_size=256, threads_per_transform= 54, factors=(3, 10, 6, 3), runtime_compile=True),
    NS(length= 544, workgroup_size=128, threads_per_transform= 34, factors=(17, 2, 16), runtime_compile=True),
    NS(length= 546, workgroup_size=128, threads_per_transform= 39, factors=(13, 3, 7, 2), runtime_compile=True),
    NS(length= 550, workgroup_size= 64, threads_per_transform= 55, factors=(11, 10, 5), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 560, workgroup_size= 64, threads_per_transform= 56, factors=(8, 7, 5, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 561, workgroup_size=256, threads_per_transform= 51, factors=(17, 3, 11), runtime_compile=True),
    NS(length= 567, workgroup_size= 64, threads_per_transform= 63, factors=(7, 9, 3, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 572, workgroup_size= 64, threads_per_transform= 52, factors=(13, 11, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 576, workgroup_size=128, threads_per_transform= 96, factors=(16, 6, 6), runtime_compile=True),
    NS(length= 578, workgroup_size= 256, threads_per_transform=34, factors=(17, 17, 2), runtime_compile=True),
    NS(length= 585, workgroup_size= 256, threads_per_transform=65, factors=(13, 5, 9), half_lds=False, runtime_compile=True),
    NS(length= 588, workgroup_size= 256, threads_per_transform=84, factors=(7, 3, 4, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 594, workgroup_size=128, threads_per_transform= 99, factors=(11, 3, 6, 3), half_lds=False, runtime_compile=True),
    NS(length= 595, workgroup_size= 64, threads_per_transform= 17, factors=(7, 17, 5), runtime_compile=True),
    NS(length= 600, workgroup_size= 64, threads_per_transform= 60, factors=(10, 6, 10), runtime_compile=True),
    NS(length= 605, workgroup_size= 64, threads_per_transform= 55, factors=(11, 5, 11), half_lds=False, runtime_compile=True),
    NS(length= 612, workgroup_size= 64, threads_per_transform= 51, factors=(17, 3, 6, 2), runtime_compile=True),
    NS(length= 616, workgroup_size=128, threads_per_transform= 88, factors=(11, 7, 8), half_lds=False, runtime_compile=True),
    NS(length= 624, workgroup_size= 64, threads_per_transform= 52, factors=(13, 4, 6, 2), half_lds=False, runtime_compile=True),
    NS(length= 625, workgroup_size=128, threads_per_transform=125, factors=(5, 5, 5, 5), runtime_compile=True),
    NS(length= 630, workgroup_size= 64, threads_per_transform= 63, factors=(3, 3, 5, 7, 2), runtime_compile=True),
    NS(length= 637, workgroup_size=128, threads_per_transform= 91, factors=(13, 7, 7), runtime_compile=True),
    NS(length= 640, workgroup_size=128, threads_per_transform= 64, factors=(8, 10, 8), runtime_compile=True),
    NS(length= 648, workgroup_size=256, threads_per_transform=216, factors=(8, 3, 3, 3, 3), runtime_compile=True),
    NS(length= 650, workgroup_size= 256, threads_per_transform=65, factors=(10, 5, 13), half_lds=False, runtime_compile=True),
    NS(length= 660, workgroup_size=128, threads_per_transform=110, factors=(11, 6, 10), runtime_compile=True),
    NS(length= 663, workgroup_size= 64, threads_per_transform= 51, factors=(17, 13, 3), half_lds=False, runtime_compile=True),
    NS(length= 672, workgroup_size= 64, threads_per_transform= 56, factors=(2, 2, 2, 2, 2, 3, 7), runtime_compile=True),
    NS(length= 675, workgroup_size=256, threads_per_transform=225, factors=(5, 5, 3, 3, 3), runtime_compile=True),
    NS(length= 676, workgroup_size= 64, threads_per_transform= 52, factors=(13, 13, 4), half_lds=False, runtime_compile=True),
    NS(length= 680, workgroup_size=256, threads_per_transform= 68, factors=(17, 4, 10), runtime_compile=True),
    NS(length= 686, workgroup_size= 64, threads_per_transform= 49, factors=(7, 7, 7, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 693, workgroup_size=128, threads_per_transform= 99, factors=(11, 7, 9), runtime_compile=True),
    NS(length= 700, workgroup_size= 128, threads_per_transform=100, factors=(10, 7, 10), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 702, workgroup_size= 128, threads_per_transform=117, factors=(13, 3, 6, 3), runtime_compile=True),
    NS(length= 704, workgroup_size=256, threads_per_transform=88, factors=(2, 2, 2, 2, 11, 2, 2), runtime_compile=True),
    NS(length= 714, workgroup_size=64, threads_per_transform=51, factors=(3, 17, 7, 2), runtime_compile=True),
    NS(length= 715, workgroup_size=256, threads_per_transform= 65, factors=(13, 5, 11), runtime_compile=True),
    NS(length= 720, workgroup_size=256, threads_per_transform=120, factors=(10, 3, 8, 3), runtime_compile=True),
    NS(length= 726, workgroup_size=256, threads_per_transform= 66, factors=(11, 6, 11), half_lds=False, runtime_compile=True),
    NS(length= 728, workgroup_size=128, threads_per_transform=104, factors=(13, 7, 8), runtime_compile=True),
    NS(length= 729, workgroup_size=256, threads_per_transform=243, factors=(3, 3, 3, 3, 3, 3), runtime_compile=True),
    NS(length= 735, workgroup_size= 256, threads_per_transform=147, factors=(7, 3, 5, 7), half_lds=False, runtime_compile=True),
    NS(length= 748, workgroup_size= 256, threads_per_transform=68, factors=(17, 4, 11), runtime_compile=True),
    NS(length= 750, workgroup_size=256, threads_per_transform=250, factors=(10, 5, 3, 5), runtime_compile=True),
    NS(length= 756, workgroup_size= 64, threads_per_transform= 63, factors=(2, 2, 3, 3, 3, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 765, workgroup_size=256, threads_per_transform= 51, factors=(17, 3, 5, 3), runtime_compile=True),
    NS(length= 768, workgroup_size= 64, threads_per_transform= 48, factors=(16, 3, 16), runtime_compile=True),
    NS(length= 770, workgroup_size=256, threads_per_transform=110, factors=(11, 10, 7), half_lds=False, runtime_compile=True),
    NS(length= 780, workgroup_size=256, threads_per_transform= 78, factors=(2, 3, 13, 5, 2), runtime_compile=True),
    NS(length= 784, workgroup_size= 64, threads_per_transform= 56, factors=(2, 2, 2, 2, 7, 7), runtime_compile=True),
    NS(length= 792, workgroup_size=256, threads_per_transform= 88, factors=(2, 2, 2, 3, 3, 11), half_lds=False, runtime_compile=True),
    NS(length= 800, workgroup_size=256, threads_per_transform=160, factors=(16, 5, 10), runtime_compile=True),
    NS(length= 810, workgroup_size=128, threads_per_transform= 81, factors=(3, 10, 3, 3, 3), runtime_compile=True),
    NS(length= 816, workgroup_size= 64, threads_per_transform= 51, factors=(17, 2, 3, 2, 2, 2), runtime_compile=True),
    NS(length= 819, workgroup_size=128, threads_per_transform=117, factors=(9, 7, 13), half_lds=False, runtime_compile=True),
    NS(length= 825, workgroup_size= 64, threads_per_transform= 55, factors=(11, 5, 5, 3), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 832, workgroup_size=128, threads_per_transform=104, factors=(13, 2, 2, 2, 2, 2, 2), runtime_compile=True),
    NS(length= 833, workgroup_size=128, threads_per_transform=119, factors=(17, 7, 7), runtime_compile=True),
    NS(length= 840, workgroup_size= 64, threads_per_transform= 56, factors=(2, 2, 2, 3, 5, 7), runtime_compile=True),
    NS(length= 845, workgroup_size= 256, threads_per_transform=65, factors=(13, 5, 13), runtime_compile=True),
    NS(length= 847, workgroup_size= 256, threads_per_transform=77, factors=(11, 7, 11), runtime_compile=True),
    NS(length= 850, workgroup_size= 128, threads_per_transform=85, factors=(10, 5, 17), half_lds=False, runtime_compile=True),
    NS(length= 858, workgroup_size= 256, threads_per_transform=78, factors=(13, 11, 6), runtime_compile=True),
    NS(length= 864, workgroup_size= 64, threads_per_transform= 54, factors=(3, 6, 16, 3), runtime_compile=True),
    NS(length= 867, workgroup_size= 64, threads_per_transform=51, factors=(17, 17, 3), runtime_compile=True),
    NS(length= 875, workgroup_size= 256, threads_per_transform=175, factors=(7, 5, 5, 5), half_lds=False, runtime_compile=True),
    NS(length= 880, workgroup_size=256, threads_per_transform= 88, factors=(2, 2, 2, 2, 11, 5), runtime_compile=True),
    NS(length= 882, workgroup_size= 64, threads_per_transform=63, factors=(9, 7, 7, 2), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 884, workgroup_size= 256, threads_per_transform=68, factors=(13, 4, 17), runtime_compile=True),
    NS(length= 891, workgroup_size= 256, threads_per_transform=99, factors=(9, 11, 3, 3), runtime_compile=True),
    NS(length= 896, workgroup_size=128, threads_per_transform=112, factors=(2, 2, 2, 2, 2, 2, 2, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 900, workgroup_size=256, threads_per_transform= 90, factors=(10, 10, 3, 3), runtime_compile=True),
    NS(length= 910, workgroup_size=256, threads_per_transform= 91, factors=(13, 2, 7, 5), half_lds=False, runtime_compile=True),
    NS(length= 918, workgroup_size=128, threads_per_transform=102, factors=(17, 9, 2, 3), runtime_compile=True),
    NS(length= 924, workgroup_size= 64, threads_per_transform= 44, factors=(2, 2, 3, 7, 11), runtime_compile=True),
    NS(length= 935, workgroup_size= 256, threads_per_transform= 85, factors=(17, 11, 5), runtime_compile=True),
    NS(length= 936, workgroup_size=256, threads_per_transform= 78, factors=(2, 2, 13, 2, 3, 3), runtime_compile=True),
    NS(length= 945, workgroup_size= 64, threads_per_transform= 63, factors=(3, 3, 3, 5, 7), runtime_compile=True),
    NS(length= 952, workgroup_size=256, threads_per_transform= 68, factors=(17, 4, 2, 7), runtime_compile=True),
    NS(length= 960, workgroup_size=256, threads_per_transform=160, factors=(16, 10, 6), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 968, workgroup_size=256, threads_per_transform= 88, factors=(2, 2, 2, 11, 11), half_lds=False, runtime_compile=True),
    NS(length= 972, workgroup_size=256, threads_per_transform=162, factors=(3, 6, 3, 6, 3), runtime_compile=True),
    NS(length= 975, workgroup_size=128, threads_per_transform= 39, factors=(13, 5, 3, 5), runtime_compile=True),
    NS(length= 980, workgroup_size= 256, threads_per_transform=196, factors=(7, 5, 7, 4), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length= 990, workgroup_size=128, threads_per_transform=110, factors=(2, 3, 3, 5, 11), half_lds=False, runtime_compile=True),
    NS(length=1000, workgroup_size=128, threads_per_transform=100, factors=(10, 10, 10), runtime_compile=True),
    NS(length=1001, workgroup_size=256, threads_per_transform= 91, factors=(13, 7, 11), runtime_compile=True),
    NS(length=1008, workgroup_size= 64, threads_per_transform= 56, factors=(2, 2, 2, 2, 3, 3, 7), runtime_compile=True),
    NS(length=1014, workgroup_size=256, threads_per_transform= 78, factors=(13, 6, 13), half_lds=False, runtime_compile=True),
    NS(length=1020, workgroup_size=256, threads_per_transform= 68, factors=(2, 17, 2, 3, 5), runtime_compile=True),
    NS(length=1024, workgroup_size=128, threads_per_transform=128, factors=(8, 8, 4, 4)),
    NS(length=1040, workgroup_size=256, threads_per_transform=208, factors=(13, 16, 5), runtime_compile=True),
    NS(length=1050, workgroup_size=256, threads_per_transform=210, factors=(2, 3, 5, 5, 7), half_lds=False, runtime_compile=True),
    NS(length=1053, workgroup_size=128, threads_per_transform=117, factors=(3, 3, 13, 3, 3), runtime_compile=True),
    NS(length=1056, workgroup_size=256, threads_per_transform=176, factors=(2, 2, 2, 2, 11, 6), runtime_compile=True),
    NS(length=1071, workgroup_size=128, threads_per_transform=119, factors=(17, 7, 9), runtime_compile=True),
    NS(length=1078, workgroup_size=256, threads_per_transform= 77, factors=(2, 11, 7, 7), runtime_compile=True),
    NS(length=1080, workgroup_size=256, threads_per_transform=108, factors=(6, 10, 6, 3), runtime_compile=True),
    NS(length=1088, workgroup_size=256, threads_per_transform= 68, factors=(17, 4, 4, 2, 2), runtime_compile=True),
    NS(length=1089, workgroup_size=128, threads_per_transform=121, factors=(3, 11, 3, 11), half_lds=False, runtime_compile=True),
    NS(length=1092, workgroup_size= 64, threads_per_transform= 52, factors=(2, 2, 13, 7, 3), runtime_compile=True),
    NS(length=1100, workgroup_size=128, threads_per_transform=110, factors=(2, 2, 11, 5, 5), half_lds=False, runtime_compile=True),
    NS(length=1105, workgroup_size=256, threads_per_transform= 85, factors=(17, 13, 5), runtime_compile=True),
    NS(length=1120, workgroup_size=256, threads_per_transform=224, factors=(2, 2, 2, 2, 2, 5, 7), runtime_compile=True),
    NS(length=1122, workgroup_size=256, threads_per_transform=102, factors=(17, 11, 6), runtime_compile=True),
    NS(length=1125, workgroup_size=256, threads_per_transform=225, factors=(5, 5, 3, 3, 5), runtime_compile=True),
    NS(length=1134, workgroup_size=128, threads_per_transform=126, factors=(2, 3, 3, 3, 3, 7), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length=1144, workgroup_size=128, threads_per_transform=104, factors=(13, 11, 8), half_lds=False, direct_to_from_reg=False, runtime_compile=True),
    NS(length=1152, workgroup_size=256, threads_per_transform=144, factors=(4, 3, 8, 3, 4), runtime_compile=True),
    NS(length=1155, workgroup_size= 64, threads_per_transform= 55, factors=(11, 5, 7, 3), runtime_compile=True),
    NS(length=1156, workgroup_size=256, threads_per_transform= 68, factors=(17, 2, 17, 2), runtime_compile=True),
    NS(length=1170, workgroup_size=256, threads_per_transform=117, factors=(2, 13, 3, 5, 3), half_lds=False, runtime_compile=True),
    NS(length=1176, workgroup_size= 64, threads_per_transform= 56, factors=(2, 2, 2, 3, 7, 7), runtime_compile=True),
    NS(length=1183, workgroup_size=256, threads_per_transform= 91, factors=(7, 13, 13), runtime_compile=True),
    NS(length=1188, workgroup_size=256, threads_per_transform= 66, factors=(6, 11, 2, 3, 3), runtime_compile=True),
    NS(length=1190, workgroup_size=256, threads_per_transform= 85, factors=(17, 2, 5, 7), runtime_compile=True),
    NS(length=1200, workgroup_size=256, threads_per_transform= 75, factors=(5, 5, 16, 3), runtime_compile=True),
    NS(length=1210, workgroup_size=128, threads_per_transform=110, factors=(2, 5, 11, 11), runtime_compile=True),
    NS(length=1215, workgroup_size=256, threads_per_transform=243, factors=(5, 3, 3, 3, 3, 3), runtime_compile=True),
    NS(length=1224, workgroup_size=256, threads_per_transform=102, factors=(17, 3, 4, 6), runtime_compile=True),
    NS(length=1225, workgroup_size=256, threads_per_transform=175, factors=(5, 5, 7, 7), runtime_compile=True),
    NS(length=1232, workgroup_size=256, threads_per_transform=176, factors=(2, 2, 2, 2, 11, 7), runtime_compile=True),
    NS(length=1248, workgroup_size= 64, threads_per_transform= 52, factors=(2, 2, 13, 2, 3, 2, 2), runtime_compile=True),
    NS(length=1250, workgroup_size=256, threads_per_transform=250, factors=(5, 10, 5, 5), runtime_compile=True),
    NS(length=1260, workgroup_size= 64, threads_per_transform= 63, factors=(2, 2, 3, 3, 5, 7), runtime_compile=True),
    NS(length=1274, workgroup_size=256, threads_per_transform=182, factors=(2, 13, 7, 7), runtime_compile=True),
    NS(length=1275, workgroup_size=256, threads_per_transform= 85, factors=(17, 3, 5, 5), runtime_compile=True),
    NS(length=1280, workgroup_size=128, threads_per_transform= 80, factors=(16, 5, 16), runtime_compile=True),
    NS(length=1287, workgroup_size=128, threads_per_transform=117, factors=(3, 13, 3, 11), half_lds=False, runtime_compile=True),
    NS(length=1296, workgroup_size=128, threads_per_transform=108, factors=(6, 6, 6, 6), runtime_compile=True),
    NS(length=1300, workgroup_size=256, threads_per_transform=130, factors=(10, 10, 13), half_lds=False, runtime_compile=True),
    NS(length=1309, workgroup_size=128, threads_per_transform=119, factors=(17, 7, 11), runtime_compile=True),
    NS(length=1320, workgroup_size=256, threads_per_transform=165, factors=(11, 2, 3, 5, 4), half_lds=False, runtime_compile=True),
    NS(length=1323, workgroup_size=256, threads_per_transform=189, factors=(3, 3, 3, 7, 7), half_lds=False, runtime_compile=True),
    NS(length=1326, workgroup_size=256, threads_per_transform=102, factors=(17, 6, 13), runtime_compile=True),
    NS(length=1331, workgroup_size=256, threads_per_transform=121, factors=(11, 11, 11), runtime_compile=True),
    NS(length=1344, workgroup_size=256, threads_per_transform=224, factors=(2, 2, 2, 2, 2, 2, 3, 7), runtime_compile=True),
    NS(length=1350, workgroup_size=256, threads_per_transform=135, factors=(5, 10, 3, 3, 3), runtime_compile=True),
    NS(length=1352, workgroup_size= 64, threads_per_transform= 52, factors=(2, 13, 13, 4), runtime_compile=True),
    NS(length=1360, workgroup_size=256, threads_per_transform= 85, factors=(17, 5, 16), runtime_compile=True),
    NS(length=1365, workgroup_size=256, threads_per_transform= 91, factors=(13, 7, 5, 3), runtime_compile=True),
    NS(length=1372, workgroup_size=256, threads_per_transform= 98, factors=(2, 2, 7, 7, 7), runtime_compile=True),
    NS(length=1375, workgroup_size= 64, threads_per_transform= 55, factors=(11, 5, 5, 5), runtime_compile=True),
    NS(length=1377, workgroup_size= 64, threads_per_transform= 51, factors=(17, 3, 9, 3), runtime_compile=True),
    NS(length=1386, workgroup_size=256, threads_per_transform=231, factors=(2, 7, 3, 11, 3), runtime_compile=True),
    NS(length=1400, workgroup_size= 64, threads_per_transform= 56, factors=(2, 2, 2, 5, 7, 5), runtime_compile=True),
    NS(length=1404, workgroup_size=128, threads_per_transform=117, factors=(2, 2, 3, 13, 3, 3), runtime_compile=True),
    NS(length=1408, workgroup_size=256, threads_per_transform=176, factors=(2, 2, 2, 2, 2, 2, 11, 2), runtime_compile=True),
    NS(length=1428, workgroup_size=128, threads_per_transform=119, factors=(17, 2, 7, 6), runtime_compile=True),
    NS(length=1430, workgroup_size=256, threads_per_transform=143, factors=(13, 11, 10), half_lds=False, runtime_compile=True),
    NS(length=1440, workgroup_size=128, threads_per_transform= 90, factors=(10, 16, 3, 3), runtime_compile=True),
    NS(length=1445, workgroup_size=128, threads_per_transform= 85, factors=(17, 5, 17), runtime_compile=True),
    NS(length=1452, workgroup_size=256, threads_per_transform=132, factors=(11, 3, 11, 4), runtime_compile=True),
    NS(length=1456, workgroup_size=256, threads_per_transform=182, factors=(13, 4, 7, 2, 2), runtime_compile=True),
    NS(length=1458, workgroup_size=256, threads_per_transform=243, factors=(6, 3, 3, 3, 3, 3), runtime_compile=True),
    NS(length=1470, workgroup_size=256, threads_per_transform=210, factors=(2, 3, 5, 7, 7), runtime_compile=True),
    NS(length=1485, workgroup_size=256, threads_per_transform=165, factors=(3, 5, 11, 3, 3), half_lds=False, runtime_compile=True),
    NS(length=1496, workgroup_size=256, threads_per_transform=187, factors=(17, 8, 11), runtime_compile=True),
    NS(length=1500, workgroup_size=256, threads_per_transform=150, factors=(5, 10, 10, 3), runtime_compile=True),
    NS(length=1512, workgroup_size= 64, threads_per_transform= 63, factors=(2, 2, 2, 3, 3, 3, 7), runtime_compile=True),
    NS(length=1521, workgroup_size=128, threads_per_transform=117, factors=(13, 3, 3, 13), runtime_compile=True),
    NS(length=1530, workgroup_size=128, threads_per_transform=102, factors=(17, 3, 6, 5), runtime_compile=True),
    NS(length=1536, workgroup_size=256, threads_per_transform=256, factors=(16, 16, 6), runtime_compile=True),
    NS(length=1540, workgroup_size=256, threads_per_transform=154, factors=(11, 2, 7, 5, 2), runtime_compile=True),
    NS(length=1547, workgroup_size=128, threads_per_transform=119, factors=(17, 7, 13), runtime_compile=True),
    NS(length=1560, workgroup_size=256, threads_per_transform=156, factors=(13, 2, 2, 10, 3), half_lds=False, runtime_compile=True),
    NS(length=1568, workgroup_size=256, threads_per_transform=224, factors=(2, 2, 2, 2, 2, 7, 7), runtime_compile=True),
    NS(length=1573, workgroup_size=256, threads_per_transform=143, factors=(13, 11, 11), half_lds=False, runtime_compile=True),
    NS(length=1575, workgroup_size= 64, threads_per_transform= 63, factors=(3, 3, 5, 7, 5), runtime_compile=True),
    NS(length=1584, workgroup_size=256, threads_per_transform=176, factors=(4, 2, 2, 11, 3, 3), runtime_compile=True),
    NS(length=1600, workgroup_size=256, threads_per_transform=100, factors=(10, 16, 10), runtime_compile=True),
    NS(length=1617, workgroup_size=256, threads_per_transform=231, factors=(3, 7, 7, 11), half_lds=False, runtime_compile=True),
    NS(length=1620, workgroup_size=256, threads_per_transform=162, factors=(10, 3, 3, 6, 3), runtime_compile=True),
    NS(length=1625, workgroup_size=256, threads_per_transform= 65, factors=(13, 5, 5, 5), runtime_compile=True),
    NS(length=1632, workgroup_size=128, threads_per_transform=102, factors=(17, 2, 2, 3, 8), runtime_compile=True),
    NS(length=1638, workgroup_size=256, threads_per_transform=182, factors=(13, 2, 3, 7, 3), runtime_compile=True),
    NS(length=1650, workgroup_size=128, threads_per_transform=110, factors=(11, 2, 3, 5, 5), runtime_compile=True),
    NS(length=1664, workgroup_size=256, threads_per_transform=208, factors=(13, 2, 2, 4, 2, 2, 2), runtime_compile=True),
    NS(length=1666, workgroup_size=128, threads_per_transform=119, factors=(17, 2, 7, 7), runtime_compile=True),
    NS(length=1680, workgroup_size=128, threads_per_transform=112, factors=(2, 2, 2, 2, 3, 7, 5), runtime_compile=True),
    NS(length=1683, workgroup_size= 64, threads_per_transform= 51, factors=(17, 3, 11, 3), runtime_compile=True),
    NS(length=1690, workgroup_size=256, threads_per_transform=169, factors=(13, 10, 13), half_lds=False, runtime_compile=True),
    NS(length=1694, workgroup_size=256, threads_per_transform=154, factors=(11, 2, 11, 7), runtime_compile=True),
    NS(length=1700, workgroup_size=256, threads_per_transform=170, factors=(17, 10, 10), runtime_compile=True),
    NS(length=1701, workgroup_size= 64, threads_per_transform= 63, factors=(3, 3, 3, 3, 3, 7), runtime_compile=True),
    NS(length=1715, workgroup_size=256, threads_per_transform=245, factors=(5, 7, 7, 7), runtime_compile=True),
    NS(length=1716, workgroup_size=256, threads_per_transform=156, factors=(13, 2, 6, 11), half_lds=False, runtime_compile=True),
    NS(length=1728, workgroup_size=128, threads_per_transform=108, factors=(3, 6, 6, 16), runtime_compile=True),
    NS(length=1734, workgroup_size=128, threads_per_transform=102, factors=(17, 17, 6), runtime_compile=True),
    NS(length=1750, workgroup_size=256, threads_per_transform=175, factors=(2, 5, 5, 7, 5), runtime_compile=True),
    NS(length=1755, workgroup_size=128, threads_per_transform=117, factors=(13, 3, 3, 3, 5), runtime_compile=True),
    NS(length=1760, workgroup_size=256, threads_per_transform=176, factors=(2, 2, 2, 2, 2, 11, 5), runtime_compile=True),
    NS(length=1764, workgroup_size=128, threads_per_transform=126, factors=(2, 2, 3, 3, 7, 7), runtime_compile=True),
    NS(length=1768, workgroup_size=256, threads_per_transform=136, factors=(17, 13, 8), runtime_compile=True),
    NS(length=1782, workgroup_size=128, threads_per_transform= 99, factors=(11, 3, 3, 3, 3, 2), runtime_compile=True),
    NS(length=1785, workgroup_size=128, threads_per_transform=119, factors=(17, 3, 5, 7), runtime_compile=True),
    NS(length=1792, workgroup_size=256, threads_per_transform=224, factors=(4, 4, 4, 4, 7), runtime_compile=True),
    NS(length=1800, workgroup_size=256, threads_per_transform=180, factors=(10, 6, 10, 3), runtime_compile=True),
    NS(length=1815, workgroup_size=256, threads_per_transform=165, factors=(11, 3, 5, 11), half_lds=False, runtime_compile=True),
    NS(length=1820, workgroup_size=256, threads_per_transform=182, factors=(10, 13, 7, 2), runtime_compile=True),
    NS(length=1836, workgroup_size=256, threads_per_transform=153, factors=(17, 3, 3, 2, 6), runtime_compile=True),
    NS(length=1848, workgroup_size=256, threads_per_transform=231, factors=(3, 11, 7, 4, 2), runtime_compile=True),
    NS(length=1859, workgroup_size=256, threads_per_transform=169, factors=(13, 11, 13), runtime_compile=True),
    NS(length=1870, workgroup_size=256, threads_per_transform=187, factors=(17, 10, 11), runtime_compile=True),
    NS(length=1872, workgroup_size=256, threads_per_transform=156, factors=(13, 3, 4, 6, 2), runtime_compile=True),
    NS(length=1875, workgroup_size=256, threads_per_transform=125, factors=(5, 5, 5, 5, 3), runtime_compile=True),
    NS(length=1890, workgroup_size=128, threads_per_transform=126, factors=(2, 3, 3, 3, 7, 5), runtime_compile=True),
    NS(length=1904, workgroup_size=128, threads_per_transform=119, factors=(17, 2, 2, 7, 4), runtime_compile=True),
    NS(length=1911, workgroup_size=128, threads_per_transform= 91, factors=(13, 7, 7, 3), runtime_compile=True),
    NS(length=1920, workgroup_size=256, threads_per_transform=120, factors=(10, 6, 16, 2), runtime_compile=True),
    NS(length=1925, workgroup_size= 64, threads_per_transform= 55, factors=(7, 11, 5, 5), runtime_compile=True),
    NS(length=1936, workgroup_size=256, threads_per_transform=176, factors=(2, 2, 4, 11, 11), half_lds=False, runtime_compile=True),
    NS(length=1944, workgroup_size=256, threads_per_transform=243, factors=(3, 3, 3, 3, 8, 3), runtime_compile=True),
    NS(length=1950, workgroup_size=256, threads_per_transform=195, factors=(13, 5, 10, 3), half_lds=False, runtime_compile=True),
    NS(length=1960, workgroup_size= 64, threads_per_transform= 56, factors=(4, 7, 2, 7, 5), runtime_compile=True),
    NS(length=1980, workgroup_size=256, threads_per_transform=198, factors=(11, 2, 3, 3, 5, 2), runtime_compile=True),
    NS(length=1989, workgroup_size=256, threads_per_transform=153, factors=(17, 13, 9), runtime_compile=True),
    NS(length=2000, workgroup_size=128, threads_per_transform=125, factors=(5, 5, 5, 16), runtime_compile=True),
    NS(length=2002, workgroup_size=256, threads_per_transform=182, factors=(2, 13, 7, 11), runtime_compile=True),
    NS(length=2016, workgroup_size=256, threads_per_transform=112, factors=(2, 2, 2, 2, 2, 3, 3, 7), runtime_compile=True),
    NS(length=2023, workgroup_size=128, threads_per_transform=119, factors=(17, 7, 17), runtime_compile=True),
    NS(length=2025, workgroup_size=256, threads_per_transform=135, factors=(3, 3, 5, 5, 3, 3), runtime_compile=True),
    NS(length=2028, workgroup_size=256, threads_per_transform=156, factors=(13, 4, 3, 13), half_lds=False, runtime_compile=True),
    NS(length=2040, workgroup_size=256, threads_per_transform=170, factors=(17, 4, 3, 10), runtime_compile=True),
    NS(length=2048, workgroup_size=256, threads_per_transform=256, factors=(16, 16, 8), runtime_compile=True),
    NS(length=2160, workgroup_size=256, threads_per_transform= 60, factors=(10, 6, 6, 6), runtime_compile=True),
    NS(length=2187, workgroup_size=256, threads_per_transform=243, factors=(3, 3, 3, 3, 3, 3, 3), runtime_compile=True),
    NS(length=2197, workgroup_size=256, threads_per_transform=169, factors=(13, 13, 13), runtime_compile=True),
    NS(length=2250, workgroup_size=256, threads_per_transform= 90, factors=(10, 3, 5, 3, 5), runtime_compile=True),
    NS(length=2304, workgroup_size=256, threads_per_transform=192, factors=(6, 6, 4, 4, 4), runtime_compile=True),
    NS(length=2400, workgroup_size=256, threads_per_transform=240, factors=(4, 10, 10, 6), runtime_compile=True),
    NS(length=2401, workgroup_size=256, threads_per_transform= 49, factors=(7, 7, 7, 7), runtime_compile=True),
    NS(length=2430, workgroup_size=256, threads_per_transform= 81, factors=(10, 3, 3, 3, 3, 3), runtime_compile=True),
    NS(length=2500, workgroup_size=256, threads_per_transform=250, factors=(10, 5, 10, 5), runtime_compile=True),
    NS(length=2560, workgroup_size=128, threads_per_transform=128, factors=(4, 4, 4, 10, 4), runtime_compile=True),
    NS(length=2592, workgroup_size=256, threads_per_transform=216, factors=(6, 6, 6, 6, 2), runtime_compile=True),
    NS(length=2700, workgroup_size=128, threads_per_transform= 90, factors=(3, 10, 10, 3, 3), runtime_compile=True),
    NS(length=2880, workgroup_size=256, threads_per_transform= 96, factors=(10, 6, 6, 2, 2, 2), runtime_compile=True),
    NS(length=2916, workgroup_size=256, threads_per_transform=243, factors=(6, 6, 3, 3, 3, 3), runtime_compile=True),
    NS(length=3000, workgroup_size=128, threads_per_transform=100, factors=(10, 3, 10, 10), runtime_compile=True),
    NS(length=3072, workgroup_size=256, threads_per_transform=256, factors=(6, 4, 4, 4, 4, 2), runtime_compile=True),
    NS(length=3125, workgroup_size=128, threads_per_transform=125, factors=(5, 5, 5, 5, 5), runtime_compile=True),
    NS(length=3200, workgroup_size=256, threads_per_transform=160, factors=(10, 10, 4, 4, 2), runtime_compile=True),
    NS(length=3240, workgroup_size=128, threads_per_transform=108, factors=(3, 3, 10, 6, 6), runtime_compile=True),
    NS(length=3375, workgroup_size=256, threads_per_transform=225, factors=(5, 5, 5, 3, 3, 3), runtime_compile=True),
    NS(length=3456, workgroup_size=256, threads_per_transform=144, factors=(6, 6, 6, 4, 4), runtime_compile=True),
    NS(length=3600, workgroup_size=256, threads_per_transform=120, factors=(10, 10, 6, 6), runtime_compile=True),
    NS(length=3645, workgroup_size=256, threads_per_transform=243, factors=(5, 3, 3, 3, 3, 3, 3), runtime_compile=True),
    NS(length=3750, workgroup_size=256, threads_per_transform=125, factors=(3, 5, 5, 10, 5), runtime_compile=True),
    NS(length=3840, workgroup_size=256, threads_per_transform=128, factors=(10, 6, 2, 2, 2, 2, 2, 2), runtime_compile=True),
    NS(length=3888, workgroup_size=512, threads_per_transform=324, factors=(16, 3, 3, 3, 3, 3), runtime_compile=True),
    NS(length=4000, workgroup_size=256, threads_per_transform=200, factors=(10, 10, 10, 4), runtime_compile=True),
    NS(length=4050, workgroup_size=256, threads_per_transform=135, factors=(10, 5, 3, 3, 3, 3), runtime_compile=True),
    NS(length=4096, workgroup_size=256, threads_per_transform=256, factors=(16, 16, 16), runtime_compile=True),
    NS(length=4704, workgroup_size=256, threads_per_transform=224, factors=(8, 4, 7, 7, 3), double_precision=False, runtime_compile=True),
    NS(length=5488, workgroup_size=256, threads_per_transform=196, factors=(7, 4, 7, 4, 7), double_precision=False, runtime_compile=True),
    NS(length=6144, workgroup_size=512, threads_per_transform=512, factors=(16, 4, 8, 3, 4), double_precision=False, runtime_compile=True),
    NS(length=6561, workgroup_size=256, threads_per_transform=243, factors=(3, 3, 3, 3, 3, 3, 3, 3), double_precision=False, runtime_compile=True),
    NS(length=8192, workgroup_size=512, threads_per_transform=512, factors=(16, 4, 4, 4, 8), double_precision=False, runtime_compile=True),

    # configs for 160KiB LDS
    NS(length=4704, workgroup_size=256, threads_per_transform=224, factors=(8, 4, 7, 7, 3), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=5488, workgroup_size=256, threads_per_transform=196, factors=(7, 4, 7, 4, 7), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=6144, workgroup_size=384, threads_per_transform=256, factors=(4, 8, 8, 8, 3), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=6561, workgroup_size=256, threads_per_transform=243, factors=(3, 3, 3, 3, 3, 3, 3, 3), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=8192, workgroup_size=512, threads_per_transform=512, factors=(16, 4, 16, 8), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=9216, workgroup_size=512, threads_per_transform=512, factors=(4, 8, 4, 4, 3, 6), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=10000, workgroup_size=512, threads_per_transform=500, factors=(4, 5, 5, 10, 10), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=10240, workgroup_size=512, threads_per_transform=512, factors=(8, 4, 4, 4, 5, 4), lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=10752, workgroup_size=512, threads_per_transform=512, factors=(4, 16, 8, 7, 3), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=11200, workgroup_size=512, threads_per_transform=448, factors=(4, 7, 5, 16, 5), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=12288, workgroup_size=512, threads_per_transform=512, factors=(8, 8, 4, 6, 8), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=16384, workgroup_size=512, threads_per_transform=512, factors=(8, 16, 4, 8, 4), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=16807, workgroup_size=384, threads_per_transform=343, factors=(7, 7, 7, 7, 7), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=18816, workgroup_size=512, threads_per_transform=448, factors=(8, 8, 7, 7, 6), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=19200, workgroup_size=512, threads_per_transform=480, factors=(8, 10, 8, 5, 6), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
    NS(length=20480, workgroup_size=512, threads_per_transform=512, factors=(4, 4, 16, 10, 8), double_precision=False, lds_size_bytes=config_lds.LDS_160k, runtime_compile=True),
]
