//This file is automatically generated. DO NOT EDIT!

#ifndef ROBOTRACONTEUR_USE_STDAFX
#include "com__robotraconteur__testing__TestService1_stubskel.h"
#include <boost/algorithm/string.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/assign/list_of.hpp>
#else
#include "stdafx.h"
#endif
// NOLINTBEGIN
namespace com
{
namespace robotraconteur
{
namespace testing
{
namespace TestService1
{
std::string com__robotraconteur__testing__TestService1Factory::GetServiceName()
{
return "com.robotraconteur.testing.TestService1";
}
std::string com__robotraconteur__testing__TestService1Factory::DefString()
{
std::string out(
"#This is the standard test service for RobotRaconteur\n"
"#It is not meant to be exhaustive, rather it tests the\n"
"#most common operations.\n"
"\n"
"#Each of the members defined has a specified behavior.\n"
"#Refer to the reference implementation for details\n"
"#on these behaviors.  New implementations of\n"
"#Robot Raconteur should test against the reference\n"
"#client and server to determine compatibility.\n"
"\n"
"service com.robotraconteur.testing.TestService1\n"
"\n"
"option version 0.8\n"
"\n"
"import com.robotraconteur.testing.TestService2\n"
"\n"
"exception testexception1\n"
"exception testexception2\n"
"\n"
"struct teststruct1\n"
"	field double[] dat1\n"
"	field string str2\n"
"	field string{int32} vec3\n"
"	field string{string} dict4\n"
"	field string{list} list5\n"
"	field teststruct2 struct1\n"
"	field teststruct2{string} dstruct2\n"
"	field teststruct2{list} lstruct3\n"
"	field double[*] multidimarray\n"
"\n"
"	field varvalue var3\n"
"\n"
"end struct\n"
"\n"
"struct teststruct2\n"
"	field double[] mydat\n"
"\n"
"end struct\n"
"\n"
"object testroot\n"
"	implements com.robotraconteur.testing.TestService2.baseobj\n"
"\n"
"	option constant double[] doubleconst {3.4, 4.8, 14372.8}\n"
"	option constant string strconst \"This is a constant\"\n"
"\n"
"#Properties to test the serialization of different data types\n"
"\n"
"	#numbers\n"
"\n"
"	property double d1\n"
"	property double[] d2\n"
"	property double[16] d3\n"
"	property double[16-] d4\n"
"	property double[*] d5\n"
"	property double[3,3] d6\n"
"\n"
"	property single s1\n"
"	property single[] s2\n"
"\n"
"	property int8 i8_1\n"
"	property int8[] i8_2\n"
"\n"
"	property uint8 u8_1\n"
"	property uint8[] u8_2\n"
"	property uint8[*] u8_3\n"
"\n"
"	property int16 i16_1\n"
"	property int16[] i16_2\n"
"\n"
"	property uint16 u16_1\n"
"	property uint16[] u16_2\n"
"\n"
"	property int32 i32_1\n"
"	property int32[] i32_2\n"
"	property int32[] i32_huge\n"
"\n"
"	property uint32 u32_1\n"
"	property uint32[] u32_2\n"
"\n"
"	property int64 i64_1\n"
"	property int64[] i64_2\n"
"\n"
"	property uint64 u64_1\n"
"	property uint64[] u64_2\n"
"\n"
"	#strings\n"
"	property string str1\n"
"\n"
"	#structs\n"
"	property teststruct1 struct1\n"
"	property teststruct2 struct2\n"
"\n"
"	#indexed sets\n"
"	property double{int32} is_d1\n"
"	property double{string} is_d2\n"
"	property double[]{int32} is_d3\n"
"	property double[]{string} is_d4\n"
"	property double[*]{int32} is_d5\n"
"	property double[*]{string} is_d6\n"
"\n"
"	property string{int32} is_str1\n"
"	property string{string} is_str2\n"
"\n"
"	property teststruct2{int32} is_struct1\n"
"	property teststruct2{string} is_struct2\n"
"	property com.robotraconteur.testing.TestService2.ostruct2 struct3\n"
"\n"
"	#lists\n"
"	property double{list} list_d1\n"
"	property double[]{list} list_d3\n"
"	property double[*]{list} list_d5\n"
"\n"
"	property string{list} list_str1\n"
"	property teststruct2{list} list_struct1\n"
"\n"
"	#varvalue\n"
"	property varvalue var1\n"
"	property varvalue{int32} var2\n"
"	property varvalue var_num\n"
"	property varvalue var_str\n"
"	property varvalue var_struct\n"
"	property varvalue var_vector\n"
"	property varvalue var_dictionary\n"
"	property varvalue var_list\n"
"	property varvalue var_multidimarray\n"
"\n"
"	#Throw an error to test error transmission\n"
"	property double errtest\n"
"	property teststruct1 nulltest\n"
"\n"
"	#functions\n"
"	function void func1()\n"
"	function void func2(double d1, double d2)\n"
"	function double func3(double d1, double d2)\n"
"	function int32 meaning_of_life()\n"
"	function void func_errtest()\n"
"	function void func_errtest1()\n"
"	function void func_errtest2()\n"
"	function void func_errtest3()\n"
"\n"
"	#events\n"
"\n"
"	event ev1()\n"
"	event ev2(double d1, teststruct2 s2 )\n"
"\n"
"	#objrefs\n"
"\n"
"	objref sub1 o1\n"
"	objref sub1[] o2\n"
"	objref sub1{int32} o3\n"
"	objref sub1{string} o4\n"
"	objref com.robotraconteur.testing.TestService2.subobj o5\n"
"\n"
"	objref varobject o6\n"
"\n"
"	function void o6_op(int32 op)\n"
"\n"
"	#pipes\n"
"\n"
"	pipe double[] p1\n"
"\n"
"	#option pipe p2 unreliable\n"
"	pipe teststruct2 p2\n"
"	function void pipe_check_error()\n"
"\n"
"	pipe double broadcastpipe\n"
"\n"
"	#callbacks\n"
"	callback void cb1()\n"
"	callback void cb2(double d1, double d2)\n"
"	callback double cb3(double d1, double d2)\n"
"	callback int32 cb_meaning_of_life()\n"
"	callback void cb_errtest()\n"
"\n"
"	function void test_callbacks()\n"
"\n"
"	#wires\n"
"\n"
"	wire double[] w1\n"
"	wire teststruct2 w2\n"
"	wire int32[*] w3\n"
"\n"
"	wire double broadcastwire\n"
"\n"
"	#memory\n"
"\n"
"	memory double[] m1\n"
"	memory double[*] m2\n"
"	memory uint8[*] m3\n"
"\n"
"end object\n"
"\n"
"object sub1\n"
"	property double[] d1\n"
"	property double[*] d2\n"
"\n"
"	objref sub2 o2_1\n"
"	objref sub2{int32} o2_2\n"
"	objref sub2{string} o2_3\n"
"\n"
"	property string s_ind\n"
"	property int32 i_ind\n"
"\n"
"end object\n"
"\n"
"object sub2\n"
"\n"
"	property string s_ind\n"
"	property int32 i_ind\n"
"\n"
"	property string data\n"
"	objref sub3{string} o3_1\n"
"end object\n"
"\n"
"object sub3\n"
"	property string ind\n"
"	property string data2\n"
"	property double data3\n"
"	function double add(double d)\n"
"end object\n"
"\n"
);
return out;
}
RR_SHARED_PTR<RobotRaconteur::StructureStub> com__robotraconteur__testing__TestService1Factory::FindStructureStub(boost::string_ref s)
{
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(s);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (objecttype=="teststruct1") return RobotRaconteur::rr_cast<RobotRaconteur::StructureStub>(RR_MAKE_SHARED<teststruct1_stub>(GetNode()));
if (objecttype=="teststruct2") return RobotRaconteur::rr_cast<RobotRaconteur::StructureStub>(RR_MAKE_SHARED<teststruct2_stub>(GetNode()));
throw RobotRaconteur::ServiceException("Invalid structure stub type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList> com__robotraconteur__testing__TestService1Factory::PackStructure(const RR_INTRUSIVE_PTR<RobotRaconteur::RRStructure>& structin)
{
std::string type=structin->RRType();boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->PackStructure(structin);
RR_SHARED_PTR<RobotRaconteur::StructureStub> stub=FindStructureStub(type);
return stub->PackStructure(structin);
throw RobotRaconteur::ServiceException("Invalid structure stub type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> com__robotraconteur__testing__TestService1Factory::UnpackStructure(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList>& mstructin)
{
RobotRaconteur::MessageStringPtr type=mstructin->GetTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type.str());
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->UnpackStructure(mstructin);
RR_SHARED_PTR<RobotRaconteur::StructureStub> stub=FindStructureStub(type.str());
return stub->UnpackStructure(mstructin);
throw RobotRaconteur::ServiceException("Invalid structure stub type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList> com__robotraconteur__testing__TestService1Factory::PackPodArray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRPodBaseArray>& structin)
{
boost::string_ref type=structin->RRElementTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->PackPodArray(structin);
throw RobotRaconteur::ServiceException("Invalid pod type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRPodBaseArray> com__robotraconteur__testing__TestService1Factory::UnpackPodArray(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList>& mstructin)
{
RobotRaconteur::MessageStringPtr type=mstructin->GetTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type.str());
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->UnpackPodArray(mstructin);
throw RobotRaconteur::ServiceException("Invalid pod type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList> com__robotraconteur__testing__TestService1Factory::PackPodMultiDimArray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRPodBaseMultiDimArray>& structin)
{
boost::string_ref type=structin->RRElementTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->PackPodMultiDimArray(structin);
throw RobotRaconteur::ServiceException("Invalid pod type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRPodBaseMultiDimArray> com__robotraconteur__testing__TestService1Factory::UnpackPodMultiDimArray(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList>& mstructin)
{
RobotRaconteur::MessageStringPtr type=mstructin->GetTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type.str());
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->UnpackPodMultiDimArray(mstructin);
throw RobotRaconteur::ServiceException("Invalid pod type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList> com__robotraconteur__testing__TestService1Factory::PackNamedArray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRNamedBaseArray>& structin)
{
boost::string_ref type=structin->RRElementTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->PackNamedArray(structin);
throw RobotRaconteur::ServiceException("Invalid namedarray type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRNamedBaseArray> com__robotraconteur__testing__TestService1Factory::UnpackNamedArray(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList>& mstructin)
{
RobotRaconteur::MessageStringPtr type=mstructin->GetTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type.str());
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->UnpackNamedArray(mstructin);
throw RobotRaconteur::ServiceException("Invalid namedarray type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList> com__robotraconteur__testing__TestService1Factory::PackNamedMultiDimArray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRNamedBaseMultiDimArray>& structin)
{
boost::string_ref type=structin->RRElementTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->PackNamedMultiDimArray(structin);
throw RobotRaconteur::ServiceException("Invalid namedarray type.");
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRNamedBaseMultiDimArray> com__robotraconteur__testing__TestService1Factory::UnpackNamedMultiDimArray(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList>& mstructin)
{
RobotRaconteur::MessageStringPtr type=mstructin->GetTypeString();
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type.str());
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->UnpackNamedMultiDimArray(mstructin);
throw RobotRaconteur::ServiceException("Invalid namedarray type.");
}
RR_SHARED_PTR<RobotRaconteur::ServiceStub> com__robotraconteur__testing__TestService1Factory::CreateStub(boost::string_ref type, boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::ClientContext>& context)
{
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->GetServiceType(servicetype)->CreateStub(type,path,context);
if (objecttype=="testroot") { RR_SHARED_PTR<testroot_stub> o=(RR_MAKE_SHARED<testroot_stub>(path,context)); o->RRInitStub(); return o; }
if (objecttype=="sub1") { RR_SHARED_PTR<sub1_stub> o=(RR_MAKE_SHARED<sub1_stub>(path,context)); o->RRInitStub(); return o; }
if (objecttype=="sub2") { RR_SHARED_PTR<sub2_stub> o=(RR_MAKE_SHARED<sub2_stub>(path,context)); o->RRInitStub(); return o; }
if (objecttype=="sub3") { RR_SHARED_PTR<sub3_stub> o=(RR_MAKE_SHARED<sub3_stub>(path,context)); o->RRInitStub(); return o; }
throw RobotRaconteur::ServiceException("Invalid structure stub type.");
}
RR_SHARED_PTR<RobotRaconteur::ServiceSkel> com__robotraconteur__testing__TestService1Factory::CreateSkel(boost::string_ref type, const boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::RRObject>& obj, const RR_SHARED_PTR<RobotRaconteur::ServerContext>& context)
{
boost::tuple<boost::string_ref,boost::string_ref> res=RobotRaconteur::SplitQualifiedName(type);
boost::string_ref servicetype=res.get<0>();
boost::string_ref objecttype=res.get<1>();
if (servicetype != "com.robotraconteur.testing.TestService1") return GetNode()->GetServiceType(servicetype)->CreateSkel(type,path,obj,context);
if (objecttype=="testroot") {RR_SHARED_PTR<testroot_skel> o=RR_MAKE_SHARED<testroot_skel>(); o->Init(path,obj,context); return o; }
if (objecttype=="sub1") {RR_SHARED_PTR<sub1_skel> o=RR_MAKE_SHARED<sub1_skel>(); o->Init(path,obj,context); return o; }
if (objecttype=="sub2") {RR_SHARED_PTR<sub2_skel> o=RR_MAKE_SHARED<sub2_skel>(); o->Init(path,obj,context); return o; }
if (objecttype=="sub3") {RR_SHARED_PTR<sub3_skel> o=RR_MAKE_SHARED<sub3_skel>(); o->Init(path,obj,context); return o; }
throw RobotRaconteur::ServiceException("Invalid structure skel type.");
return RR_SHARED_PTR<RobotRaconteur::ServiceSkel>();
}
void com__robotraconteur__testing__TestService1Factory::DownCastAndThrowException(RobotRaconteur::RobotRaconteurException& rr_exp)
{
std::string rr_type=rr_exp.Error;
if (rr_type.find('.')==std::string::npos)
{
	return;
}
boost::tuple<boost::string_ref,boost::string_ref> rr_res=RobotRaconteur::SplitQualifiedName(rr_type);
if (rr_res.get<0>() != "com.robotraconteur.testing.TestService1") GetNode()->DownCastAndThrowException(rr_exp);
if (rr_res.get<1>()=="testexception1") throw testexception1(rr_exp.Message,rr_exp.ErrorSubName,rr_exp.ErrorParam);
if (rr_res.get<1>()=="testexception2") throw testexception2(rr_exp.Message,rr_exp.ErrorSubName,rr_exp.ErrorParam);
return;
}
RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException> com__robotraconteur__testing__TestService1Factory::DownCastException(const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& rr_exp){
if (!rr_exp) return rr_exp;
std::string rr_type=rr_exp->Error;
if (rr_type.find('.')==std::string::npos)
{
	return rr_exp;
}
boost::tuple<boost::string_ref,boost::string_ref> rr_res=RobotRaconteur::SplitQualifiedName(rr_type);
if (rr_res.get<0>() != "com.robotraconteur.testing.TestService1") return GetNode()->DownCastException(rr_exp);
if (rr_res.get<1>()=="testexception1") return RR_MAKE_SHARED<testexception1>(rr_exp->Message,rr_exp->ErrorSubName,rr_exp->ErrorParam);
if (rr_res.get<1>()=="testexception2") return RR_MAKE_SHARED<testexception2>(rr_exp->Message,rr_exp->ErrorSubName,rr_exp->ErrorParam);
return rr_exp;
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList> teststruct1_stub::PackStructure(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& s)
{
RR_INTRUSIVE_PTR<teststruct1 > s2=RobotRaconteur::rr_cast<teststruct1 >(s);
std::vector<RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> > vret;
vret.reserve(10);
vret.push_back(RobotRaconteur::MessageElement_PackArrayElement<double >("dat1",s2->dat1));
vret.push_back(RobotRaconteur::MessageElement_PackStringElement("str2",s2->str2));
vret.push_back(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"vec3",s2->vec3));
vret.push_back(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"dict4",s2->dict4));
vret.push_back(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"list5",s2->list5));
vret.push_back(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"struct1",s2->struct1));
vret.push_back(RobotRaconteur::MessageElement_PackMapElement<std::string,teststruct2  >(RRGetNodeWeak(),"dstruct2",s2->dstruct2));
vret.push_back(RobotRaconteur::MessageElement_PackListElement<teststruct2  >(RRGetNodeWeak(),"lstruct3",s2->lstruct3));
vret.push_back(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"multidimarray",s2->multidimarray));
vret.push_back(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"var3",s2->var3));
return RobotRaconteur::CreateMessageElementNestedElementList(RobotRaconteur::DataTypes_structure_t,"com.robotraconteur.testing.TestService1.teststruct1",RR_MOVE(vret));
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRStructure> teststruct1_stub::UnpackStructure(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList>& m)
{
std::vector<RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> >& i = m->Elements;
RR_INTRUSIVE_PTR<teststruct1 > ret(new teststruct1());
ret->dat1=RobotRaconteur::MessageElement_UnpackArray<double >(RobotRaconteur::MessageElement::FindElement(i,"dat1"));
ret->str2=RobotRaconteur::MessageElement_UnpackString(RobotRaconteur::MessageElement::FindElement(i,"str2"));
ret->vec3=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),RobotRaconteur::MessageElement::FindElement(i,"vec3"));
ret->dict4=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),RobotRaconteur::MessageElement::FindElement(i,"dict4"));
ret->list5=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),RobotRaconteur::MessageElement::FindElement(i,"list5"));
ret->struct1=RobotRaconteur::MessageElement_UnpackStructure<teststruct2 >(RRGetNodeWeak(), RobotRaconteur::MessageElement::FindElement(i,"struct1"));
ret->dstruct2=RobotRaconteur::MessageElement_UnpackMap<std::string,teststruct2  >(RRGetNodeWeak(),RobotRaconteur::MessageElement::FindElement(i,"dstruct2"));
ret->lstruct3=RobotRaconteur::MessageElement_UnpackList<teststruct2  >(RRGetNodeWeak(),RobotRaconteur::MessageElement::FindElement(i,"lstruct3"));
ret->multidimarray=RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),RobotRaconteur::MessageElement::FindElement(i,"multidimarray"));
ret->var3=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),RobotRaconteur::MessageElement::FindElement(i,"var3"));
return ret;
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList> teststruct2_stub::PackStructure(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& s)
{
RR_INTRUSIVE_PTR<teststruct2 > s2=RobotRaconteur::rr_cast<teststruct2 >(s);
std::vector<RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> > vret;
vret.reserve(1);
vret.push_back(RobotRaconteur::MessageElement_PackArrayElement<double >("mydat",s2->mydat));
return RobotRaconteur::CreateMessageElementNestedElementList(RobotRaconteur::DataTypes_structure_t,"com.robotraconteur.testing.TestService1.teststruct2",RR_MOVE(vret));
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRStructure> teststruct2_stub::UnpackStructure(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageElementNestedElementList>& m)
{
std::vector<RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> >& i = m->Elements;
RR_INTRUSIVE_PTR<teststruct2 > ret(new teststruct2());
ret->mydat=RobotRaconteur::MessageElement_UnpackArray<double >(RobotRaconteur::MessageElement::FindElement(i,"mydat"));
return ret;
}

testroot_stub::testroot_stub(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::ClientContext>& c) : RobotRaconteur::ServiceStub(path,c){ }
void testroot_stub::RRInitStub()
{
rrvar_p1=RR_MAKE_SHARED<RobotRaconteur::PipeClient<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >("p1",shared_from_this(), false,RobotRaconteur::MemberDefinition_Direction_both) ;
rrvar_p2=RR_MAKE_SHARED<RobotRaconteur::PipeClient<RR_INTRUSIVE_PTR<teststruct2 > > >("p2",shared_from_this(), false,RobotRaconteur::MemberDefinition_Direction_both) ;
rrvar_broadcastpipe=RR_MAKE_SHARED<RobotRaconteur::PipeClient<double > >("broadcastpipe",shared_from_this(), false,RobotRaconteur::MemberDefinition_Direction_both) ;
rrvar_cb1=RR_MAKE_SHARED<RobotRaconteur::CallbackClient<boost::function<void() > > >("cb1") ;
rrvar_cb2=RR_MAKE_SHARED<RobotRaconteur::CallbackClient<boost::function<void(double, double) > > >("cb2") ;
rrvar_cb3=RR_MAKE_SHARED<RobotRaconteur::CallbackClient<boost::function<double(double, double) > > >("cb3") ;
rrvar_cb_meaning_of_life=RR_MAKE_SHARED<RobotRaconteur::CallbackClient<boost::function<int32_t() > > >("cb_meaning_of_life") ;
rrvar_cb_errtest=RR_MAKE_SHARED<RobotRaconteur::CallbackClient<boost::function<void() > > >("cb_errtest") ;
rrvar_w1=RR_MAKE_SHARED<RobotRaconteur::WireClient<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >("w1",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rrvar_w2=RR_MAKE_SHARED<RobotRaconteur::WireClient<RR_INTRUSIVE_PTR<teststruct2 > > >("w2",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rrvar_w3=RR_MAKE_SHARED<RobotRaconteur::WireClient<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > >("w3",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rrvar_broadcastwire=RR_MAKE_SHARED<RobotRaconteur::WireClient<double > >("broadcastwire",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rrvar_m1=RR_MAKE_SHARED<RobotRaconteur::ArrayMemoryClient<double > >("m1",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rrvar_m2=RR_MAKE_SHARED<RobotRaconteur::MultiDimArrayMemoryClient<double > >("m2",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rrvar_m3=RR_MAKE_SHARED<RobotRaconteur::MultiDimArrayMemoryClient<uint8_t > >("m3",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
}

double testroot_stub::get_d1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
void testroot_stub::set_d1(double value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_stub::get_d2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<double >(me);
}
void testroot_stub::set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_stub::get_d3()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d3");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::VerifyRRArrayLength(RobotRaconteur::MessageElement_UnpackArray<double >(me), 16, false);
}
void testroot_stub::set_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d3");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, false)));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_stub::get_d4()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d4");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::VerifyRRArrayLength(RobotRaconteur::MessageElement_UnpackArray<double >(me), 16, true);
}
void testroot_stub::set_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d4");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, true)));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > testroot_stub::get_d5()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d5");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),me);
}
void testroot_stub::set_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d5");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > testroot_stub::get_d6()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d6");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::VerifyRRMultiDimArrayLength<2>(RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),me),9,boost::assign::list_of(3)(3));
}
void testroot_stub::set_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d6");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",RobotRaconteur::VerifyRRMultiDimArrayLength<2>(value,9,boost::assign::list_of(3)(3))));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

float testroot_stub::get_s1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<float >(me);
}
void testroot_stub::set_s1(float value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<float >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > > testroot_stub::get_s2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<float >(me);
}
void testroot_stub::set_s2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<float >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

int8_t testroot_stub::get_i8_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i8_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<int8_t >(me);
}
void testroot_stub::set_i8_1(int8_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i8_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int8_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > > testroot_stub::get_i8_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i8_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<int8_t >(me);
}
void testroot_stub::set_i8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i8_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int8_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

uint8_t testroot_stub::get_u8_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u8_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<uint8_t >(me);
}
void testroot_stub::set_u8_1(uint8_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u8_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint8_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > > testroot_stub::get_u8_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u8_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<uint8_t >(me);
}
void testroot_stub::set_u8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u8_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint8_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > > testroot_stub::get_u8_3()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u8_3");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMultiDimArray<uint8_t >(RRGetNodeWeak(),me);
}
void testroot_stub::set_u8_3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u8_3");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<uint8_t >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

int16_t testroot_stub::get_i16_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i16_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<int16_t >(me);
}
void testroot_stub::set_i16_1(int16_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i16_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int16_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > > testroot_stub::get_i16_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i16_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<int16_t >(me);
}
void testroot_stub::set_i16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i16_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int16_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

uint16_t testroot_stub::get_u16_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u16_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<uint16_t >(me);
}
void testroot_stub::set_u16_1(uint16_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u16_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint16_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > > testroot_stub::get_u16_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u16_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<uint16_t >(me);
}
void testroot_stub::set_u16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u16_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint16_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

int32_t testroot_stub::get_i32_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i32_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<int32_t >(me);
}
void testroot_stub::set_i32_1(int32_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i32_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > testroot_stub::get_i32_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i32_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<int32_t >(me);
}
void testroot_stub::set_i32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i32_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > testroot_stub::get_i32_huge()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i32_huge");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<int32_t >(me);
}
void testroot_stub::set_i32_huge(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i32_huge");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

uint32_t testroot_stub::get_u32_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u32_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<uint32_t >(me);
}
void testroot_stub::set_u32_1(uint32_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u32_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint32_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > > testroot_stub::get_u32_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u32_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<uint32_t >(me);
}
void testroot_stub::set_u32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u32_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint32_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

int64_t testroot_stub::get_i64_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i64_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<int64_t >(me);
}
void testroot_stub::set_i64_1(int64_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i64_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int64_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > > testroot_stub::get_i64_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i64_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<int64_t >(me);
}
void testroot_stub::set_i64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i64_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int64_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

uint64_t testroot_stub::get_u64_1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u64_1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<uint64_t >(me);
}
void testroot_stub::set_u64_1(uint64_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u64_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint64_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > > testroot_stub::get_u64_2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u64_2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<uint64_t >(me);
}
void testroot_stub::set_u64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u64_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint64_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

std::string testroot_stub::get_str1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"str1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackString(me);
}
void testroot_stub::set_str1(const std::string& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"str1");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<teststruct1 > testroot_stub::get_struct1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"struct1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackStructure<teststruct1 >(RRGetNodeWeak(), me);
}
void testroot_stub::set_struct1(const RR_INTRUSIVE_PTR<teststruct1 >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"struct1");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<teststruct2 > testroot_stub::get_struct2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"struct2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackStructure<teststruct2 >(RRGetNodeWeak(), me);
}
void testroot_stub::set_struct2(const RR_INTRUSIVE_PTR<teststruct2 >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"struct2");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > testroot_stub::get_is_d1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d1");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > testroot_stub::get_is_d2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > testroot_stub::get_is_d3()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d3");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d3");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > testroot_stub::get_is_d4()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d4");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d4");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > > testroot_stub::get_is_d5()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d5");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d5");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > > testroot_stub::get_is_d6()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d6");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d6");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > > testroot_stub::get_is_str1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_str1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_str1");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > > testroot_stub::get_is_str2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_str2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_str2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_str2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > > testroot_stub::get_is_struct1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_struct1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<int32_t,teststruct2  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_struct1");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,teststruct2  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > > testroot_stub::get_is_struct2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_struct2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<std::string,teststruct2  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_is_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_struct2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,teststruct2  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 > testroot_stub::get_struct3()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"struct3");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackStructure<com::robotraconteur::testing::TestService2::ostruct2 >(RRGetNodeWeak(), me);
}
void testroot_stub::set_struct3(const RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"struct3");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > testroot_stub::get_list_d1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_d1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_list_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_d1");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > testroot_stub::get_list_d3()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_d3");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_list_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_d3");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > > testroot_stub::get_list_d5()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_d5");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_list_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_d5");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > > testroot_stub::get_list_str1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_str1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_list_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_str1");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > > testroot_stub::get_list_struct1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_struct1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackList<teststruct2  >(RRGetNodeWeak(),me);
}
void testroot_stub::set_list_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_struct1");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<teststruct2  >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var1");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > > testroot_stub::get_var2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRValue >(RRGetNodeWeak(),me);
}
void testroot_stub::set_var2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRValue >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var_num()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_num");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var_num(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_num");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var_str()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_str");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var_str(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_str");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var_struct()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_struct");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var_struct(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_struct");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var_vector()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_vector");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var_vector(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_vector");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var_dictionary()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_dictionary");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var_dictionary(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_dictionary");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var_list()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_list");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var_list(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_list");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_stub::get_var_multidimarray()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_multidimarray");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
void testroot_stub::set_var_multidimarray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_multidimarray");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

double testroot_stub::get_errtest()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"errtest");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
void testroot_stub::set_errtest(double value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"errtest");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<teststruct1 > testroot_stub::get_nulltest()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"nulltest");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackStructure<teststruct1 >(RRGetNodeWeak(), me);
}
void testroot_stub::set_nulltest(const RR_INTRUSIVE_PTR<teststruct1 >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"nulltest");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

void testroot_stub::func1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

void testroot_stub::func2(double d1, double d2)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func2");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d1",d1));
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d2",d2));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

double testroot_stub::func3(double d1, double d2)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func3");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d1",d1));
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d2",d2));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> rr_me=rr_ret->FindElement("return");
return RobotRaconteur::MessageElement_UnpackScalar<double >(rr_me);
}

int32_t testroot_stub::meaning_of_life()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"meaning_of_life");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> rr_me=rr_ret->FindElement("return");
return RobotRaconteur::MessageElement_UnpackScalar<int32_t >(rr_me);
}

void testroot_stub::func_errtest()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

void testroot_stub::func_errtest1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

void testroot_stub::func_errtest2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

void testroot_stub::func_errtest3()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest3");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

void testroot_stub::o6_op(int32_t op)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"o6_op");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("op",op));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

void testroot_stub::pipe_check_error()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"pipe_check_error");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

void testroot_stub::test_callbacks()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"test_callbacks");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
}

boost::signals2::signal<void ()>& testroot_stub::get_ev1()
{
return rrvar_ev1;
}

boost::signals2::signal<void (double, RR_INTRUSIVE_PTR<teststruct2 >)>& testroot_stub::get_ev2()
{
return rrvar_ev2;
}

RR_SHARED_PTR<sub1 > testroot_stub::get_o1()
{
return RobotRaconteur::rr_cast<sub1 >(FindObjRefTyped("o1","com.robotraconteur.testing.TestService1.sub1"));
}

RR_SHARED_PTR<sub1 > testroot_stub::get_o2(int32_t ind)
{
return RobotRaconteur::rr_cast<sub1 >(FindObjRefTyped("o2", boost::lexical_cast<std::string>(ind),"com.robotraconteur.testing.TestService1.sub1"));
}

RR_SHARED_PTR<sub1 > testroot_stub::get_o3(int32_t ind)
{
return RobotRaconteur::rr_cast<sub1 >(FindObjRefTyped("o3", boost::lexical_cast<std::string>(ind),"com.robotraconteur.testing.TestService1.sub1"));
}

RR_SHARED_PTR<sub1 > testroot_stub::get_o4(const std::string& ind)
{
return RobotRaconteur::rr_cast<sub1 >(FindObjRefTyped("o4", ind,"com.robotraconteur.testing.TestService1.sub1"));
}

RR_SHARED_PTR<com::robotraconteur::testing::TestService2::subobj > testroot_stub::get_o5()
{
return RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService2::subobj >(FindObjRefTyped("o5","com.robotraconteur.testing.TestService2.subobj"));
}

RR_SHARED_PTR<RobotRaconteur::RRObject > testroot_stub::get_o6()
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject >(FindObjRef("o6"));
}

RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > > testroot_stub::get_p1()
{
RR_SHARED_PTR<RobotRaconteur::PipeClient<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > > value=rrvar_p1;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_p1(const RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}

RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<teststruct2 > > > testroot_stub::get_p2()
{
RR_SHARED_PTR<RobotRaconteur::PipeClient<RR_INTRUSIVE_PTR<teststruct2 > > > value=rrvar_p2;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_p2(const RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<teststruct2 > > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}

RR_SHARED_PTR<RobotRaconteur::Pipe<double > > testroot_stub::get_broadcastpipe()
{
RR_SHARED_PTR<RobotRaconteur::PipeClient<double > > value=rrvar_broadcastpipe;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_broadcastpipe(const RR_SHARED_PTR<RobotRaconteur::Pipe<double > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}

RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void() > > > testroot_stub::get_cb1()
{
RR_SHARED_PTR<RobotRaconteur::CallbackClient<boost::function<void() > > > value=rrvar_cb1;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_cb1(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void()> > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void(double, double) > > > testroot_stub::get_cb2()
{
RR_SHARED_PTR<RobotRaconteur::CallbackClient<boost::function<void(double, double) > > > value=rrvar_cb2;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_cb2(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void(double, double)> > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<double(double, double) > > > testroot_stub::get_cb3()
{
RR_SHARED_PTR<RobotRaconteur::CallbackClient<boost::function<double(double, double) > > > value=rrvar_cb3;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_cb3(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<double(double, double)> > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<int32_t() > > > testroot_stub::get_cb_meaning_of_life()
{
RR_SHARED_PTR<RobotRaconteur::CallbackClient<boost::function<int32_t() > > > value=rrvar_cb_meaning_of_life;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_cb_meaning_of_life(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<int32_t()> > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void() > > > testroot_stub::get_cb_errtest()
{
RR_SHARED_PTR<RobotRaconteur::CallbackClient<boost::function<void() > > > value=rrvar_cb_errtest;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_cb_errtest(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void()> > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}
RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > > testroot_stub::get_w1()
{
RR_SHARED_PTR<RobotRaconteur::WireClient<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > > value=rrvar_w1;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_w1(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}

RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<teststruct2 > > > testroot_stub::get_w2()
{
RR_SHARED_PTR<RobotRaconteur::WireClient<RR_INTRUSIVE_PTR<teststruct2 > > > value=rrvar_w2;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_w2(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<teststruct2 > > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}

RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > > testroot_stub::get_w3()
{
RR_SHARED_PTR<RobotRaconteur::WireClient<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > > value=rrvar_w3;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_w3(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}

RR_SHARED_PTR<RobotRaconteur::Wire<double > > testroot_stub::get_broadcastwire()
{
RR_SHARED_PTR<RobotRaconteur::WireClient<double > > value=rrvar_broadcastwire;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::set_broadcastwire(const RR_SHARED_PTR<RobotRaconteur::Wire<double > >& value)
{
throw RobotRaconteur::InvalidOperationException("Not valid for client");
}

RR_SHARED_PTR<RobotRaconteur::ArrayMemory<double > > testroot_stub::get_m1()
{
RR_SHARED_PTR<RobotRaconteur::ArrayMemoryClient<double > > value=rrvar_m1;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemory<double > > testroot_stub::get_m2()
{
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemoryClient<double > > value=rrvar_m2;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemory<uint8_t > > testroot_stub::get_m3()
{
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemoryClient<uint8_t > > value=rrvar_m3;
if (!value) throw RobotRaconteur::InvalidOperationException("Stub has been closed");
return value;
}
void testroot_stub::DispatchEvent(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
if (rr_m->MemberName=="ev1")
{
get_ev1()();
return;
}
if (rr_m->MemberName=="ev2")
{
double d1=RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d1"));
RR_INTRUSIVE_PTR<teststruct2 > s2=RobotRaconteur::MessageElement_UnpackStructure<teststruct2 >(RRGetNodeWeak(), rr_m->FindElement("s2"));
get_ev2()(d1, s2);
return;
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void testroot_stub::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
if (m->MemberName=="p1")
{
rrvar_p1->PipePacketReceived(m);
return;
}
if (m->MemberName=="p2")
{
rrvar_p2->PipePacketReceived(m);
return;
}
if (m->MemberName=="broadcastpipe")
{
rrvar_broadcastpipe->PipePacketReceived(m);
return;
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void testroot_stub::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
if (m->MemberName=="w1")
{
rrvar_w1->WirePacketReceived(m);
return;
}
if (m->MemberName=="w2")
{
rrvar_w2->WirePacketReceived(m);
return;
}
if (m->MemberName=="w3")
{
rrvar_w3->WirePacketReceived(m);
return;
}
if (m->MemberName=="broadcastwire")
{
rrvar_broadcastwire->WirePacketReceived(m);
return;
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>testroot_stub::CallbackCall(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RobotRaconteur::MessageStringPtr& ename=rr_m->MemberName;
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallRet, ename);
rr_mr->ServicePath=rr_m->ServicePath;
rr_mr->RequestID=rr_m->RequestID;
if (rr_m->MemberName=="cb1")
{
rrvar_cb1->GetFunction()();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
if (rr_m->MemberName=="cb2")
{
double d1=RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d1"));
double d2=RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d2"));
rrvar_cb2->GetFunction()(d1, d2);
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
if (rr_m->MemberName=="cb3")
{
double d1=RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d1"));
double d2=RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d2"));
double rr_ret=rrvar_cb3->GetFunction()(d1, d2);
rr_mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("return",rr_ret));
return rr_mr;
}
if (rr_m->MemberName=="cb_meaning_of_life")
{
int32_t rr_ret=rrvar_cb_meaning_of_life->GetFunction()();
rr_mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("return",rr_ret));
return rr_mr;
}
if (rr_m->MemberName=="cb_errtest")
{
rrvar_cb_errtest->GetFunction()();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

std::string testroot_stub::RRType()
{
return "com.robotraconteur.testing.TestService1.testroot";
}
void testroot_stub::RRClose()
{
rrvar_p1->Shutdown();
rrvar_p2->Shutdown();
rrvar_broadcastpipe->Shutdown();
rrvar_w1->Shutdown();
rrvar_w2->Shutdown();
rrvar_w3->Shutdown();
rrvar_broadcastwire->Shutdown();
if (rrvar_m1)
{
rrvar_m1->Shutdown();
}
if (rrvar_m2)
{
rrvar_m2->Shutdown();
}
if (rrvar_m3)
{
rrvar_m3->Shutdown();
}
rrvar_ev1.disconnect_all_slots();
rrvar_ev2.disconnect_all_slots();
if (rrvar_cb1)
{
rrvar_cb1->Shutdown();
}
if (rrvar_cb2)
{
rrvar_cb2->Shutdown();
}
if (rrvar_cb3)
{
rrvar_cb3->Shutdown();
}
if (rrvar_cb_meaning_of_life)
{
rrvar_cb_meaning_of_life->Shutdown();
}
if (rrvar_cb_errtest)
{
rrvar_cb_errtest->Shutdown();
}
ServiceStub::RRClose();
}

RR_SHARED_PTR<RobotRaconteur::PipeClientBase> testroot_stub::RRGetPipeClient(boost::string_ref membername)
{
if (membername =="p1") return rrvar_p1;
if (membername =="p2") return rrvar_p2;
if (membername =="broadcastpipe") return rrvar_broadcastpipe;
return ServiceStub::RRGetPipeClient(membername);
}

RR_SHARED_PTR<RobotRaconteur::WireClientBase> testroot_stub::RRGetWireClient(boost::string_ref membername)
{
if (membername =="w1") return rrvar_w1;
if (membername =="w2") return rrvar_w2;
if (membername =="w3") return rrvar_w3;
if (membername =="broadcastwire") return rrvar_broadcastwire;
return ServiceStub::RRGetWireClient(membername);
}

void testroot_stub::async_get_d1(boost::function<void (double,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_d1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (double ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0.0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0.0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
double rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_d1(double value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_d1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_d2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_d2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<double >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_d2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_d3(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d3");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_d3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::VerifyRRArrayLength(RobotRaconteur::MessageElement_UnpackArray<double >(me), 16, false);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d3");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, false)));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_d3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_d4(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d4");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_d4, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::VerifyRRArrayLength(RobotRaconteur::MessageElement_UnpackArray<double >(me), 16, true);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d4");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, true)));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_d4, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_d5(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d5");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_d5, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d5");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_d5, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_d6(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d6");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_d6, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::VerifyRRMultiDimArrayLength<2>(RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),me),9,boost::assign::list_of(3)(3));
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d6");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",RobotRaconteur::VerifyRRMultiDimArrayLength<2>(value,9,boost::assign::list_of(3)(3))));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_d6, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_s1(boost::function<void (float,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_s1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_s1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (float ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0.0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0.0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
float rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<float >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_s1(float value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<float >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_s1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_s1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_s2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_s2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_s2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<float >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_s2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<float >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_s2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_s2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i8_1(boost::function<void (int8_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i8_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i8_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i8_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (int8_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
int8_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<int8_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i8_1(int8_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i8_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int8_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i8_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i8_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i8_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i8_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i8_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<int8_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i8_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int8_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i8_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u8_1(boost::function<void (uint8_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u8_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u8_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u8_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (uint8_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
uint8_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<uint8_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u8_1(uint8_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u8_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint8_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u8_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u8_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u8_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u8_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u8_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<uint8_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u8_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint8_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u8_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u8_3(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u8_3");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u8_3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u8_3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMultiDimArray<uint8_t >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u8_3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u8_3");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<uint8_t >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u8_3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u8_3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i16_1(boost::function<void (int16_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i16_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i16_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i16_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (int16_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
int16_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<int16_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i16_1(int16_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i16_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int16_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i16_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i16_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i16_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i16_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i16_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<int16_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i16_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int16_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i16_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u16_1(boost::function<void (uint16_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u16_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u16_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u16_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (uint16_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
uint16_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<uint16_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u16_1(uint16_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u16_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint16_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u16_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u16_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u16_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u16_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u16_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<uint16_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u16_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint16_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u16_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i32_1(boost::function<void (int32_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i32_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i32_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i32_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (int32_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
int32_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<int32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i32_1(int32_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i32_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i32_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i32_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i32_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i32_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i32_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<int32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i32_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i32_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i32_huge(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i32_huge");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i32_huge, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i32_huge(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<int32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i32_huge(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i32_huge");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i32_huge, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i32_huge(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u32_1(boost::function<void (uint32_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u32_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u32_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u32_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (uint32_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
uint32_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<uint32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u32_1(uint32_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u32_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint32_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u32_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u32_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u32_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u32_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u32_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<uint32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u32_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint32_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u32_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i64_1(boost::function<void (int64_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i64_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i64_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i64_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (int64_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
int64_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<int64_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i64_1(int64_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i64_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int64_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i64_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i64_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_i64_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i64_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_i64_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_i64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<int64_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_i64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i64_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int64_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_i64_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_i64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u64_1(boost::function<void (uint64_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u64_1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u64_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u64_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (uint64_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
uint64_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<uint64_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u64_1(uint64_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u64_1");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint64_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u64_1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u64_1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_u64_2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"u64_2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_u64_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_u64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<uint64_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_u64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"u64_2");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint64_t >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_u64_2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_u64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_str1(boost::function<void (const std::string&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"str1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_str1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const std::string& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler("",err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler("",RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
std::string rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackString(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_str1(const std::string& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"str1");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_str1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_struct1(boost::function<void (const RR_INTRUSIVE_PTR<teststruct1 >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"struct1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_struct1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<teststruct1 >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<teststruct1 >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<teststruct1 >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<teststruct1 > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackStructure<teststruct1 >(RRGetNodeWeak(), me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_struct1(const RR_INTRUSIVE_PTR<teststruct1 >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"struct1");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_struct1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_struct2(boost::function<void (const RR_INTRUSIVE_PTR<teststruct2 >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"struct2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_struct2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<teststruct2 >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<teststruct2 >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<teststruct2 >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<teststruct2 > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackStructure<teststruct2 >(RRGetNodeWeak(), me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_struct2(const RR_INTRUSIVE_PTR<teststruct2 >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"struct2");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_struct2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_d1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_d1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d1");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_d1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_d2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_d2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_d2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_d3(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d3");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_d3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d3");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_d3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_d4(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d4");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_d4, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d4");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_d4, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_d5(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d5");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_d5, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d5");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_d5, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_d6(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_d6");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_d6, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_d6");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_d6, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_str1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_str1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_str1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_str1");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_str1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_str2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_str2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_str2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_str2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_str2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_str2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_str2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_str2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_struct1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_struct1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_struct1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<int32_t,teststruct2  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_struct1");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,teststruct2  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_struct1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_is_struct2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"is_struct2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_is_struct2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_is_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<std::string,teststruct2  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_is_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"is_struct2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,teststruct2  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_is_struct2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_is_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_struct3(boost::function<void (const RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"struct3");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_struct3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_struct3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackStructure<com::robotraconteur::testing::TestService2::ostruct2 >(RRGetNodeWeak(), me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_struct3(const RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"struct3");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_struct3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_struct3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_list_d1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_d1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_list_d1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_list_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_list_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_d1");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_list_d1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_list_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_list_d3(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_d3");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_list_d3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_list_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_list_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_d3");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_list_d3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_list_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_list_d5(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_d5");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_list_d5, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_list_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_list_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_d5");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_list_d5, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_list_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_list_str1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_str1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_list_str1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_list_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_list_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_str1");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_list_str1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_list_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_list_struct1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"list_struct1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_list_struct1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_list_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackList<teststruct2  >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_list_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"list_struct1");
req->AddElement(RobotRaconteur::MessageElement_PackListElement<teststruct2  >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_list_struct1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_list_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var1");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var1");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var2");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRValue >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var2");
req->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRValue >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var_num(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_num");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var_num, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var_num(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var_num(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_num");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var_num, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var_num(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var_str(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_str");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var_str, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var_str(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var_str(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_str");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var_str, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var_str(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var_struct(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_struct");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var_struct, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var_struct(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var_struct(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_struct");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var_struct, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var_struct(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var_vector(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_vector");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var_vector, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var_vector(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var_vector(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_vector");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var_vector, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var_vector(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var_dictionary(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_dictionary");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var_dictionary, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var_dictionary(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var_dictionary(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_dictionary");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var_dictionary, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var_dictionary(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var_list(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_list");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var_list, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var_list(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var_list(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_list");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var_list, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var_list(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_var_multidimarray(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"var_multidimarray");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_var_multidimarray, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_var_multidimarray(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_var_multidimarray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"var_multidimarray");
req->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_var_multidimarray, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_var_multidimarray(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_errtest(boost::function<void (double,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"errtest");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_errtest, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_errtest(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (double ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0.0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0.0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
double rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_errtest(double value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"errtest");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_errtest, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_errtest(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_nulltest(boost::function<void (const RR_INTRUSIVE_PTR<teststruct1 >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"nulltest");
AsyncProcessRequest(m,boost::bind(&testroot_stub::rrend_get_nulltest, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_get_nulltest(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<teststruct1 >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<teststruct1 >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<teststruct1 >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<teststruct1 > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackStructure<teststruct1 >(RRGetNodeWeak(), me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_set_nulltest(const RR_INTRUSIVE_PTR<teststruct1 >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"nulltest");
req->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&testroot_stub::rrend_set_nulltest, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void testroot_stub::rrend_set_nulltest(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_func1(boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func1");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_func1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_func1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_func2(double d1, double d2,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func2");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d1",d1));
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d2",d2));
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_func2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_func2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_func3(double d1, double d2,boost::function<void (double, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func3");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d1",d1));
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d2",d2));
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_func3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_func3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (double ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0.0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0.0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
double rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("return");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_meaning_of_life(boost::function<void (int32_t, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"meaning_of_life");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_meaning_of_life, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_meaning_of_life(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (int32_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
int32_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("return");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<int32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_func_errtest(boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_func_errtest, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_func_errtest(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_func_errtest1(boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest1");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_func_errtest1, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_func_errtest1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_func_errtest2(boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest2");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_func_errtest2, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_func_errtest2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_func_errtest3(boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"func_errtest3");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_func_errtest3, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_func_errtest3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_o6_op(int32_t op,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"o6_op");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("op",op));
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_o6_op, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_o6_op(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_pipe_check_error(boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"pipe_check_error");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_pipe_check_error, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_pipe_check_error(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_test_callbacks(boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"test_callbacks");
AsyncProcessRequest(rr_req,boost::bind(&testroot_stub::rrend_test_callbacks, RobotRaconteur::rr_cast<testroot_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void testroot_stub::rrend_test_callbacks(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void testroot_stub::async_get_o1(boost::function<void(RR_SHARED_PTR<sub1>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o1", "com.robotraconteur.testing.TestService1.sub1", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub1 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

void testroot_stub::async_get_o2(int32_t ind, boost::function<void(RR_SHARED_PTR<sub1>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o2", boost::lexical_cast<std::string>(ind),"com.robotraconteur.testing.TestService1.sub1", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub1 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

void testroot_stub::async_get_o3(int32_t ind, boost::function<void(RR_SHARED_PTR<sub1>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o3", boost::lexical_cast<std::string>(ind),"com.robotraconteur.testing.TestService1.sub1", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub1 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

void testroot_stub::async_get_o4(const std::string& ind, boost::function<void(RR_SHARED_PTR<sub1>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o4", ind, "com.robotraconteur.testing.TestService1.sub1", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub1 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

void testroot_stub::async_get_o5(boost::function<void(RR_SHARED_PTR<com::robotraconteur::testing::TestService2::subobj>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o5", "com.robotraconteur.testing.TestService2.subobj", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<com::robotraconteur::testing::TestService2::subobj >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

void testroot_stub::async_get_o6(boost::function<void(RR_SHARED_PTR<RobotRaconteur::RRObject>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRef("o6", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<RobotRaconteur::RRObject >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

sub1_stub::sub1_stub(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::ClientContext>& c) : RobotRaconteur::ServiceStub(path,c){ }
void sub1_stub::RRInitStub()
{
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > sub1_stub::get_d1()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d1");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackArray<double >(me);
}
void sub1_stub::set_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d1");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > sub1_stub::get_d2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),me);
}
void sub1_stub::set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d2");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

std::string sub1_stub::get_s_ind()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s_ind");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackString(me);
}
void sub1_stub::set_s_ind(const std::string& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s_ind");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

int32_t sub1_stub::get_i_ind()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i_ind");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<int32_t >(me);
}
void sub1_stub::set_i_ind(int32_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i_ind");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_SHARED_PTR<sub2 > sub1_stub::get_o2_1()
{
return RobotRaconteur::rr_cast<sub2 >(FindObjRefTyped("o2_1","com.robotraconteur.testing.TestService1.sub2"));
}

RR_SHARED_PTR<sub2 > sub1_stub::get_o2_2(int32_t ind)
{
return RobotRaconteur::rr_cast<sub2 >(FindObjRefTyped("o2_2", boost::lexical_cast<std::string>(ind),"com.robotraconteur.testing.TestService1.sub2"));
}

RR_SHARED_PTR<sub2 > sub1_stub::get_o2_3(const std::string& ind)
{
return RobotRaconteur::rr_cast<sub2 >(FindObjRefTyped("o2_3", ind,"com.robotraconteur.testing.TestService1.sub2"));
}

void sub1_stub::DispatchEvent(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void sub1_stub::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void sub1_stub::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>sub1_stub::CallbackCall(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RobotRaconteur::MessageStringPtr& ename=rr_m->MemberName;
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallRet, ename);
rr_mr->ServicePath=rr_m->ServicePath;
rr_mr->RequestID=rr_m->RequestID;
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

std::string sub1_stub::RRType()
{
return "com.robotraconteur.testing.TestService1.sub1";
}
void sub1_stub::RRClose()
{
ServiceStub::RRClose();
}

RR_SHARED_PTR<RobotRaconteur::PipeClientBase> sub1_stub::RRGetPipeClient(boost::string_ref membername)
{
return ServiceStub::RRGetPipeClient(membername);
}

RR_SHARED_PTR<RobotRaconteur::WireClientBase> sub1_stub::RRGetWireClient(boost::string_ref membername)
{
return ServiceStub::RRGetWireClient(membername);
}

void sub1_stub::async_get_d1(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d1");
AsyncProcessRequest(m,boost::bind(&sub1_stub::rrend_get_d1, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_get_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackArray<double >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_set_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d1");
req->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",value));
AsyncProcessRequest(req,boost::bind(&sub1_stub::rrend_set_d1, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_set_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_get_d2(boost::function<void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"d2");
AsyncProcessRequest(m,boost::bind(&sub1_stub::rrend_get_d2, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_get_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >(),err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >(),RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"d2");
req->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",value));
AsyncProcessRequest(req,boost::bind(&sub1_stub::rrend_set_d2, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_get_s_ind(boost::function<void (const std::string&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s_ind");
AsyncProcessRequest(m,boost::bind(&sub1_stub::rrend_get_s_ind, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_get_s_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const std::string& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler("",err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler("",RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
std::string rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackString(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_set_s_ind(const std::string& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s_ind");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
AsyncProcessRequest(req,boost::bind(&sub1_stub::rrend_set_s_ind, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_set_s_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_get_i_ind(boost::function<void (int32_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i_ind");
AsyncProcessRequest(m,boost::bind(&sub1_stub::rrend_get_i_ind, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_get_i_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (int32_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
int32_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<int32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_set_i_ind(int32_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i_ind");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
AsyncProcessRequest(req,boost::bind(&sub1_stub::rrend_set_i_ind, RobotRaconteur::rr_cast<sub1_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub1_stub::rrend_set_i_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub1_stub::async_get_o2_1(boost::function<void(RR_SHARED_PTR<sub2>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o2_1", "com.robotraconteur.testing.TestService1.sub2", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub2 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

void sub1_stub::async_get_o2_2(int32_t ind, boost::function<void(RR_SHARED_PTR<sub2>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o2_2", boost::lexical_cast<std::string>(ind),"com.robotraconteur.testing.TestService1.sub2", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub2 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

void sub1_stub::async_get_o2_3(const std::string& ind, boost::function<void(RR_SHARED_PTR<sub2>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o2_3", ind, "com.robotraconteur.testing.TestService1.sub2", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub2 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

sub2_stub::sub2_stub(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::ClientContext>& c) : RobotRaconteur::ServiceStub(path,c){ }
void sub2_stub::RRInitStub()
{
}

std::string sub2_stub::get_s_ind()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s_ind");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackString(me);
}
void sub2_stub::set_s_ind(const std::string& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s_ind");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

int32_t sub2_stub::get_i_ind()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i_ind");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<int32_t >(me);
}
void sub2_stub::set_i_ind(int32_t value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i_ind");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

std::string sub2_stub::get_data()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"data");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackString(me);
}
void sub2_stub::set_data(const std::string& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"data");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

RR_SHARED_PTR<sub3 > sub2_stub::get_o3_1(const std::string& ind)
{
return RobotRaconteur::rr_cast<sub3 >(FindObjRefTyped("o3_1", ind,"com.robotraconteur.testing.TestService1.sub3"));
}

void sub2_stub::DispatchEvent(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void sub2_stub::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void sub2_stub::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>sub2_stub::CallbackCall(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RobotRaconteur::MessageStringPtr& ename=rr_m->MemberName;
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallRet, ename);
rr_mr->ServicePath=rr_m->ServicePath;
rr_mr->RequestID=rr_m->RequestID;
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

std::string sub2_stub::RRType()
{
return "com.robotraconteur.testing.TestService1.sub2";
}
void sub2_stub::RRClose()
{
ServiceStub::RRClose();
}

RR_SHARED_PTR<RobotRaconteur::PipeClientBase> sub2_stub::RRGetPipeClient(boost::string_ref membername)
{
return ServiceStub::RRGetPipeClient(membername);
}

RR_SHARED_PTR<RobotRaconteur::WireClientBase> sub2_stub::RRGetWireClient(boost::string_ref membername)
{
return ServiceStub::RRGetWireClient(membername);
}

void sub2_stub::async_get_s_ind(boost::function<void (const std::string&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"s_ind");
AsyncProcessRequest(m,boost::bind(&sub2_stub::rrend_get_s_ind, RobotRaconteur::rr_cast<sub2_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub2_stub::rrend_get_s_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const std::string& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler("",err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler("",RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
std::string rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackString(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub2_stub::async_set_s_ind(const std::string& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"s_ind");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
AsyncProcessRequest(req,boost::bind(&sub2_stub::rrend_set_s_ind, RobotRaconteur::rr_cast<sub2_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub2_stub::rrend_set_s_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub2_stub::async_get_i_ind(boost::function<void (int32_t,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"i_ind");
AsyncProcessRequest(m,boost::bind(&sub2_stub::rrend_get_i_ind, RobotRaconteur::rr_cast<sub2_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub2_stub::rrend_get_i_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (int32_t ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
int32_t rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<int32_t >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub2_stub::async_set_i_ind(int32_t value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"i_ind");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
AsyncProcessRequest(req,boost::bind(&sub2_stub::rrend_set_i_ind, RobotRaconteur::rr_cast<sub2_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub2_stub::rrend_set_i_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub2_stub::async_get_data(boost::function<void (const std::string&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"data");
AsyncProcessRequest(m,boost::bind(&sub2_stub::rrend_get_data, RobotRaconteur::rr_cast<sub2_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub2_stub::rrend_get_data(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const std::string& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler("",err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler("",RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
std::string rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackString(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub2_stub::async_set_data(const std::string& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"data");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
AsyncProcessRequest(req,boost::bind(&sub2_stub::rrend_set_data, RobotRaconteur::rr_cast<sub2_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub2_stub::rrend_set_data(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub2_stub::async_get_o3_1(const std::string& ind, boost::function<void(RR_SHARED_PTR<sub3>,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&)> handler, int32_t timeout)
{
AsyncFindObjRefTyped("o3_1", ind, "com.robotraconteur.testing.TestService1.sub3", boost::bind(&RobotRaconteur::ServiceStub::EndAsyncFindObjRef<sub3 >,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),handler) ,timeout);
}

sub3_stub::sub3_stub(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::ClientContext>& c) : RobotRaconteur::ServiceStub(path,c){ }
void sub3_stub::RRInitStub()
{
}

std::string sub3_stub::get_ind()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"ind");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackString(me);
}
void sub3_stub::set_ind(const std::string& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"ind");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

std::string sub3_stub::get_data2()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"data2");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackString(me);
}
void sub3_stub::set_data2(const std::string& value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"data2");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

double sub3_stub::get_data3()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"data3");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(m);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=mr->FindElement("value");
return RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
void sub3_stub::set_data3(double value)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"data3");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=ProcessRequest(req);
}

double sub3_stub::add(double d)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"add");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d",d));
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=ProcessRequest(rr_req);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> rr_me=rr_ret->FindElement("return");
return RobotRaconteur::MessageElement_UnpackScalar<double >(rr_me);
}

void sub3_stub::DispatchEvent(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void sub3_stub::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
void sub3_stub::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>sub3_stub::CallbackCall(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RobotRaconteur::MessageStringPtr& ename=rr_m->MemberName;
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallRet, ename);
rr_mr->ServicePath=rr_m->ServicePath;
rr_mr->RequestID=rr_m->RequestID;
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

std::string sub3_stub::RRType()
{
return "com.robotraconteur.testing.TestService1.sub3";
}
void sub3_stub::RRClose()
{
ServiceStub::RRClose();
}

RR_SHARED_PTR<RobotRaconteur::PipeClientBase> sub3_stub::RRGetPipeClient(boost::string_ref membername)
{
return ServiceStub::RRGetPipeClient(membername);
}

RR_SHARED_PTR<RobotRaconteur::WireClientBase> sub3_stub::RRGetWireClient(boost::string_ref membername)
{
return ServiceStub::RRGetWireClient(membername);
}

void sub3_stub::async_get_ind(boost::function<void (const std::string&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"ind");
AsyncProcessRequest(m,boost::bind(&sub3_stub::rrend_get_ind, RobotRaconteur::rr_cast<sub3_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub3_stub::rrend_get_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const std::string& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler("",err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler("",RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
std::string rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackString(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub3_stub::async_set_ind(const std::string& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"ind");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
AsyncProcessRequest(req,boost::bind(&sub3_stub::rrend_set_ind, RobotRaconteur::rr_cast<sub3_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub3_stub::rrend_set_ind(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub3_stub::async_get_data2(boost::function<void (const std::string&,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"data2");
AsyncProcessRequest(m,boost::bind(&sub3_stub::rrend_get_data2, RobotRaconteur::rr_cast<sub3_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub3_stub::rrend_get_data2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const std::string& ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler("",err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler("",RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
std::string rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackString(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub3_stub::async_set_data2(const std::string& value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"data2");
req->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
AsyncProcessRequest(req,boost::bind(&sub3_stub::rrend_set_data2, RobotRaconteur::rr_cast<sub3_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub3_stub::rrend_set_data2(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub3_stub::async_get_data3(boost::function<void (double,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> m=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetReq,"data3");
AsyncProcessRequest(m,boost::bind(&sub3_stub::rrend_get_data3, RobotRaconteur::rr_cast<sub3_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub3_stub::rrend_get_data3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (double ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0.0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0.0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
double rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("value");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub3_stub::async_set_data3(double value,boost::function<void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetReq,"data3");
req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
AsyncProcessRequest(req,boost::bind(&sub3_stub::rrend_set_data3, RobotRaconteur::rr_cast<sub3_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}
void sub3_stub::rrend_set_data3(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
handler(RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}
void sub3_stub::async_add(double d,boost::function<void (double, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > rr_handler, int32_t rr_timeout)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallReq,"add");
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d",d));
AsyncProcessRequest(rr_req,boost::bind(&sub3_stub::rrend_add, RobotRaconteur::rr_cast<sub3_stub>(shared_from_this()),RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),rr_handler ),rr_timeout);
}

void sub3_stub::rrend_add(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, boost::function< void (double ,const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>&) > handler)
{
if (err)
{
handler(0.0,err);
return;
}
if (m->Error != RobotRaconteur::MessageErrorType_None)
{
handler(0.0,RobotRaconteur::RobotRaconteurExceptionUtil::MessageEntryToException(m));
return;
}
double rr_ret;
try
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> me=m->FindElement("return");
rr_ret=RobotRaconteur::MessageElement_UnpackScalar<double >(me);
}
catch (std::exception& err2)
{
RobotRaconteur::detail::InvokeHandlerWithException(node, handler, err2, RobotRaconteur::MessageErrorType_DataTypeError);
}
handler(rr_ret, RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>());
}

void testroot_skel::Init(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::RRObject>& object, const RR_SHARED_PTR<RobotRaconteur::ServerContext>& context)
{
uncastobj=object;
rr_InitPipeServersRun=false;
rr_InitWireServersRun=false;
rr_m1_mem.reset();
rr_m2_mem.reset();
rr_m3_mem.reset();
ServiceSkel::Init(path,object,context);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot > testroot_skel::get_obj()
{
return RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot >(uncastobj);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_testroot > testroot_skel::get_asyncobj()
{
return RR_DYNAMIC_POINTER_CAST<com::robotraconteur::testing::TestService1::async_testroot >(uncastobj);
}
void testroot_skel::ReleaseCastObject() 
{
rr_p1_pipe->Shutdown();
rr_p2_pipe->Shutdown();
rr_broadcastpipe_pipe->Shutdown();
rr_w1_wire->Shutdown();
rr_w2_wire->Shutdown();
rr_w3_wire->Shutdown();
rr_broadcastwire_wire->Shutdown();
get_obj()->get_cb1()->Shutdown();
get_obj()->get_cb2()->Shutdown();
get_obj()->get_cb3()->Shutdown();
get_obj()->get_cb_meaning_of_life()->Shutdown();
get_obj()->get_cb_errtest()->Shutdown();
}
std::string testroot_skel::GetObjectType()
{
return "com.robotraconteur.testing.TestService1.testroot";
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> testroot_skel::CallGetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_testroot > async_obj=get_asyncobj();
if (m->MemberName == "d1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_d1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_d1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
double value=get_obj()->get_d1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
return mr;
}
}
if (m->MemberName == "d2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_d2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_d2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=get_obj()->get_d2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",value));
return mr;
}
}
if (m->MemberName == "d3")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_d3(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_d3,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=get_obj()->get_d3();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, false)));
return mr;
}
}
if (m->MemberName == "d4")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_d4(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_d4,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=get_obj()->get_d4();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, true)));
return mr;
}
}
if (m->MemberName == "d5")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_d5(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_d5,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value=get_obj()->get_d5();
mr->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "d6")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_d6(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_d6,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value=get_obj()->get_d6();
mr->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",RobotRaconteur::VerifyRRMultiDimArrayLength<2>(value,9,boost::assign::list_of(3)(3))));
return mr;
}
}
if (m->MemberName == "s1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_s1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_s1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
float value=get_obj()->get_s1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<float >("value",value));
return mr;
}
}
if (m->MemberName == "s2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_s2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_s2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > > value=get_obj()->get_s2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<float >("value",value));
return mr;
}
}
if (m->MemberName == "i8_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i8_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i8_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
int8_t value=get_obj()->get_i8_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int8_t >("value",value));
return mr;
}
}
if (m->MemberName == "i8_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i8_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i8_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > > value=get_obj()->get_i8_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int8_t >("value",value));
return mr;
}
}
if (m->MemberName == "u8_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u8_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u8_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
uint8_t value=get_obj()->get_u8_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint8_t >("value",value));
return mr;
}
}
if (m->MemberName == "u8_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u8_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u8_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > > value=get_obj()->get_u8_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint8_t >("value",value));
return mr;
}
}
if (m->MemberName == "u8_3")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u8_3(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u8_3,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > > value=get_obj()->get_u8_3();
mr->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<uint8_t >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "i16_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i16_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i16_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
int16_t value=get_obj()->get_i16_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int16_t >("value",value));
return mr;
}
}
if (m->MemberName == "i16_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i16_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i16_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > > value=get_obj()->get_i16_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int16_t >("value",value));
return mr;
}
}
if (m->MemberName == "u16_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u16_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u16_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
uint16_t value=get_obj()->get_u16_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint16_t >("value",value));
return mr;
}
}
if (m->MemberName == "u16_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u16_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u16_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > > value=get_obj()->get_u16_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint16_t >("value",value));
return mr;
}
}
if (m->MemberName == "i32_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i32_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i32_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
int32_t value=get_obj()->get_i32_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
return mr;
}
}
if (m->MemberName == "i32_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i32_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i32_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > value=get_obj()->get_i32_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value));
return mr;
}
}
if (m->MemberName == "i32_huge")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i32_huge(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i32_huge,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > value=get_obj()->get_i32_huge();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value));
return mr;
}
}
if (m->MemberName == "u32_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u32_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u32_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
uint32_t value=get_obj()->get_u32_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint32_t >("value",value));
return mr;
}
}
if (m->MemberName == "u32_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u32_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u32_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > > value=get_obj()->get_u32_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint32_t >("value",value));
return mr;
}
}
if (m->MemberName == "i64_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i64_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i64_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
int64_t value=get_obj()->get_i64_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int64_t >("value",value));
return mr;
}
}
if (m->MemberName == "i64_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_i64_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_i64_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > > value=get_obj()->get_i64_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<int64_t >("value",value));
return mr;
}
}
if (m->MemberName == "u64_1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u64_1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u64_1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
uint64_t value=get_obj()->get_u64_1();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<uint64_t >("value",value));
return mr;
}
}
if (m->MemberName == "u64_2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_u64_2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_u64_2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > > value=get_obj()->get_u64_2();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<uint64_t >("value",value));
return mr;
}
}
if (m->MemberName == "str1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_str1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_str1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
std::string value=get_obj()->get_str1();
mr->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
return mr;
}
}
if (m->MemberName == "struct1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_struct1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_struct1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<teststruct1 > value=get_obj()->get_struct1();
mr->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "struct2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_struct2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_struct2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<teststruct2 > value=get_obj()->get_struct2();
mr->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_d1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_d1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_d1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > value=get_obj()->get_is_d1();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_d2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_d2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_d2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > value=get_obj()->get_is_d2();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_d3")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_d3(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_d3,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > value=get_obj()->get_is_d3();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_d4")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_d4(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_d4,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > value=get_obj()->get_is_d4();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_d5")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_d5(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_d5,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > > value=get_obj()->get_is_d5();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_d6")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_d6(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_d6,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > > value=get_obj()->get_is_d6();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_str1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_str1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_str1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > > value=get_obj()->get_is_str1();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_str2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_str2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_str2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > > value=get_obj()->get_is_str2();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_struct1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_struct1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_struct1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > > value=get_obj()->get_is_struct1();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,teststruct2  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "is_struct2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_is_struct2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_is_struct2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > > value=get_obj()->get_is_struct2();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<std::string,teststruct2  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "struct3")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_struct3(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_struct3,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 > value=get_obj()->get_struct3();
mr->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "list_d1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_list_d1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_list_d1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > value=get_obj()->get_list_d1();
mr->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "list_d3")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_list_d3(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_list_d3,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > value=get_obj()->get_list_d3();
mr->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "list_d5")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_list_d5(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_list_d5,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > > value=get_obj()->get_list_d5();
mr->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "list_str1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_list_str1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_list_str1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > > value=get_obj()->get_list_str1();
mr->AddElement(RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "list_struct1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_list_struct1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_list_struct1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > > value=get_obj()->get_list_struct1();
mr->AddElement(RobotRaconteur::MessageElement_PackListElement<teststruct2  >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var1();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > > value=get_obj()->get_var2();
mr->AddElement(RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRValue >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var_num")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var_num(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var_num,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var_num();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var_str")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var_str(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var_str,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var_str();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var_struct")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var_struct(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var_struct,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var_struct();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var_vector")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var_vector(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var_vector,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var_vector();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var_dictionary")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var_dictionary(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var_dictionary,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var_dictionary();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var_list")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var_list(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var_list,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var_list();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "var_multidimarray")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_var_multidimarray(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_var_multidimarray,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=get_obj()->get_var_multidimarray();
mr->AddElement(RobotRaconteur::MessageElement_PackVarTypeElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "errtest")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_errtest(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_errtest,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
double value=get_obj()->get_errtest();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
return mr;
}
}
if (m->MemberName == "nulltest")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_get_nulltest(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_get_nulltest,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<teststruct1 > value=get_obj()->get_nulltest();
mr->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"value",value));
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> testroot_skel::CallSetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_testroot > async_obj=get_asyncobj();
if (m->MemberName == "d1")
{
double value=RobotRaconteur::MessageElement_UnpackScalar<double >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_d1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d1(value);
return mr;
}
}
if (m->MemberName == "d2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=RobotRaconteur::MessageElement_UnpackArray<double >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_d2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d2(value);
return mr;
}
}
if (m->MemberName == "d3")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=RobotRaconteur::VerifyRRArrayLength(RobotRaconteur::MessageElement_UnpackArray<double >(m->FindElement("value")), 16, false);
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_d3(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d3(value);
return mr;
}
}
if (m->MemberName == "d4")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=RobotRaconteur::VerifyRRArrayLength(RobotRaconteur::MessageElement_UnpackArray<double >(m->FindElement("value")), 16, true);
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_d4(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d4(value);
return mr;
}
}
if (m->MemberName == "d5")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value=RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_d5(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d5(value);
return mr;
}
}
if (m->MemberName == "d6")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value=RobotRaconteur::VerifyRRMultiDimArrayLength<2>(RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),m->FindElement("value")),9,boost::assign::list_of(3)(3));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_d6(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d6(value);
return mr;
}
}
if (m->MemberName == "s1")
{
float value=RobotRaconteur::MessageElement_UnpackScalar<float >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_s1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_s1(value);
return mr;
}
}
if (m->MemberName == "s2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > > value=RobotRaconteur::MessageElement_UnpackArray<float >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_s2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_s2(value);
return mr;
}
}
if (m->MemberName == "i8_1")
{
int8_t value=RobotRaconteur::MessageElement_UnpackScalar<int8_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i8_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i8_1(value);
return mr;
}
}
if (m->MemberName == "i8_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > > value=RobotRaconteur::MessageElement_UnpackArray<int8_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i8_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i8_2(value);
return mr;
}
}
if (m->MemberName == "u8_1")
{
uint8_t value=RobotRaconteur::MessageElement_UnpackScalar<uint8_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u8_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u8_1(value);
return mr;
}
}
if (m->MemberName == "u8_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > > value=RobotRaconteur::MessageElement_UnpackArray<uint8_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u8_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u8_2(value);
return mr;
}
}
if (m->MemberName == "u8_3")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > > value=RobotRaconteur::MessageElement_UnpackMultiDimArray<uint8_t >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u8_3(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u8_3(value);
return mr;
}
}
if (m->MemberName == "i16_1")
{
int16_t value=RobotRaconteur::MessageElement_UnpackScalar<int16_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i16_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i16_1(value);
return mr;
}
}
if (m->MemberName == "i16_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > > value=RobotRaconteur::MessageElement_UnpackArray<int16_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i16_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i16_2(value);
return mr;
}
}
if (m->MemberName == "u16_1")
{
uint16_t value=RobotRaconteur::MessageElement_UnpackScalar<uint16_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u16_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u16_1(value);
return mr;
}
}
if (m->MemberName == "u16_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > > value=RobotRaconteur::MessageElement_UnpackArray<uint16_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u16_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u16_2(value);
return mr;
}
}
if (m->MemberName == "i32_1")
{
int32_t value=RobotRaconteur::MessageElement_UnpackScalar<int32_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i32_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i32_1(value);
return mr;
}
}
if (m->MemberName == "i32_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > value=RobotRaconteur::MessageElement_UnpackArray<int32_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i32_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i32_2(value);
return mr;
}
}
if (m->MemberName == "i32_huge")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > value=RobotRaconteur::MessageElement_UnpackArray<int32_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i32_huge(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i32_huge(value);
return mr;
}
}
if (m->MemberName == "u32_1")
{
uint32_t value=RobotRaconteur::MessageElement_UnpackScalar<uint32_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u32_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u32_1(value);
return mr;
}
}
if (m->MemberName == "u32_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > > value=RobotRaconteur::MessageElement_UnpackArray<uint32_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u32_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u32_2(value);
return mr;
}
}
if (m->MemberName == "i64_1")
{
int64_t value=RobotRaconteur::MessageElement_UnpackScalar<int64_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i64_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i64_1(value);
return mr;
}
}
if (m->MemberName == "i64_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > > value=RobotRaconteur::MessageElement_UnpackArray<int64_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_i64_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i64_2(value);
return mr;
}
}
if (m->MemberName == "u64_1")
{
uint64_t value=RobotRaconteur::MessageElement_UnpackScalar<uint64_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u64_1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u64_1(value);
return mr;
}
}
if (m->MemberName == "u64_2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > > value=RobotRaconteur::MessageElement_UnpackArray<uint64_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_u64_2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_u64_2(value);
return mr;
}
}
if (m->MemberName == "str1")
{
std::string value=RobotRaconteur::MessageElement_UnpackString(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_str1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_str1(value);
return mr;
}
}
if (m->MemberName == "struct1")
{
RR_INTRUSIVE_PTR<teststruct1 > value=RobotRaconteur::MessageElement_UnpackStructure<teststruct1 >(RRGetNodeWeak(), m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_struct1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_struct1(value);
return mr;
}
}
if (m->MemberName == "struct2")
{
RR_INTRUSIVE_PTR<teststruct2 > value=RobotRaconteur::MessageElement_UnpackStructure<teststruct2 >(RRGetNodeWeak(), m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_struct2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_struct2(value);
return mr;
}
}
if (m->MemberName == "is_d1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > value=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_d1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_d1(value);
return mr;
}
}
if (m->MemberName == "is_d2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > value=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_d2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_d2(value);
return mr;
}
}
if (m->MemberName == "is_d3")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > value=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_d3(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_d3(value);
return mr;
}
}
if (m->MemberName == "is_d4")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > value=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_d4(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_d4(value);
return mr;
}
}
if (m->MemberName == "is_d5")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > > value=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_d5(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_d5(value);
return mr;
}
}
if (m->MemberName == "is_d6")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > > value=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_d6(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_d6(value);
return mr;
}
}
if (m->MemberName == "is_str1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > > value=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_str1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_str1(value);
return mr;
}
}
if (m->MemberName == "is_str2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > > value=RobotRaconteur::MessageElement_UnpackMap<std::string,RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_str2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_str2(value);
return mr;
}
}
if (m->MemberName == "is_struct1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > > value=RobotRaconteur::MessageElement_UnpackMap<int32_t,teststruct2  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_struct1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_struct1(value);
return mr;
}
}
if (m->MemberName == "is_struct2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > > value=RobotRaconteur::MessageElement_UnpackMap<std::string,teststruct2  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_is_struct2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_is_struct2(value);
return mr;
}
}
if (m->MemberName == "struct3")
{
RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 > value=RobotRaconteur::MessageElement_UnpackStructure<com::robotraconteur::testing::TestService2::ostruct2 >(RRGetNodeWeak(), m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_struct3(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_struct3(value);
return mr;
}
}
if (m->MemberName == "list_d1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > value=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_list_d1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_list_d1(value);
return mr;
}
}
if (m->MemberName == "list_d3")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > value=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_list_d3(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_list_d3(value);
return mr;
}
}
if (m->MemberName == "list_d5")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > > value=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRMultiDimArray<double >  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_list_d5(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_list_d5(value);
return mr;
}
}
if (m->MemberName == "list_str1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > > value=RobotRaconteur::MessageElement_UnpackList<RobotRaconteur::RRArray<char>  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_list_str1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_list_str1(value);
return mr;
}
}
if (m->MemberName == "list_struct1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > > value=RobotRaconteur::MessageElement_UnpackList<teststruct2  >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_list_struct1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_list_struct1(value);
return mr;
}
}
if (m->MemberName == "var1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var1(value);
return mr;
}
}
if (m->MemberName == "var2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > > value=RobotRaconteur::MessageElement_UnpackMap<int32_t,RobotRaconteur::RRValue >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var2(value);
return mr;
}
}
if (m->MemberName == "var_num")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var_num(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var_num(value);
return mr;
}
}
if (m->MemberName == "var_str")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var_str(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var_str(value);
return mr;
}
}
if (m->MemberName == "var_struct")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var_struct(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var_struct(value);
return mr;
}
}
if (m->MemberName == "var_vector")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var_vector(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var_vector(value);
return mr;
}
}
if (m->MemberName == "var_dictionary")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var_dictionary(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var_dictionary(value);
return mr;
}
}
if (m->MemberName == "var_list")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var_list(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var_list(value);
return mr;
}
}
if (m->MemberName == "var_multidimarray")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value=RobotRaconteur::MessageElement_UnpackVarValue(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_var_multidimarray(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_var_multidimarray(value);
return mr;
}
}
if (m->MemberName == "errtest")
{
double value=RobotRaconteur::MessageElement_UnpackScalar<double >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_errtest(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_errtest(value);
return mr;
}
}
if (m->MemberName == "nulltest")
{
RR_INTRUSIVE_PTR<teststruct1 > value=RobotRaconteur::MessageElement_UnpackStructure<teststruct1 >(RRGetNodeWeak(), m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_set_nulltest(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_nulltest(value);
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void testroot_skel::rr_get_d1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,double value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<double >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_d2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<double >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_d3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, false));
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_d4(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<double >("value",RobotRaconteur::VerifyRRArrayLength(value, 16, true));
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_d5(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_d6(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(skel1->RRGetNodeWeak(),"value",RobotRaconteur::VerifyRRMultiDimArrayLength<2>(value,9,boost::assign::list_of(3)(3)));
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_s1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,float value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<float >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_s2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<float >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i8_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,int8_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<int8_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i8_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<int8_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u8_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,uint8_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<uint8_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u8_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<uint8_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u8_3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMultiDimArrayElement<uint8_t >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i16_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,int16_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<int16_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i16_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<int16_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u16_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,uint16_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<uint16_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u16_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<uint16_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i32_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,int32_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i32_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i32_huge(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<int32_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u32_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,uint32_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<uint32_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u32_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<uint32_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i64_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,int64_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<int64_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_i64_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<int64_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u64_1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,uint64_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<uint64_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_u64_2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<uint64_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_str1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,std::string value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStringElement("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_struct1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<teststruct1 > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStructElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_struct2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<teststruct2 > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStructElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_d1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_d2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_d3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_d4(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_d5(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRMultiDimArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_d6(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRMultiDimArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_str1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRArray<char>  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_str2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<std::string,RobotRaconteur::RRArray<char>  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_struct1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<int32_t,teststruct2  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_is_struct2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<std::string,teststruct2  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_struct3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStructElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_list_d1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_list_d3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_list_d5(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRMultiDimArray<double >  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_list_str1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackListElement<RobotRaconteur::RRArray<char>  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_list_struct1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackListElement<teststruct2  >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMapElement<int32_t,RobotRaconteur::RRValue >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var_num(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var_str(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var_struct(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var_vector(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var_dictionary(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var_list(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_var_multidimarray(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackVarTypeElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_errtest(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,double value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<double >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void testroot_skel::rr_get_nulltest(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel,RR_INTRUSIVE_PTR<teststruct1 > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStructElement(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> testroot_skel::CallFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallRes,rr_m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_testroot > async_obj=get_asyncobj();
if (rr_m->MemberName == "func1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_func1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_func1,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->func1();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "func2")
{
double d1 =RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d1"));
double d2 =RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d2"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_func2(d1, d2, boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_func2,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->func2(d1, d2);
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "func3")
{
double d1 =RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d1"));
double d2 =RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d2"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_func3(d1, d2, boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_func3, rr_wp, RR_BOOST_PLACEHOLDERS(_1), RR_BOOST_PLACEHOLDERS(_2), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
double rr_return=get_obj()->func3(d1, d2);
rr_mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("return",rr_return));
return rr_mr;
}
}
if (rr_m->MemberName == "meaning_of_life")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_meaning_of_life(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_meaning_of_life, rr_wp, RR_BOOST_PLACEHOLDERS(_1), RR_BOOST_PLACEHOLDERS(_2), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
int32_t rr_return=get_obj()->meaning_of_life();
rr_mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("return",rr_return));
return rr_mr;
}
}
if (rr_m->MemberName == "func_errtest")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_func_errtest(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_func_errtest,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->func_errtest();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "func_errtest1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_func_errtest1(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_func_errtest1,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->func_errtest1();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "func_errtest2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_func_errtest2(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_func_errtest2,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->func_errtest2();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "func_errtest3")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_func_errtest3(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_func_errtest3,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->func_errtest3();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "o6_op")
{
int32_t op =RobotRaconteur::MessageElement_UnpackScalar<int32_t >(rr_m->FindElement("op"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_o6_op(op, boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_o6_op,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->o6_op(op);
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "pipe_check_error")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_pipe_check_error(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_pipe_check_error,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->pipe_check_error();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
if (rr_m->MemberName == "test_callbacks")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot_skel>(shared_from_this());
async_obj->async_test_callbacks(boost::bind(&com::robotraconteur::testing::TestService1::testroot_skel::rr_test_callbacks,rr_wp, RR_BOOST_PLACEHOLDERS(_1), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->test_callbacks();
rr_mr->AddElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
return rr_mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void testroot_skel::rr_func1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_func2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_func3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, double ret, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<double >("return",ret);
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_meaning_of_life(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, int32_t ret, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<int32_t >("return",ret);
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_func_errtest(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_func_errtest1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_func_errtest2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_func_errtest3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_o6_op(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_pipe_check_error(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_test_callbacks(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::testroot_skel> skel, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
mr=RobotRaconteur::CreateMessageElement("return",RobotRaconteur::ScalarToRRArray<int32_t>(0));
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void testroot_skel::rr_ev1_Handler()
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mm=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_EventReq,"ev1");
SendEvent(rr_mm);
}
void testroot_skel::rr_ev2_Handler(double d1, RR_INTRUSIVE_PTR<teststruct2 > s2)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mm=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_EventReq,"ev2");
rr_mm->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d1",d1));
rr_mm->AddElement(RobotRaconteur::MessageElement_PackStructElement(RRGetNodeWeak(),"s2",s2));
SendEvent(rr_mm);
}
void testroot_skel::RegisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot >(rrobj1);
ev1_rrconnection=obj->get_ev1().connect(boost::bind(&testroot_skel::rr_ev1_Handler, RobotRaconteur::rr_cast<testroot_skel>(shared_from_this())));
ev2_rrconnection=obj->get_ev2().connect(boost::bind(&testroot_skel::rr_ev2_Handler, RobotRaconteur::rr_cast<testroot_skel>(shared_from_this()), RR_BOOST_PLACEHOLDERS(_1), RR_BOOST_PLACEHOLDERS(_2)));
RobotRaconteur::ServiceSkel::RegisterEvents(rrobj1);
}

void testroot_skel::UnregisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
ev1_rrconnection.disconnect();
ev2_rrconnection.disconnect();
RobotRaconteur::ServiceSkel::UnregisterEvents(rrobj1);
}

RR_SHARED_PTR<RobotRaconteur::RRObject> testroot_skel::GetSubObj(boost::string_ref name, boost::string_ref ind)
{
if (name=="o1")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o1());
}
if (name=="o2")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o2(boost::lexical_cast<int32_t>(ind)));
}
if (name=="o3")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o3(boost::lexical_cast<int32_t>(ind)));
}
if (name=="o4")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o4(ind.to_string()));
}
if (name=="o5")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o5());
}
if (name=="o6")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o6());
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void testroot_skel::InitPipeServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitPipeServersRun) return;
rr_InitPipeServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot >(rrobj1);
rr_p1_pipe=RR_MAKE_SHARED<RobotRaconteur::PipeServer<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >("p1",shared_from_this(),false,RobotRaconteur::MemberDefinition_Direction_both);
rr_p2_pipe=RR_MAKE_SHARED<RobotRaconteur::PipeServer<RR_INTRUSIVE_PTR<teststruct2 > > >("p2",shared_from_this(),false,RobotRaconteur::MemberDefinition_Direction_both);
rr_broadcastpipe_pipe=RR_MAKE_SHARED<RobotRaconteur::PipeServer<double > >("broadcastpipe",shared_from_this(),false,RobotRaconteur::MemberDefinition_Direction_both);
obj->set_p1(rr_p1_pipe);
obj->set_p2(rr_p2_pipe);
obj->set_broadcastpipe(rr_broadcastpipe_pipe);
}

void testroot_skel::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
if (m->MemberName=="p1")
{
rr_p1_pipe->PipePacketReceived(m,e);
return;
}
if (m->MemberName=="p2")
{
rr_p2_pipe->PipePacketReceived(m,e);
return;
}
if (m->MemberName=="broadcastpipe")
{
rr_broadcastpipe_pipe->PipePacketReceived(m,e);
return;
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> testroot_skel::CallPipeFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
if (m->MemberName=="p1")
{
return rr_p1_pipe->PipeCommand(m,e);
}
if (m->MemberName=="p2")
{
return rr_p2_pipe->PipeCommand(m,e);
}
if (m->MemberName=="broadcastpipe")
{
return rr_broadcastpipe_pipe->PipeCommand(m,e);
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void testroot_skel::InitWireServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitWireServersRun) return;
rr_InitWireServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot >(rrobj1);
rr_w1_wire=RR_MAKE_SHARED<RobotRaconteur::WireServer<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >("w1",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rr_w2_wire=RR_MAKE_SHARED<RobotRaconteur::WireServer<RR_INTRUSIVE_PTR<teststruct2 > > >("w2",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rr_w3_wire=RR_MAKE_SHARED<RobotRaconteur::WireServer<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > >("w3",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
rr_broadcastwire_wire=RR_MAKE_SHARED<RobotRaconteur::WireServer<double > >("broadcastwire",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
obj->set_w1(rr_w1_wire);
obj->set_w2(rr_w2_wire);
obj->set_w3(rr_w3_wire);
obj->set_broadcastwire(rr_broadcastwire_wire);
}

void testroot_skel::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
if (m->MemberName=="w1")
{
rr_w1_wire->WirePacketReceived(m,e);
return;
}
if (m->MemberName=="w2")
{
rr_w2_wire->WirePacketReceived(m,e);
return;
}
if (m->MemberName=="w3")
{
rr_w3_wire->WirePacketReceived(m,e);
return;
}
if (m->MemberName=="broadcastwire")
{
rr_broadcastwire_wire->WirePacketReceived(m,e);
return;
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> testroot_skel::CallWireFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
if (m->MemberName=="w1")
{
return rr_w1_wire->WireCommand(m,e);
}
if (m->MemberName=="w2")
{
return rr_w2_wire->WireCommand(m,e);
}
if (m->MemberName=="w3")
{
return rr_w3_wire->WireCommand(m,e);
}
if (m->MemberName=="broadcastwire")
{
return rr_broadcastwire_wire->WireCommand(m,e);
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void testroot_skel::InitCallbackServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& o)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::testroot > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::testroot >(o);
obj->set_cb1(RR_MAKE_SHARED<RobotRaconteur::CallbackServer<boost::function<void() > > >("cb1",shared_from_this()));
obj->set_cb2(RR_MAKE_SHARED<RobotRaconteur::CallbackServer<boost::function<void(double, double) > > >("cb2",shared_from_this()));
obj->set_cb3(RR_MAKE_SHARED<RobotRaconteur::CallbackServer<boost::function<double(double, double) > > >("cb3",shared_from_this()));
obj->set_cb_meaning_of_life(RR_MAKE_SHARED<RobotRaconteur::CallbackServer<boost::function<int32_t() > > >("cb_meaning_of_life",shared_from_this()));
obj->set_cb_errtest(RR_MAKE_SHARED<RobotRaconteur::CallbackServer<boost::function<void() > > >("cb_errtest",shared_from_this()));
}
void testroot_skel::rr_cb1_callback(uint32_t rrendpoint){
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallReq,"cb1");
rr_req->ServicePath=GetServicePath();
RR_SHARED_PTR<RobotRaconteur::ServerContext> rr_s=GetContext();
if (rr_s==0) throw RobotRaconteur::InvalidOperationException("Service has been closed");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=rr_s->ProcessCallbackRequest(rr_req,rrendpoint);
}

void testroot_skel::rr_cb2_callback(uint32_t rrendpoint, double d1, double d2){
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallReq,"cb2");
rr_req->ServicePath=GetServicePath();
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d1",d1));
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d2",d2));
RR_SHARED_PTR<RobotRaconteur::ServerContext> rr_s=GetContext();
if (rr_s==0) throw RobotRaconteur::InvalidOperationException("Service has been closed");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=rr_s->ProcessCallbackRequest(rr_req,rrendpoint);
}

double testroot_skel::rr_cb3_callback(uint32_t rrendpoint, double d1, double d2){
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallReq,"cb3");
rr_req->ServicePath=GetServicePath();
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d1",d1));
rr_req->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("d2",d2));
RR_SHARED_PTR<RobotRaconteur::ServerContext> rr_s=GetContext();
if (rr_s==0) throw RobotRaconteur::InvalidOperationException("Service has been closed");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=rr_s->ProcessCallbackRequest(rr_req,rrendpoint);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> rr_me=rr_ret->FindElement("return");
return RobotRaconteur::MessageElement_UnpackScalar<double >(rr_me);
}

int32_t testroot_skel::rr_cb_meaning_of_life_callback(uint32_t rrendpoint){
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallReq,"cb_meaning_of_life");
rr_req->ServicePath=GetServicePath();
RR_SHARED_PTR<RobotRaconteur::ServerContext> rr_s=GetContext();
if (rr_s==0) throw RobotRaconteur::InvalidOperationException("Service has been closed");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=rr_s->ProcessCallbackRequest(rr_req,rrendpoint);
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> rr_me=rr_ret->FindElement("return");
return RobotRaconteur::MessageElement_UnpackScalar<int32_t >(rr_me);
}

void testroot_skel::rr_cb_errtest_callback(uint32_t rrendpoint){
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_req=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_CallbackCallReq,"cb_errtest");
rr_req->ServicePath=GetServicePath();
RR_SHARED_PTR<RobotRaconteur::ServerContext> rr_s=GetContext();
if (rr_s==0) throw RobotRaconteur::InvalidOperationException("Service has been closed");
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_ret=rr_s->ProcessCallbackRequest(rr_req,rrendpoint);
}

RR_SHARED_PTR<void> testroot_skel::GetCallbackFunction(uint32_t endpoint, boost::string_ref membername)
{
if (membername=="cb1")
{
return RR_MAKE_SHARED<boost::function<void() > >(boost::bind(&testroot_skel::rr_cb1_callback, RobotRaconteur::rr_cast<testroot_skel>(shared_from_this()), endpoint));
}
if (membername=="cb2")
{
return RR_MAKE_SHARED<boost::function<void(double, double) > >(boost::bind(&testroot_skel::rr_cb2_callback, RobotRaconteur::rr_cast<testroot_skel>(shared_from_this()), endpoint, RR_BOOST_PLACEHOLDERS(_1), RR_BOOST_PLACEHOLDERS(_2)));
}
if (membername=="cb3")
{
return RR_MAKE_SHARED<boost::function<double(double, double) > >(boost::bind(&testroot_skel::rr_cb3_callback, RobotRaconteur::rr_cast<testroot_skel>(shared_from_this()), endpoint, RR_BOOST_PLACEHOLDERS(_1), RR_BOOST_PLACEHOLDERS(_2)));
}
if (membername=="cb_meaning_of_life")
{
return RR_MAKE_SHARED<boost::function<int32_t() > >(boost::bind(&testroot_skel::rr_cb_meaning_of_life_callback, RobotRaconteur::rr_cast<testroot_skel>(shared_from_this()), endpoint));
}
if (membername=="cb_errtest")
{
return RR_MAKE_SHARED<boost::function<void() > >(boost::bind(&testroot_skel::rr_cb_errtest_callback, RobotRaconteur::rr_cast<testroot_skel>(shared_from_this()), endpoint));
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> testroot_skel::CallMemoryFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::Endpoint>& e)
{
if (m->MemberName=="m1")
{
if (rr_m1_mem==0) rr_m1_mem=RR_MAKE_SHARED<RobotRaconteur::ArrayMemoryServiceSkel<double > >("m1",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
return rr_m1_mem->CallMemoryFunction(m,e,get_obj()->get_m1());
}
if (m->MemberName=="m2")
{
if (rr_m2_mem==0) rr_m2_mem=RR_MAKE_SHARED<RobotRaconteur::MultiDimArrayMemoryServiceSkel<double > >("m2",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
return rr_m2_mem->CallMemoryFunction(m,e,get_obj()->get_m2());
}
if (m->MemberName=="m3")
{
if (rr_m3_mem==0) rr_m3_mem=RR_MAKE_SHARED<RobotRaconteur::MultiDimArrayMemoryServiceSkel<uint8_t > >("m3",shared_from_this(),RobotRaconteur::MemberDefinition_Direction_both);
return rr_m3_mem->CallMemoryFunction(m,e,get_obj()->get_m3());
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
bool testroot_skel::IsRequestNoLock(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
return false;
}
void sub1_skel::Init(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::RRObject>& object, const RR_SHARED_PTR<RobotRaconteur::ServerContext>& context)
{
uncastobj=object;
rr_InitPipeServersRun=false;
rr_InitWireServersRun=false;
ServiceSkel::Init(path,object,context);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1 > sub1_skel::get_obj()
{
return RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1 >(uncastobj);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub1 > sub1_skel::get_asyncobj()
{
return RR_DYNAMIC_POINTER_CAST<com::robotraconteur::testing::TestService1::async_sub1 >(uncastobj);
}
void sub1_skel::ReleaseCastObject() 
{
}
std::string sub1_skel::GetObjectType()
{
return "com.robotraconteur.testing.TestService1.sub1";
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub1_skel::CallGetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub1 > async_obj=get_asyncobj();
if (m->MemberName == "d1")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_get_d1(boost::bind(&com::robotraconteur::testing::TestService1::sub1_skel::rr_get_d1,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=get_obj()->get_d1();
mr->AddElement(RobotRaconteur::MessageElement_PackArrayElement<double >("value",value));
return mr;
}
}
if (m->MemberName == "d2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_get_d2(boost::bind(&com::robotraconteur::testing::TestService1::sub1_skel::rr_get_d2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value=get_obj()->get_d2();
mr->AddElement(RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(RRGetNodeWeak(),"value",value));
return mr;
}
}
if (m->MemberName == "s_ind")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_get_s_ind(boost::bind(&com::robotraconteur::testing::TestService1::sub1_skel::rr_get_s_ind,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
std::string value=get_obj()->get_s_ind();
mr->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
return mr;
}
}
if (m->MemberName == "i_ind")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_get_i_ind(boost::bind(&com::robotraconteur::testing::TestService1::sub1_skel::rr_get_i_ind,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
int32_t value=get_obj()->get_i_ind();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub1_skel::CallSetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub1 > async_obj=get_asyncobj();
if (m->MemberName == "d1")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value=RobotRaconteur::MessageElement_UnpackArray<double >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_set_d1(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d1(value);
return mr;
}
}
if (m->MemberName == "d2")
{
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value=RobotRaconteur::MessageElement_UnpackMultiDimArray<double >(RRGetNodeWeak(),m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_set_d2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_d2(value);
return mr;
}
}
if (m->MemberName == "s_ind")
{
std::string value=RobotRaconteur::MessageElement_UnpackString(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_set_s_ind(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_s_ind(value);
return mr;
}
}
if (m->MemberName == "i_ind")
{
int32_t value=RobotRaconteur::MessageElement_UnpackScalar<int32_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1_skel>(shared_from_this());
async_obj->async_set_i_ind(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i_ind(value);
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub1_skel::rr_get_d1(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackArrayElement<double >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void sub1_skel::rr_get_d2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel,RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackMultiDimArrayElement<double >(skel1->RRGetNodeWeak(),"value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void sub1_skel::rr_get_s_ind(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel,std::string value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStringElement("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void sub1_skel::rr_get_i_ind(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel,int32_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub1_skel::CallFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallRes,rr_m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub1 > async_obj=get_asyncobj();
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub1_skel::RegisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1 >(rrobj1);
RobotRaconteur::ServiceSkel::RegisterEvents(rrobj1);
}

void sub1_skel::UnregisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
RobotRaconteur::ServiceSkel::UnregisterEvents(rrobj1);
}

RR_SHARED_PTR<RobotRaconteur::RRObject> sub1_skel::GetSubObj(boost::string_ref name, boost::string_ref ind)
{
if (name=="o2_1")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o2_1());
}
if (name=="o2_2")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o2_2(boost::lexical_cast<int32_t>(ind)));
}
if (name=="o2_3")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o2_3(ind.to_string()));
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub1_skel::InitPipeServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitPipeServersRun) return;
rr_InitPipeServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1 >(rrobj1);
}

void sub1_skel::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub1_skel::CallPipeFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub1_skel::InitWireServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitWireServersRun) return;
rr_InitWireServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1 >(rrobj1);
}

void sub1_skel::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub1_skel::CallWireFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub1_skel::InitCallbackServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& o)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub1 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub1 >(o);
}
RR_SHARED_PTR<void> sub1_skel::GetCallbackFunction(uint32_t endpoint, boost::string_ref membername)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub1_skel::CallMemoryFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::Endpoint>& e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
bool sub1_skel::IsRequestNoLock(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
return false;
}
void sub2_skel::Init(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::RRObject>& object, const RR_SHARED_PTR<RobotRaconteur::ServerContext>& context)
{
uncastobj=object;
rr_InitPipeServersRun=false;
rr_InitWireServersRun=false;
ServiceSkel::Init(path,object,context);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2 > sub2_skel::get_obj()
{
return RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2 >(uncastobj);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub2 > sub2_skel::get_asyncobj()
{
return RR_DYNAMIC_POINTER_CAST<com::robotraconteur::testing::TestService1::async_sub2 >(uncastobj);
}
void sub2_skel::ReleaseCastObject() 
{
}
std::string sub2_skel::GetObjectType()
{
return "com.robotraconteur.testing.TestService1.sub2";
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub2_skel::CallGetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub2 > async_obj=get_asyncobj();
if (m->MemberName == "s_ind")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2_skel>(shared_from_this());
async_obj->async_get_s_ind(boost::bind(&com::robotraconteur::testing::TestService1::sub2_skel::rr_get_s_ind,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
std::string value=get_obj()->get_s_ind();
mr->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
return mr;
}
}
if (m->MemberName == "i_ind")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2_skel>(shared_from_this());
async_obj->async_get_i_ind(boost::bind(&com::robotraconteur::testing::TestService1::sub2_skel::rr_get_i_ind,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
int32_t value=get_obj()->get_i_ind();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value));
return mr;
}
}
if (m->MemberName == "data")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2_skel>(shared_from_this());
async_obj->async_get_data(boost::bind(&com::robotraconteur::testing::TestService1::sub2_skel::rr_get_data,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
std::string value=get_obj()->get_data();
mr->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub2_skel::CallSetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub2 > async_obj=get_asyncobj();
if (m->MemberName == "s_ind")
{
std::string value=RobotRaconteur::MessageElement_UnpackString(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2_skel>(shared_from_this());
async_obj->async_set_s_ind(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_s_ind(value);
return mr;
}
}
if (m->MemberName == "i_ind")
{
int32_t value=RobotRaconteur::MessageElement_UnpackScalar<int32_t >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2_skel>(shared_from_this());
async_obj->async_set_i_ind(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_i_ind(value);
return mr;
}
}
if (m->MemberName == "data")
{
std::string value=RobotRaconteur::MessageElement_UnpackString(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2_skel>(shared_from_this());
async_obj->async_set_data(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_data(value);
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub2_skel::rr_get_s_ind(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> skel,std::string value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStringElement("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void sub2_skel::rr_get_i_ind(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> skel,int32_t value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<int32_t >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void sub2_skel::rr_get_data(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub2_skel> skel,std::string value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStringElement("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub2_skel::CallFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallRes,rr_m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub2 > async_obj=get_asyncobj();
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub2_skel::RegisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2 >(rrobj1);
RobotRaconteur::ServiceSkel::RegisterEvents(rrobj1);
}

void sub2_skel::UnregisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
RobotRaconteur::ServiceSkel::UnregisterEvents(rrobj1);
}

RR_SHARED_PTR<RobotRaconteur::RRObject> sub2_skel::GetSubObj(boost::string_ref name, boost::string_ref ind)
{
if (name=="o3_1")
{
return RobotRaconteur::rr_cast<RobotRaconteur::RRObject>(get_obj()->get_o3_1(ind.to_string()));
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub2_skel::InitPipeServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitPipeServersRun) return;
rr_InitPipeServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2 >(rrobj1);
}

void sub2_skel::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub2_skel::CallPipeFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub2_skel::InitWireServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitWireServersRun) return;
rr_InitWireServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2 >(rrobj1);
}

void sub2_skel::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub2_skel::CallWireFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub2_skel::InitCallbackServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& o)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub2 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub2 >(o);
}
RR_SHARED_PTR<void> sub2_skel::GetCallbackFunction(uint32_t endpoint, boost::string_ref membername)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub2_skel::CallMemoryFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::Endpoint>& e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
bool sub2_skel::IsRequestNoLock(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
return false;
}
void sub3_skel::Init(boost::string_ref path, const RR_SHARED_PTR<RobotRaconteur::RRObject>& object, const RR_SHARED_PTR<RobotRaconteur::ServerContext>& context)
{
uncastobj=object;
rr_InitPipeServersRun=false;
rr_InitWireServersRun=false;
ServiceSkel::Init(path,object,context);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3 > sub3_skel::get_obj()
{
return RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3 >(uncastobj);
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub3 > sub3_skel::get_asyncobj()
{
return RR_DYNAMIC_POINTER_CAST<com::robotraconteur::testing::TestService1::async_sub3 >(uncastobj);
}
void sub3_skel::ReleaseCastObject() 
{
}
std::string sub3_skel::GetObjectType()
{
return "com.robotraconteur.testing.TestService1.sub3";
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub3_skel::CallGetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertyGetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub3 > async_obj=get_asyncobj();
if (m->MemberName == "ind")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3_skel>(shared_from_this());
async_obj->async_get_ind(boost::bind(&com::robotraconteur::testing::TestService1::sub3_skel::rr_get_ind,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
std::string value=get_obj()->get_ind();
mr->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
return mr;
}
}
if (m->MemberName == "data2")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3_skel>(shared_from_this());
async_obj->async_get_data2(boost::bind(&com::robotraconteur::testing::TestService1::sub3_skel::rr_get_data2,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
std::string value=get_obj()->get_data2();
mr->AddElement(RobotRaconteur::MessageElement_PackStringElement("value",value));
return mr;
}
}
if (m->MemberName == "data3")
{
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3_skel>(shared_from_this());
async_obj->async_get_data3(boost::bind(&com::robotraconteur::testing::TestService1::sub3_skel::rr_get_data3,wp,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
double value=get_obj()->get_data3();
mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("value",value));
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub3_skel::CallSetProperty(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_PropertySetRes,m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub3 > async_obj=get_asyncobj();
if (m->MemberName == "ind")
{
std::string value=RobotRaconteur::MessageElement_UnpackString(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3_skel>(shared_from_this());
async_obj->async_set_ind(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_ind(value);
return mr;
}
}
if (m->MemberName == "data2")
{
std::string value=RobotRaconteur::MessageElement_UnpackString(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3_skel>(shared_from_this());
async_obj->async_set_data2(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_data2(value);
return mr;
}
}
if (m->MemberName == "data3")
{
double value=RobotRaconteur::MessageElement_UnpackScalar<double >(m->FindElement("value"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3_skel>(shared_from_this());
async_obj->async_set_data3(value,boost::bind(&RobotRaconteur::ServiceSkel::EndAsyncCallSetProperty,wp,RR_BOOST_PLACEHOLDERS(_1),m,RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
get_obj()->set_data3(value);
return mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub3_skel::rr_get_ind(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel,std::string value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStringElement("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void sub3_skel::rr_get_data2(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel,std::string value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackStringElement("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
void sub3_skel::rr_get_data3(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel,double value, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::ServerEndpoint>& ep)
{
if(err)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<double >("value",value);
}
catch (std::exception& err2)
{
EndAsyncCallGetProperty(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallGetProperty(skel, mr, err, m,ep);
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub3_skel::CallFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& rr_m)
{
RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> rr_mr=RobotRaconteur::CreateMessageEntry(RobotRaconteur::MessageEntryType_FunctionCallRes,rr_m->MemberName);
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::async_sub3 > async_obj=get_asyncobj();
if (rr_m->MemberName == "add")
{
double d =RobotRaconteur::MessageElement_UnpackScalar<double >(rr_m->FindElement("d"));
if (async_obj)
{
RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> rr_wp=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3_skel>(shared_from_this());
async_obj->async_add(d, boost::bind(&com::robotraconteur::testing::TestService1::sub3_skel::rr_add, rr_wp, RR_BOOST_PLACEHOLDERS(_1), RR_BOOST_PLACEHOLDERS(_2), rr_m, RobotRaconteur::ServerEndpoint::GetCurrentEndpoint()));
return RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>();
}
else
{
double rr_return=get_obj()->add(d);
rr_mr->AddElement(RobotRaconteur::MessageElement_PackScalarElement<double >("return",rr_return));
return rr_mr;
}
}
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub3_skel::rr_add(RR_WEAK_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel, double ret, const RR_SHARED_PTR<RobotRaconteur::RobotRaconteurException>& err, const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, RR_SHARED_PTR<RobotRaconteur::ServerEndpoint> ep)
{
if(err)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),err,m, ep);
return;
}
RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement> mr;
try
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3_skel> skel1=skel.lock();
if (!skel1) throw RobotRaconteur::InvalidOperationException("skel release");
mr=RobotRaconteur::MessageElement_PackScalarElement<double >("return",ret);
}
catch (std::exception& err2)
{
EndAsyncCallFunction(skel,RR_INTRUSIVE_PTR<RobotRaconteur::MessageElement>(),RobotRaconteur::RobotRaconteurExceptionUtil::ExceptionToSharedPtr(err2, RobotRaconteur::MessageErrorType_DataTypeError),m, ep);
return;
}
EndAsyncCallFunction(skel, mr, err, m,ep);
}
void sub3_skel::RegisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3 >(rrobj1);
RobotRaconteur::ServiceSkel::RegisterEvents(rrobj1);
}

void sub3_skel::UnregisterEvents(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
RobotRaconteur::ServiceSkel::UnregisterEvents(rrobj1);
}

RR_SHARED_PTR<RobotRaconteur::RRObject> sub3_skel::GetSubObj(boost::string_ref name, boost::string_ref ind)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub3_skel::InitPipeServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitPipeServersRun) return;
rr_InitPipeServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3 >(rrobj1);
}

void sub3_skel::DispatchPipeMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub3_skel::CallPipeFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub3_skel::InitWireServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& rrobj1)
{
if (rr_InitWireServersRun) return;
rr_InitWireServersRun=true;
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3 >(rrobj1);
}

void sub3_skel::DispatchWireMessage(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub3_skel::CallWireFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, uint32_t e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

void sub3_skel::InitCallbackServers(const RR_SHARED_PTR<RobotRaconteur::RRObject>& o)
{
RR_SHARED_PTR<com::robotraconteur::testing::TestService1::sub3 > obj=RobotRaconteur::rr_cast<com::robotraconteur::testing::TestService1::sub3 >(o);
}
RR_SHARED_PTR<void> sub3_skel::GetCallbackFunction(uint32_t endpoint, boost::string_ref membername)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}

RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry> sub3_skel::CallMemoryFunction(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m, const RR_SHARED_PTR<RobotRaconteur::Endpoint>& e)
{
throw RobotRaconteur::MemberNotFoundException("Member not found");
}
bool sub3_skel::IsRequestNoLock(const RR_INTRUSIVE_PTR<RobotRaconteur::MessageEntry>& m)
{
return false;
}

testroot_default_impl::testroot_default_impl()
{
rrvar_d1=0.0;
rrvar_d2=RobotRaconteur::AllocateEmptyRRArray<double>(0);
rrvar_d3=RobotRaconteur::AllocateEmptyRRArray<double>(16);
rrvar_d4=RobotRaconteur::AllocateEmptyRRArray<double>(0);
rrvar_d5=RobotRaconteur::AllocateEmptyRRMultiDimArray<double>(boost::assign::list_of(1)(0));
rrvar_d6=RobotRaconteur::AllocateEmptyRRMultiDimArray<double>(boost::assign::list_of(3)(3));
rrvar_s1=0.0;
rrvar_s2=RobotRaconteur::AllocateEmptyRRArray<float>(0);
rrvar_i8_1=0;
rrvar_i8_2=RobotRaconteur::AllocateEmptyRRArray<int8_t>(0);
rrvar_u8_1=0;
rrvar_u8_2=RobotRaconteur::AllocateEmptyRRArray<uint8_t>(0);
rrvar_u8_3=RobotRaconteur::AllocateEmptyRRMultiDimArray<uint8_t>(boost::assign::list_of(1)(0));
rrvar_i16_1=0;
rrvar_i16_2=RobotRaconteur::AllocateEmptyRRArray<int16_t>(0);
rrvar_u16_1=0;
rrvar_u16_2=RobotRaconteur::AllocateEmptyRRArray<uint16_t>(0);
rrvar_i32_1=0;
rrvar_i32_2=RobotRaconteur::AllocateEmptyRRArray<int32_t>(0);
rrvar_i32_huge=RobotRaconteur::AllocateEmptyRRArray<int32_t>(0);
rrvar_u32_1=0;
rrvar_u32_2=RobotRaconteur::AllocateEmptyRRArray<uint32_t>(0);
rrvar_i64_1=0;
rrvar_i64_2=RobotRaconteur::AllocateEmptyRRArray<int64_t>(0);
rrvar_u64_1=0;
rrvar_u64_2=RobotRaconteur::AllocateEmptyRRArray<uint64_t>(0);
rrvar_str1="";
rrvar_struct1=RR_INTRUSIVE_PTR<teststruct1 >();
rrvar_struct2=RR_INTRUSIVE_PTR<teststruct2 >();
rrvar_is_d1=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d3=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d4=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d5=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >();
rrvar_is_d6=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >();
rrvar_is_str1=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >();
rrvar_is_str2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >();
rrvar_is_struct1=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >();
rrvar_is_struct2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >();
rrvar_struct3=RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >();
rrvar_list_d1=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >();
rrvar_list_d3=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >();
rrvar_list_d5=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >();
rrvar_list_str1=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >();
rrvar_list_struct1=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >();
rrvar_var1=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >();
rrvar_var_num=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_str=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_struct=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_vector=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_dictionary=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_list=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_multidimarray=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_errtest=0.0;
rrvar_nulltest=RR_INTRUSIVE_PTR<teststruct1 >();
}
double testroot_default_impl::get_d1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d1;
}
void testroot_default_impl::set_d1(double value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_default_impl::get_d2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d2;
}
void testroot_default_impl::set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_default_impl::get_d3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d3;
}
void testroot_default_impl::set_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_default_impl::get_d4()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d4;
}
void testroot_default_impl::set_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d4 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > testroot_default_impl::get_d5()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d5;
}
void testroot_default_impl::set_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d5 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > testroot_default_impl::get_d6()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d6;
}
void testroot_default_impl::set_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d6 = value;
}
float testroot_default_impl::get_s1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s1;
}
void testroot_default_impl::set_s1(float value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > > testroot_default_impl::get_s2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s2;
}
void testroot_default_impl::set_s2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s2 = value;
}
int8_t testroot_default_impl::get_i8_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i8_1;
}
void testroot_default_impl::set_i8_1(int8_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i8_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > > testroot_default_impl::get_i8_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i8_2;
}
void testroot_default_impl::set_i8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i8_2 = value;
}
uint8_t testroot_default_impl::get_u8_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u8_1;
}
void testroot_default_impl::set_u8_1(uint8_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u8_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > > testroot_default_impl::get_u8_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u8_2;
}
void testroot_default_impl::set_u8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u8_2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > > testroot_default_impl::get_u8_3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u8_3;
}
void testroot_default_impl::set_u8_3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u8_3 = value;
}
int16_t testroot_default_impl::get_i16_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i16_1;
}
void testroot_default_impl::set_i16_1(int16_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i16_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > > testroot_default_impl::get_i16_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i16_2;
}
void testroot_default_impl::set_i16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i16_2 = value;
}
uint16_t testroot_default_impl::get_u16_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u16_1;
}
void testroot_default_impl::set_u16_1(uint16_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u16_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > > testroot_default_impl::get_u16_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u16_2;
}
void testroot_default_impl::set_u16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u16_2 = value;
}
int32_t testroot_default_impl::get_i32_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i32_1;
}
void testroot_default_impl::set_i32_1(int32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i32_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > testroot_default_impl::get_i32_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i32_2;
}
void testroot_default_impl::set_i32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i32_2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > testroot_default_impl::get_i32_huge()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i32_huge;
}
void testroot_default_impl::set_i32_huge(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i32_huge = value;
}
uint32_t testroot_default_impl::get_u32_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u32_1;
}
void testroot_default_impl::set_u32_1(uint32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u32_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > > testroot_default_impl::get_u32_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u32_2;
}
void testroot_default_impl::set_u32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u32_2 = value;
}
int64_t testroot_default_impl::get_i64_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i64_1;
}
void testroot_default_impl::set_i64_1(int64_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i64_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > > testroot_default_impl::get_i64_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i64_2;
}
void testroot_default_impl::set_i64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i64_2 = value;
}
uint64_t testroot_default_impl::get_u64_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u64_1;
}
void testroot_default_impl::set_u64_1(uint64_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u64_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > > testroot_default_impl::get_u64_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u64_2;
}
void testroot_default_impl::set_u64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u64_2 = value;
}
std::string testroot_default_impl::get_str1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_str1;
}
void testroot_default_impl::set_str1(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_str1 = value;
}
RR_INTRUSIVE_PTR<teststruct1 > testroot_default_impl::get_struct1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_struct1;
}
void testroot_default_impl::set_struct1(const RR_INTRUSIVE_PTR<teststruct1 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_struct1 = value;
}
RR_INTRUSIVE_PTR<teststruct2 > testroot_default_impl::get_struct2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_struct2;
}
void testroot_default_impl::set_struct2(const RR_INTRUSIVE_PTR<teststruct2 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_struct2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > testroot_default_impl::get_is_d1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d1;
}
void testroot_default_impl::set_is_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > testroot_default_impl::get_is_d2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d2;
}
void testroot_default_impl::set_is_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > testroot_default_impl::get_is_d3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d3;
}
void testroot_default_impl::set_is_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > testroot_default_impl::get_is_d4()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d4;
}
void testroot_default_impl::set_is_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d4 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > > testroot_default_impl::get_is_d5()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d5;
}
void testroot_default_impl::set_is_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d5 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > > testroot_default_impl::get_is_d6()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d6;
}
void testroot_default_impl::set_is_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d6 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > > testroot_default_impl::get_is_str1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_str1;
}
void testroot_default_impl::set_is_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_str1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > > testroot_default_impl::get_is_str2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_str2;
}
void testroot_default_impl::set_is_str2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_str2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > > testroot_default_impl::get_is_struct1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_struct1;
}
void testroot_default_impl::set_is_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_struct1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > > testroot_default_impl::get_is_struct2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_struct2;
}
void testroot_default_impl::set_is_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_struct2 = value;
}
RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 > testroot_default_impl::get_struct3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_struct3;
}
void testroot_default_impl::set_struct3(const RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_struct3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > testroot_default_impl::get_list_d1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_d1;
}
void testroot_default_impl::set_list_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_d1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > testroot_default_impl::get_list_d3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_d3;
}
void testroot_default_impl::set_list_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_d3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > > testroot_default_impl::get_list_d5()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_d5;
}
void testroot_default_impl::set_list_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_d5 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > > testroot_default_impl::get_list_str1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_str1;
}
void testroot_default_impl::set_list_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_str1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > > testroot_default_impl::get_list_struct1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_struct1;
}
void testroot_default_impl::set_list_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_struct1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var1;
}
void testroot_default_impl::set_var1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > > testroot_default_impl::get_var2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var2;
}
void testroot_default_impl::set_var2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var_num()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_num;
}
void testroot_default_impl::set_var_num(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_num = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var_str()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_str;
}
void testroot_default_impl::set_var_str(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_str = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var_struct()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_struct;
}
void testroot_default_impl::set_var_struct(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_struct = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var_vector()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_vector;
}
void testroot_default_impl::set_var_vector(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_vector = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var_dictionary()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_dictionary;
}
void testroot_default_impl::set_var_dictionary(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_dictionary = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var_list()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_list;
}
void testroot_default_impl::set_var_list(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_list = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_impl::get_var_multidimarray()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_multidimarray;
}
void testroot_default_impl::set_var_multidimarray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_multidimarray = value;
}
double testroot_default_impl::get_errtest()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_errtest;
}
void testroot_default_impl::set_errtest(double value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_errtest = value;
}
RR_INTRUSIVE_PTR<teststruct1 > testroot_default_impl::get_nulltest()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_nulltest;
}
void testroot_default_impl::set_nulltest(const RR_INTRUSIVE_PTR<teststruct1 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_nulltest = value;
}
void testroot_default_impl::func1()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::func2(double d1, double d2)
{
throw RobotRaconteur::NotImplementedException("");
}
double testroot_default_impl::func3(double d1, double d2)
{
throw RobotRaconteur::NotImplementedException("");
}
int32_t testroot_default_impl::meaning_of_life()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::func_errtest()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::func_errtest1()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::func_errtest2()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::func_errtest3()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::o6_op(int32_t op)
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::pipe_check_error()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::test_callbacks()
{
throw RobotRaconteur::NotImplementedException("");
}
boost::signals2::signal<void ()>& testroot_default_impl::get_ev1()
{
return rrvar_ev1;
}
boost::signals2::signal<void (double, RR_INTRUSIVE_PTR<teststruct2 >)>& testroot_default_impl::get_ev2()
{
return rrvar_ev2;
}
RR_SHARED_PTR<sub1 > testroot_default_impl::get_o1()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub1 > testroot_default_impl::get_o2(int32_t ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub1 > testroot_default_impl::get_o3(int32_t ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub1 > testroot_default_impl::get_o4(const std::string& ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<com::robotraconteur::testing::TestService2::subobj > testroot_default_impl::get_o5()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::RRObject > testroot_default_impl::get_o6()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > > testroot_default_impl::get_p1()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::set_p1(const RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<teststruct2 > > > testroot_default_impl::get_p2()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::set_p2(const RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<teststruct2 > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Pipe<double > > testroot_default_impl::get_broadcastpipe()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::set_broadcastpipe(const RR_SHARED_PTR<RobotRaconteur::Pipe<double > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void() > > > testroot_default_impl::get_cb1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb1;
}
void testroot_default_impl::set_cb1(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void()> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb1) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb1 = value;
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void(double, double) > > > testroot_default_impl::get_cb2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb2;
}
void testroot_default_impl::set_cb2(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void(double, double)> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb2) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb2 = value;
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<double(double, double) > > > testroot_default_impl::get_cb3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb3;
}
void testroot_default_impl::set_cb3(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<double(double, double)> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb3) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb3 = value;
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<int32_t() > > > testroot_default_impl::get_cb_meaning_of_life()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb_meaning_of_life;
}
void testroot_default_impl::set_cb_meaning_of_life(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<int32_t()> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb_meaning_of_life) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb_meaning_of_life = value;
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void() > > > testroot_default_impl::get_cb_errtest()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb_errtest;
}
void testroot_default_impl::set_cb_errtest(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void()> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb_errtest) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb_errtest = value;
}
RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > > testroot_default_impl::get_w1()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::set_w1(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<teststruct2 > > > testroot_default_impl::get_w2()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::set_w2(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<teststruct2 > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > > testroot_default_impl::get_w3()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::set_w3(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Wire<double > > testroot_default_impl::get_broadcastwire()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_impl::set_broadcastwire(const RR_SHARED_PTR<RobotRaconteur::Wire<double > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::ArrayMemory<double > > testroot_default_impl::get_m1()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemory<double > > testroot_default_impl::get_m2()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemory<uint8_t > > testroot_default_impl::get_m3()
{
throw RobotRaconteur::NotImplementedException("");
}
sub1_default_impl::sub1_default_impl()
{
rrvar_d1=RobotRaconteur::AllocateEmptyRRArray<double>(0);
rrvar_d2=RobotRaconteur::AllocateEmptyRRMultiDimArray<double>(boost::assign::list_of(1)(0));
rrvar_s_ind="";
rrvar_i_ind=0;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > sub1_default_impl::get_d1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d1;
}
void sub1_default_impl::set_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > sub1_default_impl::get_d2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d2;
}
void sub1_default_impl::set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d2 = value;
}
std::string sub1_default_impl::get_s_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s_ind;
}
void sub1_default_impl::set_s_ind(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s_ind = value;
}
int32_t sub1_default_impl::get_i_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i_ind;
}
void sub1_default_impl::set_i_ind(int32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i_ind = value;
}
RR_SHARED_PTR<sub2 > sub1_default_impl::get_o2_1()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub2 > sub1_default_impl::get_o2_2(int32_t ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub2 > sub1_default_impl::get_o2_3(const std::string& ind)
{
throw RobotRaconteur::NotImplementedException("");
}
sub2_default_impl::sub2_default_impl()
{
rrvar_s_ind="";
rrvar_i_ind=0;
rrvar_data="";
}
std::string sub2_default_impl::get_s_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s_ind;
}
void sub2_default_impl::set_s_ind(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s_ind = value;
}
int32_t sub2_default_impl::get_i_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i_ind;
}
void sub2_default_impl::set_i_ind(int32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i_ind = value;
}
std::string sub2_default_impl::get_data()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_data;
}
void sub2_default_impl::set_data(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_data = value;
}
RR_SHARED_PTR<sub3 > sub2_default_impl::get_o3_1(const std::string& ind)
{
throw RobotRaconteur::NotImplementedException("");
}
sub3_default_impl::sub3_default_impl()
{
rrvar_ind="";
rrvar_data2="";
rrvar_data3=0.0;
}
std::string sub3_default_impl::get_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_ind;
}
void sub3_default_impl::set_ind(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_ind = value;
}
std::string sub3_default_impl::get_data2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_data2;
}
void sub3_default_impl::set_data2(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_data2 = value;
}
double sub3_default_impl::get_data3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_data3;
}
void sub3_default_impl::set_data3(double value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_data3 = value;
}
double sub3_default_impl::add(double d)
{
throw RobotRaconteur::NotImplementedException("");
}

testroot_default_abstract_impl::testroot_default_abstract_impl()
{
rrvar_d3=RobotRaconteur::AllocateEmptyRRArray<double>(16);
rrvar_d4=RobotRaconteur::AllocateEmptyRRArray<double>(0);
rrvar_d5=RobotRaconteur::AllocateEmptyRRMultiDimArray<double>(boost::assign::list_of(1)(0));
rrvar_d6=RobotRaconteur::AllocateEmptyRRMultiDimArray<double>(boost::assign::list_of(3)(3));
rrvar_s1=0.0;
rrvar_s2=RobotRaconteur::AllocateEmptyRRArray<float>(0);
rrvar_i8_1=0;
rrvar_i8_2=RobotRaconteur::AllocateEmptyRRArray<int8_t>(0);
rrvar_u8_1=0;
rrvar_u8_2=RobotRaconteur::AllocateEmptyRRArray<uint8_t>(0);
rrvar_u8_3=RobotRaconteur::AllocateEmptyRRMultiDimArray<uint8_t>(boost::assign::list_of(1)(0));
rrvar_i16_1=0;
rrvar_i16_2=RobotRaconteur::AllocateEmptyRRArray<int16_t>(0);
rrvar_u16_1=0;
rrvar_u16_2=RobotRaconteur::AllocateEmptyRRArray<uint16_t>(0);
rrvar_i32_1=0;
rrvar_i32_2=RobotRaconteur::AllocateEmptyRRArray<int32_t>(0);
rrvar_i32_huge=RobotRaconteur::AllocateEmptyRRArray<int32_t>(0);
rrvar_u32_1=0;
rrvar_u32_2=RobotRaconteur::AllocateEmptyRRArray<uint32_t>(0);
rrvar_i64_1=0;
rrvar_i64_2=RobotRaconteur::AllocateEmptyRRArray<int64_t>(0);
rrvar_u64_1=0;
rrvar_u64_2=RobotRaconteur::AllocateEmptyRRArray<uint64_t>(0);
rrvar_str1="";
rrvar_struct1=RR_INTRUSIVE_PTR<teststruct1 >();
rrvar_struct2=RR_INTRUSIVE_PTR<teststruct2 >();
rrvar_is_d1=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d3=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d4=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >();
rrvar_is_d5=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >();
rrvar_is_d6=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >();
rrvar_is_str1=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >();
rrvar_is_str2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >();
rrvar_is_struct1=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >();
rrvar_is_struct2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >();
rrvar_struct3=RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >();
rrvar_list_d1=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >();
rrvar_list_d3=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >();
rrvar_list_d5=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >();
rrvar_list_str1=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >();
rrvar_list_struct1=RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >();
rrvar_var1=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var2=RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >();
rrvar_var_num=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_str=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_struct=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_vector=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_dictionary=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_list=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_var_multidimarray=RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>();
rrvar_errtest=0.0;
rrvar_nulltest=RR_INTRUSIVE_PTR<teststruct1 >();
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_default_abstract_impl::get_d3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d3;
}
void testroot_default_abstract_impl::set_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > testroot_default_abstract_impl::get_d4()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d4;
}
void testroot_default_abstract_impl::set_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d4 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > testroot_default_abstract_impl::get_d5()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d5;
}
void testroot_default_abstract_impl::set_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d5 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > testroot_default_abstract_impl::get_d6()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d6;
}
void testroot_default_abstract_impl::set_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d6 = value;
}
float testroot_default_abstract_impl::get_s1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s1;
}
void testroot_default_abstract_impl::set_s1(float value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > > testroot_default_abstract_impl::get_s2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s2;
}
void testroot_default_abstract_impl::set_s2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<float > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s2 = value;
}
int8_t testroot_default_abstract_impl::get_i8_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i8_1;
}
void testroot_default_abstract_impl::set_i8_1(int8_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i8_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > > testroot_default_abstract_impl::get_i8_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i8_2;
}
void testroot_default_abstract_impl::set_i8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int8_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i8_2 = value;
}
uint8_t testroot_default_abstract_impl::get_u8_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u8_1;
}
void testroot_default_abstract_impl::set_u8_1(uint8_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u8_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > > testroot_default_abstract_impl::get_u8_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u8_2;
}
void testroot_default_abstract_impl::set_u8_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint8_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u8_2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > > testroot_default_abstract_impl::get_u8_3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u8_3;
}
void testroot_default_abstract_impl::set_u8_3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<uint8_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u8_3 = value;
}
int16_t testroot_default_abstract_impl::get_i16_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i16_1;
}
void testroot_default_abstract_impl::set_i16_1(int16_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i16_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > > testroot_default_abstract_impl::get_i16_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i16_2;
}
void testroot_default_abstract_impl::set_i16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int16_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i16_2 = value;
}
uint16_t testroot_default_abstract_impl::get_u16_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u16_1;
}
void testroot_default_abstract_impl::set_u16_1(uint16_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u16_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > > testroot_default_abstract_impl::get_u16_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u16_2;
}
void testroot_default_abstract_impl::set_u16_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint16_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u16_2 = value;
}
int32_t testroot_default_abstract_impl::get_i32_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i32_1;
}
void testroot_default_abstract_impl::set_i32_1(int32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i32_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > testroot_default_abstract_impl::get_i32_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i32_2;
}
void testroot_default_abstract_impl::set_i32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i32_2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > > testroot_default_abstract_impl::get_i32_huge()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i32_huge;
}
void testroot_default_abstract_impl::set_i32_huge(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int32_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i32_huge = value;
}
uint32_t testroot_default_abstract_impl::get_u32_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u32_1;
}
void testroot_default_abstract_impl::set_u32_1(uint32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u32_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > > testroot_default_abstract_impl::get_u32_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u32_2;
}
void testroot_default_abstract_impl::set_u32_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint32_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u32_2 = value;
}
int64_t testroot_default_abstract_impl::get_i64_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i64_1;
}
void testroot_default_abstract_impl::set_i64_1(int64_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i64_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > > testroot_default_abstract_impl::get_i64_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i64_2;
}
void testroot_default_abstract_impl::set_i64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<int64_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i64_2 = value;
}
uint64_t testroot_default_abstract_impl::get_u64_1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u64_1;
}
void testroot_default_abstract_impl::set_u64_1(uint64_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u64_1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > > testroot_default_abstract_impl::get_u64_2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_u64_2;
}
void testroot_default_abstract_impl::set_u64_2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<uint64_t > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_u64_2 = value;
}
std::string testroot_default_abstract_impl::get_str1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_str1;
}
void testroot_default_abstract_impl::set_str1(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_str1 = value;
}
RR_INTRUSIVE_PTR<teststruct1 > testroot_default_abstract_impl::get_struct1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_struct1;
}
void testroot_default_abstract_impl::set_struct1(const RR_INTRUSIVE_PTR<teststruct1 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_struct1 = value;
}
RR_INTRUSIVE_PTR<teststruct2 > testroot_default_abstract_impl::get_struct2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_struct2;
}
void testroot_default_abstract_impl::set_struct2(const RR_INTRUSIVE_PTR<teststruct2 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_struct2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > testroot_default_abstract_impl::get_is_d1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d1;
}
void testroot_default_abstract_impl::set_is_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > testroot_default_abstract_impl::get_is_d2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d2;
}
void testroot_default_abstract_impl::set_is_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > > testroot_default_abstract_impl::get_is_d3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d3;
}
void testroot_default_abstract_impl::set_is_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > > testroot_default_abstract_impl::get_is_d4()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d4;
}
void testroot_default_abstract_impl::set_is_d4(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d4 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > > testroot_default_abstract_impl::get_is_d5()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d5;
}
void testroot_default_abstract_impl::set_is_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d5 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > > testroot_default_abstract_impl::get_is_d6()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_d6;
}
void testroot_default_abstract_impl::set_is_d6(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_d6 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > > testroot_default_abstract_impl::get_is_str1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_str1;
}
void testroot_default_abstract_impl::set_is_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRArray<char>  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_str1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > > testroot_default_abstract_impl::get_is_str2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_str2;
}
void testroot_default_abstract_impl::set_is_str2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,RobotRaconteur::RRArray<char>  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_str2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > > testroot_default_abstract_impl::get_is_struct1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_struct1;
}
void testroot_default_abstract_impl::set_is_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,teststruct2  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_struct1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > > testroot_default_abstract_impl::get_is_struct2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_is_struct2;
}
void testroot_default_abstract_impl::set_is_struct2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<std::string,teststruct2  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_is_struct2 = value;
}
RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 > testroot_default_abstract_impl::get_struct3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_struct3;
}
void testroot_default_abstract_impl::set_struct3(const RR_INTRUSIVE_PTR<com::robotraconteur::testing::TestService2::ostruct2 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_struct3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > testroot_default_abstract_impl::get_list_d1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_d1;
}
void testroot_default_abstract_impl::set_list_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_d1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > > testroot_default_abstract_impl::get_list_d3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_d3;
}
void testroot_default_abstract_impl::set_list_d3(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_d3 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > > testroot_default_abstract_impl::get_list_d5()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_d5;
}
void testroot_default_abstract_impl::set_list_d5(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRMultiDimArray<double >  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_d5 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > > testroot_default_abstract_impl::get_list_str1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_str1;
}
void testroot_default_abstract_impl::set_list_str1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<RobotRaconteur::RRArray<char>  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_str1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > > testroot_default_abstract_impl::get_list_struct1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_list_struct1;
}
void testroot_default_abstract_impl::set_list_struct1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRList<teststruct2  > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_list_struct1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var1;
}
void testroot_default_abstract_impl::set_var1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > > testroot_default_abstract_impl::get_var2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var2;
}
void testroot_default_abstract_impl::set_var2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMap<int32_t,RobotRaconteur::RRValue > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var2 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var_num()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_num;
}
void testroot_default_abstract_impl::set_var_num(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_num = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var_str()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_str;
}
void testroot_default_abstract_impl::set_var_str(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_str = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var_struct()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_struct;
}
void testroot_default_abstract_impl::set_var_struct(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_struct = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var_vector()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_vector;
}
void testroot_default_abstract_impl::set_var_vector(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_vector = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var_dictionary()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_dictionary;
}
void testroot_default_abstract_impl::set_var_dictionary(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_dictionary = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var_list()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_list;
}
void testroot_default_abstract_impl::set_var_list(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_list = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRValue> testroot_default_abstract_impl::get_var_multidimarray()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_var_multidimarray;
}
void testroot_default_abstract_impl::set_var_multidimarray(const RR_INTRUSIVE_PTR<RobotRaconteur::RRValue>& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_var_multidimarray = value;
}
double testroot_default_abstract_impl::get_errtest()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_errtest;
}
void testroot_default_abstract_impl::set_errtest(double value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_errtest = value;
}
RR_INTRUSIVE_PTR<teststruct1 > testroot_default_abstract_impl::get_nulltest()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_nulltest;
}
void testroot_default_abstract_impl::set_nulltest(const RR_INTRUSIVE_PTR<teststruct1 >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_nulltest = value;
}
void testroot_default_abstract_impl::func1()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::func2(double d1, double d2)
{
throw RobotRaconteur::NotImplementedException("");
}
int32_t testroot_default_abstract_impl::meaning_of_life()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::func_errtest()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::func_errtest1()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::func_errtest2()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::func_errtest3()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::o6_op(int32_t op)
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::pipe_check_error()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::test_callbacks()
{
throw RobotRaconteur::NotImplementedException("");
}
boost::signals2::signal<void (double, RR_INTRUSIVE_PTR<teststruct2 >)>& testroot_default_abstract_impl::get_ev2()
{
return rrvar_ev2;
}
RR_SHARED_PTR<sub1 > testroot_default_abstract_impl::get_o1()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub1 > testroot_default_abstract_impl::get_o2(int32_t ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub1 > testroot_default_abstract_impl::get_o3(int32_t ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub1 > testroot_default_abstract_impl::get_o4(const std::string& ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::RRObject > testroot_default_abstract_impl::get_o6()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<teststruct2 > > > testroot_default_abstract_impl::get_p2()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::set_p2(const RR_SHARED_PTR<RobotRaconteur::Pipe<RR_INTRUSIVE_PTR<teststruct2 > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Pipe<double > > testroot_default_abstract_impl::get_broadcastpipe()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::set_broadcastpipe(const RR_SHARED_PTR<RobotRaconteur::Pipe<double > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void() > > > testroot_default_abstract_impl::get_cb1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb1;
}
void testroot_default_abstract_impl::set_cb1(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void()> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb1) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb1 = value;
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<double(double, double) > > > testroot_default_abstract_impl::get_cb3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb3;
}
void testroot_default_abstract_impl::set_cb3(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<double(double, double)> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb3) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb3 = value;
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<int32_t() > > > testroot_default_abstract_impl::get_cb_meaning_of_life()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb_meaning_of_life;
}
void testroot_default_abstract_impl::set_cb_meaning_of_life(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<int32_t()> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb_meaning_of_life) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb_meaning_of_life = value;
}
RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void() > > > testroot_default_abstract_impl::get_cb_errtest()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_cb_errtest;
}
void testroot_default_abstract_impl::set_cb_errtest(const RR_SHARED_PTR<RobotRaconteur::Callback<boost::function<void()> > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
if (rrvar_cb_errtest) throw RobotRaconteur::InvalidOperationException("Callback already set");
rrvar_cb_errtest = value;
}
RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<teststruct2 > > > testroot_default_abstract_impl::get_w2()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::set_w2(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<teststruct2 > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > > testroot_default_abstract_impl::get_w3()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::set_w3(const RR_SHARED_PTR<RobotRaconteur::Wire<RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<int32_t > > > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::Wire<double > > testroot_default_abstract_impl::get_broadcastwire()
{
throw RobotRaconteur::NotImplementedException("");
}
void testroot_default_abstract_impl::set_broadcastwire(const RR_SHARED_PTR<RobotRaconteur::Wire<double > >& value)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemory<double > > testroot_default_abstract_impl::get_m2()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<RobotRaconteur::MultiDimArrayMemory<uint8_t > > testroot_default_abstract_impl::get_m3()
{
throw RobotRaconteur::NotImplementedException("");
}
sub1_default_abstract_impl::sub1_default_abstract_impl()
{
rrvar_d1=RobotRaconteur::AllocateEmptyRRArray<double>(0);
rrvar_d2=RobotRaconteur::AllocateEmptyRRMultiDimArray<double>(boost::assign::list_of(1)(0));
rrvar_s_ind="";
rrvar_i_ind=0;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > > sub1_default_abstract_impl::get_d1()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d1;
}
void sub1_default_abstract_impl::set_d1(const RR_INTRUSIVE_PTR<RobotRaconteur::RRArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d1 = value;
}
RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > > sub1_default_abstract_impl::get_d2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_d2;
}
void sub1_default_abstract_impl::set_d2(const RR_INTRUSIVE_PTR<RobotRaconteur::RRMultiDimArray<double > >& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_d2 = value;
}
std::string sub1_default_abstract_impl::get_s_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s_ind;
}
void sub1_default_abstract_impl::set_s_ind(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s_ind = value;
}
int32_t sub1_default_abstract_impl::get_i_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i_ind;
}
void sub1_default_abstract_impl::set_i_ind(int32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i_ind = value;
}
RR_SHARED_PTR<sub2 > sub1_default_abstract_impl::get_o2_1()
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub2 > sub1_default_abstract_impl::get_o2_2(int32_t ind)
{
throw RobotRaconteur::NotImplementedException("");
}
RR_SHARED_PTR<sub2 > sub1_default_abstract_impl::get_o2_3(const std::string& ind)
{
throw RobotRaconteur::NotImplementedException("");
}
sub2_default_abstract_impl::sub2_default_abstract_impl()
{
rrvar_s_ind="";
rrvar_i_ind=0;
rrvar_data="";
}
std::string sub2_default_abstract_impl::get_s_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_s_ind;
}
void sub2_default_abstract_impl::set_s_ind(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_s_ind = value;
}
int32_t sub2_default_abstract_impl::get_i_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_i_ind;
}
void sub2_default_abstract_impl::set_i_ind(int32_t value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_i_ind = value;
}
std::string sub2_default_abstract_impl::get_data()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_data;
}
void sub2_default_abstract_impl::set_data(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_data = value;
}
RR_SHARED_PTR<sub3 > sub2_default_abstract_impl::get_o3_1(const std::string& ind)
{
throw RobotRaconteur::NotImplementedException("");
}
sub3_default_abstract_impl::sub3_default_abstract_impl()
{
rrvar_ind="";
rrvar_data2="";
rrvar_data3=0.0;
}
std::string sub3_default_abstract_impl::get_ind()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_ind;
}
void sub3_default_abstract_impl::set_ind(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_ind = value;
}
std::string sub3_default_abstract_impl::get_data2()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_data2;
}
void sub3_default_abstract_impl::set_data2(const std::string& value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_data2 = value;
}
double sub3_default_abstract_impl::get_data3()
{
boost::mutex::scoped_lock lock(this_lock);
return rrvar_data3;
}
void sub3_default_abstract_impl::set_data3(double value)
{
boost::mutex::scoped_lock lock(this_lock);
rrvar_data3 = value;
}
double sub3_default_abstract_impl::add(double d)
{
throw RobotRaconteur::NotImplementedException("");
}

}
}
}
}
// NOLINTEND

