// Copyright (C) 2023 The Qt Company Ltd and other contributors.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

// This file was generated by qlalr - DO NOT EDIT!
#ifndef GLSLPARSERTABLE_P_H
#define GLSLPARSERTABLE_P_H

#include <QtCore/qglobal.h>

QT_BEGIN_NAMESPACE

class GLSLParserTable
{
public:
    enum VariousConstants {
        EOF_SYMBOL = 0,
        T_ADD_ASSIGN = 3,
        T_AMPERSAND = 4,
        T_AND_ASSIGN = 5,
        T_AND_OP = 6,
        T_ATOMIC_UINT = 7,
        T_ATTRIBUTE = 8,
        T_BANG = 9,
        T_BOOL = 10,
        T_BREAK = 11,
        T_BVEC2 = 12,
        T_BVEC3 = 13,
        T_BVEC4 = 14,
        T_CARET = 15,
        T_CASE = 16,
        T_CENTROID = 17,
        T_COLON = 18,
        T_COMMA = 19,
        T_COMMENT = 206,
        T_CONST = 20,
        T_CONTINUE = 21,
        T_DASH = 22,
        T_DEC_OP = 23,
        T_DEFAULT = 24,
        T_DISCARD = 25,
        T_DIV_ASSIGN = 26,
        T_DMAT2 = 27,
        T_DMAT2X2 = 28,
        T_DMAT2X3 = 29,
        T_DMAT2X4 = 30,
        T_DMAT3 = 31,
        T_DMAT3X2 = 32,
        T_DMAT3X3 = 33,
        T_DMAT3X4 = 34,
        T_DMAT4 = 35,
        T_DMAT4X2 = 36,
        T_DMAT4X3 = 37,
        T_DMAT4X4 = 38,
        T_DO = 39,
        T_DOT = 40,
        T_DOUBLE = 41,
        T_DVEC2 = 42,
        T_DVEC3 = 43,
        T_DVEC4 = 44,
        T_ELSE = 45,
        T_EQUAL = 46,
        T_EQ_OP = 47,
        T_ERROR = 207,
        T_FALSE = 204,
        T_FEED_EXPRESSION = 2,
        T_FEED_GLSL = 1,
        T_FLAT = 48,
        T_FLOAT = 49,
        T_FOR = 50,
        T_GE_OP = 51,
        T_HIGHP = 52,
        T_IDENTIFIER = 53,
        T_IF = 54,
        T_IIMAGE1D = 55,
        T_IIMAGE1DARRAY = 56,
        T_IIMAGE2D = 57,
        T_IIMAGE2DARRAY = 58,
        T_IIMAGE2DMS = 59,
        T_IIMAGE2DMSARRAY = 60,
        T_IIMAGE2DRECT = 61,
        T_IIMAGE3D = 62,
        T_IIMAGEBUFFER = 63,
        T_IIMAGECUBE = 64,
        T_IIMAGECUBEARRAY = 65,
        T_IMAGE1D = 66,
        T_IMAGE1DARRAY = 67,
        T_IMAGE2D = 68,
        T_IMAGE2DARRAY = 69,
        T_IMAGE2DMS = 70,
        T_IMAGE2DMSARRAY = 71,
        T_IMAGE2DRECT = 72,
        T_IMAGE3D = 73,
        T_IMAGEBUFFER = 74,
        T_IMAGECUBE = 75,
        T_IMAGECUBEARRAY = 76,
        T_IN = 77,
        T_INC_OP = 78,
        T_INOUT = 79,
        T_INT = 80,
        T_INVARIANT = 81,
        T_ISAMPLER1D = 82,
        T_ISAMPLER1DARRAY = 83,
        T_ISAMPLER2D = 84,
        T_ISAMPLER2DARRAY = 85,
        T_ISAMPLER2DMS = 86,
        T_ISAMPLER2DMSARRAY = 87,
        T_ISAMPLER2DRECT = 88,
        T_ISAMPLER3D = 89,
        T_ISAMPLERBUFFER = 90,
        T_ISAMPLERCUBE = 91,
        T_ISAMPLERCUBEARRAY = 92,
        T_IVEC2 = 93,
        T_IVEC3 = 94,
        T_IVEC4 = 95,
        T_LAYOUT = 96,
        T_LEFT_ANGLE = 97,
        T_LEFT_ASSIGN = 98,
        T_LEFT_BRACE = 99,
        T_LEFT_BRACKET = 100,
        T_LEFT_OP = 101,
        T_LEFT_PAREN = 102,
        T_LE_OP = 103,
        T_LOWP = 104,
        T_MAT2 = 105,
        T_MAT2X2 = 106,
        T_MAT2X3 = 107,
        T_MAT2X4 = 108,
        T_MAT3 = 109,
        T_MAT3X2 = 110,
        T_MAT3X3 = 111,
        T_MAT3X4 = 112,
        T_MAT4 = 113,
        T_MAT4X2 = 114,
        T_MAT4X3 = 115,
        T_MAT4X4 = 116,
        T_MEDIUMP = 117,
        T_MOD_ASSIGN = 118,
        T_MUL_ASSIGN = 119,
        T_NE_OP = 120,
        T_NOPERSPECTIVE = 121,
        T_NUMBER = 122,
        T_OR_ASSIGN = 123,
        T_OR_OP = 124,
        T_OUT = 125,
        T_PATCH = 126,
        T_PERCENT = 127,
        T_PLUS = 128,
        T_PRECISION = 129,
        T_PREPROC = 205,
        T_QUESTION = 130,
        T_RESERVED = 208,
        T_RETURN = 131,
        T_RIGHT_ANGLE = 132,
        T_RIGHT_ASSIGN = 133,
        T_RIGHT_BRACE = 134,
        T_RIGHT_BRACKET = 135,
        T_RIGHT_OP = 136,
        T_RIGHT_PAREN = 137,
        T_SAMPLE = 138,
        T_SAMPLER1D = 139,
        T_SAMPLER1DARRAY = 140,
        T_SAMPLER1DARRAYSHADOW = 141,
        T_SAMPLER1DSHADOW = 142,
        T_SAMPLER2D = 143,
        T_SAMPLER2DARRAY = 144,
        T_SAMPLER2DARRAYSHADOW = 145,
        T_SAMPLER2DMS = 146,
        T_SAMPLER2DMSARRAY = 147,
        T_SAMPLER2DRECT = 148,
        T_SAMPLER2DRECTSHADOW = 149,
        T_SAMPLER2DSHADOW = 150,
        T_SAMPLER3D = 151,
        T_SAMPLERBUFFER = 152,
        T_SAMPLERCUBE = 153,
        T_SAMPLERCUBEARRAY = 154,
        T_SAMPLERCUBEARRAYSHADOW = 155,
        T_SAMPLERCUBESHADOW = 156,
        T_SEMICOLON = 157,
        T_SLASH = 158,
        T_SMOOTH = 159,
        T_STAR = 160,
        T_STRUCT = 161,
        T_SUBROUTINE = 162,
        T_SUB_ASSIGN = 163,
        T_SWITCH = 164,
        T_TILDE = 165,
        T_TRUE = 203,
        T_TYPE_NAME = 166,
        T_UIMAGE1D = 167,
        T_UIMAGE1DARRAY = 168,
        T_UIMAGE2D = 169,
        T_UIMAGE2DARRAY = 170,
        T_UIMAGE2DMS = 171,
        T_UIMAGE2DMSARRAY = 172,
        T_UIMAGE2DRECT = 173,
        T_UIMAGE3D = 174,
        T_UIMAGEBUFFER = 175,
        T_UIMAGECUBE = 176,
        T_UIMAGECUBEARRAY = 177,
        T_UINT = 178,
        T_UNIFORM = 179,
        T_USAMPLER1D = 180,
        T_USAMPLER1DARRAY = 181,
        T_USAMPLER2D = 182,
        T_USAMPLER2DARRAY = 183,
        T_USAMPLER2DMS = 184,
        T_USAMPLER2DMSARRAY = 185,
        T_USAMPLER2DRECT = 186,
        T_USAMPLER3D = 187,
        T_USAMPLERBUFFER = 188,
        T_USAMPLERCUBE = 189,
        T_USAMPLERCUBEARRAY = 190,
        T_UVEC2 = 191,
        T_UVEC3 = 192,
        T_UVEC4 = 193,
        T_VARYING = 194,
        T_VEC2 = 195,
        T_VEC3 = 196,
        T_VEC4 = 197,
        T_VERTICAL_BAR = 198,
        T_VOID = 199,
        T_WHILE = 200,
        T_XOR_ASSIGN = 201,
        T_XOR_OP = 202,

        ACCEPT_STATE = 496,
        RULE_COUNT = 350,
        STATE_COUNT = 497,
        TERMINAL_COUNT = 209,
        NON_TERMINAL_COUNT = 85,

        GOTO_INDEX_OFFSET = 497,
        GOTO_INFO_OFFSET = 5584,
        GOTO_CHECK_OFFSET = 5584
    };

    static const char *const     spell[];
    static const short             lhs[];
    static const short             rhs[];
    static const short    goto_default[];
    static const short  action_default[];
    static const short    action_index[];
    static const short     action_info[];
    static const short    action_check[];

    static inline int nt_action (int state, int nt)
    {
        const int yyn = action_index [GOTO_INDEX_OFFSET + state] + nt;
        if (yyn < 0 || action_check [GOTO_CHECK_OFFSET + yyn] != nt)
            return goto_default [nt];

        return action_info [GOTO_INFO_OFFSET + yyn];
    }

    static inline int t_action (int state, int token)
    {
        const int yyn = action_index [state] + token;

        if (yyn < 0 || action_check [yyn] != token)
            return - action_default [state];

        return action_info [yyn];
    }
};


QT_END_NAMESPACE
#endif // GLSLPARSERTABLE_P_H

