-- This reservoir simulation deck is made available under the Open Database
-- License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in
-- individual contents of the database are licensed under the Database Contents
-- License: http://opendatacommons.org/licenses/dbcl/1.0/

-- Copyright (C) 2025 Equinor

--
--         Generated by : Prosper 9.3 - License#:4474 - Sep 17 2006 14:05:16
--         Generated on : 23 Jan 07  14:34
--           Input File : Z:\res\sim\ior\linn\gap\PD1.PIPE.OUT
--          Output File : Z:\res\INCLUDE\VFP\PD1.PIPE.Ecl
--
--
--                Fluid : Oil
--           PVT Method : Black Oil
--    Equation Of State : 
--            Separator : Single-Stage
--            Emulsions : No
--             Hydrates : Disable Warning
--      Water Viscosity : Use Default Correlation
--         Water Vapour : No Calculations
--      Viscosity Model : Newtonian Fluid
--
--            Flow Type : 
--            Well Type : Producer
--
--      Artificial Lift : None
--            Lift Type : 
--
--           Predicting : Pressure and Temperature (offshore)
--    Temperature Model : Rough Approximation
--                Range : PipeLine Only
--
--           Completion : 
--          Gravel Pack : 
--
--          Inflow Type : 
--           Gas Coning : 
--
--              Company : Statoil
--                Field : Norne
--             Location : Nordland II
--                 Well : B-3H
--             Platform : Treasure Prospect
--              Analyst : amoe
--                 Date : 05 Feb 02  13:05
--
--
--
--  Surface Equipment Correlation :  OLGAS 2P - (1.046) (1.037)
--      Vertical Lift Correlation :  Petroleum Experts 2 - (1.010) (1.000)
--
--                    Rate Method :  User Selected
--                      Rate Type :  Liquid Rates
--
--                     First Node :    1             Manifold          0 (m)
--                      Last Node :    4            Xmas Tree        394 (m)
--
--         Sensitivity Variable 1 :  First Node Pressure
--         Sensitivity Variable 2 :  Gas Oil Ratio
--         Sensitivity Variable 3 :  Water Cut
--
--
-- PROSPER Lift Curves For ECLIPSE Simulator    (Liquid - Producer Well)  (Units System  - METRIC)


VFPPROD

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
       4           250       'LIQ'      'WCT'      'GOR'            /


-- 'LIQ' units - SM3/DAY
  100.0   500.0  1000.0  1500.0  2500.0 
 4000.0  6000.0  8000.0 10000.0 12000.0 
15000.0 20000.0 /

-- 'THP' units - BARSA
  16.01   21.01   26.01   31.01   41.01 
  51.01   61.01 /

-- 'WCT' units - FRACTION
      0     0.1     0.2    0.25     0.3 
    0.5     0.7     0.9       1 /

-- 'GOR' units - SM3/SM3
     90     100     150     200     500 
    700    1000    5000   10000 /

-- 'ALQ' units - 
      0 /

 1  1  1  1   46.06   37.47   31.58   29.20   28.44 
              31.14   37.67   45.15   53.00   61.07 
              73.43   96.86 
/
 1  1  2  1   45.75   36.46   30.52   28.35   27.98 
              31.27   38.28   46.06   54.24   62.74 
              73.64   97.37 
/
 1  1  3  1   44.19   32.33   27.01   25.86   27.35 
              32.79   41.17   50.03   56.99   62.66 
              73.44   96.36 
/
 1  1  4  1   42.74   29.42   25.17   24.99   28.00 
              34.25   43.57   52.10   60.64   68.96 
              81.68  103.81 
/
 1  1  5  1   35.76   23.00   23.81   25.61   34.28 
              47.01   63.70   80.43   97.14  113.89 
             139.26  182.93 
/
 1  1  6  1   32.46   22.27   23.77   28.48   40.14 
              56.70   78.83  100.74  122.57  144.50 
             177.91  235.91 
/
 1  1  7  1   28.93   22.66   26.11   34.17   49.21 
              71.79  101.35  130.52  159.66  189.09 
             234.30  315.87 
/
 1  1  8  1   21.62   42.68   75.03  105.95  164.62 
             257.05  397.54  561.62  754.69  980.43 
            1376.31 2160.65 
/
 1  1  9  1   22.02   72.37  130.44  188.18  314.35 
             537.98  917.19 1393.78 1970.36 2181.52 
            2172.39 2164.97 
/
 1  2  1  1   46.87   38.66   32.78   30.23   29.14 
              31.35   37.49   44.71   52.35   60.24 
              72.89   95.09 
/
 1  2  2  1   46.58   37.67   31.69   29.31   28.57 
              31.34   37.99   45.58   53.54   61.75 
              74.34   97.77 
/
 1  2  3  1   45.17   33.57   27.93   26.48   27.49 
              32.48   40.71   49.53   57.41   62.94 
              71.68   97.00 
/
 1  2  4  1   43.81   30.57   25.85   25.32   27.80 
              33.96   42.83   51.22   58.92   66.86 
              78.87   99.77 
/
 1  2  5  1   37.12   23.47   23.61   25.26   32.77 
              44.91   60.26   75.70   91.16  106.68 
             130.19  170.69 
/
 1  2  6  1   33.83   22.46   23.89   27.40   38.28 
              53.39   73.77   94.01  114.20  134.47 
             165.32  218.77 
/
 1  2  7  1   30.18   22.44   25.20   32.23   46.21 
              66.93   94.17  121.09  147.97  175.08 
             216.64  290.15 
/
 1  2  8  1   21.41   39.65   69.14   97.50  151.39 
             233.16  356.21  497.94  661.61  851.55 
            1185.59 1878.94 
/
 1  2  9  1   21.29   66.58  119.81  171.25  282.50 
             476.32  797.91 1199.96 1682.94 2248.01 
            2443.87 2460.93 
/
 1  3  1  1   47.68   39.95   34.15   31.46   30.02 
              31.72   37.37   44.35   51.84   59.43 
              71.67   93.26 
/
 1  3  2  1   47.43   39.00   33.04   30.47   29.35 
              31.56   37.76   45.10   52.77   60.75 
              73.60   96.23 
/
 1  3  3  1   46.16   34.97   29.02   27.28   27.77 
              32.19   40.15   48.68   57.49   64.02 
              73.51   98.93 
/
 1  3  4  1   44.91   31.93   26.72   25.80   27.70 
              33.57   42.19   51.08   57.20   64.81 
              76.18   95.83 
/
 1  3  5  1   38.59   24.11   23.48   25.33   31.37 
              42.88   56.90   71.01   85.17   99.40 
             121.00  158.29 
/
 1  3  6  1   35.35   22.77   24.28   26.46   36.35 
              50.15   68.69   87.22  105.71  124.28 
             152.50  201.34 
/
 1  3  7  1   31.63   22.32   24.43   30.37   43.27 
              62.04   86.90  111.50  136.07  160.82 
             198.69  264.87 
/
 1  3  8  1   21.38   36.59   63.15   88.88  137.99 
             210.00  316.51  437.39  574.92  732.40 
            1009.85 1577.95 
/
 1  3  9  1   20.83   60.70  109.01  154.73  251.63 
             417.48  686.75 1020.63 1417.71 1881.25 
            2699.34 2852.65 
/
 1  4  1  1   48.10   40.63   34.91   32.16   30.55 
              31.98   37.35   44.18   51.65   59.21 
              71.05   92.32 
/
 1  4  2  1   47.86   39.71   33.79   31.13   29.82 
              31.74   37.67   44.83   52.45   60.27 
              72.88   95.14 
/
 1  4  3  1   46.66   35.74   29.65   27.77   27.98 
              32.09   39.85   48.24   57.13   64.43 
              74.25   99.71 
/
 1  4  4  1   45.47   32.69   27.24   26.13   27.71 
              33.32   41.89   50.92   57.69   63.80 
              74.87   94.87 
/
 1  4  5  1   39.36   24.51   23.45   25.41   30.67 
              41.87   55.27   68.70   82.19   95.76 
             116.38  152.06 
/
 1  4  6  1   36.17   22.99   24.17   26.05   35.26 
              48.57   66.17   83.80  101.43  119.13 
             146.02  192.52 
/
 1  4  7  1   32.44   22.35   24.14   29.47   41.84 
              59.60   83.23  106.65  130.04  153.59 
             189.58  252.38 
/
 1  4  8  1   21.47   34.92   60.13   84.51  131.15 
             198.72  297.25  408.43  533.85  676.47 
             926.58 1437.91 
/
 1  4  9  1   20.74   57.73  103.54  146.66  236.55 
             389.22  634.17  935.63 1293.48 1709.78 
            2443.52 3105.12 
/
 1  5  1  1   48.51   41.34   35.72   32.92   31.14 
              32.30   37.36   44.04   51.36   58.99 
              70.41   91.83 
/
 1  5  2  1   48.29   40.45   34.61   31.87   30.36 
              31.98   37.61   44.59   52.22   59.79 
              72.15   94.03 
/
 1  5  3  1   47.17   36.56   30.38   28.33   28.24 
              32.01   39.53   47.77   56.48   64.73 
              74.86  100.31 
/
 1  5  4  1   46.04   33.51   27.84   26.52   27.76 
              33.09   41.56   50.76   58.09   62.79 
              73.58   95.75 
/
 1  5  5  1   40.17   24.98   23.50   25.97   30.09 
              40.87   53.67   66.43   79.24   92.13 
             111.76  145.79 
/
 1  5  6  1   37.04   23.26   24.03   25.71   34.15 
              47.02   63.66   80.38   97.12  113.94 
             139.49  183.62 
/
 1  5  7  1   33.32   22.44   23.97   28.61   40.44 
              57.16   79.55  101.76  123.95  146.29 
             180.40  239.84 
/
 1  5  8  1   21.61   33.19   57.08   80.09  124.21 
             187.66  278.39  380.26  494.59  622.89 
             846.92 1305.08 
/
 1  5  9  1   20.78   54.73   97.98  138.70  221.71 
             361.68  583.56  854.05 1175.23 1546.43 
            2200.22 3447.34 
/
 1  6  1  1   50.21   44.46   39.51   36.64   34.37 
              34.52   37.98   43.76   50.64   58.12 
              69.28   89.55 
/
 1  6  2  1   50.04   43.72   38.48   35.60   33.40 
              33.85   37.85   44.01   51.15   58.80 
              70.11   91.23 
/
 1  6  3  1   49.22   40.37   34.21   31.50   30.21 
              32.26   38.49   45.97   53.89   62.03 
              75.32   99.02 
/
 1  6  4  1   48.41   37.52   31.16   28.98   28.71 
              32.34   39.90   48.17   56.98   66.00 
              76.32  102.17 
/
 1  6  5  1   43.71   27.84   24.65   25.34   29.50 
              36.54   47.58   57.90   68.01   78.12 
              93.63  120.76 
/
 1  6  6  1   41.01   25.17   23.81   26.21   30.27 
              41.14   54.11   67.02   79.98   93.05 
             112.96  147.58 
/
 1  6  7  1   37.55   23.34   24.27   25.95   34.60 
              47.76   64.81   81.96   99.15  116.44 
             142.77  188.41 
/
 1  6  8  1   22.74   26.70   44.76   61.97   95.49 
             143.88  207.19  274.89  349.26  430.65 
             566.65  839.38 
/
 1  6  9  1   21.95   42.61   74.97  105.97  165.05 
             258.36  400.04  564.13  754.46  973.49 
            1351.82 2122.23 
/
 1  7  1  1   52.01   48.04   44.32   41.90   39.52 
              38.86   40.83   45.11   50.69   57.25 
              68.07   87.91 
/
 1  7  2  1   51.86   47.52   43.52   40.96   38.52 
              37.97   40.14   44.76   50.65   57.53 
              68.76   88.62 
/
 1  7  3  1   51.34   45.12   39.94   36.98   34.67 
              34.89   38.59   44.66   51.93   59.86 
              71.60   93.12 
/
 1  7  4  1   50.83   42.93   37.00   34.06   32.16 
              33.30   38.58   45.74   53.53   61.69 
              73.79   97.23 
/
 1  7  5  1   47.79   33.51   27.84   26.69   28.39 
              34.35   43.35   52.96   59.95   66.06 
              77.70   97.73 
/
 1  7  6  1   45.87   29.83   25.64   25.67   29.30 
              35.95   45.96   55.17   64.53   73.70 
              87.66  112.16 
/
 1  7  7  1   43.22   26.54   24.37   25.91   30.29 
              38.91   51.32   63.01   74.69   86.42 
             104.36  135.72 
/
 1  7  8  1   26.27   22.85   32.15   43.42   65.15 
              97.15  138.91  180.54  222.86  267.23 
             339.44  476.91 
/
 1  7  9  1   22.26   29.66   50.78   70.93  109.90 
             166.23  242.85  327.80  422.00  525.77 
             701.94 1052.34 
/
 1  8  1  1   55.13   52.22   50.40   49.27   48.24 
              48.53   50.39   53.18   56.74   61.44 
              69.64   85.93 
/
 1  8  2  1   54.92   51.96   50.02   48.74   47.51 
              47.68   49.55   52.42   56.10   60.97 
              69.42   86.04 
/
 1  8  3  1   54.12   50.97   48.37   46.59   44.60 
              44.16   45.98   49.33   53.72   59.35 
              68.94   87.14 
/
 1  8  4  1   53.60   50.04   46.82   44.67   42.42 
              41.65   43.48   47.29   52.46   58.74 
              69.31   88.90 
/
 1  8  5  1   52.34   45.06   39.38   36.34   34.08 
              34.68   39.22   46.06   54.03   62.84 
              75.14   98.48 
/
 1  8  6  1   51.65   42.22   35.79   32.90   31.38 
              33.33   39.78   47.81   56.40   64.90 
              79.07  104.88 
/
 1  8  7  1   50.61   38.59   31.92   29.65   29.41 
              33.37   41.54   50.55   60.16   70.24 
              82.45  110.16 
/
 1  8  8  1   39.04   23.73   24.67   26.38   35.13 
              48.72   66.00   83.32  100.71  118.26 
             145.08  191.86 
/
 1  8  9  1   30.82   23.40   26.57   34.42   49.78 
              72.62  102.74  132.70  162.90  193.67 
             241.48  329.26 
/
 1  9  1  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  2  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  3  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  4  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  5  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  6  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  7  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  8  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 1  9  9  1   57.61   57.08   56.87   56.86   57.09 
              57.83   59.43   61.68   64.58   68.11 
              74.59   88.57 
/
 2  1  1  1   51.42   44.23   38.82   36.28   34.92 
              36.62   42.38   49.44   56.89   64.60 
              77.20   99.43 
/
 2  1  2  1   51.16   43.33   37.77   35.34   34.29 
              36.51   42.85   50.20   57.99   66.10 
              78.34  101.63 
/
 2  1  3  1   49.85   39.53   33.96   32.32   32.84 
              37.32   45.35   53.99   61.16   65.59 
              76.03   99.24 
/
 2  1  4  1   48.63   36.68   31.72   30.92   32.78 
              38.76   47.36   55.21   63.42   71.41 
              83.69  105.31 
/
 2  1  5  1   42.59   29.37   28.73   30.33   37.56 
              49.67   65.49   81.73   98.14  114.68 
             139.84  183.29 
/
 2  1  6  1   39.57   28.09   29.16   32.24   43.00 
              58.54   80.03  101.59  123.21  144.99 
             178.24  236.11 
/
 2  1  7  1   36.14   27.60   30.08   37.10   51.21 
              73.03  102.12  131.04  160.03  189.36 
             234.48  315.96 
/
 2  1  8  1   26.64   44.65   76.00  106.54  164.90 
             257.17  397.54  562.00  755.44  980.54 
            1376.66 2160.71 
/
 2  1  9  1   26.26   73.36  130.84  188.40  314.41 
             538.29  917.29 1394.00 1970.42 2181.59 
            2172.46 2165.03 
/
 2  2  1  1   52.19   45.32   40.00   37.37   35.77 
              37.07   42.37   49.23   56.66   63.97 
              76.19   97.84 
/
 2  2  2  1   51.95   44.45   38.95   36.39   35.05 
              36.82   42.71   49.88   57.44   65.28 
              78.14  100.93 
/
 2  2  3  1   50.76   40.73   34.99   33.10   33.19 
              37.16   44.91   53.29   61.63   67.04 
              76.30  100.81 
/
 2  2  4  1   49.62   37.86   32.56   31.46   32.85 
              38.43   46.84   55.17   61.87   69.51 
              81.12  101.46 
/
 2  2  5  1   43.86   30.02   28.82   30.50   36.32 
              47.81   62.29   77.18   92.30  107.59 
             130.87  171.13 
/
 2  2  6  1   40.89   28.45   29.33   31.44   41.37 
              55.47   75.13   94.99  114.94  135.04 
             165.72  219.02 
/
 2  2  7  1   37.42   27.71   29.45   35.38   48.44 
              68.33   95.06  121.70  148.41  175.41 
             216.86  290.26 
/
 2  2  8  1   26.82   41.81   70.22   98.18  151.73 
             233.31  356.24  497.89  662.19  851.66 
            1185.68 1879.17 
/
 2  2  9  1   25.88   67.69  120.28  171.52  282.59 
             476.28  798.02 1200.23 1683.19 2248.09 
            2443.95 2461.00 
/
 2  3  1  1   52.97   46.50   41.33   38.64   36.80 
              37.68   42.45   49.07   56.28   63.73 
              75.14   96.68 
/
 2  3  2  1   52.75   45.67   40.28   37.62   36.00 
              37.30   42.65   49.60   57.11   64.52 
              76.93   99.00 
/
 2  3  3  1   51.68   42.07   36.22   34.07   33.69 
              37.09   44.46   52.58   61.25   68.39 
              78.10  102.80 
/
 2  3  4  1   50.64   39.21   33.60   32.17   33.04 
              38.07   46.37   55.15   61.28   67.66 
              78.66   97.76 
/
 2  3  5  1   45.22   30.84   29.00   30.46   35.11 
              45.99   59.23   72.73   86.50  100.47 
             121.81  158.85 
/
 2  3  6  1   42.34   28.96   29.13   30.82   39.47 
              52.53   70.26   88.35  106.58  124.97 
             153.00  201.64 
/
 2  3  7  1   38.88   27.95   29.10   33.78   45.81 
              63.65   87.93  112.22  136.60  161.21 
             198.95  265.02 
/
 2  3  8  1   27.10   38.89   64.39   89.66  138.39 
             210.19  316.57  437.37  575.35  733.15 
            1009.96 1578.26 
/
 2  3  9  1   25.83   61.96  109.56  155.04  251.75 
             417.47  687.33 1020.72 1417.95 1881.30 
            2699.41 2852.72 
/
 2  4  1  1   53.36   47.12   42.06   39.34   37.39 
              38.09   42.53   48.96   56.20   63.62 
              74.87   96.31 
/
 2  4  2  1   53.16   46.32   41.01   38.31   36.55 
              37.61   42.67   49.47   56.87   64.33 
              76.30   98.03 
/
 2  4  3  1   52.15   42.80   36.92   34.64   34.04 
              37.09   44.25   52.21   60.69   68.81 
              78.82  103.58 
/
 2  4  4  1   51.15   39.95   34.21   32.61   33.19 
              37.88   46.09   55.01   61.79   66.74 
              77.46   97.87 
/
 2  4  5  1   45.94   31.35   29.14   30.68   34.80 
              45.09   57.76   70.57   83.64   96.93 
             117.27  152.67 
/
 2  4  6  1   43.12   29.29   29.02   30.63   38.45 
              51.12   67.86   85.03  102.37  119.88 
             146.57  192.85 
/
 2  4  7  1   39.68   28.10   29.15   33.06   44.54 
              61.32   84.35  107.44  130.62  154.03 
             189.88  252.56 
/
 2  4  8  1   27.30   37.29   61.45   85.35  131.58 
             198.93  297.33  408.43  534.22  677.11 
             926.69 1438.22 
/
 2  4  9  1   25.98   59.07  104.14  147.00  236.69 
             389.23  634.65  935.72 1293.75 1709.98 
            2443.59 3105.19 
/
 2  5  1  1   53.76   47.76   42.82   40.08   38.04 
              38.55   42.66   48.89   56.04   63.67 
              74.85   95.91 
/
 2  5  2  1   53.57   46.99   41.79   39.06   37.17 
              38.00   42.73   49.37   56.72   64.15 
              75.67   97.51 
/
 2  5  3  1   52.62   43.56   37.68   35.28   34.45 
              37.13   44.06   51.81   60.15   68.93 
              79.43  104.19 
/
 2  5  4  1   51.68   40.75   34.89   33.10   33.39 
              37.73   45.78   54.48   62.38   66.72 
              76.30   99.72 
/
 2  5  5  1   46.68   31.92   29.33   30.68   34.85 
              44.12   56.32   68.46   80.83   93.41 
             112.74  146.48 
/
 2  5  6  1   43.93   29.68   28.97   30.60   37.54 
              49.75   65.51   81.72   98.16  114.77 
             140.10  183.99 
/
 2  5  7  1   40.53   28.28   29.52   32.41   43.31 
              59.02   80.76  102.63  124.60  146.78 
             180.74  240.04 
/
 2  5  8  1   27.54   35.71   58.50   81.01  124.69 
             187.90  278.49  380.28  494.54  623.43 
             847.03 1305.38 
/
 2  5  9  1   26.26   56.18   98.64  139.07  221.87 
             361.71  583.97  854.16 1175.31 1546.64 
            2200.27 3447.41 
/
 2  6  1  1   55.37   50.56   46.31   43.69   41.37 
              41.15   43.86   49.13   55.54   63.02 
              73.94   94.15 
/
 2  6  2  1   55.23   49.93   45.39   42.67   40.40 
              40.38   43.55   49.19   56.01   63.74 
              74.62   95.66 
/
 2  6  3  1   54.54   47.04   41.46   38.69   36.93 
              38.11   43.48   50.63   58.37   65.92 
              78.77  101.93 
/
 2  6  4  1   53.84   44.52   38.49   36.00   35.02 
              37.55   44.52   52.40   60.73   69.60 
              80.99  106.17 
/
 2  6  5  1   49.89   35.15   30.85   30.89   34.26 
              40.71   50.80   60.70   70.38   80.09 
              95.19  121.89 
/
 2  6  6  1   47.57   32.12   29.50   30.91   35.13 
              44.38   56.78   69.07   81.59   94.35 
             113.95  148.27 
/
 2  6  7  1   44.52   29.75   29.16   30.80   37.97 
              50.45   66.63   83.28  100.17  117.25 
             143.37  188.78 
/
 2  6  8  1   29.22   30.23   46.74   63.30   96.23 
             144.27  207.40  275.00  349.30  430.63 
             567.13  839.51 
/
 2  6  9  1   26.95   44.60   75.95  106.58  165.34 
             258.48  400.04  564.53  755.24  973.59 
            1352.10 2122.29 
/
 2  7  1  1   57.22   53.74   50.61   48.48   46.29 
              45.59   47.45   51.28   56.47   62.68 
              72.96   92.18 
/
 2  7  2  1   57.04   53.31   49.91   47.64   45.36 
              44.69   46.63   50.76   56.25   62.76 
              73.47   93.33 
/
 2  7  3  1   56.52   51.26   46.77   44.03   41.66 
              41.48   44.41   49.99   56.80   64.77 
              76.31   97.77 
/
 2  7  4  1   56.09   49.38   44.11   41.20   39.08 
              39.58   43.92   50.56   58.21   66.36 
              78.13  100.99 
/
 2  7  5  1   53.52   40.90   34.86   33.21   33.87 
              38.93   47.56   57.07   64.20   69.02 
              80.32   99.83 
/
 2  7  6  1   51.89   37.27   32.16   31.56   33.98 
              40.48   49.81   58.24   67.27   76.11 
              89.62  113.61 
/
 2  7  7  1   49.63   33.72   30.21   30.95   35.09 
              42.40   54.30   65.48   76.66   88.04 
             105.61  136.60 
/
 2  7  8  1   33.54   28.23   35.12   45.63   66.50 
              97.94  139.37  180.84  223.06  267.36 
             339.50  477.02 
/
 2  7  9  1   28.48   32.65   52.46   72.04  110.50 
             166.54  243.00  327.86  422.00  526.17 
             702.64 1052.45 
/
 2  8  1  1   60.46   57.58   56.00   55.08   54.37 
              54.92   56.75   59.42   62.86   67.38 
              75.29   91.22 
/
 2  8  2  1   60.26   57.31   55.62   54.56   53.68 
              54.12   56.00   58.74   62.27   66.94 
              75.06   91.29 
/
 2  8  3  1   59.41   56.37   54.17   52.61   50.90 
              50.78   52.72   55.85   59.93   65.30 
              74.45   92.12 
/
 2  8  4  1   58.85   55.58   52.85   50.95   48.85 
              48.27   50.17   53.70   58.48   64.45 
              74.52   93.53 
/
 2  8  5  1   57.55   51.34   46.33   43.42   41.05 
              41.15   44.82   51.15   58.84   67.67 
              79.74  102.97 
/
 2  8  6  1   56.97   48.89   43.05   40.11   38.17 
              39.26   44.83   52.51   60.98   69.27 
              82.55  107.84 
/
 2  8  7  1   56.08   45.68   39.30   36.70   35.72 
              38.54   46.16   54.75   63.84   73.53 
              86.72  115.06 
/
 2  8  8  1   46.13   30.22   29.56   31.34   38.53 
              51.52   67.97   84.75  101.80  119.12 
             145.71  192.24 
/
 2  8  9  1   38.39   28.29   30.65   37.46   51.93 
              73.96  103.57  133.25  163.29  193.95 
             241.67  329.35 
/
 2  9  1  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  2  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  3  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  4  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  5  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  6  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  7  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  8  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 2  9  9  1   62.61   62.09   61.87   61.86   62.09 
              62.83   64.43   66.69   69.58   73.11 
              79.60   93.57 
/
 3  1  1  1   56.62   50.46   45.56   43.00   41.31 
              42.33   47.36   54.13   61.42   68.56 
              80.71  102.39 
/
 3  1  2  1   56.39   49.65   44.55   42.03   40.57 
              42.04   47.65   54.75   62.14   69.86 
              82.70  105.59 
/
 3  1  3  1   55.27   46.17   40.71   38.72   38.53 
              42.16   49.73   57.97   65.64   69.71 
              79.03  103.37 
/
 3  1  4  1   54.22   43.44   38.28   36.98   38.03 
              43.34   51.58   59.08   66.58   74.28 
              86.18  107.25 
/
 3  1  5  1   48.90   35.69   34.18   35.64   41.35 
              52.81   67.75   83.42   99.49  115.78 
             140.69  183.89 
/
 3  1  6  1   46.14   33.99   34.40   36.49   46.35 
              60.88   81.61  102.76  124.12  145.71 
             178.78  236.45 
/
 3  1  7  1   42.88   33.09   34.53   40.48   53.72 
              74.67  103.19  131.80  160.60  189.80 
             234.79  316.15 
/
 3  1  8  1   32.18   47.12   77.29  107.36  165.33 
             257.38  397.62  561.99  755.35  981.56 
            1376.78 2160.90 
/
 3  1  9  1   30.97   74.68  131.43  188.76  314.56 
             538.29  917.99 1394.15 1970.87 2155.23 
            2172.56 2165.12 
/
 3  2  1  1   57.37   51.48   46.71   44.07   42.25 
              42.95   47.50   54.00   61.27   68.46 
              79.84  101.44 
/
 3  2  2  1   57.16   50.71   45.71   43.12   41.44 
              42.52   47.67   54.59   61.99   69.24 
              81.67  103.89 
/
 3  2  3  1   56.13   47.32   41.79   39.61   39.05 
              42.15   49.39   57.41   66.03   71.70 
              80.76  105.78 
/
 3  2  4  1   55.15   44.61   39.22   37.66   38.27 
              43.07   51.21   59.46   65.16   72.55 
              83.82  103.62 
/
 3  2  5  1   50.10   36.46   34.41   35.56   40.26 
              51.14   64.83   79.10   93.82  108.84 
             131.84  171.82 
/
 3  2  6  1   47.41   34.50   34.25   35.95   44.81 
              58.09   76.90   96.31  115.98  135.88 
             166.34  219.42 
/
 3  2  7  1   44.16   33.35   34.22   39.04   51.24 
              70.16   96.27  122.57  149.07  175.92 
             217.22  290.50 
/
 3  2  8  1   32.48   44.49   71.67   99.11  152.22 
             233.58  356.35  497.91  662.13  852.43 
            1185.82 1879.28 
/
 3  2  9  1   30.89   69.16  120.95  171.92  282.77 
             476.32  798.59 1200.35 1683.34 2248.55 
            2444.04 2461.09 
/
 3  3  1  1   58.12   52.57   47.99   45.34   43.35 
              43.76   47.75   53.89   61.05   68.56 
              79.46  100.92 
/
 3  3  2  1   57.93   51.84   47.00   44.32   42.49 
              43.20   47.79   54.38   61.76   69.03 
              80.60  102.65 
/
 3  3  3  1   57.00   48.59   43.05   40.68   39.76 
              42.24   49.13   56.82   65.09   73.29 
              82.96  107.72 
/
 3  3  4  1   56.11   45.93   40.35   38.51   38.64 
              42.80   50.78   59.44   65.66   70.86 
              81.55  101.11 
/
 3  3  5  1   51.38   37.41   34.75   35.41   39.36 
              49.50   62.06   74.92   88.25  101.91 
             122.94  159.67 
/
 3  3  6  1   48.79   35.16   34.22   35.72   42.98 
              55.45   72.28   89.86  107.77  125.93 
             153.74  202.14 
/
 3  3  7  1   45.59   33.71   34.50   37.74   48.89 
              65.69   89.31  113.23  137.37  161.82 
             199.40  265.31 
/
 3  3  8  1   32.91   41.68   66.01   90.73  138.97 
             210.50  316.72  437.43  575.34  733.07 
            1011.05 1578.39 
/
 3  3  9  1   31.16   63.60  110.34  155.51  251.98 
             417.54  687.27 1021.62 1418.06 1881.65 
            2699.86 2852.81 
/
 3  4  1  1   58.50   53.15   48.67   46.03   43.97 
              44.23   47.93   53.89   61.09   68.51 
              79.26  100.63 
/
 3  4  2  1   58.32   52.44   47.70   45.01   43.08 
              43.62   47.90   54.29   61.59   68.94 
              80.33  102.25 
/
 3  4  3  1   57.44   49.28   43.76   41.29   40.19 
              42.36   48.98   56.55   64.64   73.28 
              83.68  108.46 
/
 3  4  4  1   56.59   46.65   41.00   39.02   38.88 
              42.71   50.50   59.00   66.54   70.03 
              80.46  103.13 
/
 3  4  5  1   52.05   37.98   34.98   35.41   39.84 
              48.65   60.72   72.92   85.52   98.48 
             118.50  153.57 
/
 3  4  6  1   49.53   35.57   34.31   35.85   42.16 
              54.18   70.03   86.65  103.66  120.93 
             147.38  193.40 
/
 3  4  7  1   46.37   33.93   34.78   37.18   47.77 
              63.51   85.83  108.53  131.46  154.69 
             190.38  252.86 
/
 3  4  8  1   33.19   40.21   63.18   86.49  132.21 
             199.27  297.51  408.51  534.22  677.05 
             927.66 1438.35 
/
 3  4  9  1   31.48   60.82  104.98  147.50  236.94 
             389.32  634.61  936.52 1293.87 1710.13 
            2444.02 3145.67 
/
 3  5  1  1   58.88   53.74   49.39   46.77   44.64 
              44.75   48.16   53.93   60.91   68.45 
              79.34  100.32 
/
 3  5  2  1   58.71   53.06   48.43   45.76   43.73 
              44.10   48.06   54.23   61.56   69.03 
              80.05  101.82 
/
 3  5  3  1   57.89   49.99   44.51   41.97   40.68 
              42.54   48.82   56.38   64.22   72.60 
              84.67  109.05 
/
 3  5  4  1   57.08   47.42   41.71   39.59   39.19 
              42.65   50.26   58.57   66.99   71.52 
              79.41  104.94 
/
 3  5  5  1   52.74   38.61   35.27   35.84   39.69 
              47.66   59.42   70.99   82.86   95.10 
             114.08  147.46 
/
 3  5  6  1   50.29   36.05   34.45   35.98   41.37 
              52.94   67.85   83.48   99.55  115.91 
             140.98  184.61 
/
 3  5  7  1   47.18   34.21   34.69   36.69   46.67 
              61.38   82.36  103.81  125.51  147.51 
             181.28  240.38 
/
 3  5  8  1   33.52   38.78   60.34   82.24  125.37 
             188.27  278.68  380.38  494.57  623.39 
             847.83 1305.52 
/
 3  5  9  1   31.99   58.04   99.55  139.62  222.16 
             361.82  583.95  854.86 1175.43 1546.74 
            2200.63 3447.51 
/
 3  6  1  1   60.44   56.31   52.63   50.22   47.95 
              47.52   49.85   54.63   60.65   67.76 
              78.92   99.11 
/
 3  6  2  1   60.32   55.76   51.79   49.27   47.00 
              46.72   49.34   54.55   60.96   68.50 
              79.74   99.89 
/
 3  6  3  1   59.71   53.21   48.19   45.40   43.46 
              44.09   48.68   55.44   63.14   70.76 
              82.56  105.73 
/
 3  6  4  1   59.10   50.96   45.35   42.72   41.31 
              43.04   49.30   56.97   64.89   73.36 
              85.97  111.18 
/
 3  6  5  1   55.69   42.04   37.23   36.63   39.00 
              45.34   54.36   63.89   73.20   82.54 
              97.19  123.41 
/
 3  6  6  1   53.66   38.85   35.46   36.05   39.99 
              47.91   59.89   71.62   83.64   96.05 
             115.30  149.27 
/
 3  6  7  1   50.95   36.13   34.59   36.21   41.77 
              53.62   68.94   85.01  101.54  118.38 
             144.24  189.39 
/
 3  6  8  1   35.65   34.31   49.22   65.04   97.25 
             144.85  207.73  275.21  349.43  430.70 
             567.13  840.38 
/
 3  6  9  1   32.54   47.09   77.26  107.41  165.78 
             258.70  400.13  564.52  755.15  974.58 
            1352.22 2122.46 
/
 3  7  1  1   62.42   59.20   56.53   54.63   52.56 
              52.00   53.93   57.48   62.31   68.22 
              78.04   96.71 
/
 3  7  2  1   62.20   58.83   55.91   53.87   51.75 
              51.08   53.02   56.78   61.95   68.15 
              78.39   97.70 
/
 3  7  3  1   61.60   57.04   53.10   50.57   48.23 
              47.83   50.31   55.44   61.85   69.45 
              81.30  102.16 
/
 3  7  4  1   61.22   55.39   50.70   47.92   45.68 
              45.79   49.43   55.61   63.15   71.51 
              82.79  105.60 
/
 3  7  5  1   59.00   47.71   41.70   39.66   39.58 
              43.76   52.00   61.05   68.75   72.32 
              83.33  102.39 
/
 3  7  6  1   57.60   44.21   38.76   37.59   39.05 
              45.15   54.17   61.65   70.39   78.93 
              92.05  115.49 
/
 3  7  7  1   55.62   40.58   36.40   36.44   39.98 
              46.53   57.65   68.39   79.13   90.10 
             107.27  137.83 
/
 3  7  8  1   40.47   33.81   38.63   48.38   68.27 
              99.03  140.04  181.29  223.39  267.62 
             339.66  477.07 
/
 3  7  9  1   34.70   36.30   54.61   73.51  111.34 
             167.01  243.26  328.01  422.07  526.19 
             702.63 1053.47 
/
 3  8  1  1   65.71   62.89   61.49   60.74   60.30 
              60.82   62.76   65.36   68.63   73.10 
              80.80   96.46 
/
 3  8  2  1   65.54   62.60   61.10   60.23   59.63 
              60.10   62.08   64.74   68.16   72.69 
              80.58   96.52 
/
 3  8  3  1   64.70   61.61   59.73   58.34   56.93 
              57.09   59.08   62.06   65.92   71.11 
              79.92   97.17 
/
 3  8  4  1   64.09   60.94   58.58   56.88   55.00 
              54.63   56.64   59.97   64.44   70.17 
              79.82   98.34 
/
 3  8  5  1   62.67   57.23   52.78   50.04   47.64 
              47.43   50.51   56.40   63.71   72.42 
              84.62  107.79 
/
 3  8  6  1   62.15   55.07   49.77   46.84   44.72 
              45.29   50.07   57.27   65.69   74.24 
              86.74  111.73 
/
 3  8  7  1   61.38   52.20   46.21   43.46   42.01 
              43.98   50.89   59.31   67.93   77.21 
              91.75  119.47 
/
 3  8  8  1   52.65   36.66   34.98   36.74   42.33 
              54.74   70.45   86.62  103.26  120.31 
             146.63  192.87 
/
 3  8  9  1   45.43   33.79   35.21   41.01   54.63 
              75.69  104.70  134.06  163.89  194.42 
             242.00  329.56 
/
 3  9  1  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  2  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  3  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  4  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  5  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  6  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  7  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  8  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 3  9  9  1   67.62   67.09   66.88   66.86   67.09 
              67.84   69.44   71.69   74.58   78.11 
              84.60   98.58 
/
 4  1  1  1   61.71   56.36   51.96   49.40   47.57 
              48.14   52.51   58.90   66.14   73.00 
              84.50  106.13 
/
 4  1  2  1   61.52   55.63   50.99   48.43   46.76 
              47.68   52.67   59.49   66.74   73.95 
              86.37  108.70 
/
 4  1  3  1   60.54   52.42   47.20   45.01   44.32 
              47.19   54.33   62.24   70.53   74.90 
              83.73  108.61 
/
 4  1  4  1   59.62   49.84   44.68   43.03   43.45 
              48.05   56.07   63.55   70.02   77.46 
              89.03  109.57 
/
 4  1  5  1   54.88   41.90   39.74   40.68   45.43 
              56.30   70.46   85.49  101.15  117.18 
             141.80  184.70 
/
 4  1  6  1   52.35   39.90   39.36   41.09   50.05 
              63.67   83.54  104.23  125.28  146.67 
             179.52  236.97 
/
 4  1  7  1   49.28   38.66   39.35   44.33   56.70 
              76.67  104.53  132.78  161.36  190.42 
             235.25  316.47 
/
 4  1  8  1   37.78   50.02   78.90  108.42  165.91 
             257.72  397.79  562.06  755.33  981.46 
            1378.05 2161.11 
/
 4  1  9  1   35.96   76.32  132.20  189.25  314.81 
             538.37  917.92 1394.34 1971.04 2155.40 
            2172.68 2165.23 
/
 4  2  1  1   62.44   57.32   53.06   50.52   48.55 
              48.89   52.79   58.86   66.01   73.19 
              84.27  105.80 
/
 4  2  2  1   62.26   56.63   52.11   49.53   47.70 
              48.32   52.82   59.35   66.63   73.68 
              85.46  107.15 
/
 4  2  3  1   61.36   53.53   48.31   45.96   44.98 
              47.30   54.12   61.78   70.01   76.84 
              86.31  110.21 
/
 4  2  4  1   60.51   50.99   45.68   43.80   43.81 
              47.86   55.77   64.23   68.74   75.89 
              86.83  106.15 
/
 4  2  5  1   56.03   42.76   40.07   40.57   44.59 
              54.79   67.79   81.40   95.68  110.40 
             133.09  172.76 
/
 4  2  6  1   53.58   40.52   39.43   40.85   48.47 
              61.14   79.04   97.95  117.29  136.96 
             167.19  220.02 
/
 4  2  7  1   50.54   39.02   39.47   43.08   54.48 
              72.36   97.77  123.68  149.94  176.63 
             217.76  290.86 
/
 4  2  8  1   38.19   47.61   73.45  100.29  152.88 
             233.95  356.56  498.01  662.15  852.37 
            1186.94 1879.43 
/
 4  2  9  1   36.11   70.97  121.83  172.47  283.07 
             476.43  798.55 1201.34 1683.52 2248.72 
            2444.61 2461.20 
/
 4  3  1  1   63.17   58.35   54.28   51.76   49.69 
              49.78   53.19   58.92   65.93   73.39 
              84.02  104.90 
/
 4  3  2  1   63.01   57.70   53.35   50.78   48.80 
              49.13   53.09   59.25   66.63   73.80 
              85.08  106.55 
/
 4  3  3  1   62.19   54.74   49.57   47.09   45.81 
              47.60   53.90   61.38   69.25   77.76 
              88.06  112.84 
/
 4  3  4  1   61.41   52.27   46.86   44.76   44.32 
              47.75   55.32   63.63   70.65   74.36 
              84.76  105.73 
/
 4  3  5  1   57.24   43.80   40.55   40.70   44.00 
              53.29   65.25   77.53   90.36  103.68 
             124.37  160.75 
/
 4  3  6  1   54.89   41.30   39.69   41.08   46.91 
              58.74   74.69   91.71  109.26  127.17 
             154.71  202.84 
/
 4  3  7  1   51.93   39.48   39.91   42.06   52.37 
              68.15   91.02  114.51  138.37  162.64 
             200.02  265.72 
/
 4  3  8  1   38.75   44.90   67.99   92.07  139.73 
             210.94  316.97  437.57  575.40  733.06 
            1010.98 1578.56 
/
 4  3  9  1   36.65   65.62  111.34  156.14  252.32 
             417.69  687.28 1021.52 1418.22 1881.83 
            2700.03 2852.93 
/
 4  4  1  1   63.54   58.89   54.92   52.44   50.32 
              50.29   53.45   59.00   65.82   73.59 
              84.18  104.68 
/
 4  4  2  1   63.39   58.26   54.02   51.46   49.41 
              49.61   53.28   59.25   66.54   73.95 
              84.87  106.21 
/
 4  4  3  1   62.62   55.39   50.27   47.72   46.29 
              47.83   53.81   61.27   68.91   77.17 
              89.16  113.55 
/
 4  4  4  1   61.87   52.96   47.53   45.31   44.67 
              47.74   55.14   63.27   71.37   75.09 
              83.78  107.73 
/
 4  4  5  1   57.86   44.40   40.85   40.86   44.65 
              52.41   64.03   75.69   87.78  100.38 
             120.03  154.74 
/
 4  4  6  1   55.59   41.77   39.86   41.11   46.20 
              57.59   72.61   88.62  105.25  122.26 
             148.43  194.17 
/
 4  4  7  1   52.68   39.78   39.75   41.65   51.36 
              66.13   87.65  109.90  132.54  155.58 
             191.06  253.33 
/
 4  4  8  1   39.10   43.58   65.28   87.93  133.04 
             199.74  297.78  408.67  534.31  677.07 
             927.58 1439.68 
/
 4  4  9  1   37.15   62.95  106.05  148.18  237.31 
             389.49  634.64  936.45 1295.04 1710.31 
            2444.19 3102.67 
/
 4  5  1  1   63.92   59.45   55.60   53.15   50.99 
              50.85   53.76   59.13   65.73   73.54 
              84.04  104.46 
/
 4  5  2  1   63.77   58.84   54.72   52.18   50.07 
              50.13   53.52   59.29   66.36   74.10 
              84.95  106.39 
/
 4  5  3  1   63.04   56.07   51.01   48.38   46.84 
              48.11   53.75   61.09   68.60   76.60 
              90.13  114.77 
/
 4  5  4  1   62.34   53.69   48.25   45.93   45.08 
              47.75   54.97   62.91   71.55   76.83 
              84.76  109.53 
/
 4  5  5  1   58.51   45.07   41.22   41.01   44.61 
              51.44   62.84   73.90   85.29   97.14 
             115.74  148.74 
/
 4  5  6  1   56.31   42.31   40.04   40.96   45.51 
              56.47   70.61   85.60  101.26  117.34 
             142.12  185.45 
/
 4  5  7  1   53.46   40.14   39.66   41.32   50.36 
              64.18   84.30  105.29  126.69  148.48 
             182.03  240.90 
/
 4  5  8  1   39.50   42.38   62.58   83.77  126.26 
             188.78  279.00  380.57  494.68  623.43 
             847.78 1306.81 
/
 4  5  9  1   37.39   60.31  100.70  140.35  222.56 
             362.01  584.01  854.80 1176.35 1546.91 
            2200.81 3447.96 
/
 4  6  1  1   65.49   61.84   58.63   56.42   54.24 
              53.69   55.85   60.23   65.93   72.71 
              83.46  103.72 
/
 4  6  2  1   65.33   61.35   57.86   55.53   53.31 
              52.87   55.22   60.00   66.06   73.26 
              84.44  104.94 
/
 4  6  3  1   64.79   59.06   54.54   51.87   49.79 
              50.06   54.03   60.37   67.99   75.65 
              87.18  109.76 
/
 4  6  4  1   64.26   57.03   51.86   49.14   47.50 
              48.66   54.28   61.75   69.46   77.43 
              91.18  116.39 
/
 4  6  5  1   61.27   48.59   43.52   42.38   44.00 
              50.14   58.54   67.36   76.34   85.35 
              99.58  125.28 
/
 4  6  6  1   59.46   45.35   41.44   41.21   44.93 
              51.71   63.32   74.55   86.09   98.11 
             116.98  150.55 
/
 4  6  7  1   57.02   42.39   40.18   41.24   45.89 
              57.13   71.68   87.11  103.23  119.80 
             145.37  190.21 
/
 4  6  8  1   41.97   38.76   52.14   67.15   98.55 
             145.62  208.21  275.54  349.66  430.86 
             567.20  840.34 
/
 4  6  9  1   38.19   50.02   78.89  108.49  166.37 
             259.04  400.29  564.59  755.13  974.49 
            1353.34 2122.65 
/
 4  7  1  1   67.63   64.52   62.21   60.52   58.64 
              58.25   60.29   63.63   68.15   73.82 
              83.23  101.41 
/
 4  7  2  1   67.38   64.19   61.66   59.83   57.81 
              57.29   59.31   62.84   67.68   73.63 
              83.45  102.26 
/
 4  7  3  1   66.61   62.59   59.12   56.78   54.50 
              53.97   56.24   60.95   67.04   74.32 
              85.77  107.39 
/
 4  7  4  1   66.27   61.12   56.93   54.30   52.02 
              51.87   55.00   60.81   67.99   76.55 
              87.99  110.46 
/
 4  7  5  1   64.32   54.11   48.28   46.00   45.37 
              48.77   56.71   65.32   73.95   76.58 
              86.65  105.29 
/
 4  7  6  1   63.09   50.77   45.21   43.64   44.42 
              49.91   58.56   65.47   73.79   82.07 
              94.84  117.76 
/
 4  7  7  1   61.35   47.16   42.56   41.81   44.79 
              51.19   61.28   71.62   81.97   92.55 
             109.27  139.39 
/
 4  7  8  1   47.11   38.92   42.61   51.61   70.42 
             100.40  140.93  181.92  223.86  267.99 
             339.94  477.23 
/
 4  7  9  1   40.88   40.38   57.18   75.31  112.41 
             167.63  243.65  328.26  422.24  526.28 
             702.64 1053.66 
/
 4  8  1  1   70.90   68.19   66.93   66.33   66.10 
              66.65   68.19   70.48   73.40   78.67 
              86.20  101.66 
/
 4  8  2  1   70.75   67.87   66.53   65.82   65.44 
              66.00   67.73   70.46   73.41   78.30 
              86.00  101.71 
/
 4  8  3  1   69.98   66.79   65.13   63.91   62.79 
              63.20   65.17   68.05   71.74   76.80 
              85.33  102.25 
/
 4  8  4  1   69.33   66.17   64.12   62.60   60.88 
              60.79   62.88   66.04   70.28   75.82 
              85.13  103.23 
/
 4  8  5  1   67.71   62.87   58.89   56.32   53.94 
              53.54   56.22   61.75   68.71   77.07 
              89.66  112.24 
/
 4  8  6  1   67.25   60.94   56.13   53.30   51.06 
              51.28   55.43   62.22   70.60   79.22 
              91.51  115.87 
/
 4  8  7  1   66.57   58.34   52.76   49.90   48.21 
              49.57   55.82   64.08   72.48   81.22 
              96.20  124.12 
/
 4  8  8  1   58.81   42.99   40.59   41.72   46.47 
              58.25   73.33   88.87  105.07  121.81 
             147.82  193.74 
/
 4  8  9  1   52.07   39.44   40.20   44.91   57.77 
              77.79  106.13  135.11  164.70  195.07 
             242.49  329.89 
/
 4  9  1  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  2  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  3  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  4  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  5  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  6  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  7  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  8  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 4  9  9  1   72.63   72.10   71.88   71.87   72.10 
              72.84   74.44   76.69   79.59   83.12 
              89.60  103.58 
/
 5  1  1  1   71.71   67.58   63.98   61.68   59.69 
              59.74   63.16   68.81   75.84   83.04 
              93.68  114.68 
/
 5  1  2  1   71.56   66.98   63.12   60.75   58.83 
              59.12   63.07   69.17   76.51   83.33 
              94.59  116.60 
/
 5  1  3  1   70.80   64.24   59.58   57.19   55.93 
              57.63   63.97   71.30   79.19   85.99 
              95.42  119.57 
/
 5  1  4  1   70.07   61.94   57.03   54.91   54.48 
              57.88   65.40   73.68   77.63   84.55 
              95.49  115.09 
/
 5  1  5  1   66.22   54.01   50.94   50.99   54.47 
              64.02   76.83   90.59  105.33  120.74 
             144.72  186.95 
/
 5  1  6  1   64.08   51.63   50.01   51.13   57.96 
              70.27   88.33  107.98  128.34  149.23 
             181.57  238.48 
/
 5  1  7  1   61.37   49.84   49.93   52.82   63.70 
              81.61  108.02  135.42  163.47  192.16 
             236.61  317.48 
/
 5  1  8  1   49.02   56.88   83.02  111.22  167.54 
             258.71  398.40  562.42  755.51  981.48 
            1377.95 2163.63 
/
 5  1  9  1   46.37   80.50  134.29  190.65  315.59 
             538.74  917.98 1395.42 1972.98 2182.28 
            2173.59 2165.54 
/
 5  2  1  1   72.41   68.46   65.01   62.74   60.71 
              60.59   63.64   69.01   75.70   83.18 
              93.64  114.58 
/
 5  2  2  1   72.27   67.88   64.17   61.82   59.83 
              59.91   63.44   69.24   76.45   83.60 
              94.72  116.29 
/
 5  2  3  1   71.57   65.26   60.67   58.22   56.75 
              58.04   63.86   71.17   78.67   86.95 
              97.43  121.79 
/
 5  2  4  1   70.90   63.03   58.08   55.82   55.08 
              57.90   65.12   73.11   79.09   83.29 
              93.65  113.02 
/
 5  2  5  1   67.27   54.98   51.47   51.29   54.13 
              62.77   74.57   87.02  100.31  114.33 
             136.33  175.30 
/
 5  2  6  1   65.22   52.40   50.34   51.40   56.65 
              68.15   84.32  102.08  120.68  139.82 
             169.49  221.74 
/
 5  2  7  1   62.57   50.36   50.06   52.03   61.87 
              77.75  101.63  126.63  152.30  178.59 
             219.31  292.01 
/
 5  2  8  1   49.62   54.64   77.95  103.39  154.71 
             235.07  357.25  498.46  662.42  852.49 
            1186.83 1881.45 
/
 5  2  9  1   46.89   75.54  124.18  174.03  283.95 
             476.88  798.68 1201.30 1685.04 2249.17 
            2445.03 2461.89 
/
 5  3  1  1   73.11   69.40   66.12   63.91   61.84 
              61.57   64.26   69.32   75.65   83.11 
              93.91  114.50 
/
 5  3  2  1   72.99   68.85   65.31   63.01   60.95 
              60.84   63.94   69.41   76.22   83.85 
              94.53  115.93 
/
 5  3  3  1   72.35   66.37   61.90   59.40   57.72 
              58.59   63.86   71.08   78.26   86.06 
              99.47  124.17 
/
 5  3  4  1   71.73   64.22   59.30   56.90   55.84 
              58.00   64.95   72.63   81.02   84.15 
              92.46  117.32 
/
 5  3  5  1   68.37   56.12   52.17   51.67   54.70 
              61.33   72.43   83.68   95.54  108.08 
             128.02  163.64 
/
 5  3  6  1   66.43   53.35   50.76   51.20   55.51 
              66.15   80.57   96.30  113.05  130.40 
             157.34  204.82 
/
 5  3  7  1   63.88   51.03   49.98   51.50   60.14 
              74.14   95.30  117.83  141.05  164.88 
             201.80  267.04 
/
 5  3  8  1   50.37   52.46   72.95   95.54  141.81 
             212.21  317.78  438.11  575.76  733.27 
            1010.99 1579.94 
/
 5  3  9  1   47.81   70.64  114.01  157.88  253.33 
             418.24  687.51 1021.51 1419.38 1883.70 
            2700.46 2853.68 
/
 5  4  1  1   73.48   69.89   66.71   64.54   62.46 
              62.11   64.67   69.53   75.67   83.01 
              93.92  114.48 
/
 5  4  2  1   73.35   69.36   65.92   63.65   61.57 
              61.37   64.25   69.55   76.15   83.87 
              94.42  115.75 
/
 5  4  3  1   72.74   66.95   62.57   60.05   58.27 
              58.96   63.90   70.94   78.45   85.66 
              98.76  122.88 
/
 5  4  4  1   72.16   64.86   59.97   57.51   56.30 
              58.14   64.81   72.37   80.55   86.26 
              94.51  119.22 
/
 5  4  5  1   68.94   56.76   52.59   51.90   54.58 
              60.60   71.40   82.09   93.28  105.07 
             123.93  157.83 
/
 5  4  6  1   67.06   53.91   51.01   51.20   55.05 
              65.19   78.79   93.51  109.27  125.69 
             151.24  196.30 
/
 5  4  7  1   64.57   51.44   50.12   51.40   59.26 
              72.43   92.18  113.44  135.41  157.98 
             192.97  254.74 
/
 5  4  8  1   50.82   51.51   70.49   91.62  135.27 
             201.10  298.66  409.27  534.72  677.32 
             927.64 1439.77 
/
 5  4  9  1   47.98   68.23  108.90  150.03  238.40 
             390.11  634.92  936.48 1294.96 1711.94 
            2444.63 3103.43 
/
 5  5  1  1   73.87   70.39   67.32   65.21   63.11 
              62.70   65.13   69.79   75.75   82.90 
              93.65  114.47 
/
 5  5  2  1   73.71   69.88   66.55   64.33   62.22 
              61.93   64.62   69.72   76.11   83.69 
              94.64  115.57 
/
 5  5  3  1   73.14   67.56   63.27   60.76   58.88 
              59.39   63.99   70.77   78.42   85.30 
              98.04  121.58 
/
 5  5  4  1   72.59   65.53   60.69   58.18   56.81 
              58.35   64.66   72.21   80.10   88.14 
              96.80  120.95 
/
 5  5  5  1   69.52   57.47   53.07   52.17   54.40 
              60.46   70.39   80.57   91.10  102.15 
             119.91  152.06 
/
 5  5  6  1   67.71   54.52   51.32   51.34   54.70 
              64.25   77.08   90.82  105.55  121.00 
             145.13  187.77 
/
 5  5  7  1   65.30   51.91   50.29   51.46   58.19 
              70.80   89.12  109.06  129.77  151.06 
             184.10  242.44 
/
 5  5  8  1   51.34   50.66   68.06   87.71  128.66 
             190.24  279.94  381.23  495.14  623.75 
             847.91 1306.82 
/
 5  5  9  1   48.18   65.86  103.75  142.34  223.73 
             362.69  584.34  854.90 1176.32 1548.31 
            2203.19 3448.38 
/
 5  6  1  1   75.68   72.53   70.02   68.20   66.17 
              65.66   67.85   71.61   76.79   83.04 
              93.01  112.32 
/
 5  6  2  1   75.41   72.13   69.37   67.41   65.28 
              64.78   67.01   71.12   76.62   83.27 
              93.69  113.83 
/
 5  6  3  1   74.78   70.23   66.51   64.11   61.95 
              61.79   64.93   70.60   77.69   85.93 
              96.89  119.51 
/
 5  6  4  1   74.36   68.53   64.13   61.54   59.58 
              60.02   64.59   71.46   79.36   86.26 
              99.21  123.35 
/
 5  6  5  1   71.99   61.01   55.82   54.06   54.64 
              59.81   68.15   75.00   83.36   91.77 
             105.27  129.92 
/
 5  6  6  1   70.53   57.81   53.33   52.41   54.73 
              60.84   70.88   81.23   91.93  103.15 
             121.18  153.89 
/
 5  6  7  1   68.51   54.63   51.45   51.52   55.02 
              64.87   78.10   92.27  107.47  123.42 
             148.35  192.50 
/
 5  6  8  1   54.30   48.53   59.01   72.37  101.91 
             147.72  209.58  276.55  350.43  431.46 
             567.61  840.49 
/
 5  6  9  1   49.52   56.85   83.05  111.32  168.04 
             260.05  400.91  564.95  755.32  974.51 
            1353.40 2124.90 
/
 5  7  1  1   78.08   74.90   73.14   71.79   70.25 
              70.40   72.51   75.56   79.64   84.95 
              93.71  111.10 
/
 5  7  2  1   77.77   74.63   72.68   71.21   69.50 
              69.41   71.56   74.76   79.10   84.65 
              93.78  111.75 
/
 5  7  3  1   76.70   73.33   70.56   68.58   66.40 
              65.84   68.06   72.15   77.72   84.47 
              95.18  115.87 
/
 5  7  4  1   76.23   72.11   68.68   66.37   64.12 
              63.68   66.27   71.41   77.97   85.92 
              97.75  120.14 
/
 5  7  5  1   74.69   66.16   60.83   58.25   57.02 
              59.11   66.43   74.44   83.23   87.95 
              94.05  116.85 
/
 5  7  6  1   73.70   63.15   57.69   55.53   55.38 
              59.65   67.96   75.73   81.29   89.06 
             101.19  123.18 
/
 5  7  7  1   72.29   59.70   54.70   53.32   54.75 
              61.00   69.21   78.80   88.44   98.35 
             114.21  143.33 
/
 5  7  8  1   59.75   49.33   51.42   59.05   75.69 
             103.94  143.31  183.69  225.26  269.15 
             340.84  477.84 
/
 5  7  9  1   53.06   49.36   63.35   79.86  115.26 
             169.39  244.80  329.09  422.85  526.73 
             702.89 1053.64 
/
 5  8  1  1   81.16   78.78   77.74   77.37   77.28 
              77.85   79.36   81.56   84.39   89.52 
              96.80  111.96 
/
 5  8  2  1   81.04   78.44   77.32   76.86   76.74 
              77.31   78.83   81.06   83.92   89.20 
              96.63  112.00 
/
 5  8  3  1   80.44   77.16   75.76   74.86   74.24 
              74.79   76.82   79.54   82.94   87.87 
              95.99  112.41 
/
 5  8  4  1   79.83   76.45   74.84   73.61   72.32 
              72.74   74.78   77.74   81.64   86.92 
              95.70  113.17 
/
 5  8  5  1   77.68   73.75   70.48   68.23   65.84 
              65.33   67.72   72.56   78.96   86.74 
              98.66  121.64 
/
 5  8  6  1   77.28   72.15   68.10   65.54   63.21 
              63.00   66.32   72.45   80.18   89.24 
             101.52  125.28 
/
 5  8  7  1   76.75   69.96   65.11   62.36   60.30 
              60.86   66.03   73.70   82.49   89.94 
             104.10  131.07 
/
 5  8  8  1   70.43   55.34   51.95   52.00   55.73 
              65.94   79.91   94.35  109.58  125.63 
             150.93  196.13 
/
 5  8  9  1   64.56   50.76   51.18   53.58   64.94 
              83.00  109.79  137.89  166.93  196.92 
             243.95  330.95 
/
 5  9  1  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  2  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  3  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  4  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  5  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  6  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  7  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  8  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 5  9  9  1   82.64   82.11   81.89   81.88   82.11 
              82.85   84.45   86.70   89.59   93.12 
              99.61  113.58 
/
 6  1  1  1   81.58   78.35   75.34   73.34   71.35 
              71.14   74.02   79.10   85.50   92.76 
             103.62  124.38 
/
 6  1  2  1   81.44   77.82   74.56   72.47   70.50 
              70.45   73.75   79.25   86.21   93.44 
             104.44  126.14 
/
 6  1  3  1   80.84   75.45   71.31   69.02   67.41 
              68.38   73.89   81.08   88.25   96.34 
             107.41  131.64 
/
 6  1  4  1   80.24   73.41   68.84   66.65   65.66 
              68.08   75.05   82.78   87.35   92.47 
             102.82  121.54 
/
 6  1  5  1   77.04   65.77   62.16   61.76   64.34 
              72.46   84.11   96.78  110.52  125.23 
             148.49  189.99 
/
 6  1  6  1   75.21   63.18   60.84   61.64   66.59 
              77.80   94.21  112.69  132.28  152.61 
             184.36  240.64 
/
 6  1  7  1   72.82   61.03   60.29   62.14   71.61 
              87.63  112.46  138.90  166.31  194.57 
             238.57  319.03 
/
 6  1  8  1   60.24   64.71   88.20  114.89  169.80 
             260.19  399.36  563.11  756.01  981.78 
            1378.10 2163.61 
/
 6  1  9  1   57.04   85.76  137.13  192.62  316.78 
             539.38  918.35 1395.52 1972.86 2156.40 
            2174.16 2166.31 
/
 6  2  1  1   82.32   79.17   76.30   74.36   72.31 
              72.03   74.69   79.47   85.56   92.66 
             103.49  124.59 
/
 6  2  2  1   82.13   78.67   75.55   73.50   71.49 
              71.30   74.28   79.50   86.10   93.57 
             104.41  126.08 
/
 6  2  3  1   81.57   76.41   72.37   70.06   68.31 
              68.97   73.97   81.05   88.11   95.63 
             108.92  133.61 
/
 6  2  4  1   81.02   74.43   69.90   67.63   66.39 
              68.25   74.96   82.45   90.64   91.82 
             101.33  125.26 
/
 6  2  5  1   78.02   66.78   62.83   62.18   64.36 
              71.38   82.18   93.64  106.00  119.23 
             140.47  178.67 
/
 6  2  6  1   76.27   64.06   61.30   61.49   65.65 
              76.01   90.72  107.19  124.99  143.55 
             172.58  224.15 
/
 6  2  7  1   73.96   61.68   60.35   61.74   70.08 
              84.29  106.47  130.46  155.45  181.26 
             221.49  293.74 
/
 6  2  8  1   60.97   62.73   83.54  107.43  157.21 
             236.70  358.34  499.24  663.01  852.90 
            1187.01 1881.40 
/
 6  2  9  1   57.82   81.21  127.31  176.20  285.28 
             477.68  799.09 1201.50 1685.02 2250.93 
            2445.61 2462.45 
/
 6  3  1  1   83.12   80.04   77.34   75.47   73.43 
              73.05   75.56   80.00   85.78   92.67 
             103.13  123.66 
/
 6  3  2  1   82.87   79.57   76.61   74.63   72.57 
              72.27   74.97   79.86   86.08   93.35 
             104.43  126.03 
/
 6  3  3  1   82.31   77.43   73.54   71.24   69.35 
              69.73   74.17   80.79   88.51   95.05 
             107.72  131.34 
/
 6  3  4  1   81.82   75.55   71.10   68.75   67.28 
              68.60   74.75   82.19   89.90   96.36 
             105.13  129.37 
/
 6  3  5  1   79.04   67.96   63.67   62.69   64.58 
              70.17   80.36   90.73  101.75  113.51 
             132.61  167.40 
/
 6  3  6  1   77.40   65.10   61.85   61.72   64.96 
              74.32   87.45  101.96  117.78  134.51 
             160.78  207.54 
/
 6  3  7  1   75.19   62.49   60.68   61.72   68.56 
              81.20  100.59  122.07  144.57  167.88 
             204.26  268.95 
/
 6  3  8  1   61.86   61.09   79.01  100.01  144.63 
             214.03  319.01  439.01  576.45  733.80 
            1011.29 1580.02 
/
 6  3  9  1   58.54   76.79  117.53  160.28  254.83 
             419.14  688.03 1021.82 1419.48 1883.61 
            2702.89 2854.24 
/
 6  4  1  1   83.55   80.49   77.88   76.07   74.04 
              73.62   76.08   80.34   85.95   92.72 
             102.99  123.22 
/
 6  4  2  1   83.27   80.04   77.18   75.24   73.15 
              72.81   75.41   80.10   86.14   93.29 
             104.15  125.42 
/
 6  4  3  1   82.69   77.97   74.17   71.88   69.93 
              70.17   74.33   80.72   88.53   95.20 
             107.44  130.77 
/
 6  4  4  1   82.22   76.15   71.75   69.38   67.79 
              68.87   74.70   82.15   89.58   98.06 
             107.43  131.18 
/
 6  4  5  1   79.57   68.62   64.16   63.01   64.49 
              69.96   79.50   89.36   99.75  110.79 
             128.79  161.82 
/
 6  4  6  1   77.98   65.70   62.20   61.92   64.77 
              73.51   85.91   99.48  114.26  130.02 
             154.88  199.20 
/
 6  4  7  1   75.84   62.98   60.90   61.95   67.64 
              79.74   97.75  117.91  139.15  161.17 
             195.60  256.78 
/
 6  4  8  1   62.39   60.39   76.81   96.33  138.26 
             203.03  299.98  410.23  535.46  677.90 
             928.01 1439.82 
/
 6  4  9  1   58.77   74.63  112.63  152.57  239.99 
             391.08  635.51  936.79 1295.11 1711.91 
            2446.75 3104.00 
/
 6  5  1  1   83.99   80.96   78.45   76.69   74.69 
              74.24   76.65   80.73   86.19   92.81 
             102.88  122.80 
/
 6  5  2  1   83.70   80.52   77.77   75.88   73.80 
              73.40   75.92   80.41   86.26   93.27 
             103.90  124.81 
/
 6  5  3  1   83.07   78.53   74.83   72.56   70.56 
              70.66   74.53   80.68   88.47   95.57 
             107.14  130.78 
/
 6  5  4  1   82.63   76.77   72.45   70.06   68.35 
              69.19   74.68   82.10   89.31   97.47 
             109.10  133.50 
/
 6  5  5  1   80.10   69.33   64.71   63.39   64.48 
              70.42   78.66   88.04   97.83  108.18 
             125.08  156.29 
/
 6  5  6  1   78.58   66.36   62.60   62.16   64.70 
              72.74   84.44   97.11  110.84  125.58 
             148.99  190.88 
/
 6  5  7  1   76.51   63.52   61.15   61.98   66.89 
              78.34   95.02  113.79  133.74  154.47 
             186.92  244.63 
/
 6  5  8  1   62.99   59.77   74.67   92.68  131.85 
             192.29  281.36  382.28  495.96  624.39 
             848.34 1306.94 
/
 6  5  9  1   59.05   72.52  107.71  145.04  225.43 
             363.74  584.98  855.27 1176.54 1548.35 
            2203.07 3448.95 
/
 6  6  1  1   86.02   82.93   80.91   79.44   77.67 
              77.45   79.73   83.10   87.82   93.67 
             102.96  121.44 
/
 6  6  2  1   85.66   82.59   80.35   78.75   76.85 
              76.45   78.78   82.40   87.47   93.67 
             103.41  122.69 
/
 6  6  3  1   84.65   80.97   77.82   75.73   73.58 
              73.21   75.96   81.07   87.60   95.30 
             107.00  129.26 
/
 6  6  4  1   84.31   79.51   75.69   73.36   71.27 
              71.32   75.17   81.42   89.35   96.64 
             108.79  132.76 
/
 6  6  5  1   82.36   72.79   67.71   65.70   65.44 
              69.67   77.69   83.39   91.14   99.01 
             111.88  135.57 
/
 6  6  6  1   81.15   69.74   65.01   63.65   64.79 
              70.86   79.16   88.72   98.67  109.20 
             126.37  158.14 
/
 6  6  7  1   79.45   66.51   62.74   62.34   64.98 
              73.31   85.40   98.49  112.71  127.95 
             152.18  195.57 
/
 6  6  8  1   66.24   58.90   66.96   78.70  106.23 
             150.55  211.53  278.06  351.64  432.45 
             568.36  840.98 
/
 6  6  9  1   60.83   64.56   88.27  115.04  170.34 
             261.55  401.87  565.64  755.80  974.81 
            1353.55 2124.99 
/
 6  7  1  1   88.58   85.15   83.68   82.64   81.61 
              82.04   83.78   86.30   90.67   95.91 
             104.19  120.99 
/
 6  7  2  1   88.26   84.87   83.30   82.14   80.80 
              81.06   83.30   86.16   90.30   95.57 
             104.18  121.51 
/
 6  7  3  1   86.94   83.78   81.49   79.86   77.90 
              77.45   79.79   83.43   88.61   94.94 
             105.00  124.87 
/
 6  7  4  1   86.19   82.74   79.84   77.86   75.64 
              75.12   77.60   82.18   88.26   95.70 
             106.90  129.09 
/
 6  7  5  1   84.82   77.58   72.72   70.19   68.53 
              69.79   76.26   84.27   92.23  100.55 
             105.85  129.79 
/
 6  7  6  1   84.01   74.87   69.64   67.34   66.49 
              69.73   77.53   86.26   89.54   96.81 
             108.35  129.47 
/
 6  7  7  1   82.84   71.64   66.54   64.80   65.30 
              70.80   78.19   86.71   95.72  105.03 
             120.15  148.22 
/
 6  7  8  1   71.74   60.14   60.95   67.21   82.05 
             108.45  146.49  186.13  227.25  270.87 
             342.23  478.85 
/
 6  7  9  1   64.97   59.10   70.60   85.50  118.99 
             171.79  246.48  330.36  423.84  527.53 
             703.46 1053.92 
/
 6  8  1  1   91.33   89.34   88.45   88.14   88.10 
              88.68   90.17   92.34   95.13  100.13 
             107.23  122.17 
/
 6  8  2  1   91.23   89.02   88.05   87.71   87.64 
              88.22   89.72   91.91   94.73   99.85 
             107.07  122.20 
/
 6  8  3  1   90.74   87.60   86.35   85.71   85.47 
              86.04   87.63   89.94   92.92   98.68 
             106.49  122.56 
/
 6  8  4  1   90.24   86.70   85.28   84.34   83.54 
              84.09   86.08   89.01   92.68   97.78 
             106.18  123.17 
/
 6  8  5  1   87.80   84.31   81.53   79.61   77.38 
              76.76   79.18   83.50   89.47   96.81 
             108.10  130.26 
/
 6  8  6  1   87.20   82.93   79.44   77.17   74.77 
              74.41   77.29   82.90   90.10   98.69 
             111.47  135.86 
/
 6  8  7  1   86.76   81.06   76.77   74.23   72.00 
              72.13   76.51   83.55   92.51  100.36 
             112.66  138.66 
/
 6  8  8  1   81.49   67.31   63.31   62.86   65.70 
              74.33   87.27  100.79  115.13  130.41 
             154.92  199.33 
/
 6  8  9  1   76.33   62.08   61.23   63.04   72.91 
              89.35  114.42  141.53  169.91  199.46 
             246.03  332.61 
/
 6  9  1  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  2  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  3  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  4  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  5  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  6  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  7  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  8  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 6  9  9  1   92.66   92.11   91.90   91.89   92.12 
              92.86   94.46   96.71   99.60  103.13 
             109.61  123.58 
/
 7  1  1  1   91.61   88.83   86.31   84.61   82.67 
              82.35   85.07   89.61   95.49  102.24 
             112.79  133.53 
/
 7  1  2  1   91.31   88.37   85.60   83.79   81.80 
              81.60   84.54   89.56   95.96  103.08 
             114.32  135.66 
/
 7  1  3  1   90.73   86.29   82.61   80.50   78.64 
              79.24   84.09   90.98   98.01  105.29 
             118.44  143.09 
/
 7  1  4  1   90.24   84.47   80.27   78.13   76.68 
              78.48   84.97   92.32   99.67  101.03 
             110.87  134.23 
/
 7  1  5  1   87.54   77.22   73.32   72.57   74.62 
              81.43   92.05  103.75  116.58  130.51 
             153.03  193.75 
/
 7  1  6  1   85.96   74.55   71.69   71.81   75.85 
              85.98  101.00  118.21  137.00  156.74 
             187.83  243.42 
/
 7  1  7  1   83.85   72.15   70.68   72.00   80.13 
              94.57  117.73  143.14  169.85  197.61 
             241.11  321.13 
/
 7  1  8  1   71.38   73.12   94.27  119.38  172.68 
             262.15  400.71  564.15  756.83  982.40 
            1378.53 2163.71 
/
 7  1  9  1   67.81   91.92  140.68  195.18  318.42 
             540.40  919.00 1395.86 1972.96 2156.30 
            2177.36 2167.04 
/
 7  2  1  1   92.44   89.62   87.22   85.59   83.68 
              83.32   85.93   90.17   95.79  102.37 
             112.60  132.83 
/
 7  2  2  1   92.09   89.18   86.53   84.78   82.80 
              82.49   85.26   89.97   96.04  103.00 
             113.88  135.24 
/
 7  2  3  1   91.44   87.19   83.63   81.53   79.58 
              79.95   84.32   90.81   98.52  104.81 
             117.40  141.05 
/
 7  2  4  1   90.99   85.44   81.31   79.13   77.49 
              78.78   84.84   92.12   99.74  104.52 
             113.94  138.65 
/
 7  2  5  1   88.47   78.26   74.08   73.08   74.45 
              80.40   90.40  100.99  112.51  124.97 
             145.39  182.78 
/
 7  2  6  1   86.96   75.49   72.23   72.04   75.24 
              84.45   97.91  113.18  130.08  148.02 
             176.39  227.21 
/
 7  2  7  1   84.93   72.91   70.97   71.97   78.85 
              91.67  112.14  135.08  159.32  184.60 
             224.29  296.02 
/
 7  2  8  1   72.21   71.58   90.04  112.32  160.36 
             238.85  359.84  500.37  663.89  853.64 
            1187.48 1881.63 
/
 7  2  9  1   68.80   87.79  131.21  178.98  287.06 
             478.81  799.83 1201.95 1685.24 2250.95 
            2471.37 2463.17 
/
 7  3  1  1   93.33   90.44   88.19   86.66   84.79 
              84.45   86.96   90.90   96.25  102.62 
             112.50  132.19 
/
 7  3  2  1   92.95   90.03   87.54   85.87   83.91 
              83.53   86.17   90.53   96.29  103.04 
             113.52  134.27 
/
 7  3  3  1   92.17   88.15   84.74   82.68   80.64 
              80.79   84.68   90.76   98.60  105.44 
             117.32  140.77 
/
 7  3  4  1   91.75   86.49   82.47   80.27   78.46 
              79.32   84.83   92.22   99.25  107.46 
             118.29  142.43 
/
 7  3  5  1   89.42   79.44   75.01   73.73   74.44 
              79.64   88.87   98.44  108.71  119.78 
             138.02  171.93 
/
 7  3  6  1   88.01   76.59   72.92   72.44   74.98 
              83.04   95.05  108.49  123.33  139.39 
             164.96  210.94 
/
 7  3  7  1   86.09   73.82   71.43   72.33   77.37 
              88.98  106.76  127.12  148.85  171.59 
             207.37  271.46 
/
 7  3  8  1   73.21   70.33   85.96  105.35  148.14 
             216.39  320.70  440.29  577.48  734.58 
            1011.90 1580.38 
/
 7  3  9  1   69.29   83.81  121.85  163.34  256.81 
             420.45  688.77 1022.41 1419.82 1883.75 
            2702.80 2854.95 
/
 7  4  1  1   93.81   90.87   88.71   87.22   85.39 
              85.09   87.56   91.34   96.54  102.80 
             112.49  131.89 
/
 7  4  2  1   93.41   90.48   88.07   86.45   84.51 
              84.12   86.71   90.89   96.48  103.11 
             113.39  133.81 
/
 7  4  3  1   92.53   88.66   85.33   83.30   81.23 
              81.27   84.92   90.79   98.35  105.63 
             117.42  140.90 
/
 7  4  4  1   92.14   87.05   83.11   80.90   79.01 
              79.70   84.87   92.14   99.06  106.98 
             120.39  144.74 
/
 7  4  5  1   89.92   80.10   75.54   74.12   74.54 
              79.36   88.16   97.26  106.93  117.33 
             134.50  166.57 
/
 7  4  6  1   88.56   77.21   73.33   72.70   75.02 
              82.38   93.71  106.27  120.10  135.13 
             159.27  202.82 
/
 7  4  7  1   86.70   74.35   71.71   72.21   76.75 
              87.72  104.22  123.20  143.65  165.10 
             198.90  259.40 
/
 7  4  8  1   73.79   69.82   84.01  101.92  141.97 
             205.52  301.76  411.61  536.55  678.81 
             928.71 1440.22 
/
 7  4  9  1   69.59   81.89  117.18  155.78  242.09 
             392.44  636.31  937.44 1295.52 1712.13 
            2446.72 3107.41 
/
 7  5  1  1   94.30   91.31   89.23   87.80   86.01 
              85.59   88.20   91.83   96.89  103.03 
             112.53  131.63 
/
 7  5  2  1   93.89   90.93   88.63   87.06   85.15 
              84.77   87.30   91.30   96.73  103.24 
             113.29  133.37 
/
 7  5  3  1   92.91   89.18   85.96   83.95   81.86 
              81.79   85.20   90.85   98.13  105.78 
             117.49  140.38 
/
 7  5  4  1   92.53   87.63   83.77   81.57   79.61 
              80.12   84.95   91.93   99.46  106.53 
             119.97  145.36 
/
 7  5  5  1   90.42   80.80   76.14   74.57   74.76 
              80.21   87.50   96.14  105.25  114.98 
             131.12  161.30 
/
 7  5  6  1   89.12   77.88   73.80   73.01   75.00 
              81.68   92.44  104.16  117.01  130.96 
             153.61  194.72 
/
 7  5  7  1   87.33   74.94   72.03   72.13   76.16 
              86.52  101.81  119.33  138.48  158.63 
             190.42  247.43 
/
 7  5  8  1   74.44   69.40   82.12   98.54  135.79 
             194.92  283.25  383.75  497.15  625.38 
             849.11 1307.36 
/
 7  5  9  1   69.94   80.03  112.51  148.42  227.66 
             365.21  585.88  855.94 1177.02 1548.64 
            2203.12 3462.56 
/
 7  6  1  1   96.51   93.16   91.50   90.34   88.82 
              88.97   90.90   93.67   98.81  104.35 
             113.10  130.89 
/
 7  6  2  1   96.08   92.87   91.01   89.72   88.03 
              87.88   90.34   93.24   98.38  104.23 
             113.39  131.94 
/
 7  6  3  1   94.64   91.46   88.75   86.97   84.87 
              84.41   87.10   91.70   97.78  105.00 
             116.12  138.20 
/
 7  6  4  1   94.15   90.17   86.83   84.76   82.58 
              82.45   85.86   91.63   99.05  107.18 
             118.98  142.55 
/
 7  6  5  1   92.53   84.14   79.26   77.16   76.21 
              79.76   87.45   92.34   99.53  106.88 
             119.15  141.97 
/
 7  6  6  1   91.50   81.26   76.46   74.86   75.04 
              80.66   88.00   96.82  106.10  116.01 
             132.42  163.16 
/
 7  6  7  1   90.05   78.08   73.95   73.19   75.34 
              82.24   93.36  105.49  118.81  133.28 
             156.75  199.36 
/
 7  6  8  1   77.86   69.39   75.41   85.89  111.40 
             154.08  214.04  280.06  353.30  433.86 
             569.48  841.81 
/
 7  6  9  1   72.07   73.08   94.38  119.57  173.27 
             263.54  403.27  566.66  756.60  975.40 
            1353.96 2125.07 
/
 7  7  1  1   98.93   95.51   94.17   93.41   92.86 
              93.46   95.13   97.55  100.64  106.71 
             114.62  130.97 
/
 7  7  2  1   98.67   95.11   93.72   92.84   92.00 
              92.56   94.29   96.79  100.38  106.37 
             114.56  131.39 
/
 7  7  3  1   97.34   94.05   92.12   90.79   89.03 
              88.78   91.31   94.69   99.49  105.51 
             115.02  134.20 
/
 7  7  4  1   96.34   93.15   90.66   89.00   86.93 
              86.40   88.95   93.08   98.77  105.77 
             116.43  137.84 
/
 7  7  5  1   94.81   88.60   84.16   81.78   79.87 
              80.57   86.37   94.33  101.67  110.28 
             119.27  143.83 
/
 7  7  6  1   94.13   86.16   81.21   78.90   77.47 
              80.01   87.59   95.67   98.37  105.19 
             116.19  136.48 
/
 7  7  7  1   93.15   83.15   78.09   76.17   75.78 
              80.81   89.04   95.21  103.62  112.37 
             126.85  153.95 
/
 7  7  8  1   83.28   71.00   71.03   75.88   89.31 
             113.81  150.39  189.21  229.81  273.13 
             344.14  480.34 
/
 7  7  9  1   76.61   69.41   78.67   92.03  123.53 
             174.83  248.69  332.09  425.26  528.70 
             704.36 1054.51 
/
 7  8  1  1  101.44   99.73   98.96   98.70   98.70 
              99.30  100.78  102.93  105.70  110.58 
             117.54  132.32 
/
 7  8  2  1  101.36   99.46   98.61   98.32   98.30 
              98.89  100.38  102.55  105.34  110.34 
             117.40  132.35 
/
 7  8  3  1  100.95   98.14   96.96   96.52   96.41 
              96.98   98.54  100.81  103.72  109.30 
             116.88  132.67 
/
 7  8  4  1  100.53   97.05   95.73   95.03   94.66 
              95.24   96.88   99.28  102.35  108.48 
             116.57  133.20 
/
 7  8  5  1   98.09   94.67   92.27   90.66   88.60 
              88.05   90.57   94.50  100.13  107.12 
             117.83  139.27 
/
 7  8  6  1   97.17   93.47   90.39   88.42   86.09 
              85.56   88.33   93.43  100.19  108.33 
             120.55  144.85 
/
 7  8  7  1   96.68   91.83   87.99   85.70   83.32 
              83.25   87.11   93.65  102.09  111.08 
             123.09  149.34 
/
 7  8  8  1   92.20   78.98   74.59   73.75   76.01 
              83.19   95.23  107.92  121.48  136.00 
             159.67  203.25 
/
 7  8  9  1   87.64   73.35   71.62   73.06   81.45 
              96.53  119.88  145.95  173.61  202.65 
             248.71  334.82 
/
 7  9  1  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  2  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  3  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  4  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  5  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  6  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  7  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  8  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
 7  9  9  1  102.67  102.12  101.91  101.89  102.12 
             102.87  104.47  106.72  109.61  113.13 
             119.61  133.58 
/
