# TODOs(?)
Some ideas for potential features that I have been reluctant to add.

## Command Aliases
Allow the user to specify custom noss commands in their `noss.conf`.
```json
"alias": {
    "cat": "noss read --stdout $1"
}
```
How this feature would be implemented is that the command's alias would be
treated as a shell command with `$@` set to the list of arguments given to noss.
This would mean that `$1`, `$2`, `$3`, etc. would be set to their respective
positional arguments and `$@` would be the entire argument list.

What's keeping me from implementing this feature is that handling arguments
that look options (start with `-` or `--`) would be difficult as `GetOptions`
would slurp those arguments up and not allow them to be available to the shell
command.

## Color code format sequences
Allow the user to color the output of some commands via color codes.
```json
"list_format": "<1>%s <2>%-15f <3>%3i <4>%t"
```
This feature would be implemented by modifying the `_fmt()` subroutine to
accept a hash ref of color codes. Color codes that appear in the format string
would be replaced by their corresponding ANSI escape sequence returned by
`Term::ANSIColor`.

What's keeping me from implementing this feature is that colorful output can
already be achieved by embedding ANSI color sequences inside of the format
strings themselves.

## "open" feed setting
Setting for feeds/groups that allow the user to specify a custom command to use
for opening that specific feed or group which would override the global open
setting.
```json
"WatameCh": {
    "feed": "http://www.youtube.com/feeds/videos.xml?channel_id=UCqm3BQLlJfvkTsX_hvm0UmA",
    "open": "yt-dlp",
}
```
The idea for this feature came when I was experimenting with subscribing to
YouTube channel feeds, and I thought it would be cool if I could use the `open`
command to open YouTube posts via yt-dlp.

The main issue keeping me from implementing this feature is how niche this
feature would be. I feel like implementing <##Command Aliases> would be the
better, more general solution. For example, instead of defining a specific open
command for a YouTube feed, you could define a `yt-dlp` alias which opens a
URL with yt-dlp.

## "list\_unread\_fmt" setting
Specify a format string to use for specifically listing unread posts in the
`list` command.

The idea for this feature came when I was experimenting with embedding
ANSI color codes in the "list\_format" setting to give the `list` command
colorful output. I thought it would be cool if I could give unread posts a
unique color to distinguish them from read posts, which could be achieved by
giving them a separate format string.

The issue keeping me from implementing this feature is how useful it would be
outside my very specific use-case. I'd like to refrain from adding features
that only exist to accomplish an extremely niche goal, as there is usually a
better, more general solution available.
