/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sql;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.style.StyleElement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SQLClose
extends StyleElement {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws TransformerException {
        DocumentInfo documentInfo = context.getCurrentNodeInfo().getDocumentRoot();
        Connection connection = (Connection)context.getController().getUserData(documentInfo, "sql:connection");
        if (connection == null) {
            throw this.styleError("No SQL connection has been established");
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            throw this.styleError("(SQL) Failed to close connection: " + sQLException.getMessage());
        }
    }
}

