; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64-unknown-aix-xcoff -verify-machineinstrs \
; RUN:   -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck \
; RUN:   --check-prefix=AIX64 %s
; RUN: llc -mtriple=powerpc-unknown-aix-xcoff -verify-machineinstrs \
; RUN:   -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck \
; RUN:   --check-prefix=AIX32 %s
; RUN: llc -mtriple=powerpc64le-- -verify-machineinstrs \
; RUN:   -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck --check-prefix=LE %s

define dso_local void @test1(ptr %v, i64 %a) local_unnamed_addr #0 {
; AIX64-LABEL: test1:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mtvsrd vs34, r4
; AIX64-NEXT:    #APP
; AIX64-NEXT:    stvx v2, 0, r3
; AIX64-NEXT:    #NO_APP
; AIX64-NEXT:    blr
;
; AIX32-LABEL: test1:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stw r5, -4(r1)
; AIX32-NEXT:    stw r4, -8(r1)
; AIX32-NEXT:    lfd f0, -8(r1)
; AIX32-NEXT:    xxlor vs34, f0, f0
; AIX32-NEXT:    #APP
; AIX32-NEXT:    stvx v2, 0, r3
; AIX32-NEXT:    #NO_APP
; AIX32-NEXT:    blr
;
; LE-LABEL: test1:
; LE:       # %bb.0: # %entry
; LE-NEXT:    mtvsrd vs34, r4
; LE-NEXT:    #APP
; LE-NEXT:    stvx v2, 0, r3
; LE-NEXT:    #NO_APP
; LE-NEXT:    blr
entry:
  tail call void asm sideeffect "stvx $0,0,$1", "v,r,~{memory}"(i64 %a, ptr %v)
  ret void
}

define dso_local void @test2(ptr %v, i32 signext %a) local_unnamed_addr #0 {
; AIX64-LABEL: test2:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    clrldi r4, r4, 32
; AIX64-NEXT:    mtvsrd vs34, r4
; AIX64-NEXT:    #APP
; AIX64-NEXT:    stvx v2, 0, r3
; AIX64-NEXT:    #NO_APP
; AIX64-NEXT:    blr
;
; AIX32-LABEL: test2:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stw r4, -4(r1)
; AIX32-NEXT:    li r4, 0
; AIX32-NEXT:    stw r4, -8(r1)
; AIX32-NEXT:    lfd f0, -8(r1)
; AIX32-NEXT:    xxlor vs34, f0, f0
; AIX32-NEXT:    #APP
; AIX32-NEXT:    stvx v2, 0, r3
; AIX32-NEXT:    #NO_APP
; AIX32-NEXT:    blr
;
; LE-LABEL: test2:
; LE:       # %bb.0: # %entry
; LE-NEXT:    clrldi r4, r4, 32
; LE-NEXT:    mtvsrd vs34, r4
; LE-NEXT:    #APP
; LE-NEXT:    stvx v2, 0, r3
; LE-NEXT:    #NO_APP
; LE-NEXT:    blr
entry:
  tail call void asm sideeffect "stvx $0,0,$1", "v,r,~{memory}"(i32 %a, ptr %v)
  ret void
}

define dso_local void @test3(ptr %v, i16 signext %a) local_unnamed_addr #0 {
; AIX64-LABEL: test3:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    clrldi r4, r4, 48
; AIX64-NEXT:    mtvsrd vs34, r4
; AIX64-NEXT:    #APP
; AIX64-NEXT:    stvx v2, 0, r3
; AIX64-NEXT:    #NO_APP
; AIX64-NEXT:    blr
;
; AIX32-LABEL: test3:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    li r5, 0
; AIX32-NEXT:    clrlwi r4, r4, 16
; AIX32-NEXT:    stw r5, -8(r1)
; AIX32-NEXT:    stw r4, -4(r1)
; AIX32-NEXT:    lfd f0, -8(r1)
; AIX32-NEXT:    xxlor vs34, f0, f0
; AIX32-NEXT:    #APP
; AIX32-NEXT:    stvx v2, 0, r3
; AIX32-NEXT:    #NO_APP
; AIX32-NEXT:    blr
;
; LE-LABEL: test3:
; LE:       # %bb.0: # %entry
; LE-NEXT:    clrldi r4, r4, 48
; LE-NEXT:    mtvsrd vs34, r4
; LE-NEXT:    #APP
; LE-NEXT:    stvx v2, 0, r3
; LE-NEXT:    #NO_APP
; LE-NEXT:    blr
entry:
  tail call void asm sideeffect "stvx $0,0,$1", "v,r,~{memory}"(i16 %a, ptr %v)
  ret void
}

define dso_local void @test4(ptr %v, i8 signext %a) local_unnamed_addr #0 {
; AIX64-LABEL: test4:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    clrldi r4, r4, 56
; AIX64-NEXT:    mtvsrd vs34, r4
; AIX64-NEXT:    #APP
; AIX64-NEXT:    stvx v2, 0, r3
; AIX64-NEXT:    #NO_APP
; AIX64-NEXT:    blr
;
; AIX32-LABEL: test4:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    li r5, 0
; AIX32-NEXT:    clrlwi r4, r4, 24
; AIX32-NEXT:    stw r5, -8(r1)
; AIX32-NEXT:    stw r4, -4(r1)
; AIX32-NEXT:    lfd f0, -8(r1)
; AIX32-NEXT:    xxlor vs34, f0, f0
; AIX32-NEXT:    #APP
; AIX32-NEXT:    stvx v2, 0, r3
; AIX32-NEXT:    #NO_APP
; AIX32-NEXT:    blr
;
; LE-LABEL: test4:
; LE:       # %bb.0: # %entry
; LE-NEXT:    clrldi r4, r4, 56
; LE-NEXT:    mtvsrd vs34, r4
; LE-NEXT:    #APP
; LE-NEXT:    stvx v2, 0, r3
; LE-NEXT:    #NO_APP
; LE-NEXT:    blr
entry:
  tail call void asm sideeffect "stvx $0,0,$1", "v,r,~{memory}"(i8 %a, ptr %v)
  ret void
}

define dso_local void @test6(ptr %v, i32 zeroext %a) local_unnamed_addr #0 {
; AIX64-LABEL: test6:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mtvsrd vs34, r4
; AIX64-NEXT:    #APP
; AIX64-NEXT:    stvx v2, 0, r3
; AIX64-NEXT:    #NO_APP
; AIX64-NEXT:    blr
;
; AIX32-LABEL: test6:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stw r4, -4(r1)
; AIX32-NEXT:    li r4, 0
; AIX32-NEXT:    stw r4, -8(r1)
; AIX32-NEXT:    lfd f0, -8(r1)
; AIX32-NEXT:    xxlor vs34, f0, f0
; AIX32-NEXT:    #APP
; AIX32-NEXT:    stvx v2, 0, r3
; AIX32-NEXT:    #NO_APP
; AIX32-NEXT:    blr
;
; LE-LABEL: test6:
; LE:       # %bb.0: # %entry
; LE-NEXT:    mtvsrd vs34, r4
; LE-NEXT:    #APP
; LE-NEXT:    stvx v2, 0, r3
; LE-NEXT:    #NO_APP
; LE-NEXT:    blr
entry:
  tail call void asm sideeffect "stvx $0,0,$1", "v,r,~{memory}"(i32 %a, ptr %v)
  ret void
}

define dso_local void @test7(ptr %v, i16 zeroext %a) local_unnamed_addr #0 {
; AIX64-LABEL: test7:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mtvsrd vs34, r4
; AIX64-NEXT:    #APP
; AIX64-NEXT:    stvx v2, 0, r3
; AIX64-NEXT:    #NO_APP
; AIX64-NEXT:    blr
;
; AIX32-LABEL: test7:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stw r4, -4(r1)
; AIX32-NEXT:    li r4, 0
; AIX32-NEXT:    stw r4, -8(r1)
; AIX32-NEXT:    lfd f0, -8(r1)
; AIX32-NEXT:    xxlor vs34, f0, f0
; AIX32-NEXT:    #APP
; AIX32-NEXT:    stvx v2, 0, r3
; AIX32-NEXT:    #NO_APP
; AIX32-NEXT:    blr
;
; LE-LABEL: test7:
; LE:       # %bb.0: # %entry
; LE-NEXT:    mtvsrd vs34, r4
; LE-NEXT:    #APP
; LE-NEXT:    stvx v2, 0, r3
; LE-NEXT:    #NO_APP
; LE-NEXT:    blr
entry:
  tail call void asm sideeffect "stvx $0,0,$1", "v,r,~{memory}"(i16 %a, ptr %v)
  ret void
}

define dso_local void @test8(ptr %v, i8 zeroext %a) local_unnamed_addr #0 {
; AIX64-LABEL: test8:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mtvsrd vs34, r4
; AIX64-NEXT:    #APP
; AIX64-NEXT:    stvx v2, 0, r3
; AIX64-NEXT:    #NO_APP
; AIX64-NEXT:    blr
;
; AIX32-LABEL: test8:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stw r4, -4(r1)
; AIX32-NEXT:    li r4, 0
; AIX32-NEXT:    stw r4, -8(r1)
; AIX32-NEXT:    lfd f0, -8(r1)
; AIX32-NEXT:    xxlor vs34, f0, f0
; AIX32-NEXT:    #APP
; AIX32-NEXT:    stvx v2, 0, r3
; AIX32-NEXT:    #NO_APP
; AIX32-NEXT:    blr
;
; LE-LABEL: test8:
; LE:       # %bb.0: # %entry
; LE-NEXT:    mtvsrd vs34, r4
; LE-NEXT:    #APP
; LE-NEXT:    stvx v2, 0, r3
; LE-NEXT:    #NO_APP
; LE-NEXT:    blr
entry:
  tail call void asm sideeffect "stvx $0,0,$1", "v,r,~{memory}"(i8 %a, ptr %v)
  ret void
}

attributes #0 = { nounwind }
