#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Adjust sound volume"

    def run(self):
        current_volume = self.getFloatSetting("sound", "volume", 0.7)

        # Present current volume
        volume_percent = int(current_volume * 100)
        self.present_text(f"Current sound volume: {volume_percent} percent")

        # Adjust volume by 10%
        new_volume = self.adjustFloatSetting("sound", "volume", 0.1, 0.0, 1.0)

        if new_volume != current_volume:
            new_percent = int(new_volume * 100)
            self.present_text(
                f"Sound volume set to {new_percent} percent", interrupt=False
            )
            self.play_sound("Accept")
        else:
            # If we hit the maximum, try decreasing instead
            new_volume = self.adjustFloatSetting(
                "sound", "volume", -0.1, 0.0, 1.0
            )
            if new_volume != current_volume:
                new_percent = int(new_volume * 100)
                self.present_text(
                    f"Sound volume set to {new_percent} percent",
                    interrupt=False,
                )
                self.play_sound("Accept")
            else:
                self.present_text("Sound volume unchanged", interrupt=False)
                self.play_sound("Cancel")
