import wasm from "./diplomat-wasm.mjs"
import * as diplomatRuntime from "./diplomat-runtime.js"

export const ICU4XError_js_to_rust = {
  "UnknownError": 0,
  "WriteableError": 1,
  "OutOfBoundsError": 2,
  "DataMissingDataKeyError": 256,
  "DataMissingVariantError": 257,
  "DataMissingLocaleError": 258,
  "DataNeedsVariantError": 259,
  "DataNeedsLocaleError": 260,
  "DataExtraneousLocaleError": 261,
  "DataFilteredResourceError": 262,
  "DataMismatchedTypeError": 263,
  "DataMissingPayloadError": 264,
  "DataInvalidStateError": 265,
  "DataCustomError": 266,
  "DataIoError": 267,
  "DataUnavailableBufferFormatError": 268,
  "DataMismatchedAnyBufferError": 269,
  "LocaleUndefinedSubtagError": 512,
  "LocaleParserLanguageError": 513,
  "LocaleParserSubtagError": 514,
  "LocaleParserExtensionError": 515,
  "DataStructValidityError": 768,
  "PropertyUnknownScriptIdError": 1024,
  "PropertyUnknownGeneralCategoryGroupError": 1025,
  "PropertyUnexpectedPropertyNameError": 1026,
  "FixedDecimalLimitError": 1280,
  "FixedDecimalSyntaxError": 1281,
  "PluralsParserError": 1536,
  "CalendarParseError": 1792,
  "CalendarOverflowError": 1793,
  "CalendarUnderflowError": 1794,
  "CalendarOutOfRangeError": 1795,
  "CalendarUnknownEraError": 1796,
  "CalendarUnknownMonthCodeError": 1797,
  "CalendarMissingInputError": 1798,
  "CalendarUnknownKindError": 1799,
  "CalendarMissingError": 1800,
  "DateTimePatternError": 2048,
  "DateTimeMissingInputFieldError": 2049,
  "DateTimeSkeletonError": 2050,
  "DateTimeUnsupportedFieldError": 2051,
  "DateTimeUnsupportedOptionsError": 2052,
  "DateTimeMissingWeekdaySymbolError": 2053,
  "DateTimeMissingMonthSymbolError": 2054,
  "DateTimeFixedDecimalError": 2055,
  "DateTimeMismatchedCalendarError": 2056,
  "TinyStrTooLargeError": 2304,
  "TinyStrContainsNullError": 2305,
  "TinyStrNonAsciiError": 2306,
  "TimeZoneOffsetOutOfBoundsError": 2560,
  "TimeZoneInvalidOffsetError": 2561,
  "TimeZoneMissingInputError": 2562,
  "TimeZoneInvalidIdError": 2563,
  "NormalizerFutureExtensionError": 2816,
  "NormalizerValidationError": 2817,
};

export const ICU4XError_rust_to_js = {
  [0]: "UnknownError",
  [1]: "WriteableError",
  [2]: "OutOfBoundsError",
  [256]: "DataMissingDataKeyError",
  [257]: "DataMissingVariantError",
  [258]: "DataMissingLocaleError",
  [259]: "DataNeedsVariantError",
  [260]: "DataNeedsLocaleError",
  [261]: "DataExtraneousLocaleError",
  [262]: "DataFilteredResourceError",
  [263]: "DataMismatchedTypeError",
  [264]: "DataMissingPayloadError",
  [265]: "DataInvalidStateError",
  [266]: "DataCustomError",
  [267]: "DataIoError",
  [268]: "DataUnavailableBufferFormatError",
  [269]: "DataMismatchedAnyBufferError",
  [512]: "LocaleUndefinedSubtagError",
  [513]: "LocaleParserLanguageError",
  [514]: "LocaleParserSubtagError",
  [515]: "LocaleParserExtensionError",
  [768]: "DataStructValidityError",
  [1024]: "PropertyUnknownScriptIdError",
  [1025]: "PropertyUnknownGeneralCategoryGroupError",
  [1026]: "PropertyUnexpectedPropertyNameError",
  [1280]: "FixedDecimalLimitError",
  [1281]: "FixedDecimalSyntaxError",
  [1536]: "PluralsParserError",
  [1792]: "CalendarParseError",
  [1793]: "CalendarOverflowError",
  [1794]: "CalendarUnderflowError",
  [1795]: "CalendarOutOfRangeError",
  [1796]: "CalendarUnknownEraError",
  [1797]: "CalendarUnknownMonthCodeError",
  [1798]: "CalendarMissingInputError",
  [1799]: "CalendarUnknownKindError",
  [1800]: "CalendarMissingError",
  [2048]: "DateTimePatternError",
  [2049]: "DateTimeMissingInputFieldError",
  [2050]: "DateTimeSkeletonError",
  [2051]: "DateTimeUnsupportedFieldError",
  [2052]: "DateTimeUnsupportedOptionsError",
  [2053]: "DateTimeMissingWeekdaySymbolError",
  [2054]: "DateTimeMissingMonthSymbolError",
  [2055]: "DateTimeFixedDecimalError",
  [2056]: "DateTimeMismatchedCalendarError",
  [2304]: "TinyStrTooLargeError",
  [2305]: "TinyStrContainsNullError",
  [2306]: "TinyStrNonAsciiError",
  [2560]: "TimeZoneOffsetOutOfBoundsError",
  [2561]: "TimeZoneInvalidOffsetError",
  [2562]: "TimeZoneMissingInputError",
  [2563]: "TimeZoneInvalidIdError",
  [2816]: "NormalizerFutureExtensionError",
  [2817]: "NormalizerValidationError",
};

export const ICU4XError = {
  "UnknownError": "UnknownError",
  "WriteableError": "WriteableError",
  "OutOfBoundsError": "OutOfBoundsError",
  "DataMissingDataKeyError": "DataMissingDataKeyError",
  "DataMissingVariantError": "DataMissingVariantError",
  "DataMissingLocaleError": "DataMissingLocaleError",
  "DataNeedsVariantError": "DataNeedsVariantError",
  "DataNeedsLocaleError": "DataNeedsLocaleError",
  "DataExtraneousLocaleError": "DataExtraneousLocaleError",
  "DataFilteredResourceError": "DataFilteredResourceError",
  "DataMismatchedTypeError": "DataMismatchedTypeError",
  "DataMissingPayloadError": "DataMissingPayloadError",
  "DataInvalidStateError": "DataInvalidStateError",
  "DataCustomError": "DataCustomError",
  "DataIoError": "DataIoError",
  "DataUnavailableBufferFormatError": "DataUnavailableBufferFormatError",
  "DataMismatchedAnyBufferError": "DataMismatchedAnyBufferError",
  "LocaleUndefinedSubtagError": "LocaleUndefinedSubtagError",
  "LocaleParserLanguageError": "LocaleParserLanguageError",
  "LocaleParserSubtagError": "LocaleParserSubtagError",
  "LocaleParserExtensionError": "LocaleParserExtensionError",
  "DataStructValidityError": "DataStructValidityError",
  "PropertyUnknownScriptIdError": "PropertyUnknownScriptIdError",
  "PropertyUnknownGeneralCategoryGroupError": "PropertyUnknownGeneralCategoryGroupError",
  "PropertyUnexpectedPropertyNameError": "PropertyUnexpectedPropertyNameError",
  "FixedDecimalLimitError": "FixedDecimalLimitError",
  "FixedDecimalSyntaxError": "FixedDecimalSyntaxError",
  "PluralsParserError": "PluralsParserError",
  "CalendarParseError": "CalendarParseError",
  "CalendarOverflowError": "CalendarOverflowError",
  "CalendarUnderflowError": "CalendarUnderflowError",
  "CalendarOutOfRangeError": "CalendarOutOfRangeError",
  "CalendarUnknownEraError": "CalendarUnknownEraError",
  "CalendarUnknownMonthCodeError": "CalendarUnknownMonthCodeError",
  "CalendarMissingInputError": "CalendarMissingInputError",
  "CalendarUnknownKindError": "CalendarUnknownKindError",
  "CalendarMissingError": "CalendarMissingError",
  "DateTimePatternError": "DateTimePatternError",
  "DateTimeMissingInputFieldError": "DateTimeMissingInputFieldError",
  "DateTimeSkeletonError": "DateTimeSkeletonError",
  "DateTimeUnsupportedFieldError": "DateTimeUnsupportedFieldError",
  "DateTimeUnsupportedOptionsError": "DateTimeUnsupportedOptionsError",
  "DateTimeMissingWeekdaySymbolError": "DateTimeMissingWeekdaySymbolError",
  "DateTimeMissingMonthSymbolError": "DateTimeMissingMonthSymbolError",
  "DateTimeFixedDecimalError": "DateTimeFixedDecimalError",
  "DateTimeMismatchedCalendarError": "DateTimeMismatchedCalendarError",
  "TinyStrTooLargeError": "TinyStrTooLargeError",
  "TinyStrContainsNullError": "TinyStrContainsNullError",
  "TinyStrNonAsciiError": "TinyStrNonAsciiError",
  "TimeZoneOffsetOutOfBoundsError": "TimeZoneOffsetOutOfBoundsError",
  "TimeZoneInvalidOffsetError": "TimeZoneInvalidOffsetError",
  "TimeZoneMissingInputError": "TimeZoneMissingInputError",
  "TimeZoneInvalidIdError": "TimeZoneInvalidIdError",
  "NormalizerFutureExtensionError": "NormalizerFutureExtensionError",
  "NormalizerValidationError": "NormalizerValidationError",
};
