/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.grddl.GrddlTransformationAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeVersionAttribute;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeFontFaceDeclsElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeScriptsElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class OfficeDocumentContentElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.OFFICE, "document-content");

    public OfficeDocumentContentElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getGrddlTransformationAttribute() {
        GrddlTransformationAttribute attr = (GrddlTransformationAttribute)this.getOdfAttribute(OdfDocumentNamespace.GRDDL, "transformation");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setGrddlTransformationAttribute(String grddlTransformationValue) {
        GrddlTransformationAttribute attr = new GrddlTransformationAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(grddlTransformationValue);
    }

    public String getOfficeVersionAttribute() {
        OfficeVersionAttribute attr = (OfficeVersionAttribute)this.getOdfAttribute(OdfDocumentNamespace.OFFICE, "version");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setOfficeVersionAttribute(String officeVersionValue) {
        OfficeVersionAttribute attr = new OfficeVersionAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(officeVersionValue);
    }

    public OfficeAutomaticStylesElement newOfficeAutomaticStylesElement() {
        OfficeAutomaticStylesElement officeAutomaticStyles = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeAutomaticStylesElement.class);
        this.appendChild(officeAutomaticStyles);
        return officeAutomaticStyles;
    }

    public OfficeBodyElement newOfficeBodyElement() {
        OfficeBodyElement officeBody = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeBodyElement.class);
        this.appendChild(officeBody);
        return officeBody;
    }

    public OfficeFontFaceDeclsElement newOfficeFontFaceDeclsElement() {
        OfficeFontFaceDeclsElement officeFontFaceDecls = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeFontFaceDeclsElement.class);
        this.appendChild(officeFontFaceDecls);
        return officeFontFaceDecls;
    }

    public OfficeScriptsElement newOfficeScriptsElement() {
        OfficeScriptsElement officeScripts = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeScriptsElement.class);
        this.appendChild(officeScripts);
        return officeScripts;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

