/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextConditionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIsHiddenAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStringValueAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextHiddenTextElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "hidden-text");

    public TextHiddenTextElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextConditionAttribute() {
        TextConditionAttribute attr = (TextConditionAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "condition");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextConditionAttribute(String textConditionValue) {
        TextConditionAttribute attr = new TextConditionAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textConditionValue);
    }

    public Boolean getTextIsHiddenAttribute() {
        TextIsHiddenAttribute attr = (TextIsHiddenAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "is-hidden");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextIsHiddenAttribute(Boolean textIsHiddenValue) {
        TextIsHiddenAttribute attr = new TextIsHiddenAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textIsHiddenValue);
    }

    public String getTextStringValueAttribute() {
        TextStringValueAttribute attr = (TextStringValueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "string-value");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStringValueAttribute(String textStringValueValue) {
        TextStringValueAttribute attr = new TextStringValueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStringValueValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

