/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright 2025 Nebulamatrix Technology Co., Ltd.
 */

#ifndef _NBL_TXRX_H_
#define _NBL_TXRX_H_

#include "nbl_resource.h"

#define NBL_PACKED_DESC_F_NEXT			(0)
#define NBL_PACKED_DESC_F_WRITE			(1)
#define NBL_PACKED_DESC_F_AVAIL			(7)
#define NBL_PACKED_DESC_F_USED			(15)
#define NBL_PACKED_DESC_F_NEXT_BIT		(1 << NBL_PACKED_DESC_F_NEXT)
#define NBL_PACKED_DESC_F_WRITE_BIT		(1 << NBL_PACKED_DESC_F_WRITE)
#define NBL_PACKED_DESC_F_AVAIL_BIT		(1 << NBL_PACKED_DESC_F_AVAIL)
#define NBL_PACKED_DESC_F_USED_BIT		(1 << NBL_PACKED_DESC_F_USED)
#define NBL_PACKED_DESC_F_AVAIL_USED		(NBL_PACKED_DESC_F_AVAIL_BIT | \
						 NBL_PACKED_DESC_F_USED_BIT)

#define NBL_TX_HEADER_LEN			(32)
#define NBL_VQ_HDR_NAME_MAXSIZE			(32)

#define NBL_VRING_DESC_F_NEXT			RTE_BIT64(0)
#define NBL_VRING_DESC_F_WRITE			RTE_BIT64(1)
#define NBL_FREE_DESC_THRES			16
#define NBL_USED_DESC_THRES			32
#define NBL_TX_TOTAL_HEADERLEN_SHIFT		24
#define NBL_TX_FREE_THRESH			32
#define NBL_TX_RS_THRESH			32

#define NBL_RXQ_REARM_THRESH			32

#define NBL_DESC_PER_LOOP_VEC_MAX		(8)
#define NBL_BUF_LEN_16K				(16384)
#define NBL_BUF_LEN_8K				(8192)
#define NBL_BUF_LEN_4K				(4096)
#define NBL_BUF_LEN_2K				(2048)

#endif
