// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Microsoft.CodeAnalysis;

namespace Microsoft.AspNetCore.SignalR.Client.SourceGenerator;

internal static class GeneratorHelpers
{
    public static string GetAccessibilityString(Accessibility accessibility)
    {
        switch (accessibility)
        {
            case Accessibility.Private:
                return "private";
            case Accessibility.ProtectedAndInternal:
                return "protected internal";
            case Accessibility.Protected:
                return "protected";
            case Accessibility.Internal:
                return "internal";
            case Accessibility.Public:
                return "public";
            default:
                return null;
        }
    }

    public static string SourceFilePrefix()
    {
        return @"// <auto-generated>
// Generated by Microsoft.AspNetCore.Client.SourceGenerator
// </auto-generated>
#nullable enable
";
    }
}
