% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer.R
\docType{class}
\name{buffer}
\alias{buffer}
\alias{Buffer}
\title{Buffer class}
\usage{
buffer(x)
}
\arguments{
\item{x}{R object. Only raw, numeric and integer vectors are currently supported}
}
\value{
an instance of \code{Buffer} that borrows memory from \code{x}
}
\description{
A Buffer is an object containing a pointer to a piece of
contiguous memory with a particular size.
}
\section{Factory}{

\code{buffer()} lets you create an \code{arrow::Buffer} from an R object
}

\section{Methods}{

\itemize{
\item \verb{$is_mutable} : is this buffer mutable?
\item \verb{$ZeroPadding()} : zero bytes in padding, i.e. bytes between size and capacity
\item \verb{$size} : size in memory, in bytes
\item \verb{$capacity}: possible capacity, in bytes
}
}

\examples{
\dontshow{if (arrow_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
my_buffer <- buffer(c(1, 2, 3, 4))
my_buffer$is_mutable
my_buffer$ZeroPadding()
my_buffer$size
my_buffer$capacity
\dontshow{\}) # examplesIf}
}
