/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Milo Yip
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copied from https://github.com/miloyip/nativejson-benchmark.git
 */

static const char test_json1[] =
"{\n"
"  \"statuses\": [\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:15 +0000 2014\",\n"
"      \"id\": 505874924095815700,\n"
"      \"id_str\": \"505874924095815681\",\n"
"      \"text\": \"@aym0566x \\n\\n名前:前田あゆみ\\n第一印象:なんか怖っ！\\n今の印象:とりあえずキモい。噛み合わない\\n好きなところ:ぶすでキモいとこ😋✨✨\\n思い出:んーーー、ありすぎ😊❤️\\nLINE交換できる？:あぁ……ごめん✋\\nトプ画をみて:照れますがな😘✨\\n一言:お前は一生もんのダチ💖\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": 866260188,\n"
"      \"in_reply_to_user_id_str\": \"866260188\",\n"
"      \"in_reply_to_screen_name\": \"aym0566x\",\n"
"      \"user\": {\n"
"        \"id\": 1186275104,\n"
"        \"id_str\": \"1186275104\",\n"
"        \"name\": \"AYUMI\",\n"
"        \"screen_name\": \"ayuu0123\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"元野球部マネージャー❤︎…最高の夏をありがとう…❤︎\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 262,\n"
"        \"friends_count\": 252,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Feb 16 13:40:25 +0000 2013\",\n"
"        \"favourites_count\": 235,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 1769,\n"
"        \"lang\": \"en\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/497760886795153410/LDjAwR_y_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/497760886795153410/LDjAwR_y_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1186275104/1409318784\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"aym0566x\",\n"
"            \"name\": \"前田あゆみ\",\n"
"            \"id\": 866260188,\n"
"            \"id_str\": \"866260188\",\n"
"            \"indices\": [\n"
"              0,\n"
"              9\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:14 +0000 2014\",\n"
"      \"id\": 505874922023837700,\n"
"      \"id_str\": \"505874922023837696\",\n"
"      \"text\": \"RT @KATANA77: えっそれは・・・（一同） http://t.co/PkCJAcSuYK\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 903487807,\n"
"        \"id_str\": \"903487807\",\n"
"        \"name\": \"RT&ファボ魔のむっつんさっm\",\n"
"        \"screen_name\": \"yuttari1998\",\n"
"        \"location\": \"関西    ↓詳しいプロ↓\",\n"
"        \"description\": \"無言フォローはあまり好みません ゲームと動画が好きですシモ野郎ですがよろしく…最近はMGSとブレイブルー、音ゲーをプレイしてます\",\n"
"        \"url\": \"http://t.co/Yg9e1Fl8wd\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/Yg9e1Fl8wd\",\n"
"                \"expanded_url\": \"http://twpf.jp/yuttari1998\",\n"
"                \"display_url\": \"twpf.jp/yuttari1998\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 95,\n"
"        \"friends_count\": 158,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Thu Oct 25 08:27:13 +0000 2012\",\n"
"        \"favourites_count\": 3652,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 10276,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/500268849275494400/AoXHZ7Ij_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/500268849275494400/AoXHZ7Ij_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/903487807/1409062272\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 23:49:35 +0000 2014\",\n"
"        \"id\": 505864943636197400,\n"
"        \"id_str\": \"505864943636197376\",\n"
"        \"text\": \"えっそれは・・・（一同） http://t.co/PkCJAcSuYK\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com\\\" rel=\\\"nofollow\\\">Twitter Web Client</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 77915997,\n"
"          \"id_str\": \"77915997\",\n"
"          \"name\": \"(有)刀\",\n"
"          \"screen_name\": \"KATANA77\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"プリキュア好きのサラリーマンです。好きなプリキュアシリーズはハートキャッチ、最愛のキャラクターは月影ゆりさんです。 http://t.co/QMLJeFmfMTご質問、お問い合わせはこちら http://t.co/LU8T7vmU3h\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/QMLJeFmfMT\",\n"
"                  \"expanded_url\": \"http://www.pixiv.net/member.php?id=4776\",\n"
"                  \"display_url\": \"pixiv.net/member.php?id=…\",\n"
"                  \"indices\": [\n"
"                    58,\n"
"                    80\n"
"                  ]\n"
"                },\n"
"                {\n"
"                  \"url\": \"http://t.co/LU8T7vmU3h\",\n"
"                  \"expanded_url\": \"http://ask.fm/KATANA77\",\n"
"                  \"display_url\": \"ask.fm/KATANA77\",\n"
"                  \"indices\": [\n"
"                    95,\n"
"                    117\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 1095,\n"
"          \"friends_count\": 740,\n"
"          \"listed_count\": 50,\n"
"          \"created_at\": \"Mon Sep 28 03:41:27 +0000 2009\",\n"
"          \"favourites_count\": 3741,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Tokyo\",\n"
"          \"geo_enabled\": true,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 19059,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/808597451/45b82f887085d32bd4b87dfc348fe22a.png\",\n"
"          \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/808597451/45b82f887085d32bd4b87dfc348fe22a.png\",\n"
"          \"profile_background_tile\": true,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/480210114964504577/MjVIEMS4_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/480210114964504577/MjVIEMS4_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/77915997/1404661392\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": false,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 82,\n"
"        \"favorite_count\": 42,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": [],\n"
"          \"media\": [\n"
"            {\n"
"              \"id\": 505864942575034400,\n"
"              \"id_str\": \"505864942575034369\",\n"
"              \"indices\": [\n"
"                13,\n"
"                35\n"
"              ],\n"
"              \"media_url\": \"http://pbs.twimg.com/media/BwUxfC6CIAEr-Ye.jpg\",\n"
"              \"media_url_https\": \"https://pbs.twimg.com/media/BwUxfC6CIAEr-Ye.jpg\",\n"
"              \"url\": \"http://t.co/PkCJAcSuYK\",\n"
"              \"display_url\": \"pic.twitter.com/PkCJAcSuYK\",\n"
"              \"expanded_url\": \"http://twitter.com/KATANA77/status/505864943636197376/photo/1\",\n"
"              \"type\": \"photo\",\n"
"              \"sizes\": {\n"
"                \"medium\": {\n"
"                  \"w\": 600,\n"
"                  \"h\": 338,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"small\": {\n"
"                  \"w\": 340,\n"
"                  \"h\": 192,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"thumb\": {\n"
"                  \"w\": 150,\n"
"                  \"h\": 150,\n"
"                  \"resize\": \"crop\"\n"
"                },\n"
"                \"large\": {\n"
"                  \"w\": 765,\n"
"                  \"h\": 432,\n"
"                  \"resize\": \"fit\"\n"
"                }\n"
"              }\n"
"            }\n"
"          ]\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 82,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"KATANA77\",\n"
"            \"name\": \"(有)刀\",\n"
"            \"id\": 77915997,\n"
"            \"id_str\": \"77915997\",\n"
"            \"indices\": [\n"
"              3,\n"
"              12\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"media\": [\n"
"          {\n"
"            \"id\": 505864942575034400,\n"
"            \"id_str\": \"505864942575034369\",\n"
"            \"indices\": [\n"
"              27,\n"
"              49\n"
"            ],\n"
"            \"media_url\": \"http://pbs.twimg.com/media/BwUxfC6CIAEr-Ye.jpg\",\n"
"            \"media_url_https\": \"https://pbs.twimg.com/media/BwUxfC6CIAEr-Ye.jpg\",\n"
"            \"url\": \"http://t.co/PkCJAcSuYK\",\n"
"            \"display_url\": \"pic.twitter.com/PkCJAcSuYK\",\n"
"            \"expanded_url\": \"http://twitter.com/KATANA77/status/505864943636197376/photo/1\",\n"
"            \"type\": \"photo\",\n"
"            \"sizes\": {\n"
"              \"medium\": {\n"
"                \"w\": 600,\n"
"                \"h\": 338,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"small\": {\n"
"                \"w\": 340,\n"
"                \"h\": 192,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"thumb\": {\n"
"                \"w\": 150,\n"
"                \"h\": 150,\n"
"                \"resize\": \"crop\"\n"
"              },\n"
"              \"large\": {\n"
"                \"w\": 765,\n"
"                \"h\": 432,\n"
"                \"resize\": \"fit\"\n"
"              }\n"
"            },\n"
"            \"source_status_id\": 505864943636197400,\n"
"            \"source_status_id_str\": \"505864943636197376\"\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:14 +0000 2014\",\n"
"      \"id\": 505874920140591100,\n"
"      \"id_str\": \"505874920140591104\",\n"
"      \"text\": \"@longhairxMIURA 朝一ライカス辛目だよw\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": 505874728897085440,\n"
"      \"in_reply_to_status_id_str\": \"505874728897085440\",\n"
"      \"in_reply_to_user_id\": 114188950,\n"
"      \"in_reply_to_user_id_str\": \"114188950\",\n"
"      \"in_reply_to_screen_name\": \"longhairxMIURA\",\n"
"      \"user\": {\n"
"        \"id\": 114786346,\n"
"        \"id_str\": \"114786346\",\n"
"        \"name\": \"PROTECT-T\",\n"
"        \"screen_name\": \"ttm_protect\",\n"
"        \"location\": \"静岡県長泉町\",\n"
"        \"description\": \"24 / XXX / @andprotector / @lifefocus0545 potato design works\",\n"
"        \"url\": \"http://t.co/5EclbQiRX4\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/5EclbQiRX4\",\n"
"                \"expanded_url\": \"http://ap.furtherplatonix.net/index.html\",\n"
"                \"display_url\": \"ap.furtherplatonix.net/index.html\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 1387,\n"
"        \"friends_count\": 903,\n"
"        \"listed_count\": 25,\n"
"        \"created_at\": \"Tue Feb 16 16:13:41 +0000 2010\",\n"
"        \"favourites_count\": 492,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Osaka\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 12679,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/481360383253295104/4B9Rcfys_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/481360383253295104/4B9Rcfys_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/114786346/1403600232\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"longhairxMIURA\",\n"
"            \"name\": \"miura desu\",\n"
"            \"id\": 114188950,\n"
"            \"id_str\": \"114188950\",\n"
"            \"indices\": [\n"
"              0,\n"
"              15\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:14 +0000 2014\",\n"
"      \"id\": 505874919020699650,\n"
"      \"id_str\": \"505874919020699648\",\n"
"      \"text\": \"RT @omo_kko: ラウワン脱出→友達が家に連んで帰ってって言うから友達ん家に乗せて帰る(1度も行ったことない田舎道)→友達おろして迷子→500メートルくらい続く変な一本道進む→墓地で行き止まりでUターン出来ずバックで500メートル元のところまで進まないといけない←今ここ\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 392585658,\n"
"        \"id_str\": \"392585658\",\n"
"        \"name\": \"原稿\",\n"
"        \"screen_name\": \"chibu4267\",\n"
"        \"location\": \"キミの部屋の燃えるゴミ箱\",\n"
"        \"description\": \"RTしてTLに濁流を起こすからフォローしない方が良いよ 言ってることもつまらないし 詳細→http://t.co/ANSFlYXERJ 相方@1life_5106_hshd 葛西教徒その壱\",\n"
"        \"url\": \"http://t.co/JTFjV89eaN\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/JTFjV89eaN\",\n"
"                \"expanded_url\": \"http://www.pixiv.net/member.php?id=1778417\",\n"
"                \"display_url\": \"pixiv.net/member.php?id=…\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/ANSFlYXERJ\",\n"
"                \"expanded_url\": \"http://twpf.jp/chibu4267\",\n"
"                \"display_url\": \"twpf.jp/chibu4267\",\n"
"                \"indices\": [\n"
"                  45,\n"
"                  67\n"
"                ]\n"
"              }\n"
"            ]\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 1324,\n"
"        \"friends_count\": 1165,\n"
"        \"listed_count\": 99,\n"
"        \"created_at\": \"Mon Oct 17 08:23:46 +0000 2011\",\n"
"        \"favourites_count\": 9542,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Tokyo\",\n"
"        \"geo_enabled\": true,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 369420,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/453106940822814720/PcJIZv43.png\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/453106940822814720/PcJIZv43.png\",\n"
"        \"profile_background_tile\": true,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/505731759216943107/pzhnkMEg_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/505731759216943107/pzhnkMEg_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/392585658/1362383911\",\n"
"        \"profile_link_color\": \"5EB9FF\",\n"
"        \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 16:51:09 +0000 2014\",\n"
"        \"id\": 505759640164892700,\n"
"        \"id_str\": \"505759640164892673\",\n"
"        \"text\": \"ラウワン脱出→友達が家に連んで帰ってって言うから友達ん家に乗せて帰る(1度も行ったことない田舎道)→友達おろして迷子→500メートルくらい続く変な一本道進む→墓地で行き止まりでUターン出来ずバックで500メートル元のところまで進まないといけない←今ここ\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 309565423,\n"
"          \"id_str\": \"309565423\",\n"
"          \"name\": \"おもっこ\",\n"
"          \"screen_name\": \"omo_kko\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"ぱんすと\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 730,\n"
"          \"friends_count\": 200,\n"
"          \"listed_count\": 23,\n"
"          \"created_at\": \"Thu Jun 02 09:15:51 +0000 2011\",\n"
"          \"favourites_count\": 5441,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Tokyo\",\n"
"          \"geo_enabled\": true,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 30012,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/499126939378929664/GLWpIKTW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/499126939378929664/GLWpIKTW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/309565423/1409418370\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 67,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"omo_kko\",\n"
"            \"name\": \"おもっこ\",\n"
"            \"id\": 309565423,\n"
"            \"id_str\": \"309565423\",\n"
"            \"indices\": [\n"
"              3,\n"
"              11\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:13 +0000 2014\",\n"
"      \"id\": 505874918198624260,\n"
"      \"id_str\": \"505874918198624256\",\n"
"      \"text\": \"RT @thsc782_407: #LEDカツカツ選手権\\n漢字一文字ぶんのスペースに「ハウステンボス」を収める狂気 http://t.co/vmrreDMziI\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 753161754,\n"
"        \"id_str\": \"753161754\",\n"
"        \"name\": \"ねこねこみかん＊\",\n"
"        \"screen_name\": \"nekonekomikan\",\n"
"        \"location\": \"ソーダ水のあふれるビンの中\",\n"
"        \"description\": \"猫×6、大学・高校・旦那各1と暮らしています。猫、子供、日常思った事をつぶやいています／今年の目標：読書、庭の手入れ、ランニング、手芸／猫＊花＊写真＊詩＊林ももこさん＊鉄道など好きな方をフォローさせていただいています。よろしくお願いします♬\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 217,\n"
"        \"friends_count\": 258,\n"
"        \"listed_count\": 8,\n"
"        \"created_at\": \"Sun Aug 12 14:00:47 +0000 2012\",\n"
"        \"favourites_count\": 7650,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Tokyo\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 20621,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/470627990271848448/m83uy6Vc_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/470627990271848448/m83uy6Vc_normal.jpeg\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Fri Feb 28 16:04:13 +0000 2014\",\n"
"        \"id\": 439430848190742500,\n"
"        \"id_str\": \"439430848190742528\",\n"
"        \"text\": \"#LEDカツカツ選手権\\n漢字一文字ぶんのスペースに「ハウステンボス」を収める狂気 http://t.co/vmrreDMziI\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com\\\" rel=\\\"nofollow\\\">Twitter Web Client</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 82900665,\n"
"          \"id_str\": \"82900665\",\n"
"          \"name\": \"[90]青葉台  芦 (第二粟屋) 屋\",\n"
"          \"screen_name\": \"thsc782_407\",\n"
"          \"location\": \"かんましき\",\n"
"          \"description\": \"湯の街の元勃酩姦なんちゃら大　赤い犬の犬（外資系）　肥後で緑ナンバー屋さん勤め\\nくだらないことしかつぶやかないし、いちいち訳のわからない記号を連呼するので相当邪魔になると思います。害はないと思います。のりものの画像とかたくさん上げます。さみしい。車輪のついたものならだいたい好き。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 587,\n"
"          \"friends_count\": 623,\n"
"          \"listed_count\": 30,\n"
"          \"created_at\": \"Fri Oct 16 15:13:32 +0000 2009\",\n"
"          \"favourites_count\": 1405,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Tokyo\",\n"
"          \"geo_enabled\": true,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 60427,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"352726\",\n"
"          \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/154137819/__813-1103.jpg\",\n"
"          \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/154137819/__813-1103.jpg\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/493760276676620289/32oLiTtT_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/493760276676620289/32oLiTtT_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/82900665/1398865798\",\n"
"          \"profile_link_color\": \"D02B55\",\n"
"          \"profile_sidebar_border_color\": \"829D5E\",\n"
"          \"profile_sidebar_fill_color\": \"99CC33\",\n"
"          \"profile_text_color\": \"3E4415\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": false,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 3291,\n"
"        \"favorite_count\": 1526,\n"
"        \"entities\": {\n"
"          \"hashtags\": [\n"
"            {\n"
"              \"text\": \"LEDカツカツ選手権\",\n"
"              \"indices\": [\n"
"                0,\n"
"                11\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": [],\n"
"          \"media\": [\n"
"            {\n"
"              \"id\": 439430848194936800,\n"
"              \"id_str\": \"439430848194936832\",\n"
"              \"indices\": [\n"
"                41,\n"
"                63\n"
"              ],\n"
"              \"media_url\": \"http://pbs.twimg.com/media/BhksBzoCAAAJeDS.jpg\",\n"
"              \"media_url_https\": \"https://pbs.twimg.com/media/BhksBzoCAAAJeDS.jpg\",\n"
"              \"url\": \"http://t.co/vmrreDMziI\",\n"
"              \"display_url\": \"pic.twitter.com/vmrreDMziI\",\n"
"              \"expanded_url\": \"http://twitter.com/thsc782_407/status/439430848190742528/photo/1\",\n"
"              \"type\": \"photo\",\n"
"              \"sizes\": {\n"
"                \"medium\": {\n"
"                  \"w\": 600,\n"
"                  \"h\": 450,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"large\": {\n"
"                  \"w\": 1024,\n"
"                  \"h\": 768,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"thumb\": {\n"
"                  \"w\": 150,\n"
"                  \"h\": 150,\n"
"                  \"resize\": \"crop\"\n"
"                },\n"
"                \"small\": {\n"
"                  \"w\": 340,\n"
"                  \"h\": 255,\n"
"                  \"resize\": \"fit\"\n"
"                }\n"
"              }\n"
"            }\n"
"          ]\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 3291,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [\n"
"          {\n"
"            \"text\": \"LEDカツカツ選手権\",\n"
"            \"indices\": [\n"
"              17,\n"
"              28\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"thsc782_407\",\n"
"            \"name\": \"[90]青葉台  芦 (第二粟屋) 屋\",\n"
"            \"id\": 82900665,\n"
"            \"id_str\": \"82900665\",\n"
"            \"indices\": [\n"
"              3,\n"
"              15\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"media\": [\n"
"          {\n"
"            \"id\": 439430848194936800,\n"
"            \"id_str\": \"439430848194936832\",\n"
"            \"indices\": [\n"
"              58,\n"
"              80\n"
"            ],\n"
"            \"media_url\": \"http://pbs.twimg.com/media/BhksBzoCAAAJeDS.jpg\",\n"
"            \"media_url_https\": \"https://pbs.twimg.com/media/BhksBzoCAAAJeDS.jpg\",\n"
"            \"url\": \"http://t.co/vmrreDMziI\",\n"
"            \"display_url\": \"pic.twitter.com/vmrreDMziI\",\n"
"            \"expanded_url\": \"http://twitter.com/thsc782_407/status/439430848190742528/photo/1\",\n"
"            \"type\": \"photo\",\n"
"            \"sizes\": {\n"
"              \"medium\": {\n"
"                \"w\": 600,\n"
"                \"h\": 450,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"large\": {\n"
"                \"w\": 1024,\n"
"                \"h\": 768,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"thumb\": {\n"
"                \"w\": 150,\n"
"                \"h\": 150,\n"
"                \"resize\": \"crop\"\n"
"              },\n"
"              \"small\": {\n"
"                \"w\": 340,\n"
"                \"h\": 255,\n"
"                \"resize\": \"fit\"\n"
"              }\n"
"            },\n"
"            \"source_status_id\": 439430848190742500,\n"
"            \"source_status_id_str\": \"439430848190742528\"\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:13 +0000 2014\",\n"
"      \"id\": 505874918039228400,\n"
"      \"id_str\": \"505874918039228416\",\n"
"      \"text\": \"【金一地区太鼓台】川関と小山の見分けがつかない\",\n"
"      \"source\": \"<a href=\\\"http://twittbot.net/\\\" rel=\\\"nofollow\\\">twittbot.net</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2530194984,\n"
"        \"id_str\": \"2530194984\",\n"
"        \"name\": \"川之江中高生あるある\",\n"
"        \"screen_name\": \"kw_aru\",\n"
"        \"location\": \"DMにてネタ提供待ってますよ\",\n"
"        \"description\": \"川之江中高生の川之江中高生による川之江中高生のためのあるあるアカウントです。タイムリーなネタはお気に入りにあります。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 113,\n"
"        \"friends_count\": 157,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Wed May 28 15:01:43 +0000 2014\",\n"
"        \"favourites_count\": 30,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 4472,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/471668359314948097/XbIyXiZK_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/471668359314948097/XbIyXiZK_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2530194984/1401289473\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:13 +0000 2014\",\n"
"      \"id\": 505874915338104800,\n"
"      \"id_str\": \"505874915338104833\",\n"
"      \"text\": \"おはようございますん♪ SSDSのDVDが朝一で届いた〜（≧∇≦）\",\n"
"      \"source\": \"<a href=\\\"http://tweetli.st/\\\" rel=\\\"nofollow\\\">TweetList!</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 428179337,\n"
"        \"id_str\": \"428179337\",\n"
"        \"name\": \"サラ\",\n"
"        \"screen_name\": \"sala_mgn\",\n"
"        \"location\": \"東京都\",\n"
"        \"description\": \"bot遊びと実況が主目的の趣味アカウント。成人済♀。時々TLお騒がせします。リフォ率低いですがＦ／Ｂご自由に。スパムはブロック！[HOT]K[アニメ]タイバニ/Ｋ/薄桜鬼/トライガン/進撃[小説]冲方丁/森博嗣[漫画]内藤泰弘/高河ゆん[他]声優/演劇 ※@sano_bot1二代目管理人\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 104,\n"
"        \"friends_count\": 421,\n"
"        \"listed_count\": 2,\n"
"        \"created_at\": \"Sun Dec 04 12:51:18 +0000 2011\",\n"
"        \"favourites_count\": 3257,\n"
"        \"utc_offset\": -36000,\n"
"        \"time_zone\": \"Hawaii\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 25303,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"1A1B1F\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/601682567/put73jtg48ytjylq00if.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/601682567/put73jtg48ytjylq00if.jpeg\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/3350624721/755920942e4f512e6ba489df7eb1147e_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/3350624721/755920942e4f512e6ba489df7eb1147e_normal.jpeg\",\n"
"        \"profile_link_color\": \"2FC2EF\",\n"
"        \"profile_sidebar_border_color\": \"181A1E\",\n"
"        \"profile_sidebar_fill_color\": \"252429\",\n"
"        \"profile_text_color\": \"666666\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:13 +0000 2014\",\n"
"      \"id\": 505874914897690600,\n"
"      \"id_str\": \"505874914897690624\",\n"
"      \"text\": \"@ran_kirazuki そのようなお言葉を頂けるとは……！この雨太郎、誠心誠意を持って姉御の足の指の第一関節を崇め奉りとうございます\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": 505874276692406300,\n"
"      \"in_reply_to_status_id_str\": \"505874276692406272\",\n"
"      \"in_reply_to_user_id\": 531544559,\n"
"      \"in_reply_to_user_id_str\": \"531544559\",\n"
"      \"in_reply_to_screen_name\": \"ran_kirazuki\",\n"
"      \"user\": {\n"
"        \"id\": 2364828518,\n"
"        \"id_str\": \"2364828518\",\n"
"        \"name\": \"雨\",\n"
"        \"screen_name\": \"tear_dice\",\n"
"        \"location\": \"変態/日常/創作/室町/たまに版権\",\n"
"        \"description\": \"アイコンは兄さんから！\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 28,\n"
"        \"friends_count\": 28,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Fri Feb 28 00:28:40 +0000 2014\",\n"
"        \"favourites_count\": 109,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Seoul\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 193,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"000000\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/504434510675443713/lvW7ad5b.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/504434510675443713/lvW7ad5b.jpeg\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/505170142284640256/rnW4XeEJ_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/505170142284640256/rnW4XeEJ_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2364828518/1409087198\",\n"
"        \"profile_link_color\": \"0D31BF\",\n"
"        \"profile_sidebar_border_color\": \"000000\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"ran_kirazuki\",\n"
"            \"name\": \"蘭ぴよの日常\",\n"
"            \"id\": 531544559,\n"
"            \"id_str\": \"531544559\",\n"
"            \"indices\": [\n"
"              0,\n"
"              13\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:13 +0000 2014\",\n"
"      \"id\": 505874914591514600,\n"
"      \"id_str\": \"505874914591514626\",\n"
"      \"text\": \"RT @AFmbsk: @samao21718 \\n呼び方☞まおちゃん\\n呼ばれ方☞あーちゃん\\n第一印象☞平野から？！\\n今の印象☞おとなっぽい！！\\nLINE交換☞もってるん\\\\( ˆoˆ )/\\nトプ画について☞楽しそうでいーな😳\\n家族にするなら☞おねぇちゃん\\n最後に一言☞全然会えない…\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2179759316,\n"
"        \"id_str\": \"2179759316\",\n"
"        \"name\": \"まお\",\n"
"        \"screen_name\": \"samao21718\",\n"
"        \"location\": \"埼玉  UK留学してました✈\",\n"
"        \"description\": \"ﾟ.＊97line おさらに貢いでる系女子＊.゜                                   DISH// ✯ 佐野悠斗 ✯ 読モ ✯ WEGO ✯ 嵐                                I met @OTYOfficial in the London ;)\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 111,\n"
"        \"friends_count\": 121,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Nov 07 09:47:41 +0000 2013\",\n"
"        \"favourites_count\": 321,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 1777,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501535615351926784/c5AAh6Sz_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501535615351926784/c5AAh6Sz_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2179759316/1407640217\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 14:59:49 +0000 2014\",\n"
"        \"id\": 505731620456771600,\n"
"        \"id_str\": \"505731620456771584\",\n"
"        \"text\": \"@samao21718 \\n呼び方☞まおちゃん\\n呼ばれ方☞あーちゃん\\n第一印象☞平野から？！\\n今の印象☞おとなっぽい！！\\nLINE交換☞もってるん\\\\( ˆoˆ )/\\nトプ画について☞楽しそうでいーな😳\\n家族にするなら☞おねぇちゃん\\n最後に一言☞全然会えないねー今度会えたらいいな！\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": 2179759316,\n"
"        \"in_reply_to_user_id_str\": \"2179759316\",\n"
"        \"in_reply_to_screen_name\": \"samao21718\",\n"
"        \"user\": {\n"
"          \"id\": 1680668713,\n"
"          \"id_str\": \"1680668713\",\n"
"          \"name\": \"★Shiiiii!☆\",\n"
"          \"screen_name\": \"AFmbsk\",\n"
"          \"location\": \"埼玉\",\n"
"          \"description\": \"2310*basketball#41*UVERworld*Pooh☪Bell +.｡*弱さを知って強くなれ*ﾟ\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 429,\n"
"          \"friends_count\": 434,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Sun Aug 18 12:45:00 +0000 2013\",\n"
"          \"favourites_count\": 2488,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 6352,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/504643170886365185/JN_dlwUd_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/504643170886365185/JN_dlwUd_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1680668713/1408805886\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 1,\n"
"        \"favorite_count\": 1,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": [\n"
"            {\n"
"              \"screen_name\": \"samao21718\",\n"
"              \"name\": \"まお\",\n"
"              \"id\": 2179759316,\n"
"              \"id_str\": \"2179759316\",\n"
"              \"indices\": [\n"
"                0,\n"
"                11\n"
"              ]\n"
"            }\n"
"          ]\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 1,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"AFmbsk\",\n"
"            \"name\": \"★Shiiiii!☆\",\n"
"            \"id\": 1680668713,\n"
"            \"id_str\": \"1680668713\",\n"
"            \"indices\": [\n"
"              3,\n"
"              10\n"
"            ]\n"
"          },\n"
"          {\n"
"            \"screen_name\": \"samao21718\",\n"
"            \"name\": \"まお\",\n"
"            \"id\": 2179759316,\n"
"            \"id_str\": \"2179759316\",\n"
"            \"indices\": [\n"
"              12,\n"
"              23\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:10 +0000 2014\",\n"
"      \"id\": 505874905712189440,\n"
"      \"id_str\": \"505874905712189440\",\n"
"      \"text\": \"一、常に身一つ簡素にして、美食を好んではならない\",\n"
"      \"source\": \"<a href=\\\"http://twittbot.net/\\\" rel=\\\"nofollow\\\">twittbot.net</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1330420010,\n"
"        \"id_str\": \"1330420010\",\n"
"        \"name\": \"獨行道bot\",\n"
"        \"screen_name\": \"dokkodo_bot\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"宮本武蔵の自誓書、「獨行道」に記された二十一箇条をランダムにつぶやくbotです。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 4,\n"
"        \"friends_count\": 5,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Sat Apr 06 01:19:55 +0000 2013\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 9639,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/3482551671/d9e749f7658b523bdd50b7584ed4ba6a_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/3482551671/d9e749f7658b523bdd50b7584ed4ba6a_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1330420010/1365212335\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:10 +0000 2014\",\n"
"      \"id\": 505874903094939650,\n"
"      \"id_str\": \"505874903094939648\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/mote_danshi1\\\" rel=\\\"nofollow\\\">モテモテ大作戦★男子編</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2714526565,\n"
"        \"id_str\": \"2714526565\",\n"
"        \"name\": \"モテモテ大作戦★男子編\",\n"
"        \"screen_name\": \"mote_danshi1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"やっぱりモテモテ男子になりたい！自分を磨くヒントをみつけたい！応援してくれる人は RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 664,\n"
"        \"friends_count\": 1835,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Aug 07 12:59:59 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 597,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/497368689386086400/7hqdKMzG_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/497368689386086400/7hqdKMzG_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2714526565/1407416898\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:10 +0000 2014\",\n"
"      \"id\": 505874902390276100,\n"
"      \"id_str\": \"505874902390276096\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/kokoro_meigen11\\\" rel=\\\"nofollow\\\">心に響くアツい名言集</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2699261263,\n"
"        \"id_str\": \"2699261263\",\n"
"        \"name\": \"心に響くアツい名言集\",\n"
"        \"screen_name\": \"kokoro_meigen11\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"人生の格言は、人の心や人生を瞬時にに動かしてしまうことがある。\\r\\nそんな言葉の重みを味わおう。\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 183,\n"
"        \"friends_count\": 1126,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Fri Aug 01 22:00:00 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 749,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495328654126112768/1rKnNuWK_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495328654126112768/1rKnNuWK_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2699261263/1406930543\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:10 +0000 2014\",\n"
"      \"id\": 505874902247677950,\n"
"      \"id_str\": \"505874902247677954\",\n"
"      \"text\": \"RT @POTENZA_SUPERGT: ありがとうございます！“@8CBR8: @POTENZA_SUPERGT 13時半ごろ一雨きそうですが、無事全車決勝レース完走出来ること祈ってます！ http://t.co/FzTyFnt9xH”\",\n"
"      \"source\": \"<a href=\\\"http://jigtwi.jp/?p=1\\\" rel=\\\"nofollow\\\">jigtwi</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1021030416,\n"
"        \"id_str\": \"1021030416\",\n"
"        \"name\": \"narur\",\n"
"        \"screen_name\": \"narur2\",\n"
"        \"location\": \"晴れの国なのに何故か開幕戦では雨や雪や冰や霰が降る✨\",\n"
"        \"description\": \"F1.GP2.Superformula.SuperGT.F3...\\nスーパーGTが大好き♡車が好き！新幹線も好き！飛行機も好き！こっそり別アカです(๑´ㅂ`๑)♡*.+゜\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 257,\n"
"        \"friends_count\": 237,\n"
"        \"listed_count\": 2,\n"
"        \"created_at\": \"Wed Dec 19 01:14:41 +0000 2012\",\n"
"        \"favourites_count\": 547,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 55417,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/462180217574789121/1Jf6m_2L.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/462180217574789121/1Jf6m_2L.jpeg\",\n"
"        \"profile_background_tile\": true,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/444312241395863552/FKl40ebQ_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/444312241395863552/FKl40ebQ_normal.jpeg\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:05:11 +0000 2014\",\n"
"        \"id\": 505868866686169100,\n"
"        \"id_str\": \"505868866686169089\",\n"
"        \"text\": \"ありがとうございます！“@8CBR8: @POTENZA_SUPERGT 13時半ごろ一雨きそうですが、無事全車決勝レース完走出来ること祈ってます！ http://t.co/FzTyFnt9xH”\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": 505868690588303360,\n"
"        \"in_reply_to_status_id_str\": \"505868690588303360\",\n"
"        \"in_reply_to_user_id\": 333344408,\n"
"        \"in_reply_to_user_id_str\": \"333344408\",\n"
"        \"in_reply_to_screen_name\": \"8CBR8\",\n"
"        \"user\": {\n"
"          \"id\": 359324738,\n"
"          \"id_str\": \"359324738\",\n"
"          \"name\": \"POTENZA_SUPERGT\",\n"
"          \"screen_name\": \"POTENZA_SUPERGT\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"ブリヂストンのスポーツタイヤ「POTENZA」のアカウントです。レースやタイヤの事などをつぶやきます。今シーズンも「チャンピオンタイヤの称号は譲らない」をキャッチコピーに、タイヤ供給チームを全力でサポートしていきますので、応援よろしくお願いします！なお、返信ができない場合もありますので、ご了承よろしくお願い致します。\",\n"
"          \"url\": \"http://t.co/LruVPk5x4K\",\n"
"          \"entities\": {\n"
"            \"url\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/LruVPk5x4K\",\n"
"                  \"expanded_url\": \"http://www.bridgestone.co.jp/sc/potenza/\",\n"
"                  \"display_url\": \"bridgestone.co.jp/sc/potenza/\",\n"
"                  \"indices\": [\n"
"                    0,\n"
"                    22\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            },\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 9612,\n"
"          \"friends_count\": 308,\n"
"          \"listed_count\": 373,\n"
"          \"created_at\": \"Sun Aug 21 11:33:38 +0000 2011\",\n"
"          \"favourites_count\": 26,\n"
"          \"utc_offset\": -36000,\n"
"          \"time_zone\": \"Hawaii\",\n"
"          \"geo_enabled\": true,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 10032,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"131516\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme14/bg.gif\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme14/bg.gif\",\n"
"          \"profile_background_tile\": true,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/1507885396/TW_image_normal.jpg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/1507885396/TW_image_normal.jpg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/359324738/1402546267\",\n"
"          \"profile_link_color\": \"FF2424\",\n"
"          \"profile_sidebar_border_color\": \"EEEEEE\",\n"
"          \"profile_sidebar_fill_color\": \"EFEFEF\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": false,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 7,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": [\n"
"            {\n"
"              \"screen_name\": \"8CBR8\",\n"
"              \"name\": \"CBR Rider #17 KEIHIN\",\n"
"              \"id\": 333344408,\n"
"              \"id_str\": \"333344408\",\n"
"              \"indices\": [\n"
"                12,\n"
"                18\n"
"              ]\n"
"            },\n"
"            {\n"
"              \"screen_name\": \"POTENZA_SUPERGT\",\n"
"              \"name\": \"POTENZA_SUPERGT\",\n"
"              \"id\": 359324738,\n"
"              \"id_str\": \"359324738\",\n"
"              \"indices\": [\n"
"                20,\n"
"                36\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"media\": [\n"
"            {\n"
"              \"id\": 505868690252779500,\n"
"              \"id_str\": \"505868690252779521\",\n"
"              \"indices\": [\n"
"                75,\n"
"                97\n"
"              ],\n"
"              \"media_url\": \"http://pbs.twimg.com/media/BwU05MGCUAEY6Wu.jpg\",\n"
"              \"media_url_https\": \"https://pbs.twimg.com/media/BwU05MGCUAEY6Wu.jpg\",\n"
"              \"url\": \"http://t.co/FzTyFnt9xH\",\n"
"              \"display_url\": \"pic.twitter.com/FzTyFnt9xH\",\n"
"              \"expanded_url\": \"http://twitter.com/8CBR8/status/505868690588303360/photo/1\",\n"
"              \"type\": \"photo\",\n"
"              \"sizes\": {\n"
"                \"medium\": {\n"
"                  \"w\": 600,\n"
"                  \"h\": 399,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"thumb\": {\n"
"                  \"w\": 150,\n"
"                  \"h\": 150,\n"
"                  \"resize\": \"crop\"\n"
"                },\n"
"                \"large\": {\n"
"                  \"w\": 1024,\n"
"                  \"h\": 682,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"small\": {\n"
"                  \"w\": 340,\n"
"                  \"h\": 226,\n"
"                  \"resize\": \"fit\"\n"
"                }\n"
"              },\n"
"              \"source_status_id\": 505868690588303360,\n"
"              \"source_status_id_str\": \"505868690588303360\"\n"
"            }\n"
"          ]\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 7,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"POTENZA_SUPERGT\",\n"
"            \"name\": \"POTENZA_SUPERGT\",\n"
"            \"id\": 359324738,\n"
"            \"id_str\": \"359324738\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          },\n"
"          {\n"
"            \"screen_name\": \"8CBR8\",\n"
"            \"name\": \"CBR Rider #17 KEIHIN\",\n"
"            \"id\": 333344408,\n"
"            \"id_str\": \"333344408\",\n"
"            \"indices\": [\n"
"              33,\n"
"              39\n"
"            ]\n"
"          },\n"
"          {\n"
"            \"screen_name\": \"POTENZA_SUPERGT\",\n"
"            \"name\": \"POTENZA_SUPERGT\",\n"
"            \"id\": 359324738,\n"
"            \"id_str\": \"359324738\",\n"
"            \"indices\": [\n"
"              41,\n"
"              57\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"media\": [\n"
"          {\n"
"            \"id\": 505868690252779500,\n"
"            \"id_str\": \"505868690252779521\",\n"
"            \"indices\": [\n"
"              96,\n"
"              118\n"
"            ],\n"
"            \"media_url\": \"http://pbs.twimg.com/media/BwU05MGCUAEY6Wu.jpg\",\n"
"            \"media_url_https\": \"https://pbs.twimg.com/media/BwU05MGCUAEY6Wu.jpg\",\n"
"            \"url\": \"http://t.co/FzTyFnt9xH\",\n"
"            \"display_url\": \"pic.twitter.com/FzTyFnt9xH\",\n"
"            \"expanded_url\": \"http://twitter.com/8CBR8/status/505868690588303360/photo/1\",\n"
"            \"type\": \"photo\",\n"
"            \"sizes\": {\n"
"              \"medium\": {\n"
"                \"w\": 600,\n"
"                \"h\": 399,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"thumb\": {\n"
"                \"w\": 150,\n"
"                \"h\": 150,\n"
"                \"resize\": \"crop\"\n"
"              },\n"
"              \"large\": {\n"
"                \"w\": 1024,\n"
"                \"h\": 682,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"small\": {\n"
"                \"w\": 340,\n"
"                \"h\": 226,\n"
"                \"resize\": \"fit\"\n"
"              }\n"
"            },\n"
"            \"source_status_id\": 505868690588303360,\n"
"            \"source_status_id_str\": \"505868690588303360\"\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:09 +0000 2014\",\n"
"      \"id\": 505874901689851900,\n"
"      \"id_str\": \"505874901689851904\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/danshi_honne1\\\" rel=\\\"nofollow\\\">ここだけの本音★男子編</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2762136439,\n"
"        \"id_str\": \"2762136439\",\n"
"        \"name\": \"ここだけの本音★男子編\",\n"
"        \"screen_name\": \"danshi_honne1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"思ってるけど言えない！でもホントは言いたいこと、実はいっぱいあるんです！ \\r\\nそんな男子の本音を、つぶやきます。 \\r\\nその気持わかるって人は RT & フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 101,\n"
"        \"friends_count\": 985,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 11:11:30 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 209,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503500282840354816/CEv8UMay_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503500282840354816/CEv8UMay_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2762136439/1408878822\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:09 +0000 2014\",\n"
"      \"id\": 505874900939046900,\n"
"      \"id_str\": \"505874900939046912\",\n"
"      \"text\": \"RT @UARROW_Y: ようかい体操第一を踊る国見英 http://t.co/SXoYWH98as\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2454426158,\n"
"        \"id_str\": \"2454426158\",\n"
"        \"name\": \"ぴかりん\",\n"
"        \"screen_name\": \"gncnToktTtksg\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"銀魂/黒バス/進撃/ハイキュー/BLEACH/うたプリ/鈴木達央さん/神谷浩史さん 気軽にフォローしてください（＾∇＾）✨\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 1274,\n"
"        \"friends_count\": 1320,\n"
"        \"listed_count\": 17,\n"
"        \"created_at\": \"Sun Apr 20 07:48:53 +0000 2014\",\n"
"        \"favourites_count\": 2314,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 5868,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/457788684146716672/KCOy0S75_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/457788684146716672/KCOy0S75_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2454426158/1409371302\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:45 +0000 2014\",\n"
"        \"id\": 505871779949051900,\n"
"        \"id_str\": \"505871779949051904\",\n"
"        \"text\": \"ようかい体操第一を踊る国見英 http://t.co/SXoYWH98as\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 1261662588,\n"
"          \"id_str\": \"1261662588\",\n"
"          \"name\": \"ゆう矢\",\n"
"          \"screen_name\": \"UARROW_Y\",\n"
"          \"location\": \"つくり出そう国影の波 広げよう国影の輪\",\n"
"          \"description\": \"HQ!! 成人済腐女子。日常ツイート多いです。赤葦京治夢豚クソツイ含みます注意。フォローをお考えの際はプロフご一読お願い致します。FRBお気軽に\",\n"
"          \"url\": \"http://t.co/LFX2XOzb0l\",\n"
"          \"entities\": {\n"
"            \"url\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/LFX2XOzb0l\",\n"
"                  \"expanded_url\": \"http://twpf.jp/UARROW_Y\",\n"
"                  \"display_url\": \"twpf.jp/UARROW_Y\",\n"
"                  \"indices\": [\n"
"                    0,\n"
"                    22\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            },\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 265,\n"
"          \"friends_count\": 124,\n"
"          \"listed_count\": 12,\n"
"          \"created_at\": \"Tue Mar 12 10:42:17 +0000 2013\",\n"
"          \"favourites_count\": 6762,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Tokyo\",\n"
"          \"geo_enabled\": true,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 55946,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/502095104618663937/IzuPYx3E_normal.png\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/502095104618663937/IzuPYx3E_normal.png\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1261662588/1408618604\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 29,\n"
"        \"favorite_count\": 54,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [\n"
"            {\n"
"              \"url\": \"http://t.co/SXoYWH98as\",\n"
"              \"expanded_url\": \"http://twitter.com/UARROW_Y/status/505871779949051904/photo/1\",\n"
"              \"display_url\": \"pic.twitter.com/SXoYWH98as\",\n"
"              \"indices\": [\n"
"                15,\n"
"                37\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 29,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/SXoYWH98as\",\n"
"            \"expanded_url\": \"http://twitter.com/UARROW_Y/status/505871779949051904/photo/1\",\n"
"            \"display_url\": \"pic.twitter.com/SXoYWH98as\",\n"
"            \"indices\": [\n"
"              29,\n"
"              51\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"UARROW_Y\",\n"
"            \"name\": \"ゆう矢\",\n"
"            \"id\": 1261662588,\n"
"            \"id_str\": \"1261662588\",\n"
"            \"indices\": [\n"
"              3,\n"
"              12\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:09 +0000 2014\",\n"
"      \"id\": 505874900561580000,\n"
"      \"id_str\": \"505874900561580032\",\n"
"      \"text\": \"今日は一高と三桜（・θ・）\\n光梨ちゃんに会えないかな〜\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1366375976,\n"
"        \"id_str\": \"1366375976\",\n"
"        \"name\": \"ゆいの\",\n"
"        \"screen_name\": \"yuino1006\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"さんおう 男バスマネ2ねん（＾ω＾）\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 270,\n"
"        \"friends_count\": 260,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Apr 20 07:02:08 +0000 2013\",\n"
"        \"favourites_count\": 1384,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Irkutsk\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 5202,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/505354401448349696/nxVFEQQ4_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/505354401448349696/nxVFEQQ4_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1366375976/1399989379\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:09 +0000 2014\",\n"
"      \"id\": 505874899324248060,\n"
"      \"id_str\": \"505874899324248064\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/kyoukan_aru\\\" rel=\\\"nofollow\\\">共感★絶対あるあるww</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2704420069,\n"
"        \"id_str\": \"2704420069\",\n"
"        \"name\": \"共感★絶対あるあるww\",\n"
"        \"screen_name\": \"kyoukan_aru\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"みんなにもわかってもらえる、あるあるを見つけたい。\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 857,\n"
"        \"friends_count\": 1873,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 03 15:50:40 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 682,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495960812670836737/1LqkoyvU_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495960812670836737/1LqkoyvU_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2704420069/1407081298\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:09 +0000 2014\",\n"
"      \"id\": 505874898493796350,\n"
"      \"id_str\": \"505874898493796352\",\n"
"      \"text\": \"RT @assam_house: 泉田新潟県知事は、東電の申請書提出を容認させられただけで、再稼働に必要な「同意」はまだ与えていません。今まで柏崎刈羽の再稼働を抑え続けてきた知事に、もう一踏ん張りをお願いする意見を送って下さい。全国の皆様、お願いします！\\nhttp://t.co…\",\n"
"      \"source\": \"<a href=\\\"http://jigtwi.jp/?p=1001\\\" rel=\\\"nofollow\\\">jigtwi for Android</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 960765968,\n"
"        \"id_str\": \"960765968\",\n"
"        \"name\": \"さち\",\n"
"        \"screen_name\": \"sachitaka_dears\",\n"
"        \"location\": \"宮城県\",\n"
"        \"description\": \"動物関連のアカウントです。サブアカウント@sachi_dears (さち ❷) もあります。『心あるものは皆、愛し愛されるために生まれてきた。そして愛情を感じながら生を全うするべきなんだ』\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 3212,\n"
"        \"friends_count\": 3528,\n"
"        \"listed_count\": 91,\n"
"        \"created_at\": \"Tue Nov 20 16:30:53 +0000 2012\",\n"
"        \"favourites_count\": 3180,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Irkutsk\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 146935,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/3659653229/5b698df67f5d105400e9077f5ea50e91_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/3659653229/5b698df67f5d105400e9077f5ea50e91_normal.png\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Tue Aug 19 11:00:53 +0000 2014\",\n"
"        \"id\": 501685228427964400,\n"
"        \"id_str\": \"501685228427964417\",\n"
"        \"text\": \"泉田新潟県知事は、東電の申請書提出を容認させられただけで、再稼働に必要な「同意」はまだ与えていません。今まで柏崎刈羽の再稼働を抑え続けてきた知事に、もう一踏ん張りをお願いする意見を送って下さい。全国の皆様、お願いします！\\nhttp://t.co/9oH5cgpy1q\",\n"
"        \"source\": \"<a href=\\\"http://twittbot.net/\\\" rel=\\\"nofollow\\\">twittbot.net</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 1104771276,\n"
"          \"id_str\": \"1104771276\",\n"
"          \"name\": \"アッサム山中（殺処分ゼロに一票）\",\n"
"          \"screen_name\": \"assam_house\",\n"
"          \"location\": \"新潟県柏崎市\",\n"
"          \"description\": \"アッサム山中の趣味用アカ。当分の間、選挙啓発用としても使っていきます。このアカウントがアッサム山中本人のものである事は @assam_yamanaka のプロフでご確認下さい。\\r\\n公選法に係る表示\\r\\n庶民新党 #脱原発 http://t.co/96UqoCo0oU\\r\\nonestep.revival@gmail.com\",\n"
"          \"url\": \"http://t.co/AEOCATaNZc\",\n"
"          \"entities\": {\n"
"            \"url\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/AEOCATaNZc\",\n"
"                  \"expanded_url\": \"http://www.assam-house.net/\",\n"
"                  \"display_url\": \"assam-house.net\",\n"
"                  \"indices\": [\n"
"                    0,\n"
"                    22\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            },\n"
"            \"description\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/96UqoCo0oU\",\n"
"                  \"expanded_url\": \"http://blog.assam-house.net/datsu-genpatsu/index.html\",\n"
"                  \"display_url\": \"blog.assam-house.net/datsu-genpatsu…\",\n"
"                  \"indices\": [\n"
"                    110,\n"
"                    132\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 2977,\n"
"          \"friends_count\": 3127,\n"
"          \"listed_count\": 64,\n"
"          \"created_at\": \"Sat Jan 19 22:10:13 +0000 2013\",\n"
"          \"favourites_count\": 343,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Irkutsk\",\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 18021,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/378800000067217575/e0a85b440429ff50430a41200327dcb8_normal.png\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/378800000067217575/e0a85b440429ff50430a41200327dcb8_normal.png\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1104771276/1408948288\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 2,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [\n"
"            {\n"
"              \"url\": \"http://t.co/9oH5cgpy1q\",\n"
"              \"expanded_url\": \"http://www.pref.niigata.lg.jp/kouhou/info.html\",\n"
"              \"display_url\": \"pref.niigata.lg.jp/kouhou/info.ht…\",\n"
"              \"indices\": [\n"
"                111,\n"
"                133\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 2,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/9oH5cgpy1q\",\n"
"            \"expanded_url\": \"http://www.pref.niigata.lg.jp/kouhou/info.html\",\n"
"            \"display_url\": \"pref.niigata.lg.jp/kouhou/info.ht…\",\n"
"            \"indices\": [\n"
"              139,\n"
"              140\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"assam_house\",\n"
"            \"name\": \"アッサム山中（殺処分ゼロに一票）\",\n"
"            \"id\": 1104771276,\n"
"            \"id_str\": \"1104771276\",\n"
"            \"indices\": [\n"
"              3,\n"
"              15\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:09 +0000 2014\",\n"
"      \"id\": 505874898468630500,\n"
"      \"id_str\": \"505874898468630528\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/osyare_pea\\\" rel=\\\"nofollow\\\">おしゃれ★ペアルック</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2708607692,\n"
"        \"id_str\": \"2708607692\",\n"
"        \"name\": \"おしゃれ★ペアルック\",\n"
"        \"screen_name\": \"osyare_pea\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"ラブラブ度がアップする、素敵なペアルックを見つけて紹介します♪ 気に入ったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 129,\n"
"        \"friends_count\": 1934,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 05 07:09:31 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 641,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496554257676382208/Zgg0bmNu_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496554257676382208/Zgg0bmNu_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2708607692/1407222776\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:08 +0000 2014\",\n"
"      \"id\": 505874897633951740,\n"
"      \"id_str\": \"505874897633951745\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/love_live55\\\" rel=\\\"nofollow\\\">LOVE ♥ ラブライブ</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2745389137,\n"
"        \"id_str\": \"2745389137\",\n"
"        \"name\": \"LOVE ♥ ラブライブ\",\n"
"        \"screen_name\": \"love_live55\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"とにかく「ラブライブが好きで～す♥」 \\r\\nラブライブファンには、たまらない内容ばかり集めています♪ \\r\\n気に入ったら RT & 相互フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 251,\n"
"        \"friends_count\": 969,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 15:45:40 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 348,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501757482448850944/x2uPpqRx_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501757482448850944/x2uPpqRx_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745389137/1408463342\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:08 +0000 2014\",\n"
"      \"id\": 505874896795086850,\n"
"      \"id_str\": \"505874896795086848\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/koisurudoress\\\" rel=\\\"nofollow\\\">恋する♡ドレスシリーズ</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2726346560,\n"
"        \"id_str\": \"2726346560\",\n"
"        \"name\": \"恋する♡ドレスシリーズ\",\n"
"        \"screen_name\": \"koisurudoress\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"どれもこれも、見ているだけで欲しくなっちゃう♪  \\r\\n特別な日に着る素敵なドレスを見つけたいです。  \\r\\n着てみたいと思ったら RT & フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 314,\n"
"        \"friends_count\": 1900,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 12 14:10:35 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 471,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/499199619465621504/fg7sVusT_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/499199619465621504/fg7sVusT_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2726346560/1407853688\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:08 +0000 2014\",\n"
"      \"id\": 505874895964626940,\n"
"      \"id_str\": \"505874895964626944\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/doubutuzukan\\\" rel=\\\"nofollow\\\">胸キュン♥動物図鑑</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2759192574,\n"
"        \"id_str\": \"2759192574\",\n"
"        \"name\": \"胸キュン♥動物図鑑\",\n"
"        \"screen_name\": \"doubutuzukan\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"ふとした表情に思わずキュンとしてしまう♪ \\r\\nそんな愛しの動物たちの写真を見つけます。 \\r\\n気に入ったら RT & フォローを、お願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 80,\n"
"        \"friends_count\": 959,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Sat Aug 23 15:47:36 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 219,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503211559552688128/Ej_bixna_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503211559552688128/Ej_bixna_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2759192574/1408809101\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:08 +0000 2014\",\n"
"      \"id\": 505874895079608300,\n"
"      \"id_str\": \"505874895079608320\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/disney_para\\\" rel=\\\"nofollow\\\">ディズニー★パラダイス</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2719228561,\n"
"        \"id_str\": \"2719228561\",\n"
"        \"name\": \"ディズニー★パラダイス\",\n"
"        \"screen_name\": \"disney_para\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"ディズニーのかわいい画像、ニュース情報、あるあるなどをお届けします♪\\r\\nディズニーファンは RT & フォローもお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 331,\n"
"        \"friends_count\": 1867,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Aug 09 12:01:32 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 540,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498076922488696832/Ti2AEuOT_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498076922488696832/Ti2AEuOT_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2719228561/1407585841\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:08 +0000 2014\",\n"
"      \"id\": 505874894135898100,\n"
"      \"id_str\": \"505874894135898112\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/nama_fuushi\\\" rel=\\\"nofollow\\\">生々しい風刺画</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2714772727,\n"
"        \"id_str\": \"2714772727\",\n"
"        \"name\": \"生々しい風刺画\",\n"
"        \"screen_name\": \"nama_fuushi\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"深い意味が込められた「生々しい風刺画」を見つけます。\\r\\n考えさせられたら RT & 相互フォローでみなさん、お願いします\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 298,\n"
"        \"friends_count\": 1902,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Thu Aug 07 15:04:45 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 595,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/497398363352875011/tS-5FPJB_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/497398363352875011/tS-5FPJB_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2714772727/1407424091\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874893347377150,\n"
"      \"id_str\": \"505874893347377152\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/arashi_suki1\\\" rel=\\\"nofollow\\\">嵐★大好きっ娘</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2721682579,\n"
"        \"id_str\": \"2721682579\",\n"
"        \"name\": \"嵐★大好きっ娘\",\n"
"        \"screen_name\": \"arashi_suki1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"なんだかんだ言って、やっぱり嵐が好きなんです♪\\r\\nいろいろ集めたいので、嵐好きな人に見てほしいです。\\r\\n気に入ったら RT & 相互フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 794,\n"
"        \"friends_count\": 1913,\n"
"        \"listed_count\": 2,\n"
"        \"created_at\": \"Sun Aug 10 13:43:56 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 504,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498465364733198336/RO6wupdc_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498465364733198336/RO6wupdc_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2721682579/1407678436\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874893154426900,\n"
"      \"id_str\": \"505874893154426881\",\n"
"      \"text\": \"RT @Takashi_Shiina: テレビで「成人男性のカロリー摂取量は1900kcal」とか言ってて、それはいままさに私がダイエットのために必死でキープしようとしている量で、「それが普通なら人はいつ天一やココイチに行って大盛りを食えばいいんだ！」と思った。\",\n"
"      \"source\": \"<a href=\\\"http://twicca.r246.jp/\\\" rel=\\\"nofollow\\\">twicca</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 353516742,\n"
"        \"id_str\": \"353516742\",\n"
"        \"name\": \"おしんこー＠土曜西え41a\",\n"
"        \"screen_name\": \"oshin_koko\",\n"
"        \"location\": \"こたつ\",\n"
"        \"description\": \"ROMって楽しんでいる部分もあり無言フォロー多めですすみません…。ツイート数多め・あらぶり多めなのでフォロー非推奨です。最近は早兵・兵部受け中心ですがBLNLなんでも好きです。地雷少ないため雑多に呟きます。腐・R18・ネタバレ有るのでご注意。他好きなジャンルはプロフ参照願います。　主催→@chounou_antholo\",\n"
"        \"url\": \"http://t.co/mM1dG54NiO\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/mM1dG54NiO\",\n"
"                \"expanded_url\": \"http://twpf.jp/oshin_koko\",\n"
"                \"display_url\": \"twpf.jp/oshin_koko\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 479,\n"
"        \"friends_count\": 510,\n"
"        \"listed_count\": 43,\n"
"        \"created_at\": \"Fri Aug 12 05:53:13 +0000 2011\",\n"
"        \"favourites_count\": 3059,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Tokyo\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 104086,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"000000\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/799871497/01583a031f83a45eba881c8acde729ee.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/799871497/01583a031f83a45eba881c8acde729ee.jpeg\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/484347196523835393/iHaYxm-2_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/484347196523835393/iHaYxm-2_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/353516742/1369039651\",\n"
"        \"profile_link_color\": \"FF96B0\",\n"
"        \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"        \"profile_sidebar_fill_color\": \"95E8EC\",\n"
"        \"profile_text_color\": \"3C3940\",\n"
"        \"profile_use_background_image\": false,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 09:58:30 +0000 2014\",\n"
"        \"id\": 505655792733650940,\n"
"        \"id_str\": \"505655792733650944\",\n"
"        \"text\": \"テレビで「成人男性のカロリー摂取量は1900kcal」とか言ってて、それはいままさに私がダイエットのために必死でキープしようとしている量で、「それが普通なら人はいつ天一やココイチに行って大盛りを食えばいいんだ！」と思った。\",\n"
"        \"source\": \"<a href=\\\"http://janetter.net/\\\" rel=\\\"nofollow\\\">Janetter</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 126573583,\n"
"          \"id_str\": \"126573583\",\n"
"          \"name\": \"椎名高志\",\n"
"          \"screen_name\": \"Takashi_Shiina\",\n"
"          \"location\": \"BABEL（超能力支援研究局）\",\n"
"          \"description\": \"漫画家。週刊少年サンデーで『絶対可憐チルドレン』連載中。TVアニメ『THE UNLIMITED 兵部京介』公式サイト＞http://t.co/jVqBoBEc\",\n"
"          \"url\": \"http://t.co/K3Oi83wM3w\",\n"
"          \"entities\": {\n"
"            \"url\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/K3Oi83wM3w\",\n"
"                  \"expanded_url\": \"http://cnanews.asablo.jp/blog/\",\n"
"                  \"display_url\": \"cnanews.asablo.jp/blog/\",\n"
"                  \"indices\": [\n"
"                    0,\n"
"                    22\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            },\n"
"            \"description\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/jVqBoBEc\",\n"
"                  \"expanded_url\": \"http://unlimited-zc.jp/index.html\",\n"
"                  \"display_url\": \"unlimited-zc.jp/index.html\",\n"
"                  \"indices\": [\n"
"                    59,\n"
"                    79\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 110756,\n"
"          \"friends_count\": 61,\n"
"          \"listed_count\": 8159,\n"
"          \"created_at\": \"Fri Mar 26 08:54:51 +0000 2010\",\n"
"          \"favourites_count\": 25,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Tokyo\",\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 27364,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"EDECE9\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme3/bg.gif\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme3/bg.gif\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/504597210772688896/Uvt4jgf5_normal.png\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/504597210772688896/Uvt4jgf5_normal.png\",\n"
"          \"profile_link_color\": \"088253\",\n"
"          \"profile_sidebar_border_color\": \"D3D2CF\",\n"
"          \"profile_sidebar_fill_color\": \"E3E2DE\",\n"
"          \"profile_text_color\": \"634047\",\n"
"          \"profile_use_background_image\": false,\n"
"          \"default_profile\": false,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 221,\n"
"        \"favorite_count\": 109,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 221,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"Takashi_Shiina\",\n"
"            \"name\": \"椎名高志\",\n"
"            \"id\": 126573583,\n"
"            \"id_str\": \"126573583\",\n"
"            \"indices\": [\n"
"              3,\n"
"              18\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874892567244800,\n"
"      \"id_str\": \"505874892567244801\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/shimo_hentai\\\" rel=\\\"nofollow\\\">下ネタ＆笑変態雑学</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2762581922,\n"
"        \"id_str\": \"2762581922\",\n"
"        \"name\": \"下ネタ＆笑変態雑学\",\n"
"        \"screen_name\": \"shimo_hentai\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"普通の人には思いつかない、ちょっと変態チックな 笑える下ネタ雑学をお届けします。 \\r\\nおもしろかったら RT & フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 37,\n"
"        \"friends_count\": 990,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 14:13:20 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 212,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503545991950114816/K9yQbh1Q_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503545991950114816/K9yQbh1Q_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2762581922/1408889893\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874891778703360,\n"
"      \"id_str\": \"505874891778703360\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/kantaneigo1\\\" rel=\\\"nofollow\\\">超簡単★初心者英語</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744544025,\n"
"        \"id_str\": \"2744544025\",\n"
"        \"name\": \"超簡単★初心者英語\",\n"
"        \"screen_name\": \"kantaneigo1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"すぐに使えるフレーズや簡単な会話を紹介します。 \\r\\n少しづつ練習して、どんどん使ってみよう☆ \\r\\n使ってみたいと思ったら RT & フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 147,\n"
"        \"friends_count\": 970,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Tue Aug 19 10:11:48 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 345,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501676136321929216/4MLpyHe3_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501676136321929216/4MLpyHe3_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744544025/1408443928\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874891032121340,\n"
"      \"id_str\": \"505874891032121344\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/ima_handsign\\\" rel=\\\"nofollow\\\">現代のハンドサイン</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2762816814,\n"
"        \"id_str\": \"2762816814\",\n"
"        \"name\": \"現代のハンドサイン\",\n"
"        \"screen_name\": \"ima_handsign\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"イザという時や、困った時に、必ず役に立つハンドサインのオンパレードです♪ \\r\\n使ってみたくなったら RT & フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 95,\n"
"        \"friends_count\": 996,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 15:33:58 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 210,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503566188253687809/7wtdp1AC_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503566188253687809/7wtdp1AC_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2762816814/1408894540\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874890247782400,\n"
"      \"id_str\": \"505874890247782401\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/anata_iionna\\\" rel=\\\"nofollow\\\">今日からアナタもイイ女♪</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2714167411,\n"
"        \"id_str\": \"2714167411\",\n"
"        \"name\": \"今日からアナタもイイ女♪\",\n"
"        \"screen_name\": \"anata_iionna\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"みんなが知りたい イイ女の秘密を見つけます♪ いいな～と思ってくれた人は RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 390,\n"
"        \"friends_count\": 1425,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Aug 07 09:27:59 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 609,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/497314455655436288/dz7P3-fy_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/497314455655436288/dz7P3-fy_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2714167411/1407404214\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874890218434560,\n"
"      \"id_str\": \"505874890218434560\",\n"
"      \"text\": \"@kohecyan3 \\n名前:上野滉平\\n呼び方:うえの\\n呼ばれ方:ずるかわ\\n第一印象:過剰な俺イケメンですアピール\\n今の印象:バーバリーの時計\\n好きなところ:あの自信さ、笑いが絶えない\\n一言:大学受かったの？応援してる〜(*^^*)！\\n\\n#RTした人にやる\\nちょっとやってみる笑\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": 2591363659,\n"
"      \"in_reply_to_user_id_str\": \"2591363659\",\n"
"      \"in_reply_to_screen_name\": \"kohecyan3\",\n"
"      \"user\": {\n"
"        \"id\": 2613282517,\n"
"        \"id_str\": \"2613282517\",\n"
"        \"name\": \"K\",\n"
"        \"screen_name\": \"kawazurukenna\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"# I surprise even my self\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 113,\n"
"        \"friends_count\": 185,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Wed Jul 09 09:39:13 +0000 2014\",\n"
"        \"favourites_count\": 157,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 242,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/502436858135973888/PcUU0lov_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/502436858135973888/PcUU0lov_normal.jpeg\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [\n"
"          {\n"
"            \"text\": \"RTした人にやる\",\n"
"            \"indices\": [\n"
"              119,\n"
"              128\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"kohecyan3\",\n"
"            \"name\": \"上野滉平\",\n"
"            \"id\": 2591363659,\n"
"            \"id_str\": \"2591363659\",\n"
"            \"indices\": [\n"
"              0,\n"
"              10\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:07 +0000 2014\",\n"
"      \"id\": 505874889392156700,\n"
"      \"id_str\": \"505874889392156672\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/iq_tameshi\\\" rel=\\\"nofollow\\\">IQ★力だめし</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2709308887,\n"
"        \"id_str\": \"2709308887\",\n"
"        \"name\": \"IQ★力だめし\",\n"
"        \"screen_name\": \"iq_tameshi\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"解けると楽しい気分になれる問題を見つけて紹介します♪面白かったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 443,\n"
"        \"friends_count\": 1851,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Tue Aug 05 13:14:30 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 664,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496646485266558977/W_W--qV__normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496646485266558977/W_W--qV__normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2709308887/1407244754\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:06 +0000 2014\",\n"
"      \"id\": 505874888817532900,\n"
"      \"id_str\": \"505874888817532928\",\n"
"      \"text\": \"第一三軍から２個師団が北へ移動中らしい　　　　　この調子では満州に陸軍兵力があふれかえる\",\n"
"      \"source\": \"<a href=\\\"http://m.blogs.yahoo.co.jp/misa_1273\\\" rel=\\\"nofollow\\\">如月克己</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1171299612,\n"
"        \"id_str\": \"1171299612\",\n"
"        \"name\": \"如月 克己\",\n"
"        \"screen_name\": \"kisaragi_katumi\",\n"
"        \"location\": \"満州\",\n"
"        \"description\": \"GパングのA型K月克己中尉の非公式botです。 主に七巻と八巻が中心の台詞をつぶやきます。 4/18.台詞追加しました/現在試運転中/現在軽い挨拶だけTL反応。/追加したい台詞や何おかしい所がありましたらDMやリプライで/フォロー返しは手動です/\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 65,\n"
"        \"friends_count\": 63,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Feb 12 08:21:38 +0000 2013\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 27219,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/3242847112/0ce536444c94cbec607229022d43a27a_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/3242847112/0ce536444c94cbec607229022d43a27a_normal.jpeg\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:06 +0000 2014\",\n"
"      \"id\": 505874888616181760,\n"
"      \"id_str\": \"505874888616181760\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/tokuda_ouen1\\\" rel=\\\"nofollow\\\">徳田有希★応援隊</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2766021865,\n"
"        \"id_str\": \"2766021865\",\n"
"        \"name\": \"徳田有希★応援隊\",\n"
"        \"screen_name\": \"tokuda_ouen1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"女子中高生に大人気ww　いやされるイラストを紹介します。 \\r\\nみんなで RTして応援しよう～♪ \\r\\n「非公式アカウントです」\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 123,\n"
"        \"friends_count\": 978,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Mon Aug 25 10:48:41 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 210,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503857235802333184/YS0sDN6q_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503857235802333184/YS0sDN6q_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2766021865/1408963998\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:06 +0000 2014\",\n"
"      \"id\": 505874887802511360,\n"
"      \"id_str\": \"505874887802511361\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/fujyoshinoheya\\\" rel=\\\"nofollow\\\">腐女子の☆部屋</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744683982,\n"
"        \"id_str\": \"2744683982\",\n"
"        \"name\": \"腐女子の☆部屋\",\n"
"        \"screen_name\": \"fujyoshinoheya\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"腐女子にしかわからないネタや、あるあるを見つけていきます。 \\r\\n他には、BL～萌えキュン系まで、腐のための画像を集めています♪ \\r\\n同じ境遇の人には、わかってもらえると思うので、気軽に RT & フォローお願いします☆\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 241,\n"
"        \"friends_count\": 990,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 11:47:21 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 345,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501697365590306817/GLP_QH_b_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501697365590306817/GLP_QH_b_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744683982/1408448984\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:06 +0000 2014\",\n"
"      \"id\": 505874887009767400,\n"
"      \"id_str\": \"505874887009767424\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/moe_rate\\\" rel=\\\"nofollow\\\">萌え芸術★ラテアート</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2763178045,\n"
"        \"id_str\": \"2763178045\",\n"
"        \"name\": \"萌え芸術★ラテアート\",\n"
"        \"screen_name\": \"moe_rate\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"ここまで来ると、もはや芸術!! 見てるだけで楽しい♪ \\r\\nそんなラテアートを、とことん探します。 \\r\\nスゴイと思ったら RT & フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 187,\n"
"        \"friends_count\": 998,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 16:53:16 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 210,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503586151764992000/RC80it20_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503586151764992000/RC80it20_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2763178045/1408899447\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:06 +0000 2014\",\n"
"      \"id\": 505874886225448960,\n"
"      \"id_str\": \"505874886225448960\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/zenbu_johnnys\\\" rel=\\\"nofollow\\\">全部★ジャニーズ図鑑</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2724158970,\n"
"        \"id_str\": \"2724158970\",\n"
"        \"name\": \"全部★ジャニーズ図鑑\",\n"
"        \"screen_name\": \"zenbu_johnnys\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"ジャニーズのカッコイイ画像、おもしろエピソードなどを発信します。\\r\\n「非公式アカウントです」\\r\\nジャニーズ好きな人は、是非 RT ＆ フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 738,\n"
"        \"friends_count\": 1838,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Mon Aug 11 15:50:08 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 556,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498859581057945600/ncMKwdvC_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498859581057945600/ncMKwdvC_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2724158970/1407772462\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:06 +0000 2014\",\n"
"      \"id\": 505874885810200600,\n"
"      \"id_str\": \"505874885810200576\",\n"
"      \"text\": \"RT @naopisu_: 呼び方:\\n呼ばれ方:\\n第一印象:\\n今の印象:\\n好きなところ:\\n家族にするなら:\\n最後に一言:\\n#RTした人にやる\\n\\nお腹痛くて寝れないからやるww\\nだれでもどうぞ〜😏🙌\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2347898072,\n"
"        \"id_str\": \"2347898072\",\n"
"        \"name\": \"にたにた\",\n"
"        \"screen_name\": \"syo6660129\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 64,\n"
"        \"friends_count\": 70,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Mon Feb 17 04:29:46 +0000 2014\",\n"
"        \"favourites_count\": 58,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 145,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/485603672118669314/73uh_xRS_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/485603672118669314/73uh_xRS_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2347898072/1396957619\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 14:19:31 +0000 2014\",\n"
"        \"id\": 505721480261300200,\n"
"        \"id_str\": \"505721480261300224\",\n"
"        \"text\": \"呼び方:\\n呼ばれ方:\\n第一印象:\\n今の印象:\\n好きなところ:\\n家族にするなら:\\n最後に一言:\\n#RTした人にやる\\n\\nお腹痛くて寝れないからやるww\\nだれでもどうぞ〜😏🙌\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 856045488,\n"
"          \"id_str\": \"856045488\",\n"
"          \"name\": \"なおぴす\",\n"
"          \"screen_name\": \"naopisu_\",\n"
"          \"location\": \"Fujino 65th ⇢ Sagaso 12A(LJK\",\n"
"          \"description\": \"＼ もうすぐ18歳 “Only One”になる ／\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 267,\n"
"          \"friends_count\": 259,\n"
"          \"listed_count\": 2,\n"
"          \"created_at\": \"Mon Oct 01 08:36:23 +0000 2012\",\n"
"          \"favourites_count\": 218,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 1790,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496321592553525249/tuzX9ByR_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496321592553525249/tuzX9ByR_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/856045488/1407118111\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 23,\n"
"        \"favorite_count\": 1,\n"
"        \"entities\": {\n"
"          \"hashtags\": [\n"
"            {\n"
"              \"text\": \"RTした人にやる\",\n"
"              \"indices\": [\n"
"                47,\n"
"                56\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 23,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [\n"
"          {\n"
"            \"text\": \"RTした人にやる\",\n"
"            \"indices\": [\n"
"              61,\n"
"              70\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"naopisu_\",\n"
"            \"name\": \"なおぴす\",\n"
"            \"id\": 856045488,\n"
"            \"id_str\": \"856045488\",\n"
"            \"indices\": [\n"
"              3,\n"
"              12\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:06 +0000 2014\",\n"
"      \"id\": 505874885474656260,\n"
"      \"id_str\": \"505874885474656256\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/line_aru1\\\" rel=\\\"nofollow\\\">爆笑★LINE あるある</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2709561589,\n"
"        \"id_str\": \"2709561589\",\n"
"        \"name\": \"爆笑★LINE あるある\",\n"
"        \"screen_name\": \"line_aru1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"思わず笑ってしまうLINEでのやりとりや、あるあるを見つけたいです♪面白かったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 496,\n"
"        \"friends_count\": 1875,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Tue Aug 05 15:01:30 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 687,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496673793939492867/p1BN4YaW_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496673793939492867/p1BN4YaW_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2709561589/1407251270\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874884627410940,\n"
"      \"id_str\": \"505874884627410944\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/misawahatugen\\\" rel=\\\"nofollow\\\">全力★ミサワ的w発言</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2734455415,\n"
"        \"id_str\": \"2734455415\",\n"
"        \"name\": \"全力★ミサワ的w発言!!\",\n"
"        \"screen_name\": \"misawahatugen\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"ウザすぎて笑えるミサワ的名言や、おもしろミサワ画像を集めています。　\\r\\nミサワを知らない人でも、いきなりツボにハマっちゃう内容をお届けします。　\\r\\nウザいｗと思ったら RT & 相互フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 144,\n"
"        \"friends_count\": 1915,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Fri Aug 15 13:20:04 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 436,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/500271070834749444/HvengMe5_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/500271070834749444/HvengMe5_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2734455415/1408108944\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874883809521660,\n"
"      \"id_str\": \"505874883809521664\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/otakara_sotuaru\\\" rel=\\\"nofollow\\\">お宝ww有名人卒アル特集</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2708183557,\n"
"        \"id_str\": \"2708183557\",\n"
"        \"name\": \"お宝ww有名人卒アル特集\",\n"
"        \"screen_name\": \"otakara_sotuaru\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"みんな昔は若かったんですね。今からは想像もつかない、あの有名人を見つけます。\\r\\n面白かったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 286,\n"
"        \"friends_count\": 1938,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 05 03:26:54 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 650,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496499121276985344/hC8RoebP_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496499121276985344/hC8RoebP_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2708183557/1407318758\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874883322970100,\n"
"      \"id_str\": \"505874883322970112\",\n"
"      \"text\": \"レッドクリフのキャラのこと女装ってくそわろたwww朝一で面白かった( ˘ω゜)笑\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1620730616,\n"
"        \"id_str\": \"1620730616\",\n"
"        \"name\": \"ひーちゃん@橘芋健ぴ\",\n"
"        \"screen_name\": \"2nd_8hkr\",\n"
"        \"location\": \"北の大地.95年組 ☞ 9/28.10/2(5).12/28\",\n"
"        \"description\": \"THE SECOND/劇団EXILE/EXILE/二代目JSB ☞KENCHI.AKIRA.青柳翔.小森隼.石井杏奈☜ Big Love ♡ Respect ..... ✍ MATSU Origin✧ .た ち ば な '' い も '' け ん い ち ろ う さ んTEAM NACS 安田.戸次 Liebe !\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 109,\n"
"        \"friends_count\": 148,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Jul 25 16:09:29 +0000 2013\",\n"
"        \"favourites_count\": 783,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 9541,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/458760951060123648/Cocoxi-2_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/458760951060123648/Cocoxi-2_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1620730616/1408681982\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874883067129860,\n"
"      \"id_str\": \"505874883067129857\",\n"
"      \"text\": \"【状態良好】ペンタックス・デジタル一眼レフカメラ・K20D 入札数=38 現在価格=15000円 http://t.co/4WK1f6V2n6終了=2014年08月31日 20:47:53 #一眼レフ http://t.co/PcSaXzfHMW\",\n"
"      \"source\": \"<a href=\\\"https://github.com/AKB428/YahooAuctionBot\\\" rel=\\\"nofollow\\\">YahooAuction Degicame</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2278053589,\n"
"        \"id_str\": \"2278053589\",\n"
"        \"name\": \"AuctionCamera\",\n"
"        \"screen_name\": \"AuctionCamera\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"Yahooオークションのデジカメカテゴリから商品を抽出するボットです。\",\n"
"        \"url\": \"https://t.co/3sB1NDnd0m\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"https://t.co/3sB1NDnd0m\",\n"
"                \"expanded_url\": \"https://github.com/AKB428/YahooAuctionBot\",\n"
"                \"display_url\": \"github.com/AKB428/YahooAu…\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  23\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 5,\n"
"        \"friends_count\": 24,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Jan 05 20:10:56 +0000 2014\",\n"
"        \"favourites_count\": 1,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 199546,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/419927606146789376/vko-kd6Q_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/419927606146789376/vko-kd6Q_normal.jpeg\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [\n"
"          {\n"
"            \"text\": \"一眼レフ\",\n"
"            \"indices\": [\n"
"              95,\n"
"              100\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/4WK1f6V2n6\",\n"
"            \"expanded_url\": \"http://atq.ck.valuecommerce.com/servlet/atq/referral?sid=2219441&pid=877510753&vcptn=auct/p/RJH492.PLqoLQQx1Jy8U9LE-&vc_url=http://page8.auctions.yahoo.co.jp/jp/auction/h192024356\",\n"
"            \"display_url\": \"atq.ck.valuecommerce.com/servlet/atq/re…\",\n"
"            \"indices\": [\n"
"              49,\n"
"              71\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": [],\n"
"        \"media\": [\n"
"          {\n"
"            \"id\": 505874882828046340,\n"
"            \"id_str\": \"505874882828046336\",\n"
"            \"indices\": [\n"
"              101,\n"
"              123\n"
"            ],\n"
"            \"media_url\": \"http://pbs.twimg.com/media/BwU6hpPCEAAxnpq.jpg\",\n"
"            \"media_url_https\": \"https://pbs.twimg.com/media/BwU6hpPCEAAxnpq.jpg\",\n"
"            \"url\": \"http://t.co/PcSaXzfHMW\",\n"
"            \"display_url\": \"pic.twitter.com/PcSaXzfHMW\",\n"
"            \"expanded_url\": \"http://twitter.com/AuctionCamera/status/505874883067129857/photo/1\",\n"
"            \"type\": \"photo\",\n"
"            \"sizes\": {\n"
"              \"large\": {\n"
"                \"w\": 600,\n"
"                \"h\": 450,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"medium\": {\n"
"                \"w\": 600,\n"
"                \"h\": 450,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"thumb\": {\n"
"                \"w\": 150,\n"
"                \"h\": 150,\n"
"                \"resize\": \"crop\"\n"
"              },\n"
"              \"small\": {\n"
"                \"w\": 340,\n"
"                \"h\": 255,\n"
"                \"resize\": \"fit\"\n"
"              }\n"
"            }\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874882995826700,\n"
"      \"id_str\": \"505874882995826689\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/yabai_giness\\\" rel=\\\"nofollow\\\">ヤバすぎる!!ギネス世界記録</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2762405780,\n"
"        \"id_str\": \"2762405780\",\n"
"        \"name\": \"ヤバすぎる!!ギネス世界記録\",\n"
"        \"screen_name\": \"yabai_giness\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"世の中には、まだまだ知られていないスゴイ記録があるんです！ \\r\\nそんなギネス世界記録を見つけます☆ \\r\\nどんどん友達にも教えてあげてくださいねww \\r\\nヤバイと思ったら RT ＆ フォローを、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 36,\n"
"        \"friends_count\": 985,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 13:17:03 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 210,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503531782919045121/NiIC25wL_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503531782919045121/NiIC25wL_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2762405780/1408886328\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874882870009860,\n"
"      \"id_str\": \"505874882870009856\",\n"
"      \"text\": \"すごく面白い夢見た。魔法科高校通ってて（別に一科二科の区別ない）クラスメイトにヨセアツメ面子や赤僕の拓也がいて、学校対抗合唱コンクールが開催されたり会場入りの際他校の妨害工作受けたり、拓也が連れてきてた実が人質に取られたりとにかくてんこ盛りだった楽しかった赤僕読みたい手元にない\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 597357105,\n"
"        \"id_str\": \"597357105\",\n"
"        \"name\": \"ふじよし\",\n"
"        \"screen_name\": \"fuji_mark\",\n"
"        \"location\": \"多摩動物公園\",\n"
"        \"description\": \"成人腐女子\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 128,\n"
"        \"friends_count\": 126,\n"
"        \"listed_count\": 6,\n"
"        \"created_at\": \"Sat Jun 02 10:06:05 +0000 2012\",\n"
"        \"favourites_count\": 2842,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Irkutsk\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 10517,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"0099B9\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme4/bg.gif\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme4/bg.gif\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503553738569560065/D_JW2dCJ_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503553738569560065/D_JW2dCJ_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/597357105/1408864355\",\n"
"        \"profile_link_color\": \"0099B9\",\n"
"        \"profile_sidebar_border_color\": \"5ED4DC\",\n"
"        \"profile_sidebar_fill_color\": \"95E8EC\",\n"
"        \"profile_text_color\": \"3C3940\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874882228281340,\n"
"      \"id_str\": \"505874882228281345\",\n"
"      \"text\": \"RT @oen_yakyu: ●継続試合（中京対崇徳）46回～　9時～\\n　〈ラジオ中継〉\\n　らじる★らじる→大阪放送局を選択→NHK-FM\\n●決勝戦(三浦対中京or崇徳)　12時30分～\\n　〈ラジオ中継〉\\n　らじる★らじる→大阪放送局を選択→NHK第一\\n　※神奈川の方は普通のラ…\",\n"
"      \"source\": \"<a href=\\\"http://twicca.r246.jp/\\\" rel=\\\"nofollow\\\">twicca</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 18477566,\n"
"        \"id_str\": \"18477566\",\n"
"        \"name\": \"Natit（なち）＠そうだ、トップ行こう\",\n"
"        \"screen_name\": \"natit_yso\",\n"
"        \"location\": \"福岡市の端っこ\",\n"
"        \"description\": \"ヤー・チャイカ。紫宝勢の末席くらいでQMAやってます。\\r\\n9/13（土）「九州杯」今年も宜しくお願いします！キーワードは「そうだ、トップ、行こう。」\\r\\nmore → http://t.co/ezuHyjF4Qy \\r\\n【旅の予定】9/20-22 関西 → 9/23-28 北海道ぐるり\",\n"
"        \"url\": \"http://t.co/ll2yu78DGR\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/ll2yu78DGR\",\n"
"                \"expanded_url\": \"http://qma-kyushu.sakura.ne.jp/\",\n"
"                \"display_url\": \"qma-kyushu.sakura.ne.jp\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/ezuHyjF4Qy\",\n"
"                \"expanded_url\": \"http://twpf.jp/natit_yso\",\n"
"                \"display_url\": \"twpf.jp/natit_yso\",\n"
"                \"indices\": [\n"
"                  83,\n"
"                  105\n"
"                ]\n"
"              }\n"
"            ]\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 591,\n"
"        \"friends_count\": 548,\n"
"        \"listed_count\": 93,\n"
"        \"created_at\": \"Tue Dec 30 14:11:44 +0000 2008\",\n"
"        \"favourites_count\": 11676,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Tokyo\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 130145,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"131516\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme14/bg.gif\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme14/bg.gif\",\n"
"        \"profile_background_tile\": true,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/1556202861/chibi-Leon_normal.jpg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/1556202861/chibi-Leon_normal.jpg\",\n"
"        \"profile_link_color\": \"009999\",\n"
"        \"profile_sidebar_border_color\": \"EEEEEE\",\n"
"        \"profile_sidebar_fill_color\": \"EFEFEF\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 23:12:39 +0000 2014\",\n"
"        \"id\": 505855649196953600,\n"
"        \"id_str\": \"505855649196953600\",\n"
"        \"text\": \"●継続試合（中京対崇徳）46回～　9時～\\n　〈ラジオ中継〉\\n　らじる★らじる→大阪放送局を選択→NHK-FM\\n●決勝戦(三浦対中京or崇徳)　12時30分～\\n　〈ラジオ中継〉\\n　らじる★らじる→大阪放送局を選択→NHK第一\\n　※神奈川の方は普通のラジオのNHK-FMでも\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com\\\" rel=\\\"nofollow\\\">Twitter Web Client</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2761692762,\n"
"          \"id_str\": \"2761692762\",\n"
"          \"name\": \"三浦学苑軟式野球部応援団！\",\n"
"          \"screen_name\": \"oen_yakyu\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"兵庫県で開催される「もう一つの甲子園」こと全国高校軟式野球選手権大会に南関東ブロックから出場する三浦学苑軟式野球部を応援する非公式アカウントです。\",\n"
"          \"url\": \"http://t.co/Cn1tPTsBGY\",\n"
"          \"entities\": {\n"
"            \"url\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/Cn1tPTsBGY\",\n"
"                  \"expanded_url\": \"http://www.miura.ed.jp/index.html\",\n"
"                  \"display_url\": \"miura.ed.jp/index.html\",\n"
"                  \"indices\": [\n"
"                    0,\n"
"                    22\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            },\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 464,\n"
"          \"friends_count\": 117,\n"
"          \"listed_count\": 4,\n"
"          \"created_at\": \"Sun Aug 24 07:47:29 +0000 2014\",\n"
"          \"favourites_count\": 69,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 553,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/504299474445811712/zsxJUmL0_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/504299474445811712/zsxJUmL0_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2761692762/1409069337\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 7,\n"
"        \"favorite_count\": 2,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 7,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"oen_yakyu\",\n"
"            \"name\": \"三浦学苑軟式野球部応援団！\",\n"
"            \"id\": 2761692762,\n"
"            \"id_str\": \"2761692762\",\n"
"            \"indices\": [\n"
"              3,\n"
"              13\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874882110824450,\n"
"      \"id_str\": \"505874882110824448\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/sumahoanime\\\" rel=\\\"nofollow\\\">スマホに密封★アニメ画像</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2725976444,\n"
"        \"id_str\": \"2725976444\",\n"
"        \"name\": \"スマホに密封★アニメ画像\",\n"
"        \"screen_name\": \"sumahoanime\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"なんともめずらしい、いろんなキャラがスマホに閉じ込められています。 \\r\\nあなたのスマホにマッチする画像が見つかるかも♪  \\r\\n気に入ったら是非 RT ＆ フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 227,\n"
"        \"friends_count\": 1918,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 12 11:27:54 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 527,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/499155646164393984/l5vSz5zu_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/499155646164393984/l5vSz5zu_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2725976444/1407843121\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:05 +0000 2014\",\n"
"      \"id\": 505874881297133600,\n"
"      \"id_str\": \"505874881297133568\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/mijika_kiken\\\" rel=\\\"nofollow\\\">アナタのそばの身近な危険</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2713926078,\n"
"        \"id_str\": \"2713926078\",\n"
"        \"name\": \"アナタのそばの身近な危険\",\n"
"        \"screen_name\": \"mijika_kiken\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"知らないうちにやっている危険な行動を見つけて自分を守りましょう。 役に立つと思ったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 301,\n"
"        \"friends_count\": 1871,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Aug 07 07:12:50 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 644,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/497279579245907968/Ftvms_HR_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/497279579245907968/Ftvms_HR_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2713926078/1407395683\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:04 +0000 2014\",\n"
"      \"id\": 505874880294682600,\n"
"      \"id_str\": \"505874880294682624\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/ninkimono_daosy\\\" rel=\\\"nofollow\\\">人気者♥デイジー大好き</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2726199583,\n"
"        \"id_str\": \"2726199583\",\n"
"        \"name\": \"人気者♥デイジー大好き\",\n"
"        \"screen_name\": \"ninkimono_daosy\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"デイジーの想いを、代わりにつぶやきます♪  \\r\\nデイジーのかわいい画像やグッズも大好きｗ  \\r\\n可愛いと思ったら RT & フォローお願いします。 \\r\\n「非公式アカウントです」\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 190,\n"
"        \"friends_count\": 474,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 12 12:58:33 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 469,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/499178622494576640/EzWKdR_p_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/499178622494576640/EzWKdR_p_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2726199583/1407848478\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:04 +0000 2014\",\n"
"      \"id\": 505874879392919550,\n"
"      \"id_str\": \"505874879392919552\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/shiawasehanashi\\\" rel=\\\"nofollow\\\">幸せ話でフル充電しよう</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2721453846,\n"
"        \"id_str\": \"2721453846\",\n"
"        \"name\": \"幸せ話でフル充電しようww\",\n"
"        \"screen_name\": \"shiawasehanashi\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"私が聞いて心に残った感動エピソードをお届けします。\\r\\n少しでも多くの人へ届けたいと思います。\\r\\nいいなと思ったら RT & フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 302,\n"
"        \"friends_count\": 1886,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 10 12:16:25 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 508,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498444554916216832/ml8EiQka_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498444554916216832/ml8EiQka_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2721453846/1407673555\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:04 +0000 2014\",\n"
"      \"id\": 505874879103520800,\n"
"      \"id_str\": \"505874879103520768\",\n"
"      \"text\": \"RT @Ang_Angel73: 逢坂「くっ…僕の秘められし右目が…！」\\n一同「……………。」\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2571968509,\n"
"        \"id_str\": \"2571968509\",\n"
"        \"name\": \"イイヒト\",\n"
"        \"screen_name\": \"IwiAlohomora\",\n"
"        \"location\": \"草葉の陰\",\n"
"        \"description\": \"大人です。気軽に絡んでくれるとうれしいです！ イラスト大好き！（≧∇≦） BF(仮）逢坂紘夢くんにお熱です！ マンガも好き♡欲望のままにつぶやきますのでご注意を。雑食♡\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 156,\n"
"        \"friends_count\": 165,\n"
"        \"listed_count\": 14,\n"
"        \"created_at\": \"Tue Jun 17 01:18:34 +0000 2014\",\n"
"        \"favourites_count\": 11926,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 7234,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/504990074862178304/DoBvOb9c_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/504990074862178304/DoBvOb9c_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2571968509/1409106012\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:27:01 +0000 2014\",\n"
"        \"id\": 505874364596621300,\n"
"        \"id_str\": \"505874364596621313\",\n"
"        \"text\": \"逢坂「くっ…僕の秘められし右目が…！」\\n一同「……………。」\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 1600750194,\n"
"          \"id_str\": \"1600750194\",\n"
"          \"name\": \"臙脂\",\n"
"          \"screen_name\": \"Ang_Angel73\",\n"
"          \"location\": \"逢坂紘夢のそばに\",\n"
"          \"description\": \"自由、気ままに。詳しくはツイプロ。アイコンはまめせろりちゃんからだよ☆～（ゝ。∂）\",\n"
"          \"url\": \"http://t.co/kKCCwHTaph\",\n"
"          \"entities\": {\n"
"            \"url\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/kKCCwHTaph\",\n"
"                  \"expanded_url\": \"http://twpf.jp/Ang_Angel73\",\n"
"                  \"display_url\": \"twpf.jp/Ang_Angel73\",\n"
"                  \"indices\": [\n"
"                    0,\n"
"                    22\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            },\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 155,\n"
"          \"friends_count\": 154,\n"
"          \"listed_count\": 10,\n"
"          \"created_at\": \"Wed Jul 17 11:44:31 +0000 2013\",\n"
"          \"favourites_count\": 2115,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Irkutsk\",\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 12342,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/378800000027871001/aa764602922050b22bf9ade3741367dc.jpeg\",\n"
"          \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/378800000027871001/aa764602922050b22bf9ade3741367dc.jpeg\",\n"
"          \"profile_background_tile\": true,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/500293786287603713/Ywyh69eG_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/500293786287603713/Ywyh69eG_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1600750194/1403879183\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": false,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 2,\n"
"        \"favorite_count\": 2,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 2,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"Ang_Angel73\",\n"
"            \"name\": \"臙脂\",\n"
"            \"id\": 1600750194,\n"
"            \"id_str\": \"1600750194\",\n"
"            \"indices\": [\n"
"              3,\n"
"              15\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:04 +0000 2014\",\n"
"      \"id\": 505874877933314050,\n"
"      \"id_str\": \"505874877933314048\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/honne_jyoshi1\\\" rel=\\\"nofollow\\\">秘密の本音♥女子編</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2762237088,\n"
"        \"id_str\": \"2762237088\",\n"
"        \"name\": \"秘密の本音♥女子編\",\n"
"        \"screen_name\": \"honne_jyoshi1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"普段は言えない「お・ん・なの建前と本音」をつぶやきます。 気になる あの人の本音も、わかるかも!? \\r\\nわかるって人は RT ＆ フォローを、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 123,\n"
"        \"friends_count\": 988,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 12:27:07 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 211,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503519190364332032/BVjS_XBD_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503519190364332032/BVjS_XBD_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2762237088/1408883328\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:04 +0000 2014\",\n"
"      \"id\": 505874877148958700,\n"
"      \"id_str\": \"505874877148958721\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/bi_iroenpitu\\\" rel=\\\"nofollow\\\">美し過ぎる★色鉛筆アート</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2740047343,\n"
"        \"id_str\": \"2740047343\",\n"
"        \"name\": \"美し過ぎる★色鉛筆アート\",\n"
"        \"screen_name\": \"bi_iroenpitu\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"ほんとにコレ色鉛筆なの～？ \\r\\n本物と見間違える程のリアリティを御覧ください。 \\r\\n気に入ったら RT & 相互フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 321,\n"
"        \"friends_count\": 1990,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 17 16:15:05 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 396,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501039950972739585/isigil4V_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501039950972739585/isigil4V_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2740047343/1408292283\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874876465295360,\n"
"      \"id_str\": \"505874876465295361\",\n"
"      \"text\": \"【H15-9-4】道路を利用する利益は反射的利益であり、建築基準法に基づいて道路一の指定がなされている私道の敷地所有者に対し、通行妨害行為の排除を求める人格的権利を認めることはできない。→誤。\",\n"
"      \"source\": \"<a href=\\\"http://twittbot.net/\\\" rel=\\\"nofollow\\\">twittbot.net</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1886570281,\n"
"        \"id_str\": \"1886570281\",\n"
"        \"name\": \"行政法過去問\",\n"
"        \"screen_name\": \"gyosei_goukaku\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"行政書士の本試験問題の過去問（行政法分野）をランダムにつぶやきます。問題は随時追加中です。基本的に相互フォローします。※140字制限の都合上、表現は一部変えてあります。解説も文字数が可能であればなるべく…。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 1554,\n"
"        \"friends_count\": 1772,\n"
"        \"listed_count\": 12,\n"
"        \"created_at\": \"Fri Sep 20 13:24:29 +0000 2013\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 14565,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/378800000487791870/0e45e3c089c6b641cdd8d1b6f1ceb8a4_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/378800000487791870/0e45e3c089c6b641cdd8d1b6f1ceb8a4_normal.jpeg\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874876318511100,\n"
"      \"id_str\": \"505874876318511104\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/kgoehassou\\\" rel=\\\"nofollow\\\">K点越えの発想力!!</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744863153,\n"
"        \"id_str\": \"2744863153\",\n"
"        \"name\": \"K点越えの発想力!!\",\n"
"        \"screen_name\": \"kgoehassou\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"いったいどうやったら、その領域にたどりつけるのか！？ \\r\\nそんな思わず笑ってしまう別世界の発想力をお届けします♪ \\r\\nおもしろかったら RT & 相互フォローで、お願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 76,\n"
"        \"friends_count\": 957,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 13:00:08 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 341,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501715651686178816/Fgpe0B8M_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501715651686178816/Fgpe0B8M_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744863153/1408453328\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874875521581060,\n"
"      \"id_str\": \"505874875521581056\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/ketueki_sinjitu\\\" rel=\\\"nofollow\\\">血液型の真実２</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2698625690,\n"
"        \"id_str\": \"2698625690\",\n"
"        \"name\": \"血液型の真実\",\n"
"        \"screen_name\": \"ketueki_sinjitu\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"やっぱりそうだったのか～♪\\r\\n意外な、あの人の裏側を見つけます。\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 193,\n"
"        \"friends_count\": 1785,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Fri Aug 01 16:11:40 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 769,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495241446706790400/h_0DSFPG_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495241446706790400/h_0DSFPG_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2698625690/1406911319\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874874712072200,\n"
"      \"id_str\": \"505874874712072192\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/yahari_kamiga\\\" rel=\\\"nofollow\\\">やっぱり神が？？を作る時</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2714868440,\n"
"        \"id_str\": \"2714868440\",\n"
"        \"name\": \"やっぱり神が？？を作る時\",\n"
"        \"screen_name\": \"yahari_kamiga\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"やっぱり今日も、神は何かを作ろうとしています　笑。　どうやって作っているのかわかったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 243,\n"
"        \"friends_count\": 1907,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Aug 07 16:12:33 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 590,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/497416102108884992/NRMEbKaT_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/497416102108884992/NRMEbKaT_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2714868440/1407428237\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874874275864600,\n"
"      \"id_str\": \"505874874275864576\",\n"
"      \"text\": \"RT @takuramix: 福島第一原発の構内地図がこちら。\\nhttp://t.co/ZkU4TZCGPG\\nどう見ても、１号機。\\nRT @Lightworker19: 【大拡散】　 福島第一原発　４号機　爆発動画　40秒～ 　http://t.co/lmlgp38fgZ\",\n"
"      \"source\": \"<a href=\\\"http://twitter.softama.com/\\\" rel=\\\"nofollow\\\">ツイタマ</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 62525372,\n"
"        \"id_str\": \"62525372\",\n"
"        \"name\": \"NANCY-MOON☆ひよこちゃん☆\",\n"
"        \"screen_name\": \"nancy_moon_703\",\n"
"        \"location\": \"JAPAN\",\n"
"        \"description\": \"【無断転載禁止･コピペ禁止・非公式RT禁止】【必読！】⇒ http://t.co/nuUvfUVD 今現在活動中の東方神起YUNHO＆CHANGMINの2人を全力で応援しています!!(^_-)-☆ ※東方神起及びYUNHO＆CHANGMINを応援していない方・鍵付ユーザーのフォローお断り！\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/nuUvfUVD\",\n"
"                \"expanded_url\": \"http://goo.gl/SrGLb\",\n"
"                \"display_url\": \"goo.gl/SrGLb\",\n"
"                \"indices\": [\n"
"                  29,\n"
"                  49\n"
"                ]\n"
"              }\n"
"            ]\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 270,\n"
"        \"friends_count\": 328,\n"
"        \"listed_count\": 4,\n"
"        \"created_at\": \"Mon Aug 03 14:22:24 +0000 2009\",\n"
"        \"favourites_count\": 3283,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Tokyo\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 180310,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"642D8B\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/470849781397336064/ltM6EdFn.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/470849781397336064/ltM6EdFn.jpeg\",\n"
"        \"profile_background_tile\": true,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/3699005246/9ba2e306518d296b68b7cbfa5e4ce4e6_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/3699005246/9ba2e306518d296b68b7cbfa5e4ce4e6_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/62525372/1401094223\",\n"
"        \"profile_link_color\": \"FF0000\",\n"
"        \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"        \"profile_sidebar_fill_color\": \"F065A8\",\n"
"        \"profile_text_color\": \"080808\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 21:21:33 +0000 2014\",\n"
"        \"id\": 505827689660313600,\n"
"        \"id_str\": \"505827689660313600\",\n"
"        \"text\": \"福島第一原発の構内地図がこちら。\\nhttp://t.co/ZkU4TZCGPG\\nどう見ても、１号機。\\nRT @Lightworker19: 【大拡散】　 福島第一原発　４号機　爆発動画　40秒～ 　http://t.co/lmlgp38fgZ\",\n"
"        \"source\": \"<a href=\\\"https://about.twitter.com/products/tweetdeck\\\" rel=\\\"nofollow\\\">TweetDeck</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": 505774460910043140,\n"
"        \"in_reply_to_status_id_str\": \"505774460910043136\",\n"
"        \"in_reply_to_user_id\": 238157843,\n"
"        \"in_reply_to_user_id_str\": \"238157843\",\n"
"        \"in_reply_to_screen_name\": \"Lightworker19\",\n"
"        \"user\": {\n"
"          \"id\": 29599253,\n"
"          \"id_str\": \"29599253\",\n"
"          \"name\": \"タクラミックス\",\n"
"          \"screen_name\": \"takuramix\",\n"
"          \"location\": \"i7\",\n"
"          \"description\": \"私の機能一覧：歌う、演劇、ネットワークエンジニア、ライター、プログラマ、翻訳、シルバーアクセサリ、……何をやってる人かは良くわからない人なので、「機能」が欲しい人は私にがっかりするでしょう。私って人間に御用があるなら別ですが。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 5136,\n"
"          \"friends_count\": 724,\n"
"          \"listed_count\": 335,\n"
"          \"created_at\": \"Wed Apr 08 01:10:58 +0000 2009\",\n"
"          \"favourites_count\": 21363,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Tokyo\",\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 70897,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/2049751947/takuramix1204_normal.jpg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/2049751947/takuramix1204_normal.jpg\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 1,\n"
"        \"favorite_count\": 1,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [\n"
"            {\n"
"              \"url\": \"http://t.co/ZkU4TZCGPG\",\n"
"              \"expanded_url\": \"http://www.tepco.co.jp/nu/fukushima-np/review/images/review1_01.gif\",\n"
"              \"display_url\": \"tepco.co.jp/nu/fukushima-n…\",\n"
"              \"indices\": [\n"
"                17,\n"
"                39\n"
"              ]\n"
"            },\n"
"            {\n"
"              \"url\": \"http://t.co/lmlgp38fgZ\",\n"
"              \"expanded_url\": \"http://youtu.be/gDXEhyuVSDk\",\n"
"              \"display_url\": \"youtu.be/gDXEhyuVSDk\",\n"
"              \"indices\": [\n"
"                99,\n"
"                121\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"user_mentions\": [\n"
"            {\n"
"              \"screen_name\": \"Lightworker19\",\n"
"              \"name\": \"Lightworker\",\n"
"              \"id\": 238157843,\n"
"              \"id_str\": \"238157843\",\n"
"              \"indices\": [\n"
"                54,\n"
"                68\n"
"              ]\n"
"            }\n"
"          ]\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 1,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/ZkU4TZCGPG\",\n"
"            \"expanded_url\": \"http://www.tepco.co.jp/nu/fukushima-np/review/images/review1_01.gif\",\n"
"            \"display_url\": \"tepco.co.jp/nu/fukushima-n…\",\n"
"            \"indices\": [\n"
"              32,\n"
"              54\n"
"            ]\n"
"          },\n"
"          {\n"
"            \"url\": \"http://t.co/lmlgp38fgZ\",\n"
"            \"expanded_url\": \"http://youtu.be/gDXEhyuVSDk\",\n"
"            \"display_url\": \"youtu.be/gDXEhyuVSDk\",\n"
"            \"indices\": [\n"
"              114,\n"
"              136\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"takuramix\",\n"
"            \"name\": \"タクラミックス\",\n"
"            \"id\": 29599253,\n"
"            \"id_str\": \"29599253\",\n"
"            \"indices\": [\n"
"              3,\n"
"              13\n"
"            ]\n"
"          },\n"
"          {\n"
"            \"screen_name\": \"Lightworker19\",\n"
"            \"name\": \"Lightworker\",\n"
"            \"id\": 238157843,\n"
"            \"id_str\": \"238157843\",\n"
"            \"indices\": [\n"
"              69,\n"
"              83\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874873961308160,\n"
"      \"id_str\": \"505874873961308160\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/anayuki_suki\\\" rel=\\\"nofollow\\\">やっぱりアナ雪が好き♥</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2714052962,\n"
"        \"id_str\": \"2714052962\",\n"
"        \"name\": \"やっぱりアナ雪が好き♥\",\n"
"        \"screen_name\": \"anayuki_suki\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"なんだかんだ言ってもやっぱりアナ雪が好きなんですよね～♪ \\r\\n私も好きって人は RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 368,\n"
"        \"friends_count\": 1826,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Thu Aug 07 08:29:13 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 670,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/497299646662705153/KMo3gkv7_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/497299646662705153/KMo3gkv7_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2714052962/1407400477\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"zh\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874873759977500,\n"
"      \"id_str\": \"505874873759977473\",\n"
"      \"text\": \"四川盆地江淮等地将有强降雨 开学日多地将有雨: 　　中新网8月31日电 据中央气象台消息，江淮东部、四川盆地东北部等地今天(31日)又将迎来一场暴雨或大暴雨天气。明天9月1日，是中小学生开学的日子。预计明天，内蒙古中部、... http://t.co/toQgVlXPyH\",\n"
"      \"source\": \"<a href=\\\"http://twitterfeed.com\\\" rel=\\\"nofollow\\\">twitterfeed</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2281979863,\n"
"        \"id_str\": \"2281979863\",\n"
"        \"name\": \"News 24h China\",\n"
"        \"screen_name\": \"news24hchn\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 719,\n"
"        \"friends_count\": 807,\n"
"        \"listed_count\": 7,\n"
"        \"created_at\": \"Wed Jan 08 10:56:04 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": 7200,\n"
"        \"time_zone\": \"Amsterdam\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 94782,\n"
"        \"lang\": \"it\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/452558963754561536/QPID3isM.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/452558963754561536/QPID3isM.jpeg\",\n"
"        \"profile_background_tile\": true,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/439031926569979904/SlBH9iMg_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/439031926569979904/SlBH9iMg_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2281979863/1393508427\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/toQgVlXPyH\",\n"
"            \"expanded_url\": \"http://news24h.allnews24h.com/FX54\",\n"
"            \"display_url\": \"news24h.allnews24h.com/FX54\",\n"
"            \"indices\": [\n"
"              114,\n"
"              136\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"zh\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874873248268300,\n"
"      \"id_str\": \"505874873248268288\",\n"
"      \"text\": \"@Take3carnifex それは大変！一大事！命に関わります！\\n是非うちに受診して下さい！\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": 505874353716600800,\n"
"      \"in_reply_to_status_id_str\": \"505874353716600832\",\n"
"      \"in_reply_to_user_id\": 535179785,\n"
"      \"in_reply_to_user_id_str\": \"535179785\",\n"
"      \"in_reply_to_screen_name\": \"Take3carnifex\",\n"
"      \"user\": {\n"
"        \"id\": 226897125,\n"
"        \"id_str\": \"226897125\",\n"
"        \"name\": \"ひかり＠hack\",\n"
"        \"screen_name\": \"hikari_thirteen\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"hackというバンドで、ギターを弾いています。 モンハンとポケモンが好き。 \\nSPRING WATER リードギター(ヘルプ)\\nROCK OUT レギュラーDJ\",\n"
"        \"url\": \"http://t.co/SQLZnvjVxB\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/SQLZnvjVxB\",\n"
"                \"expanded_url\": \"http://s.ameblo.jp/hikarihikarimay\",\n"
"                \"display_url\": \"s.ameblo.jp/hikarihikarimay\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 296,\n"
"        \"friends_count\": 348,\n"
"        \"listed_count\": 3,\n"
"        \"created_at\": \"Wed Dec 15 10:51:51 +0000 2010\",\n"
"        \"favourites_count\": 33,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Tokyo\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 3293,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"131516\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme14/bg.gif\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme14/bg.gif\",\n"
"        \"profile_background_tile\": true,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/378800000504584690/8ccba98eda8c0fd1d15a74e401f621d1_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/378800000504584690/8ccba98eda8c0fd1d15a74e401f621d1_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/226897125/1385551752\",\n"
"        \"profile_link_color\": \"009999\",\n"
"        \"profile_sidebar_border_color\": \"EEEEEE\",\n"
"        \"profile_sidebar_fill_color\": \"EFEFEF\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"Take3carnifex\",\n"
"            \"name\": \"Take3\",\n"
"            \"id\": 535179785,\n"
"            \"id_str\": \"535179785\",\n"
"            \"indices\": [\n"
"              0,\n"
"              14\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:03 +0000 2014\",\n"
"      \"id\": 505874873223110660,\n"
"      \"id_str\": \"505874873223110656\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/imadokijoshiko\\\" rel=\\\"nofollow\\\">今どき女子高生の謎w</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744236873,\n"
"        \"id_str\": \"2744236873\",\n"
"        \"name\": \"今どき女子高生の謎w\",\n"
"        \"screen_name\": \"imadokijoshiko\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"思わず耳を疑う男性の方の夢を壊してしまう、\\r\\n女子高生達のディープな世界を見てください☆  \\r\\nおもしろいと思ったら RT & 相互フォローでお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 79,\n"
"        \"friends_count\": 973,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 07:06:47 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 354,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501627015980535808/avWBgkDh_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501627015980535808/avWBgkDh_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744236873/1408432455\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874872463925250,\n"
"      \"id_str\": \"505874872463925248\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/risou_dansei\\\" rel=\\\"nofollow\\\">私の理想の男性像</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2761782601,\n"
"        \"id_str\": \"2761782601\",\n"
"        \"name\": \"私の理想の男性像\",\n"
"        \"screen_name\": \"risou_dansei\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"こんな男性♥ ほんとにいるのかしら!? \\r\\n「いたらいいのになぁ」っていう理想の男性像をを、私目線でつぶやきます。 \\r\\nいいなと思った人は RT & フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 69,\n"
"        \"friends_count\": 974,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 08:03:32 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 208,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503452833719410688/tFU509Yk_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503452833719410688/tFU509Yk_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2761782601/1408867519\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874871713157100,\n"
"      \"id_str\": \"505874871713157120\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/gekiatu_6byou\\\" rel=\\\"nofollow\\\">激アツ★6秒動画</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2725690658,\n"
"        \"id_str\": \"2725690658\",\n"
"        \"name\": \"激アツ★6秒動画\",\n"
"        \"screen_name\": \"gekiatu_6byou\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"話題の６秒動画！ \\r\\n思わず「ほんとかよっ」てツッコんでしまう内容のオンパレード！ \\r\\nおもしろかったら、是非 RT ＆ フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 195,\n"
"        \"friends_count\": 494,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 12 08:17:29 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 477,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/499107997444886528/3rl6FrIk_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/499107997444886528/3rl6FrIk_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2725690658/1407832963\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874871616671740,\n"
"      \"id_str\": \"505874871616671744\",\n"
"      \"text\": \"爆笑ｗｗ珍解答集！\\n先生のツメの甘さと生徒のセンスを感じる一問一答だとFBでも話題！！\\nうどん天下一決定戦ウィンドウズ9三重高校竹内由恵アナ花火保険\\nhttp://t.co/jRWJt8IrSB http://t.co/okrAoxSbt0\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/waraeru_kan\\\" rel=\\\"nofollow\\\">笑える博物館</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2748747362,\n"
"        \"id_str\": \"2748747362\",\n"
"        \"name\": \"笑える博物館\",\n"
"        \"screen_name\": \"waraeru_kan\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 19,\n"
"        \"friends_count\": 10,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Wed Aug 20 11:11:04 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 15137,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://abs.twimg.com/sticky/default_profile_images/default_profile_4_normal.png\",\n"
"        \"profile_image_url_https\": \"https://abs.twimg.com/sticky/default_profile_images/default_profile_4_normal.png\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": true,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/jRWJt8IrSB\",\n"
"            \"expanded_url\": \"http://bit.ly/1qBa1nl\",\n"
"            \"display_url\": \"bit.ly/1qBa1nl\",\n"
"            \"indices\": [\n"
"              75,\n"
"              97\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": [],\n"
"        \"media\": [\n"
"          {\n"
"            \"id\": 505874871344066560,\n"
"            \"id_str\": \"505874871344066560\",\n"
"            \"indices\": [\n"
"              98,\n"
"              120\n"
"            ],\n"
"            \"media_url\": \"http://pbs.twimg.com/media/BwU6g-dCcAALxAW.png\",\n"
"            \"media_url_https\": \"https://pbs.twimg.com/media/BwU6g-dCcAALxAW.png\",\n"
"            \"url\": \"http://t.co/okrAoxSbt0\",\n"
"            \"display_url\": \"pic.twitter.com/okrAoxSbt0\",\n"
"            \"expanded_url\": \"http://twitter.com/waraeru_kan/status/505874871616671744/photo/1\",\n"
"            \"type\": \"photo\",\n"
"            \"sizes\": {\n"
"              \"small\": {\n"
"                \"w\": 340,\n"
"                \"h\": 425,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"thumb\": {\n"
"                \"w\": 150,\n"
"                \"h\": 150,\n"
"                \"resize\": \"crop\"\n"
"              },\n"
"              \"large\": {\n"
"                \"w\": 600,\n"
"                \"h\": 750,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"medium\": {\n"
"                \"w\": 600,\n"
"                \"h\": 750,\n"
"                \"resize\": \"fit\"\n"
"              }\n"
"            }\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874871268540400,\n"
"      \"id_str\": \"505874871268540416\",\n"
"      \"text\": \"@nasan_arai \\n名前→なーさん\\n第一印象→誰。(´･_･`)\\n今の印象→れいら♡\\nLINE交換できる？→してる(｢･ω･)｢\\n好きなところ→可愛い優しい優しい優しい\\n最後に一言→なーさん好き〜(´･_･`)♡GEM現場おいでね(´･_･`)♡\\n\\n#ふぁぼした人にやる\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": 1717603286,\n"
"      \"in_reply_to_user_id_str\": \"1717603286\",\n"
"      \"in_reply_to_screen_name\": \"nasan_arai\",\n"
"      \"user\": {\n"
"        \"id\": 2417626784,\n"
"        \"id_str\": \"2417626784\",\n"
"        \"name\": \"✩.ゆきଘ(*´꒳`)\",\n"
"        \"screen_name\": \"Ymaaya_gem\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"⁽⁽٩( ᐖ )۶⁾⁾ ❤︎ 武 田 舞 彩 ❤︎ ₍₍٩( ᐛ )۶₎₎\",\n"
"        \"url\": \"http://t.co/wR0Qb76TbB\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/wR0Qb76TbB\",\n"
"                \"expanded_url\": \"http://twpf.jp/Ymaaya_gem\",\n"
"                \"display_url\": \"twpf.jp/Ymaaya_gem\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 198,\n"
"        \"friends_count\": 245,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Sat Mar 29 16:03:06 +0000 2014\",\n"
"        \"favourites_count\": 3818,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": true,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 8056,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/505516858816987136/4gFGjHzu_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/505516858816987136/4gFGjHzu_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2417626784/1407764793\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [\n"
"          {\n"
"            \"text\": \"ふぁぼした人にやる\",\n"
"            \"indices\": [\n"
"              128,\n"
"              138\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"nasan_arai\",\n"
"            \"name\": \"なーさん\",\n"
"            \"id\": 1717603286,\n"
"            \"id_str\": \"1717603286\",\n"
"            \"indices\": [\n"
"              0,\n"
"              11\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874871218225150,\n"
"      \"id_str\": \"505874871218225152\",\n"
"      \"text\": \"\\\"ソードマスター\\\"剣聖カミイズミ (CV:緑川光)-「ソードマスター」のアスタリスク所持者\\n第一師団団長にして「剣聖」の称号を持つ剣士。イデアの剣の師匠。 \\n敵味方からも尊敬される一流の武人。\",\n"
"      \"source\": \"<a href=\\\"http://twittbot.net/\\\" rel=\\\"nofollow\\\">twittbot.net</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1435517814,\n"
"        \"id_str\": \"1435517814\",\n"
"        \"name\": \"俺、関係ないよ？\",\n"
"        \"screen_name\": \"BDFF_LOVE\",\n"
"        \"location\": \"ルクセンダルクorリングアベルさんの隣\",\n"
"        \"description\": \"自分なりに生きる人、最後まであきらめないの。でも、フォローありがとう…。@ringo_BDFFLOVE ←は、妹です。時々、会話します。「現在BOTで、BDFFのこと呟くよ！」夜は、全滅　「BDFFプレイ中」詳しくは、ツイプロみてください！(絶対)\",\n"
"        \"url\": \"http://t.co/5R4dzpbWX2\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/5R4dzpbWX2\",\n"
"                \"expanded_url\": \"http://twpf.jp/BDFF_LOVE\",\n"
"                \"display_url\": \"twpf.jp/BDFF_LOVE\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 1066,\n"
"        \"friends_count\": 1799,\n"
"        \"listed_count\": 6,\n"
"        \"created_at\": \"Fri May 17 12:33:23 +0000 2013\",\n"
"        \"favourites_count\": 1431,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Irkutsk\",\n"
"        \"geo_enabled\": true,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 6333,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/505696320380612608/qvaxb_zx_normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/505696320380612608/qvaxb_zx_normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1435517814/1409401948\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874871130136600,\n"
"      \"id_str\": \"505874871130136576\",\n"
"      \"text\": \"闇「リンと付き合うに当たって歳の差以外にもいろいろ壁があったんだよ。愛し隊の妨害とか風紀厨の生徒会長とか…」\\n一号「リンちゃんを泣かせたらシメるかんね！」\\n二号「リンちゃんにやましい事したら×す…」\\n執行部「不純な交際は僕が取り締まろうじゃないか…」\\n闇「（消される）」\",\n"
"      \"source\": \"<a href=\\\"http://twittbot.net/\\\" rel=\\\"nofollow\\\">twittbot.net</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2386208737,\n"
"        \"id_str\": \"2386208737\",\n"
"        \"name\": \"闇未来Bot\",\n"
"        \"screen_name\": \"StxRinFbot\",\n"
"        \"location\": \"DIVAルーム\",\n"
"        \"description\": \"ProjectDIVAのモジュール・ストレンジダーク×鏡音リンFutureStyleの自己満足非公式Bot　マセレン仕様。CP要素あります。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 7,\n"
"        \"friends_count\": 2,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Mar 13 02:58:09 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 4876,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/443948925351755776/6rmljL5C_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/443948925351755776/6rmljL5C_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2386208737/1396259004\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874870933016600,\n"
"      \"id_str\": \"505874870933016576\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/suitestengoku\\\" rel=\\\"nofollow\\\">絶品!!スイーツ天国</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2725681663,\n"
"        \"id_str\": \"2725681663\",\n"
"        \"name\": \"絶品!!スイーツ天国\",\n"
"        \"screen_name\": \"suitestengoku\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"美味しそうなスイーツって、見てるだけで幸せな気分になれますね♪\\r\\nそんな素敵なスイーツに出会いたいです。\\r\\n食べたいと思ったら是非 RT ＆ フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 401,\n"
"        \"friends_count\": 1877,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Tue Aug 12 07:43:52 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 554,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/499099533507178496/g5dNpArt_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/499099533507178496/g5dNpArt_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2725681663/1407829743\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874870148669440,\n"
"      \"id_str\": \"505874870148669440\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/dengeki_omoro\\\" rel=\\\"nofollow\\\">電車厳禁!!おもしろ話</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2699667800,\n"
"        \"id_str\": \"2699667800\",\n"
"        \"name\": \"電車厳禁!!おもしろ話w\",\n"
"        \"screen_name\": \"dengeki_omoro\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"日常のオモシロくて笑える場面を探します♪\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 461,\n"
"        \"friends_count\": 1919,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Aug 02 02:16:32 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 728,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495400387961036800/BBMb_hcG_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495400387961036800/BBMb_hcG_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2699667800/1406947654\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874869339189250,\n"
"      \"id_str\": \"505874869339189249\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/ketueki_face\\\" rel=\\\"nofollow\\\">笑えるwwランキング2</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2695745652,\n"
"        \"id_str\": \"2695745652\",\n"
"        \"name\": \"笑えるwwランキング\",\n"
"        \"screen_name\": \"wara_runk\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"知ってると使えるランキングを探そう。\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 314,\n"
"        \"friends_count\": 1943,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Thu Jul 31 13:51:57 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 737,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/494844659856728064/xBQfnm5J_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/494844659856728064/xBQfnm5J_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2695745652/1406815103\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:02 +0000 2014\",\n"
"      \"id\": 505874868533854200,\n"
"      \"id_str\": \"505874868533854209\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/sunikar_daisuki\\\" rel=\\\"nofollow\\\">スニーカー大好き★図鑑</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2707963890,\n"
"        \"id_str\": \"2707963890\",\n"
"        \"name\": \"スニーカー大好き★図鑑\",\n"
"        \"screen_name\": \"sunikar_daisuki\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"スニーカー好きを見つけて仲間になろう♪\\r\\n気に入ったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 394,\n"
"        \"friends_count\": 1891,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 05 01:54:28 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 642,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496474952631996416/f0C_u3_u_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496474952631996416/f0C_u3_u_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2707963890/1407203869\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"zh\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:01 +0000 2014\",\n"
"      \"id\": 505874867997380600,\n"
"      \"id_str\": \"505874867997380608\",\n"
"      \"text\": \"\\\"@BelloTexto: ¿Quieres ser feliz? \\n一\\\"No stalkees\\\" \\n一\\\"No stalkees\\\" \\n一\\\"No stalkees\\\" \\n一\\\"No stalkees\\\" \\n一\\\"No stalkees\\\" \\n一\\\"No stalkees\\\".\\\"\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2249378935,\n"
"        \"id_str\": \"2249378935\",\n"
"        \"name\": \"Maggie Becerril \",\n"
"        \"screen_name\": \"maggdesie\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"cambiando la vida de las personas.\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 120,\n"
"        \"friends_count\": 391,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Mon Dec 16 21:56:49 +0000 2013\",\n"
"        \"favourites_count\": 314,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 1657,\n"
"        \"lang\": \"es\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/505093371665604608/K0x_LV2y_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/505093371665604608/K0x_LV2y_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2249378935/1409258479\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"BelloTexto\",\n"
"            \"name\": \"Indirectas... ✉\",\n"
"            \"id\": 833083404,\n"
"            \"id_str\": \"833083404\",\n"
"            \"indices\": [\n"
"              1,\n"
"              12\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"zh\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:01 +0000 2014\",\n"
"      \"id\": 505874867720183800,\n"
"      \"id_str\": \"505874867720183808\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/iseiuragao\\\" rel=\\\"nofollow\\\">ザ・異性の裏の顔</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2719746578,\n"
"        \"id_str\": \"2719746578\",\n"
"        \"name\": \"ザ・異性の裏の顔\",\n"
"        \"screen_name\": \"iseiuragao\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"異性について少し学ぶことで、必然的にモテるようになる！？　相手を理解することで見えてくるもの「それは・・・●●」　いい内容だと思ったら RT & フォローもお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 238,\n"
"        \"friends_count\": 1922,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Aug 09 17:18:43 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 532,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498157077726900224/tW8q4di__normal.png\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498157077726900224/tW8q4di__normal.png\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2719746578/1407604947\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:01 +0000 2014\",\n"
"      \"id\": 505874866910687200,\n"
"      \"id_str\": \"505874866910687233\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/bijyoalbum\\\" rel=\\\"nofollow\\\">超w美女☆アルバム</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744054334,\n"
"        \"id_str\": \"2744054334\",\n"
"        \"name\": \"超w美女☆アルバム\",\n"
"        \"screen_name\": \"bijyoalbum\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"「おお～っ！いいね～」って、思わず言ってしまう、美女を見つけます☆ \\r\\nタイプだと思ったら RT & 相互フォローでお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 45,\n"
"        \"friends_count\": 966,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 05:36:48 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 352,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501604413312491520/GP66eKWr_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501604413312491520/GP66eKWr_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744054334/1408426814\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:01 +0000 2014\",\n"
"      \"id\": 505874866105376800,\n"
"      \"id_str\": \"505874866105376769\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/jyoshiuraseitai\\\" rel=\\\"nofollow\\\">男に見せない女子の裏生態</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744261238,\n"
"        \"id_str\": \"2744261238\",\n"
"        \"name\": \"男に見せない女子の裏生態\",\n"
"        \"screen_name\": \"jyoshiuraseitai\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"男の知らない女子ならではのあるある☆ \\r\\nそんな生々しい女子の生態をつぶやきます。 \\r\\nわかる～って人は RT & フォローでお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 203,\n"
"        \"friends_count\": 967,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 08:01:28 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 348,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501641354804346880/Uh1-n1LD_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501641354804346880/Uh1-n1LD_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744261238/1408435630\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:01 +0000 2014\",\n"
"      \"id\": 505874865354584060,\n"
"      \"id_str\": \"505874865354584064\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/soubutu_seitai\\\" rel=\\\"nofollow\\\">驚きの動物たちの生態</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2759403146,\n"
"        \"id_str\": \"2759403146\",\n"
"        \"name\": \"驚きの動物たちの生態\",\n"
"        \"screen_name\": \"soubutu_seitai\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"「おお～っ」と 言われるような、動物の生態をツイートします♪ \\r\\n知っていると、あなたも人気者に!? \\r\\nおもしろかったら RT & フォローを、お願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 67,\n"
"        \"friends_count\": 954,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Aug 23 16:39:31 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 219,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503220468128567296/Z8mGDIBS_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503220468128567296/Z8mGDIBS_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2759403146/1408812130\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:01 +0000 2014\",\n"
"      \"id\": 505874864603820000,\n"
"      \"id_str\": \"505874864603820032\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/mote_woman\\\" rel=\\\"nofollow\\\">モテ女子★ファションの秘密</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2706659820,\n"
"        \"id_str\": \"2706659820\",\n"
"        \"name\": \"モテ女子★ファションの秘密\",\n"
"        \"screen_name\": \"mote_woman\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"オシャレかわいい♥モテ度UPの注目アイテムを見つけます。\\r\\n気に入ったら RT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 217,\n"
"        \"friends_count\": 1806,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Mon Aug 04 14:30:24 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 682,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496303370936668161/s7xP8rTy_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496303370936668161/s7xP8rTy_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2706659820/1407163059\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:00 +0000 2014\",\n"
"      \"id\": 505874863874007040,\n"
"      \"id_str\": \"505874863874007040\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/danjyonotigai1\\\" rel=\\\"nofollow\\\">男女の違いを解明する</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2761896468,\n"
"        \"id_str\": \"2761896468\",\n"
"        \"name\": \"男女の違いを解明する\",\n"
"        \"screen_name\": \"danjyonotigai1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"意外と理解できていない男女それぞれの事情。 \\r\\n「えっ　マジで!?」と驚くような、男女の習性をつぶやきます♪ ためになったら、是非 RT ＆ フォローで、お願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 82,\n"
"        \"friends_count\": 992,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 24 09:47:44 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 237,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503479057380413441/zDLu5Z9o_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503479057380413441/zDLu5Z9o_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2761896468/1408873803\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:00 +0000 2014\",\n"
"      \"id\": 505874862900924400,\n"
"      \"id_str\": \"505874862900924416\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/kamihassou\\\" rel=\\\"nofollow\\\">神レベル★極限の発想</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744950735,\n"
"        \"id_str\": \"2744950735\",\n"
"        \"name\": \"神レベル★極限の発想\",\n"
"        \"screen_name\": \"kamihassou\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"見ているだけで、本気がビシバシ伝わってきます！ \\r\\n人生のヒントになるような、そんな究極の発想を集めています。 \\r\\nいいなと思ったら RT & 相互フォローで、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 84,\n"
"        \"friends_count\": 992,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 13:36:05 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 343,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501725053189226496/xZNOTYz2_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501725053189226496/xZNOTYz2_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744950735/1408455571\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:00 +0000 2014\",\n"
"      \"id\": 505874862397591550,\n"
"      \"id_str\": \"505874862397591552\",\n"
"      \"text\": \"@kaoritoxx そうよ！あたしはそう思うようにしておる。いま職場一やけとる気がする(°_°)！満喫幸せ焼け！！wあー、なるほどね！毎回そうだよね！ティアラちゃんみにいってるもんね♡五月と九月恐ろしい、、、\\nハリポタエリアはいった？？\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": 505838547308277760,\n"
"      \"in_reply_to_status_id_str\": \"505838547308277761\",\n"
"      \"in_reply_to_user_id\": 796000214,\n"
"      \"in_reply_to_user_id_str\": \"796000214\",\n"
"      \"in_reply_to_screen_name\": \"kaoritoxx\",\n"
"      \"user\": {\n"
"        \"id\": 2256249487,\n"
"        \"id_str\": \"2256249487\",\n"
"        \"name\": \"はあちゃん@海賊同盟中\",\n"
"        \"screen_name\": \"onepiece_24\",\n"
"        \"location\": \"どえすえろぉたんの助手兼ね妹(願望)\",\n"
"        \"description\": \"ONE PIECE愛しすぎて今年２３ちゃい(歴１４年目)ゾロ様に一途だったのにロー、このやろー。ロビンちゃんが幸せになればいい。ルフィは無条件にすき。ゾロビン、ローロビ、ルロビ♡usj、声優さん、コナン、進撃、クレしん、H x Hも好き♩\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 415,\n"
"        \"friends_count\": 384,\n"
"        \"listed_count\": 3,\n"
"        \"created_at\": \"Sat Dec 21 09:37:25 +0000 2013\",\n"
"        \"favourites_count\": 1603,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 9636,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501686340564418561/hMQFN4vD_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501686340564418561/hMQFN4vD_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2256249487/1399987924\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"kaoritoxx\",\n"
"            \"name\": \"かおちゃん\",\n"
"            \"id\": 796000214,\n"
"            \"id_str\": \"796000214\",\n"
"            \"indices\": [\n"
"              0,\n"
"              10\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:00 +0000 2014\",\n"
"      \"id\": 505874861973991400,\n"
"      \"id_str\": \"505874861973991424\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/renai_sennin\\\" rel=\\\"nofollow\\\">恋愛仙人</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2698885082,\n"
"        \"id_str\": \"2698885082\",\n"
"        \"name\": \"恋愛仙人\",\n"
"        \"screen_name\": \"renai_sennin\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"豊富でステキな恋愛経験を、シェアしましょう。\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 618,\n"
"        \"friends_count\": 1847,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Fri Aug 01 18:09:38 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 726,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495272204641132544/GNA18aOg_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495272204641132544/GNA18aOg_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2698885082/1406917096\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:00 +0000 2014\",\n"
"      \"id\": 505874861881700350,\n"
"      \"id_str\": \"505874861881700353\",\n"
"      \"text\": \"@itsukibot_ 一稀の俺のソーセージをペロペロする音はデカイ\",\n"
"      \"source\": \"<a href=\\\"http://jigtwi.jp/?p=1\\\" rel=\\\"nofollow\\\">jigtwi</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": 505871017428795400,\n"
"      \"in_reply_to_status_id_str\": \"505871017428795392\",\n"
"      \"in_reply_to_user_id\": 141170845,\n"
"      \"in_reply_to_user_id_str\": \"141170845\",\n"
"      \"in_reply_to_screen_name\": \"itsukibot_\",\n"
"      \"user\": {\n"
"        \"id\": 2184752048,\n"
"        \"id_str\": \"2184752048\",\n"
"        \"name\": \"アンドー\",\n"
"        \"screen_name\": \"55dakedayo\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 15,\n"
"        \"friends_count\": 24,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Nov 09 17:42:22 +0000 2013\",\n"
"        \"favourites_count\": 37249,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Irkutsk\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 21070,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://abs.twimg.com/sticky/default_profile_images/default_profile_3_normal.png\",\n"
"        \"profile_image_url_https\": \"https://abs.twimg.com/sticky/default_profile_images/default_profile_3_normal.png\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": true,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"itsukibot_\",\n"
"            \"name\": \"前田一稀\",\n"
"            \"id\": 141170845,\n"
"            \"id_str\": \"141170845\",\n"
"            \"indices\": [\n"
"              0,\n"
"              11\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:00 +0000 2014\",\n"
"      \"id\": 505874861185437700,\n"
"      \"id_str\": \"505874861185437697\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/densetunodorama\\\" rel=\\\"nofollow\\\">あの伝説の名ドラマ＆名場面</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2706951979,\n"
"        \"id_str\": \"2706951979\",\n"
"        \"name\": \"あの伝説の名ドラマ＆名場面\",\n"
"        \"screen_name\": \"densetunodorama\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"誰にでも記憶に残る、ドラマの名場面があると思います。そんな感動のストーリーを、もう一度わかちあいたいです。\\r\\n「これ知ってる！」とか「あ～懐かしい」と思ったら RT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 300,\n"
"        \"friends_count\": 1886,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Mon Aug 04 16:38:25 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 694,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/496335892152209408/fKzb8Nv3_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/496335892152209408/fKzb8Nv3_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2706951979/1407170704\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:29:00 +0000 2014\",\n"
"      \"id\": 505874860447260700,\n"
"      \"id_str\": \"505874860447260672\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/tabetaicake1\\\" rel=\\\"nofollow\\\">マジで食べたい♥ケーキ特集</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2724328646,\n"
"        \"id_str\": \"2724328646\",\n"
"        \"name\": \"マジで食べたい♥ケーキ特集\",\n"
"        \"screen_name\": \"tabetaicake1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"女性の目線から見た、美味しそうなケーキを探し求めています。\\r\\n見てるだけで、あれもコレも食べたくなっちゃう♪\\r\\n美味しそうだと思ったら、是非 RT ＆ フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 158,\n"
"        \"friends_count\": 1907,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Mon Aug 11 17:15:22 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 493,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498881289844293632/DAa9No9M_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498881289844293632/DAa9No9M_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2724328646/1407777704\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:59 +0000 2014\",\n"
"      \"id\": 505874859662925800,\n"
"      \"id_str\": \"505874859662925824\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/adi_mania11\\\" rel=\\\"nofollow\\\">アディダス★マニア</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2704003662,\n"
"        \"id_str\": \"2704003662\",\n"
"        \"name\": \"アディダス★マニア\",\n"
"        \"screen_name\": \"adi_mania11\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"素敵なアディダスのアイテムを見つけたいです♪\\r\\n気に入ってもらえたららRT & 相互フォローで みなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 340,\n"
"        \"friends_count\": 1851,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 03 12:26:37 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 734,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495911561781727235/06QAMVrR_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495911561781727235/06QAMVrR_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2704003662/1407069046\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:59 +0000 2014\",\n"
"      \"id\": 505874858920513540,\n"
"      \"id_str\": \"505874858920513537\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/moe_pet1\\\" rel=\\\"nofollow\\\">萌えペット大好き</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2719061228,\n"
"        \"id_str\": \"2719061228\",\n"
"        \"name\": \"萌えペット大好き\",\n"
"        \"screen_name\": \"moe_pet1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"かわいいペットを見るのが趣味です♥そんな私と一緒にいやされたい人いませんか？かわいいと思ったら RT & フォローもお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 289,\n"
"        \"friends_count\": 1812,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Aug 09 10:20:25 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 632,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498051549537386496/QizThq7N_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498051549537386496/QizThq7N_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2719061228/1407581287\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:59 +0000 2014\",\n"
"      \"id\": 505874858115219460,\n"
"      \"id_str\": \"505874858115219456\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/renaikyoukasyo\\\" rel=\\\"nofollow\\\">恋愛の教科書　</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2744344514,\n"
"        \"id_str\": \"2744344514\",\n"
"        \"name\": \"恋愛の教科書\",\n"
"        \"screen_name\": \"renaikyoukasyo\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"もっと早く知っとくべきだった～！知っていればもっと上手くいく♪ \\r\\n今すぐ役立つ恋愛についての雑学やマメ知識をお届けします。 \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 124,\n"
"        \"friends_count\": 955,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Tue Aug 19 08:32:45 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 346,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501655512018997248/7SznYGWi_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501655512018997248/7SznYGWi_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2744344514/1408439001\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:59 +0000 2014\",\n"
"      \"id\": 505874857335074800,\n"
"      \"id_str\": \"505874857335074816\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/omorogakusei\\\" rel=\\\"nofollow\\\">オモロすぎる★学生の日常</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2699365116,\n"
"        \"id_str\": \"2699365116\",\n"
"        \"name\": \"オモロすぎる★学生の日常\",\n"
"        \"screen_name\": \"omorogakusei\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"楽しすぎる学生の日常を探していきます。\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 289,\n"
"        \"friends_count\": 1156,\n"
"        \"listed_count\": 2,\n"
"        \"created_at\": \"Fri Aug 01 23:35:18 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 770,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495353473886478336/S-4B_RVl_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495353473886478336/S-4B_RVl_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2699365116/1406936481\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:59 +0000 2014\",\n"
"      \"id\": 505874856605257700,\n"
"      \"id_str\": \"505874856605257728\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/akogareinteria\\\" rel=\\\"nofollow\\\">憧れの★インテリア図鑑</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2721907602,\n"
"        \"id_str\": \"2721907602\",\n"
"        \"name\": \"憧れの★インテリア図鑑\",\n"
"        \"screen_name\": \"akogareinteria\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"自分の住む部屋もこんなふうにしてみたい♪　\\r\\nそんな素敵なインテリアを、日々探していますw　\\r\\nいいなと思ったら RT & 相互フォローお願いします。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 298,\n"
"        \"friends_count\": 1925,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sun Aug 10 15:59:13 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 540,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498499374423343105/Wi_izHvT_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498499374423343105/Wi_izHvT_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2721907602/1407686543\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:59 +0000 2014\",\n"
"      \"id\": 505874856089378800,\n"
"      \"id_str\": \"505874856089378816\",\n"
"      \"text\": \"天冥の標 VI 宿怨 PART1 / 小川 一水\\nhttp://t.co/fXIgRt4ffH\\n \\n#キンドル #天冥の標VI宿怨PART1\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/\\\" rel=\\\"nofollow\\\">waromett</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1953404612,\n"
"        \"id_str\": \"1953404612\",\n"
"        \"name\": \"わろめっと\",\n"
"        \"screen_name\": \"waromett\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"たのしいついーとしょうかい\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 16980,\n"
"        \"friends_count\": 16983,\n"
"        \"listed_count\": 18,\n"
"        \"created_at\": \"Fri Oct 11 05:49:57 +0000 2013\",\n"
"        \"favourites_count\": 3833,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Tokyo\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 98655,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"352726\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme5/bg.gif\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme5/bg.gif\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/378800000578908101/14c4744c7aa34b1f8bbd942b78e59385_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/378800000578908101/14c4744c7aa34b1f8bbd942b78e59385_normal.jpeg\",\n"
"        \"profile_link_color\": \"D02B55\",\n"
"        \"profile_sidebar_border_color\": \"829D5E\",\n"
"        \"profile_sidebar_fill_color\": \"99CC33\",\n"
"        \"profile_text_color\": \"3E4415\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [\n"
"          {\n"
"            \"text\": \"キンドル\",\n"
"            \"indices\": [\n"
"              50,\n"
"              55\n"
"            ]\n"
"          },\n"
"          {\n"
"            \"text\": \"天冥の標VI宿怨PART1\",\n"
"            \"indices\": [\n"
"              56,\n"
"              70\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/fXIgRt4ffH\",\n"
"            \"expanded_url\": \"http://j.mp/1kHBOym\",\n"
"            \"display_url\": \"j.mp/1kHBOym\",\n"
"            \"indices\": [\n"
"              25,\n"
"              47\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"zh\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:58 +0000 2014\",\n"
"      \"id\": 505874855770599400,\n"
"      \"id_str\": \"505874855770599425\",\n"
"      \"text\": \"四川盆地江淮等地将有强降雨 开学日多地将有雨: 　　中新网8月31日电 据中央气象台消息，江淮东部、四川盆地东北部等地今天(31日)又将迎来一场暴雨或大暴雨天气。明天9月1日，是中小学生开学的日子。预计明天，内蒙古中部、... http://t.co/RNdqIHmTby\",\n"
"      \"source\": \"<a href=\\\"http://twitterfeed.com\\\" rel=\\\"nofollow\\\">twitterfeed</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 402427654,\n"
"        \"id_str\": \"402427654\",\n"
"        \"name\": \"中国新闻\",\n"
"        \"screen_name\": \"zhongwenxinwen\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"中国的新闻，世界的新闻。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 2429,\n"
"        \"friends_count\": 15,\n"
"        \"listed_count\": 29,\n"
"        \"created_at\": \"Tue Nov 01 01:56:43 +0000 2011\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": -28800,\n"
"        \"time_zone\": \"Alaska\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 84564,\n"
"        \"lang\": \"zh-cn\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"709397\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme6/bg.gif\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme6/bg.gif\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/2700523149/5597e347b2eb880425faef54287995f2_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/2700523149/5597e347b2eb880425faef54287995f2_normal.jpeg\",\n"
"        \"profile_link_color\": \"FF3300\",\n"
"        \"profile_sidebar_border_color\": \"86A4A6\",\n"
"        \"profile_sidebar_fill_color\": \"A0C5C7\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/RNdqIHmTby\",\n"
"            \"expanded_url\": \"http://bit.ly/1tOdNsI\",\n"
"            \"display_url\": \"bit.ly/1tOdNsI\",\n"
"            \"indices\": [\n"
"              114,\n"
"              136\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"zh\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:58 +0000 2014\",\n"
"      \"id\": 505874854877200400,\n"
"      \"id_str\": \"505874854877200384\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/LDH_daisuki1\\\" rel=\\\"nofollow\\\">LDH ★大好き応援団</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2700961603,\n"
"        \"id_str\": \"2700961603\",\n"
"        \"name\": \"LDH ★大好き応援団\",\n"
"        \"screen_name\": \"LDH_daisuki1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"LDHファンは、全員仲間です♪\\r\\n面白かったらRT & 相互フォローでみなさん、お願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 458,\n"
"        \"friends_count\": 1895,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Sat Aug 02 14:23:46 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 735,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/495578007298252800/FOZflgYu_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/495578007298252800/FOZflgYu_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2700961603/1406989928\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:58 +0000 2014\",\n"
"      \"id\": 505874854147407900,\n"
"      \"id_str\": \"505874854147407872\",\n"
"      \"text\": \"RT @shiawaseomamori: 一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるの…\",\n"
"      \"source\": \"<a href=\\\"https://twitter.com/anime_toshiden1\\\" rel=\\\"nofollow\\\">マジ!?怖いアニメ都市伝説</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2719489172,\n"
"        \"id_str\": \"2719489172\",\n"
"        \"name\": \"マジ!?怖いアニメ都市伝説\",\n"
"        \"screen_name\": \"anime_toshiden1\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"あなたの知らない、怖すぎるアニメの都市伝説を集めています。\\r\\n「え～知らなかったよww]」って人は RT & フォローお願いします♪\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 377,\n"
"        \"friends_count\": 1911,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Sat Aug 09 14:41:15 +0000 2014\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 536,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/498118027322208258/h7XOTTSi_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/498118027322208258/h7XOTTSi_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2719489172/1407595513\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:06 +0000 2014\",\n"
"        \"id\": 505871615125491700,\n"
"        \"id_str\": \"505871615125491712\",\n"
"        \"text\": \"一に止まると書いて、正しいという意味だなんて、この年になるまで知りませんでした。 人は生きていると、前へ前へという気持ちばかり急いて、どんどん大切なものを置き去りにしていくものでしょう。本当に正しいことというのは、一番初めの場所にあるのかもしれません。 by神様のカルテ、夏川草介\",\n"
"        \"source\": \"<a href=\\\"https://twitter.com/shiawaseomamori\\\" rel=\\\"nofollow\\\">幸せの☆お守り</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2745121514,\n"
"          \"id_str\": \"2745121514\",\n"
"          \"name\": \"幸せの☆お守り\",\n"
"          \"screen_name\": \"shiawaseomamori\",\n"
"          \"location\": \"\",\n"
"          \"description\": \"自分が幸せだと周りも幸せにできる！ \\r\\nそんな人生を精一杯生きるために必要な言葉をお届けします♪ \\r\\nいいなと思ったら RT & 相互フォローで、お願いします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 213,\n"
"          \"friends_count\": 991,\n"
"          \"listed_count\": 0,\n"
"          \"created_at\": \"Tue Aug 19 14:45:19 +0000 2014\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 349,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/501742437606244354/scXy81ZW_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2745121514/1408459730\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 58,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 58,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"shiawaseomamori\",\n"
"            \"name\": \"幸せの☆お守り\",\n"
"            \"id\": 2745121514,\n"
"            \"id_str\": \"2745121514\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:58 +0000 2014\",\n"
"      \"id\": 505874854134820860,\n"
"      \"id_str\": \"505874854134820864\",\n"
"      \"text\": \"@vesperia1985 おはよー！\\n今日までなのですよ…！！明日一生来なくていい\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": 505868030329364500,\n"
"      \"in_reply_to_status_id_str\": \"505868030329364480\",\n"
"      \"in_reply_to_user_id\": 2286548834,\n"
"      \"in_reply_to_user_id_str\": \"2286548834\",\n"
"      \"in_reply_to_screen_name\": \"vesperia1985\",\n"
"      \"user\": {\n"
"        \"id\": 2389045190,\n"
"        \"id_str\": \"2389045190\",\n"
"        \"name\": \"りいこ\",\n"
"        \"screen_name\": \"riiko_dq10\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"サマーエルフです、りいこです。えるおくんラブです！随時ふれぼしゅ〜〜(っ˘ω˘c )＊日常のどうでもいいことも呟いてますがよろしくね〜\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 67,\n"
"        \"friends_count\": 69,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Fri Mar 14 13:02:27 +0000 2014\",\n"
"        \"favourites_count\": 120,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 324,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/503906346815610881/BfSrCoBr_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/503906346815610881/BfSrCoBr_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2389045190/1409232058\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"vesperia1985\",\n"
"            \"name\": \"ユーリ\",\n"
"            \"id\": 2286548834,\n"
"            \"id_str\": \"2286548834\",\n"
"            \"indices\": [\n"
"              0,\n"
"              13\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:58 +0000 2014\",\n"
"      \"id\": 505874853778685950,\n"
"      \"id_str\": \"505874853778685952\",\n"
"      \"text\": \"【映画パンフレット】　永遠の０ （永遠のゼロ）　監督　山崎貴　キャスト　岡田准一、三浦春馬、井上真央東宝(2)11点の新品／中古品を見る: ￥ 500より\\n(この商品の現在のランクに関する正式な情報については、アートフレーム... http://t.co/4hbyB1rbQ7\",\n"
"      \"source\": \"<a href=\\\"http://ifttt.com\\\" rel=\\\"nofollow\\\">IFTTT</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1319883571,\n"
"        \"id_str\": \"1319883571\",\n"
"        \"name\": \"森林木工家具製作所\",\n"
"        \"screen_name\": \"Furniturewood\",\n"
"        \"location\": \"沖縄\",\n"
"        \"description\": \"家具（かぐ、Furniture）は、家財道具のうち家の中に据え置いて利用する比較的大型の道具類、または元々家に作り付けられている比較的大型の道具類をさす。なお、日本の建築基準法上は、作り付け家具は、建築確認及び完了検査の対象となるが、後から置かれるものについては対象外である。\",\n"
"        \"url\": \"http://t.co/V4oyL0xtZk\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/V4oyL0xtZk\",\n"
"                \"expanded_url\": \"http://astore.amazon.co.jp/furniturewood-22\",\n"
"                \"display_url\": \"astore.amazon.co.jp/furniturewood-…\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 677,\n"
"        \"friends_count\": 743,\n"
"        \"listed_count\": 1,\n"
"        \"created_at\": \"Mon Apr 01 07:55:14 +0000 2013\",\n"
"        \"favourites_count\": 0,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Irkutsk\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 17210,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/3460466135/c67d9df9b760787b9ed284fe80b1dd31_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/3460466135/c67d9df9b760787b9ed284fe80b1dd31_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1319883571/1364804982\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/4hbyB1rbQ7\",\n"
"            \"expanded_url\": \"http://ift.tt/1kT55bk\",\n"
"            \"display_url\": \"ift.tt/1kT55bk\",\n"
"            \"indices\": [\n"
"              116,\n"
"              138\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:58 +0000 2014\",\n"
"      \"id\": 505874852754907140,\n"
"      \"id_str\": \"505874852754907136\",\n"
"      \"text\": \"RT @siranuga_hotoke: ゴキブリは一世帯に平均して480匹いる。\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 413944345,\n"
"        \"id_str\": \"413944345\",\n"
"        \"name\": \"泥酔イナバウアー\",\n"
"        \"screen_name\": \"Natade_co_co_21\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"君の瞳にうつる僕に乾杯。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 298,\n"
"        \"friends_count\": 300,\n"
"        \"listed_count\": 4,\n"
"        \"created_at\": \"Wed Nov 16 12:52:46 +0000 2011\",\n"
"        \"favourites_count\": 3125,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 12237,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"FFF04D\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/378800000115928444/9bf5fa13385cc80bfeb097e51af9862a.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/378800000115928444/9bf5fa13385cc80bfeb097e51af9862a.jpeg\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/500849752351600640/lMQqIzYj_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/500849752351600640/lMQqIzYj_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/413944345/1403511193\",\n"
"        \"profile_link_color\": \"0099CC\",\n"
"        \"profile_sidebar_border_color\": \"000000\",\n"
"        \"profile_sidebar_fill_color\": \"F6FFD1\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 23:24:23 +0000 2014\",\n"
"        \"id\": 505858599411666940,\n"
"        \"id_str\": \"505858599411666944\",\n"
"        \"text\": \"ゴキブリは一世帯に平均して480匹いる。\",\n"
"        \"source\": \"<a href=\\\"http://twittbot.net/\\\" rel=\\\"nofollow\\\">twittbot.net</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 2243896200,\n"
"          \"id_str\": \"2243896200\",\n"
"          \"name\": \"知らぬが仏bot\",\n"
"          \"screen_name\": \"siranuga_hotoke\",\n"
"          \"location\": \"奈良・京都辺り\",\n"
"          \"description\": \"知らぬが仏な情報をお伝えします。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 3288,\n"
"          \"friends_count\": 3482,\n"
"          \"listed_count\": 7,\n"
"          \"created_at\": \"Fri Dec 13 13:16:35 +0000 2013\",\n"
"          \"favourites_count\": 0,\n"
"          \"utc_offset\": null,\n"
"          \"time_zone\": null,\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 1570,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/378800000866399372/ypy5NnPe_normal.png\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/378800000866399372/ypy5NnPe_normal.png\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/2243896200/1386997755\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 1,\n"
"        \"favorite_count\": 0,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 1,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"siranuga_hotoke\",\n"
"            \"name\": \"知らぬが仏bot\",\n"
"            \"id\": 2243896200,\n"
"            \"id_str\": \"2243896200\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:58 +0000 2014\",\n"
"      \"id\": 505874852603908100,\n"
"      \"id_str\": \"505874852603908096\",\n"
"      \"text\": \"RT @UARROW_Y: ようかい体操第一を踊る国見英 http://t.co/SXoYWH98as\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 2463035136,\n"
"        \"id_str\": \"2463035136\",\n"
"        \"name\": \"や\",\n"
"        \"screen_name\": \"yae45\",\n"
"        \"location\": \"\",\n"
"        \"description\": \"きもちわるいことつぶやく用\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 4,\n"
"        \"friends_count\": 30,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Fri Apr 25 10:49:20 +0000 2014\",\n"
"        \"favourites_count\": 827,\n"
"        \"utc_offset\": 32400,\n"
"        \"time_zone\": \"Irkutsk\",\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 390,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/505345820137234433/csFeRxPm_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/505345820137234433/csFeRxPm_normal.jpeg\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"ja\"\n"
"        },\n"
"        \"created_at\": \"Sun Aug 31 00:16:45 +0000 2014\",\n"
"        \"id\": 505871779949051900,\n"
"        \"id_str\": \"505871779949051904\",\n"
"        \"text\": \"ようかい体操第一を踊る国見英 http://t.co/SXoYWH98as\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com/download/android\\\" rel=\\\"nofollow\\\">Twitter for Android</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 1261662588,\n"
"          \"id_str\": \"1261662588\",\n"
"          \"name\": \"ゆう矢\",\n"
"          \"screen_name\": \"UARROW_Y\",\n"
"          \"location\": \"つくり出そう国影の波 広げよう国影の輪\",\n"
"          \"description\": \"HQ!! 成人済腐女子。日常ツイート多いです。赤葦京治夢豚クソツイ含みます注意。フォローをお考えの際はプロフご一読お願い致します。FRBお気軽に\",\n"
"          \"url\": \"http://t.co/LFX2XOzb0l\",\n"
"          \"entities\": {\n"
"            \"url\": {\n"
"              \"urls\": [\n"
"                {\n"
"                  \"url\": \"http://t.co/LFX2XOzb0l\",\n"
"                  \"expanded_url\": \"http://twpf.jp/UARROW_Y\",\n"
"                  \"display_url\": \"twpf.jp/UARROW_Y\",\n"
"                  \"indices\": [\n"
"                    0,\n"
"                    22\n"
"                  ]\n"
"                }\n"
"              ]\n"
"            },\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 265,\n"
"          \"friends_count\": 124,\n"
"          \"listed_count\": 12,\n"
"          \"created_at\": \"Tue Mar 12 10:42:17 +0000 2013\",\n"
"          \"favourites_count\": 6762,\n"
"          \"utc_offset\": 32400,\n"
"          \"time_zone\": \"Tokyo\",\n"
"          \"geo_enabled\": true,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 55946,\n"
"          \"lang\": \"ja\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"C0DEED\",\n"
"          \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"          \"profile_background_tile\": false,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/502095104618663937/IzuPYx3E_normal.png\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/502095104618663937/IzuPYx3E_normal.png\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1261662588/1408618604\",\n"
"          \"profile_link_color\": \"0084B4\",\n"
"          \"profile_sidebar_border_color\": \"C0DEED\",\n"
"          \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"          \"profile_text_color\": \"333333\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": true,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 29,\n"
"        \"favorite_count\": 54,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [\n"
"            {\n"
"              \"url\": \"http://t.co/SXoYWH98as\",\n"
"              \"expanded_url\": \"http://twitter.com/UARROW_Y/status/505871779949051904/photo/1\",\n"
"              \"display_url\": \"pic.twitter.com/SXoYWH98as\",\n"
"              \"indices\": [\n"
"                15,\n"
"                37\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"user_mentions\": []\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"ja\"\n"
"      },\n"
"      \"retweet_count\": 29,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/SXoYWH98as\",\n"
"            \"expanded_url\": \"http://twitter.com/UARROW_Y/status/505871779949051904/photo/1\",\n"
"            \"display_url\": \"pic.twitter.com/SXoYWH98as\",\n"
"            \"indices\": [\n"
"              29,\n"
"              51\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"UARROW_Y\",\n"
"            \"name\": \"ゆう矢\",\n"
"            \"id\": 1261662588,\n"
"            \"id_str\": \"1261662588\",\n"
"            \"indices\": [\n"
"              3,\n"
"              12\n"
"            ]\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"zh\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:57 +0000 2014\",\n"
"      \"id\": 505874848900341760,\n"
"      \"id_str\": \"505874848900341760\",\n"
"      \"text\": \"RT @fightcensorship: 李克強總理的臉綠了！在前日南京青奧會閉幕式，觀眾席上一名貪玩韓國少年運動員，竟斗膽用激光筆射向中國總理李克強的臉。http://t.co/HLX9mHcQwe http://t.co/fVVOSML5s8\",\n"
"      \"source\": \"<a href=\\\"http://twitter.com/download/iphone\\\" rel=\\\"nofollow\\\">Twitter for iPhone</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 889332218,\n"
"        \"id_str\": \"889332218\",\n"
"        \"name\": \"民權初步\",\n"
"        \"screen_name\": \"JoeyYoungkm\",\n"
"        \"location\": \"km/cn\",\n"
"        \"description\": \"经历了怎样的曲折才从追求“一致通过”发展到今天人们接受“过半数通过”，正是人们认识到对“一致”甚至是“基本一致”的追求本身就会变成一种独裁。\",\n"
"        \"url\": null,\n"
"        \"entities\": {\n"
"          \"description\": {\n"
"            \"urls\": []\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 313,\n"
"        \"friends_count\": 46,\n"
"        \"listed_count\": 0,\n"
"        \"created_at\": \"Thu Oct 18 17:21:17 +0000 2012\",\n"
"        \"favourites_count\": 24,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 15707,\n"
"        \"lang\": \"en\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"C0DEED\",\n"
"        \"profile_background_image_url\": \"http://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_image_url_https\": \"https://abs.twimg.com/images/themes/theme1/bg.png\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/378800000563062033/a7e8274752ce36a6cd5bad971ec7d416_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/378800000563062033/a7e8274752ce36a6cd5bad971ec7d416_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/889332218/1388896916\",\n"
"        \"profile_link_color\": \"0084B4\",\n"
"        \"profile_sidebar_border_color\": \"C0DEED\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": true,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweeted_status\": {\n"
"        \"metadata\": {\n"
"          \"result_type\": \"recent\",\n"
"          \"iso_language_code\": \"zh\"\n"
"        },\n"
"        \"created_at\": \"Sat Aug 30 23:56:27 +0000 2014\",\n"
"        \"id\": 505866670356070400,\n"
"        \"id_str\": \"505866670356070401\",\n"
"        \"text\": \"李克強總理的臉綠了！在前日南京青奧會閉幕式，觀眾席上一名貪玩韓國少年運動員，竟斗膽用激光筆射向中國總理李克強的臉。http://t.co/HLX9mHcQwe http://t.co/fVVOSML5s8\",\n"
"        \"source\": \"<a href=\\\"http://twitter.com\\\" rel=\\\"nofollow\\\">Twitter Web Client</a>\",\n"
"        \"truncated\": false,\n"
"        \"in_reply_to_status_id\": null,\n"
"        \"in_reply_to_status_id_str\": null,\n"
"        \"in_reply_to_user_id\": null,\n"
"        \"in_reply_to_user_id_str\": null,\n"
"        \"in_reply_to_screen_name\": null,\n"
"        \"user\": {\n"
"          \"id\": 67661086,\n"
"          \"id_str\": \"67661086\",\n"
"          \"name\": \"※范强※法特姗瑟希蒲※\",\n"
"          \"screen_name\": \"fightcensorship\",\n"
"          \"location\": \"Middle of Nowhere\",\n"
"          \"description\": \"被人指责“封建”、“落后”、“保守”的代表，当代红卫兵攻击对象。致力于言论自由，人权； 倡导资讯公开，反对网络封锁。既不是精英分子，也不是意见领袖，本推言论不代表任何国家、党派和组织，也不标榜伟大、光荣和正确。\",\n"
"          \"url\": null,\n"
"          \"entities\": {\n"
"            \"description\": {\n"
"              \"urls\": []\n"
"            }\n"
"          },\n"
"          \"protected\": false,\n"
"          \"followers_count\": 7143,\n"
"          \"friends_count\": 779,\n"
"          \"listed_count\": 94,\n"
"          \"created_at\": \"Fri Aug 21 17:16:22 +0000 2009\",\n"
"          \"favourites_count\": 364,\n"
"          \"utc_offset\": 28800,\n"
"          \"time_zone\": \"Singapore\",\n"
"          \"geo_enabled\": false,\n"
"          \"verified\": false,\n"
"          \"statuses_count\": 16751,\n"
"          \"lang\": \"en\",\n"
"          \"contributors_enabled\": false,\n"
"          \"is_translator\": false,\n"
"          \"is_translation_enabled\": false,\n"
"          \"profile_background_color\": \"FFFFFF\",\n"
"          \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/611138516/toeccqnahbpmr0sw9ybv.jpeg\",\n"
"          \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/611138516/toeccqnahbpmr0sw9ybv.jpeg\",\n"
"          \"profile_background_tile\": true,\n"
"          \"profile_image_url\": \"http://pbs.twimg.com/profile_images/3253137427/3524557d21ef2c04871e985d4d136bdb_normal.jpeg\",\n"
"          \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/3253137427/3524557d21ef2c04871e985d4d136bdb_normal.jpeg\",\n"
"          \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/67661086/1385608347\",\n"
"          \"profile_link_color\": \"ED1313\",\n"
"          \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"          \"profile_sidebar_fill_color\": \"E0FF92\",\n"
"          \"profile_text_color\": \"000000\",\n"
"          \"profile_use_background_image\": true,\n"
"          \"default_profile\": false,\n"
"          \"default_profile_image\": false,\n"
"          \"following\": false,\n"
"          \"follow_request_sent\": false,\n"
"          \"notifications\": false\n"
"        },\n"
"        \"geo\": null,\n"
"        \"coordinates\": null,\n"
"        \"place\": null,\n"
"        \"contributors\": null,\n"
"        \"retweet_count\": 4,\n"
"        \"favorite_count\": 2,\n"
"        \"entities\": {\n"
"          \"hashtags\": [],\n"
"          \"symbols\": [],\n"
"          \"urls\": [\n"
"            {\n"
"              \"url\": \"http://t.co/HLX9mHcQwe\",\n"
"              \"expanded_url\": \"http://is.gd/H3OgTO\",\n"
"              \"display_url\": \"is.gd/H3OgTO\",\n"
"              \"indices\": [\n"
"                57,\n"
"                79\n"
"              ]\n"
"            }\n"
"          ],\n"
"          \"user_mentions\": [],\n"
"          \"media\": [\n"
"            {\n"
"              \"id\": 505866668485386240,\n"
"              \"id_str\": \"505866668485386241\",\n"
"              \"indices\": [\n"
"                80,\n"
"                102\n"
"              ],\n"
"              \"media_url\": \"http://pbs.twimg.com/media/BwUzDgbIIAEgvhD.jpg\",\n"
"              \"media_url_https\": \"https://pbs.twimg.com/media/BwUzDgbIIAEgvhD.jpg\",\n"
"              \"url\": \"http://t.co/fVVOSML5s8\",\n"
"              \"display_url\": \"pic.twitter.com/fVVOSML5s8\",\n"
"              \"expanded_url\": \"http://twitter.com/fightcensorship/status/505866670356070401/photo/1\",\n"
"              \"type\": \"photo\",\n"
"              \"sizes\": {\n"
"                \"large\": {\n"
"                  \"w\": 640,\n"
"                  \"h\": 554,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"medium\": {\n"
"                  \"w\": 600,\n"
"                  \"h\": 519,\n"
"                  \"resize\": \"fit\"\n"
"                },\n"
"                \"thumb\": {\n"
"                  \"w\": 150,\n"
"                  \"h\": 150,\n"
"                  \"resize\": \"crop\"\n"
"                },\n"
"                \"small\": {\n"
"                  \"w\": 340,\n"
"                  \"h\": 294,\n"
"                  \"resize\": \"fit\"\n"
"                }\n"
"              }\n"
"            }\n"
"          ]\n"
"        },\n"
"        \"favorited\": false,\n"
"        \"retweeted\": false,\n"
"        \"possibly_sensitive\": false,\n"
"        \"lang\": \"zh\"\n"
"      },\n"
"      \"retweet_count\": 4,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/HLX9mHcQwe\",\n"
"            \"expanded_url\": \"http://is.gd/H3OgTO\",\n"
"            \"display_url\": \"is.gd/H3OgTO\",\n"
"            \"indices\": [\n"
"              78,\n"
"              100\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": [\n"
"          {\n"
"            \"screen_name\": \"fightcensorship\",\n"
"            \"name\": \"※范强※法特姗瑟希蒲※\",\n"
"            \"id\": 67661086,\n"
"            \"id_str\": \"67661086\",\n"
"            \"indices\": [\n"
"              3,\n"
"              19\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"media\": [\n"
"          {\n"
"            \"id\": 505866668485386240,\n"
"            \"id_str\": \"505866668485386241\",\n"
"            \"indices\": [\n"
"              101,\n"
"              123\n"
"            ],\n"
"            \"media_url\": \"http://pbs.twimg.com/media/BwUzDgbIIAEgvhD.jpg\",\n"
"            \"media_url_https\": \"https://pbs.twimg.com/media/BwUzDgbIIAEgvhD.jpg\",\n"
"            \"url\": \"http://t.co/fVVOSML5s8\",\n"
"            \"display_url\": \"pic.twitter.com/fVVOSML5s8\",\n"
"            \"expanded_url\": \"http://twitter.com/fightcensorship/status/505866670356070401/photo/1\",\n"
"            \"type\": \"photo\",\n"
"            \"sizes\": {\n"
"              \"large\": {\n"
"                \"w\": 640,\n"
"                \"h\": 554,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"medium\": {\n"
"                \"w\": 600,\n"
"                \"h\": 519,\n"
"                \"resize\": \"fit\"\n"
"              },\n"
"              \"thumb\": {\n"
"                \"w\": 150,\n"
"                \"h\": 150,\n"
"                \"resize\": \"crop\"\n"
"              },\n"
"              \"small\": {\n"
"                \"w\": 340,\n"
"                \"h\": 294,\n"
"                \"resize\": \"fit\"\n"
"              }\n"
"            },\n"
"            \"source_status_id\": 505866670356070400,\n"
"            \"source_status_id_str\": \"505866670356070401\"\n"
"          }\n"
"        ]\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"zh\"\n"
"    },\n"
"    {\n"
"      \"metadata\": {\n"
"        \"result_type\": \"recent\",\n"
"        \"iso_language_code\": \"ja\"\n"
"      },\n"
"      \"created_at\": \"Sun Aug 31 00:28:56 +0000 2014\",\n"
"      \"id\": 505874847260352500,\n"
"      \"id_str\": \"505874847260352513\",\n"
"      \"text\": \"【マイリスト】【彩りりあ】妖怪体操第一　踊ってみた【反転】 http://t.co/PjL9if8OZC #sm24357625\",\n"
"      \"source\": \"<a href=\\\"http://www.nicovideo.jp/\\\" rel=\\\"nofollow\\\">ニコニコ動画</a>\",\n"
"      \"truncated\": false,\n"
"      \"in_reply_to_status_id\": null,\n"
"      \"in_reply_to_status_id_str\": null,\n"
"      \"in_reply_to_user_id\": null,\n"
"      \"in_reply_to_user_id_str\": null,\n"
"      \"in_reply_to_screen_name\": null,\n"
"      \"user\": {\n"
"        \"id\": 1609789375,\n"
"        \"id_str\": \"1609789375\",\n"
"        \"name\": \"食いしん坊前ちゃん\",\n"
"        \"screen_name\": \"2no38mae\",\n"
"        \"location\": \"ニノと二次元の間\",\n"
"        \"description\": \"ニコ動で踊り手やってます!!応援本当に嬉しいですありがとうございます!!　ぽっちゃりだけど前向きに頑張る腐女子です。嵐と弱虫ペダルが大好き！【お返事】りぷ(基本は)”○”　DM (同業者様を除いて)”×”　動画の転載は絶対にやめてください。 ブログ→http://t.co/8E91tqoeKX　　\",\n"
"        \"url\": \"http://t.co/ulD2e9mcwb\",\n"
"        \"entities\": {\n"
"          \"url\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/ulD2e9mcwb\",\n"
"                \"expanded_url\": \"http://www.nicovideo.jp/mylist/37917495\",\n"
"                \"display_url\": \"nicovideo.jp/mylist/37917495\",\n"
"                \"indices\": [\n"
"                  0,\n"
"                  22\n"
"                ]\n"
"              }\n"
"            ]\n"
"          },\n"
"          \"description\": {\n"
"            \"urls\": [\n"
"              {\n"
"                \"url\": \"http://t.co/8E91tqoeKX\",\n"
"                \"expanded_url\": \"http://ameblo.jp/2no38mae/\",\n"
"                \"display_url\": \"ameblo.jp/2no38mae/\",\n"
"                \"indices\": [\n"
"                  125,\n"
"                  147\n"
"                ]\n"
"              }\n"
"            ]\n"
"          }\n"
"        },\n"
"        \"protected\": false,\n"
"        \"followers_count\": 560,\n"
"        \"friends_count\": 875,\n"
"        \"listed_count\": 11,\n"
"        \"created_at\": \"Sun Jul 21 05:09:43 +0000 2013\",\n"
"        \"favourites_count\": 323,\n"
"        \"utc_offset\": null,\n"
"        \"time_zone\": null,\n"
"        \"geo_enabled\": false,\n"
"        \"verified\": false,\n"
"        \"statuses_count\": 3759,\n"
"        \"lang\": \"ja\",\n"
"        \"contributors_enabled\": false,\n"
"        \"is_translator\": false,\n"
"        \"is_translation_enabled\": false,\n"
"        \"profile_background_color\": \"F2C6E4\",\n"
"        \"profile_background_image_url\": \"http://pbs.twimg.com/profile_background_images/378800000029400927/114b242f5d838ec7cb098ea5db6df413.jpeg\",\n"
"        \"profile_background_image_url_https\": \"https://pbs.twimg.com/profile_background_images/378800000029400927/114b242f5d838ec7cb098ea5db6df413.jpeg\",\n"
"        \"profile_background_tile\": false,\n"
"        \"profile_image_url\": \"http://pbs.twimg.com/profile_images/487853237723095041/LMBMGvOc_normal.jpeg\",\n"
"        \"profile_image_url_https\": \"https://pbs.twimg.com/profile_images/487853237723095041/LMBMGvOc_normal.jpeg\",\n"
"        \"profile_banner_url\": \"https://pbs.twimg.com/profile_banners/1609789375/1375752225\",\n"
"        \"profile_link_color\": \"FF9EDD\",\n"
"        \"profile_sidebar_border_color\": \"FFFFFF\",\n"
"        \"profile_sidebar_fill_color\": \"DDEEF6\",\n"
"        \"profile_text_color\": \"333333\",\n"
"        \"profile_use_background_image\": true,\n"
"        \"default_profile\": false,\n"
"        \"default_profile_image\": false,\n"
"        \"following\": false,\n"
"        \"follow_request_sent\": false,\n"
"        \"notifications\": false\n"
"      },\n"
"      \"geo\": null,\n"
"      \"coordinates\": null,\n"
"      \"place\": null,\n"
"      \"contributors\": null,\n"
"      \"retweet_count\": 0,\n"
"      \"favorite_count\": 0,\n"
"      \"entities\": {\n"
"        \"hashtags\": [\n"
"          {\n"
"            \"text\": \"sm24357625\",\n"
"            \"indices\": [\n"
"              53,\n"
"              64\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"symbols\": [],\n"
"        \"urls\": [\n"
"          {\n"
"            \"url\": \"http://t.co/PjL9if8OZC\",\n"
"            \"expanded_url\": \"http://nico.ms/sm24357625\",\n"
"            \"display_url\": \"nico.ms/sm24357625\",\n"
"            \"indices\": [\n"
"              30,\n"
"              52\n"
"            ]\n"
"          }\n"
"        ],\n"
"        \"user_mentions\": []\n"
"      },\n"
"      \"favorited\": false,\n"
"      \"retweeted\": false,\n"
"      \"possibly_sensitive\": false,\n"
"      \"lang\": \"ja\"\n"
"    }\n"
"  ],\n"
"  \"search_metadata\": {\n"
"    \"completed_in\": 0.087,\n"
"    \"max_id\": 505874924095815700,\n"
"    \"max_id_str\": \"505874924095815681\",\n"
"    \"next_results\": \"?max_id=505874847260352512&q=%E4%B8%80&count=100&include_entities=1\",\n"
"    \"query\": \"%E4%B8%80\",\n"
"    \"refresh_url\": \"?since_id=505874924095815681&q=%E4%B8%80&include_entities=1\",\n"
"    \"count\": 100,\n"
"    \"since_id\": 0,\n"
"    \"since_id_str\": \"0\"\n"
"  }\n"
"}";
