% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_vars.R
\name{remove_var}
\alias{remove_var}
\alias{remove_cols}
\title{Remove variables from a data frame}
\usage{
remove_var(x, ...)

remove_cols(x, ...)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Character vector with variable names, or unquoted names
of variables that should be removed from the data frame.
You may also use functions like \code{:} or tidyselect's
select-helpers.}
}
\value{
\code{x}, with variables specified in \code{...} removed.
}
\description{
This function removes variables from a data frame, and is
  intended to use within a pipe-workflow. \code{remove_cols()} is an
  alias for \code{remove_var()}.
}
\examples{
mtcars \%>\% remove_var("disp", "cyl")
mtcars \%>\% remove_var(c("wt", "vs"))
mtcars \%>\% remove_var(drat:am)
}
