% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{cli_format}
\alias{cli_format}
\alias{cli_format.default}
\alias{cli_format.character}
\alias{cli_format.numeric}
\title{Format a value for printing}
\usage{
cli_format(x, style = NULL, ...)

\method{cli_format}{default}(x, style = NULL, ...)

\method{cli_format}{character}(x, style = NULL, ...)

\method{cli_format}{numeric}(x, style = NULL, ...)
}
\arguments{
\item{x}{The object to format.}

\item{style}{List of formatting options, see the individual methods
for the style options they support.}

\item{...}{Additional arguments for methods.}
}
\description{
This function can be used directly, or via the \verb{\{.val ...\}} inline
style. \verb{\{.val \{expr\}\}} calls \code{cli_format()} automatically on the value
of \code{expr}, before styling and collapsing it.
}
\details{
\subsection{Default style}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{months <- month.name[1:3]
cli_text("\{.val \{months\}\}")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #268BD2;">"January"</span>, <span style="color: #268BD2;">"February"</span>, and <span style="color: #268BD2;">"March"</span>                                              
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{nums <- 1:5 / 7
cli_text("\{.val \{nums\}\}")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #268BD2;">0.142857142857143</span>, <span style="color: #268BD2;">0.285714285714286</span>, <span style="color: #268BD2;">0.428571428571429</span>,                        
#> <span style="color: #268BD2;">0.571428571428571</span>, and <span style="color: #268BD2;">0.714285714285714</span>                                        
</pre></div>
}}

}

\subsection{Styling with themes}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nums <- 1:5 / 7
divid <- cli_div(theme = list(.val = list(digits = 3)))
cli_text("\{.val \{nums\}\}")
cli_end(divid)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #268BD2;">0.143</span>, <span style="color: #268BD2;">0.286</span>, <span style="color: #268BD2;">0.429</span>, <span style="color: #268BD2;">0.571</span>, and <span style="color: #268BD2;">0.714</span>                                           
</pre></div>
}}


It is possible to define new S3 methods for \code{cli_format} and then
these will be used automatically for \verb{\{.val ...\}} expressions.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_format.month <- function(x, style = NULL, ...) \{
  x <- encodeString(substr(x, 1, 3), quote = "\\"")
  NextMethod("cli_format")
\}
registerS3method("cli_format", "month", cli_format.month)
months <- structure(month.name[1:3], class = "month")
cli_text("\{.val \{months\}\}")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #268BD2;">"Jan"</span>, <span style="color: #268BD2;">"Feb"</span>, and <span style="color: #268BD2;">"Mar"</span>                                                         
</pre></div>
}}

}
}
\seealso{
\code{\link[=cli_vec]{cli_vec()}}
}
