# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.dataprotection import DataProtectionMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-dataprotection
# USAGE
    python put_backup_instance_adlsblob_backup_datasource_parameters.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DataProtectionMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.backup_instances.begin_create_or_update(
        resource_group_name="adlsrg",
        vault_name="adlsvault",
        backup_instance_name="adlsstorageaccount-adlsstorageaccount-19a76f8a-c176-4f7d-819e-95157e2b0071",
        parameters={
            "properties": {
                "dataSourceInfo": {
                    "datasourceType": "Microsoft.Storage/storageAccounts/adlsBlobServices",
                    "objectType": "Datasource",
                    "resourceID": "/subscriptions/54707983-993e-43de-8d94-074451394eda/resourceGroups/adlsrg/providers/Microsoft.Storage/storageAccounts/adlsstorageaccount",
                    "resourceLocation": "centraluseuap",
                    "resourceName": "adlsstorageaccount",
                    "resourceType": "microsoft.storage/storageAccounts",
                    "resourceUri": "/subscriptions/54707983-993e-43de-8d94-074451394eda/resourceGroups/adlsrg/providers/Microsoft.Storage/storageAccounts/adlsstorageaccount",
                },
                "dataSourceSetInfo": {
                    "datasourceType": "Microsoft.Storage/storageAccounts/adlsBlobServices",
                    "objectType": "DatasourceSet",
                    "resourceID": "/subscriptions/54707983-993e-43de-8d94-074451394eda/resourceGroups/adlsrg/providers/Microsoft.Storage/storageAccounts/adlsstorageaccount",
                    "resourceLocation": "centraluseuap",
                    "resourceName": "adlsstorageaccount",
                    "resourceType": "microsoft.storage/storageAccounts",
                    "resourceUri": "/subscriptions/54707983-993e-43de-8d94-074451394eda/resourceGroups/adlsrg/providers/Microsoft.Storage/storageAccounts/adlsstorageaccount",
                },
                "friendlyName": "adlsstorageaccount\\adlsbackupinstance",
                "objectType": "BackupInstance",
                "policyInfo": {
                    "policyId": "/subscriptions/54707983-993e-43de-8d94-074451394eda/resourceGroups/adlsrg/providers/Microsoft.DataProtection/backupVaults/adlsvault/backupPolicies/adlspolicy",
                    "policyParameters": {
                        "backupDatasourceParametersList": [
                            {"containersList": ["container1"], "objectType": "AdlsBlobBackupDatasourceParameters"}
                        ]
                    },
                },
            }
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-07-01/BackupInstanceOperations/PutBackupInstance_ADLSBlobBackupDatasourceParameters.json
if __name__ == "__main__":
    main()
