# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.appcontainers import ContainerAppsAPIClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-appcontainers
# USAGE
    python container_apps_kind_function_app_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerAppsAPIClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.container_apps.begin_create_or_update(
        resource_group_name="rg",
        container_app_name="testcontainerAppFunctionKind",
        container_app_envelope={
            "kind": "functionapp",
            "location": "East Us",
            "managedBy": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg/providers/Microsoft.Web/sites/testcontainerAppFunctionKind",
            "properties": {
                "configuration": {
                    "activeRevisionsMode": "Single",
                    "ingress": {"allowInsecure": False, "external": True, "targetPort": 80},
                },
                "managedEnvironmentId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/testmanagedenv3",
                "template": {
                    "containers": [
                        {
                            "env": [
                                {
                                    "name": "AzureWebJobsStorage",
                                    "value": "DefaultEndpointsProtocol=https;AccountName=mystorageaccount;AccountKey=mykey;EndpointSuffix=core.windows.net",
                                },
                                {"name": "FUNCTIONS_WORKER_RUNTIME", "value": "dotnet"},
                                {"name": "WEBSITES_ENABLE_APP_SERVICE_STORAGE", "value": "false"},
                            ],
                            "image": "mcr.microsoft.com/azure-functions/dotnet:4",
                            "name": "function-app-container",
                            "resources": {"cpu": 0.5, "memory": "1.0Gi"},
                        }
                    ],
                    "scale": {"cooldownPeriod": 300, "maxReplicas": 10, "minReplicas": 0, "pollingInterval": 30},
                },
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/app/resource-manager/Microsoft.App/ContainerApps/stable/2025-07-01/examples/ContainerApps_Kind_FunctionApp_CreateOrUpdate.json
if __name__ == "__main__":
    main()
